/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.ILayoutlibVersion;
import com.android.sdklib.internal.repository.packages.LayoutlibVersionMixin;
import com.android.sdklib.internal.repository.packages.MinToolsPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.utils.Pair;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class PlatformPackage
extends MinToolsPackage
implements IAndroidVersionProvider,
ILayoutlibVersion {
    private final AndroidVersion mVersion;
    private final String mVersionName;
    private final String mIncludedAbi;
    private final LayoutlibVersionMixin mLayoutlibVersion;
    private final IPkgDesc mPkgDesc;

    public PlatformPackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        this.mVersionName = PackageParserUtils.getXmlString(packageNode, "version");
        int apiLevel = PackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = PackageParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        this.mVersion = new AndroidVersion(apiLevel, codeName);
        this.mIncludedAbi = PackageParserUtils.getOptionalXmlString(packageNode, "included-abi");
        this.mLayoutlibVersion = new LayoutlibVersionMixin(packageNode);
        this.mPkgDesc = PkgDesc.Builder.newPlatform(this.mVersion, (MajorRevision)this.getRevision(), this.getMinToolsRevision()).setDescriptions(this).create();
    }

    public static Package create(@NonNull IAndroidTarget target, @Nullable Properties props) {
        return new PlatformPackage(target, props);
    }

    protected PlatformPackage(@NonNull IAndroidTarget target, @Nullable Properties props) {
        this(null, target, props);
    }

    protected PlatformPackage(@Nullable SdkSource source, @NonNull IAndroidTarget target, @Nullable Properties props) {
        super(source, props, target.getRevision(), null, target.getDescription(), null, target.getLocation());
        this.mVersion = target.getVersion();
        this.mVersionName = target.getVersionName();
        this.mLayoutlibVersion = new LayoutlibVersionMixin(props);
        this.mIncludedAbi = props == null ? null : props.getProperty("Platform.Included.Abi");
        this.mPkgDesc = PkgDesc.Builder.newPlatform(this.mVersion, (MajorRevision)this.getRevision(), this.getMinToolsRevision()).setDescriptions(this).create();
    }

    @Override
    @NonNull
    public IPkgDesc getPkgDesc() {
        return this.mPkgDesc;
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mVersion.saveProperties(props);
        this.mLayoutlibVersion.saveProperties(props);
        if (this.mVersionName != null) {
            props.setProperty("Platform.Version", this.mVersionName);
        }
        if (this.mIncludedAbi != null) {
            props.setProperty("Platform.Included.Abi", this.mIncludedAbi);
        }
    }

    public String getVersionName() {
        return this.mVersionName;
    }

    @Override
    @NonNull
    public AndroidVersion getAndroidVersion() {
        return this.mVersion;
    }

    public String getIncludedAbi() {
        return this.mIncludedAbi;
    }

    @Override
    public Pair<Integer, Integer> getLayoutlibVersion() {
        return this.mLayoutlibVersion.getLayoutlibVersion();
    }

    @Override
    public String installId() {
        return AndroidTargetHash.getPlatformHashString(this.mVersion);
    }

    @Override
    public String getListDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s%2$s", ld, this.isObsolete() ? " (Obsolete)" : "");
        }
        String s = this.mVersion.isPreview() ? String.format("SDK Platform Android %1$s Preview%2$s", this.getVersionName(), this.isObsolete() ? " (Obsolete)" : "") : String.format("SDK Platform Android %1$s%2$s", this.getVersionName(), this.isObsolete() ? " (Obsolete)" : "");
        return s;
    }

    @Override
    public String getShortDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", ld, this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        String s = this.mVersion.isPreview() ? String.format("SDK Platform Android %1$s Preview, revision %2$s%3$s", this.getVersionName(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "") : String.format("SDK Platform Android %1$s, API %2$d, revision %3$s%4$s", this.getVersionName(), this.mVersion.getApiLevel(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        return s;
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getShortDescription();
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        for (IAndroidTarget target : sdkManager.getTargets()) {
            if (!target.isPlatform() || !target.getVersion().equals(this.mVersion)) continue;
            return new File(target.getLocation());
        }
        File platforms = new File(osSdkRoot, "platforms");
        File folder = new File(platforms, String.format("android-%s", this.getAndroidVersion().getApiString()));
        return folder;
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof PlatformPackage) {
            PlatformPackage newPkg = (PlatformPackage)pkg;
            return newPkg.getAndroidVersion().equals(this.getAndroidVersion());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mLayoutlibVersion == null ? 0 : this.mLayoutlibVersion.hashCode());
        result = 31 * result + (this.mVersion == null ? 0 : this.mVersion.hashCode());
        result = 31 * result + (this.mVersionName == null ? 0 : this.mVersionName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PlatformPackage)) {
            return false;
        }
        PlatformPackage other = (PlatformPackage)obj;
        if (this.mLayoutlibVersion == null ? other.mLayoutlibVersion != null : !this.mLayoutlibVersion.equals(other.mLayoutlibVersion)) {
            return false;
        }
        if (this.mVersion == null ? other.mVersion != null : !this.mVersion.equals(other.mVersion)) {
            return false;
        }
        return !(this.mVersionName == null ? other.mVersionName != null : !this.mVersionName.equals(other.mVersionName));
    }
}

