/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import java.util.List;
import java.util.Map;

public final class MapProducer<K, V>
extends AbstractProducer<Map<K, V>> {
    private final Producer<Map<K, Producer<V>>> mapProducerProducer;
    private static final Function<Map.Entry<Object, Producer<Object>>, ListenableFuture<Map.Entry<Object, Object>>> ENTRY_UNWRAPPER = new Function<Map.Entry<Object, Producer<Object>>, ListenableFuture<Map.Entry<Object, Object>>>(){

        public ListenableFuture<Map.Entry<Object, Object>> apply(final Map.Entry<Object, Producer<Object>> entry) {
            return Futures.transform(entry.getValue().get(), (Function)new Function<Object, Map.Entry<Object, Object>>(){

                public Map.Entry<Object, Object> apply(Object value) {
                    return Maps.immutableEntry(entry.getKey(), (Object)value);
                }
            });
        }
    };

    private MapProducer(Producer<Map<K, Producer<V>>> mapProducerProducer) {
        this.mapProducerProducer = mapProducerProducer;
    }

    public static <K, V> MapProducer<K, V> create(Producer<Map<K, Producer<V>>> mapProducerProducer) {
        return new MapProducer<K, V>(mapProducerProducer);
    }

    @Override
    public ListenableFuture<Map<K, V>> compute() {
        return Futures.transformAsync(this.mapProducerProducer.get(), (AsyncFunction)new AsyncFunction<Map<K, Producer<V>>, Map<K, V>>(){

            public ListenableFuture<Map<K, V>> apply(Map<K, Producer<V>> map) {
                return Futures.transform((ListenableFuture)Futures.allAsList((Iterable)Iterables.transform(map.entrySet(), (Function)MapProducer.entryUnwrapper())), (Function)new Function<List<Map.Entry<K, V>>, Map<K, V>>(){

                    public Map<K, V> apply(List<Map.Entry<K, V>> entries) {
                        return ImmutableMap.copyOf(entries);
                    }
                });
            }
        });
    }

    private static <K, V> Function<Map.Entry<K, Producer<V>>, ListenableFuture<Map.Entry<K, V>>> entryUnwrapper() {
        return ENTRY_UNWRAPPER;
    }
}

