/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Retention(value=RetentionPolicy.RUNTIME)
public @interface BugPattern {
    public String name();

    public String[] altNames() default {};

    public LinkType linkType() default LinkType.AUTOGENERATED;

    public String link() default "";

    public Category category();

    public String summary();

    public String explanation() default "";

    public SeverityLevel severity();

    public MaturityLevel maturity();

    public Suppressibility suppressibility() default Suppressibility.SUPPRESS_WARNINGS;

    public Class<? extends Annotation>[] customSuppressionAnnotations() default {};

    public boolean documentSuppression() default true;

    public boolean generateExamplesFromTestCases() default true;

    public static enum Suppressibility {
        SUPPRESS_WARNINGS(true),
        CUSTOM_ANNOTATION(false),
        UNSUPPRESSIBLE(false);

        private final boolean disableable;

        private Suppressibility(boolean disableable) {
            this.disableable = disableable;
        }

        public boolean disableable() {
            return this.disableable;
        }
    }

    public static enum MaturityLevel {
        MATURE("On by default"),
        EXPERIMENTAL("Experimental");

        final String description;

        private MaturityLevel(String description) {
            this.description = description;
        }
    }

    public static enum SeverityLevel {
        ERROR,
        WARNING,
        SUGGESTION;

    }

    public static enum Category {
        JDK,
        GUAVA,
        GUICE,
        DAGGER,
        JUNIT,
        ONE_OFF,
        INJECT,
        MOCKITO,
        JMOCK,
        ANDROID,
        TRUTH;

    }

    public static enum LinkType {
        AUTOGENERATED,
        CUSTOM,
        NONE;

    }
}

