/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.ConstFold;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.tools.JavaFileObject;

public class Annotate {
    protected static final Context.Key<Annotate> annotateKey = new Context.Key();
    private final Attr attr;
    private final TreeMaker make;
    private final Log log;
    private final Symtab syms;
    private final Names names;
    private final Resolve rs;
    private final Types types;
    private final ConstFold cfolder;
    private final Check chk;
    private final Lint lint;
    private final DeferredLintHandler deferredLintHandler;
    private final Source source;
    private boolean allowTypeAnnos;
    private boolean allowRepeatedAnnos;
    private int enterCount = 0;
    ListBuffer<Worker> q = new ListBuffer();
    ListBuffer<Worker> typesQ = new ListBuffer();
    ListBuffer<Worker> repeatedQ = new ListBuffer();
    ListBuffer<Worker> afterRepeatedQ = new ListBuffer();
    ListBuffer<Worker> validateQ = new ListBuffer();
    private final AttributeAttacher<Attribute.Compound> declAnnotationsAttacher = new AttributeAttacher<Attribute.Compound>(){

        @Override
        public void attach(Symbol symbol, List<Attribute.Compound> list) {
            symbol.resetAnnotations();
            symbol.setDeclarationAttributes(list);
        }
    };
    private final AttributeAttacher<Attribute.TypeCompound> typeAnnotationsAttacher = new AttributeAttacher<Attribute.TypeCompound>(){

        @Override
        public void attach(Symbol symbol, List<Attribute.TypeCompound> list) {
            symbol.appendUniqueTypeAttributes(list);
        }
    };
    private final AttributeCreator<Attribute.Compound> enterAnnotationsCreator = new AttributeCreator<Attribute.Compound>(){

        @Override
        public Attribute.Compound create(JCTree.JCAnnotation jCAnnotation, Type type, Env<AttrContext> env) {
            return Annotate.this.enterAnnotation(jCAnnotation, ((Annotate)Annotate.this).syms.annotationType, env);
        }
    };
    private final AttributeCreator<Attribute.TypeCompound> enterTypeAnnotationsCreator = new AttributeCreator<Attribute.TypeCompound>(){

        @Override
        public Attribute.TypeCompound create(JCTree.JCAnnotation jCAnnotation, Type type, Env<AttrContext> env) {
            return Annotate.this.enterTypeAnnotation(jCAnnotation, ((Annotate)Annotate.this).syms.annotationType, env);
        }
    };

    public static Annotate instance(Context context) {
        Annotate annotate = context.get(annotateKey);
        if (annotate == null) {
            annotate = new Annotate(context);
        }
        return annotate;
    }

    protected Annotate(Context context) {
        context.put(annotateKey, this);
        this.attr = Attr.instance(context);
        this.make = TreeMaker.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
        this.rs = Resolve.instance(context);
        this.types = Types.instance(context);
        this.cfolder = ConstFold.instance(context);
        this.chk = Check.instance(context);
        this.source = Source.instance(context);
        this.lint = Lint.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.allowRepeatedAnnos = this.source.allowRepeatedAnnotations();
        this.allowTypeAnnos = this.source.allowTypeAnnotations();
    }

    public void earlier(Worker worker) {
        this.q.prepend(worker);
    }

    public void normal(Worker worker) {
        this.q.append(worker);
    }

    public void typeAnnotation(Worker worker) {
        this.typesQ.append(worker);
    }

    public void repeated(Worker worker) {
        this.repeatedQ.append(worker);
    }

    public void afterRepeated(Worker worker) {
        this.afterRepeatedQ.append(worker);
    }

    public void validate(Worker worker) {
        this.validateQ.append(worker);
    }

    public void enterStart() {
        ++this.enterCount;
    }

    public void enterDone() {
        --this.enterCount;
        this.flush();
    }

    public void enterDoneWithoutFlush() {
        --this.enterCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.enterCount != 0) {
            return;
        }
        ++this.enterCount;
        try {
            while (this.q.nonEmpty()) {
                this.q.next().run();
            }
            while (this.typesQ.nonEmpty()) {
                this.typesQ.next().run();
            }
            while (this.repeatedQ.nonEmpty()) {
                this.repeatedQ.next().run();
            }
            while (this.afterRepeatedQ.nonEmpty()) {
                this.afterRepeatedQ.next().run();
            }
            while (this.validateQ.nonEmpty()) {
                this.validateQ.next().run();
            }
        }
        finally {
            --this.enterCount;
        }
    }

    Attribute.Compound enterAnnotation(JCTree.JCAnnotation jCAnnotation, Type type, Env<AttrContext> env) {
        Attribute.Compound compound;
        List<Pair<Symbol.MethodSymbol, Attribute>> list = this.enterAttributeValues(jCAnnotation, type, env);
        jCAnnotation.attribute = compound = new Attribute.Compound(jCAnnotation.type, list);
        return compound;
    }

    Attribute.TypeCompound enterTypeAnnotation(JCTree.JCAnnotation jCAnnotation, Type type, Env<AttrContext> env) {
        List<Pair<Symbol.MethodSymbol, Attribute>> list = this.enterAttributeValues(jCAnnotation, type, env);
        if (jCAnnotation.attribute == null || !(jCAnnotation.attribute instanceof Attribute.TypeCompound)) {
            Attribute.TypeCompound typeCompound = new Attribute.TypeCompound(jCAnnotation.type, list, TypeAnnotationPosition.unknown);
            jCAnnotation.attribute = typeCompound;
            return typeCompound;
        }
        return (Attribute.TypeCompound)jCAnnotation.attribute;
    }

    private List<Pair<Symbol.MethodSymbol, Attribute>> enterAttributeValues(JCTree.JCAnnotation jCAnnotation, Type type, Env<AttrContext> env) {
        List<JCTree.JCExpression> list;
        Type type2 = jCAnnotation.annotationType.type != null ? jCAnnotation.annotationType.type : this.attr.attribType(jCAnnotation.annotationType, env);
        jCAnnotation.type = this.chk.checkType(jCAnnotation.annotationType.pos(), type2, type);
        boolean bl = jCAnnotation.type.isErroneous();
        if ((jCAnnotation.type.tsym.flags() & 0x2000L) == 0L && !bl) {
            this.log.error(jCAnnotation.annotationType.pos(), "not.annotation.type", jCAnnotation.type.toString());
            bl = true;
        }
        if ((list = jCAnnotation.args).length() == 1 && !((JCTree.JCExpression)list.head).hasTag(JCTree.Tag.ASSIGN)) {
            list.head = this.make.at(((JCTree.JCExpression)list.head).pos).Assign(this.make.Ident(this.names.value), (JCTree.JCExpression)list.head);
        }
        ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> listBuffer = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
        List<JCTree.JCExpression> list2 = list;
        while (list2.nonEmpty()) {
            JCTree.JCExpression jCExpression = (JCTree.JCExpression)list2.head;
            if (!jCExpression.hasTag(JCTree.Tag.ASSIGN)) {
                this.log.error(jCExpression.pos(), "annotation.value.must.be.name.value", new Object[0]);
                jCExpression.type = this.syms.errType;
                this.enterAttributeValue(jCExpression.type, jCExpression, env);
            } else {
                JCTree.JCAssign jCAssign = (JCTree.JCAssign)jCExpression;
                if (!jCAssign.lhs.hasTag(JCTree.Tag.IDENT)) {
                    this.log.error(jCExpression.pos(), "annotation.value.must.be.name.value", new Object[0]);
                    jCExpression.type = this.syms.errType;
                    this.enterAttributeValue(jCExpression.type, jCExpression, env);
                } else {
                    Symbol symbol;
                    JCTree.JCIdent jCIdent = (JCTree.JCIdent)jCAssign.lhs;
                    jCIdent.sym = symbol = this.rs.resolveQualifiedMethod(jCAssign.rhs.pos(), env, jCAnnotation.type, jCIdent.name, List.nil(), null);
                    jCIdent.type = symbol.type;
                    if (symbol.owner != jCAnnotation.type.tsym && !bl) {
                        this.log.error(jCIdent.pos(), "no.annotation.member", jCIdent.name, jCAnnotation.type);
                    }
                    Type type3 = symbol.type.getReturnType();
                    Attribute attribute = this.enterAttributeValue(type3, jCAssign.rhs, env);
                    if (!symbol.type.isErroneous()) {
                        listBuffer.append(new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)symbol, attribute));
                    }
                    jCExpression.type = type3;
                }
            }
            list2 = list2.tail;
        }
        return listBuffer.toList();
    }

    Attribute enterAttributeValue(Type type, JCTree.JCExpression jCExpression, Env<AttrContext> env) {
        try {
            type.tsym.complete();
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.log.error(jCExpression.pos(), "cant.resolve", Kinds.kindName(completionFailure.sym), completionFailure.sym);
            type = this.syms.errType;
        }
        if (type.hasTag(TypeTag.ARRAY)) {
            if (!jCExpression.hasTag(JCTree.Tag.NEWARRAY)) {
                jCExpression = this.make.at(jCExpression.pos).NewArray(null, List.nil(), List.of(jCExpression));
            }
            JCTree.JCNewArray jCNewArray = (JCTree.JCNewArray)jCExpression;
            if (jCNewArray.elemtype != null) {
                this.log.error(jCNewArray.elemtype.pos(), "new.not.allowed.in.annotation", new Object[0]);
            }
            ListBuffer<Attribute> listBuffer = new ListBuffer<Attribute>();
            List<JCTree.JCExpression> list = jCNewArray.elems;
            while (list.nonEmpty()) {
                listBuffer.append(this.enterAttributeValue(this.types.elemtype(type), (JCTree.JCExpression)list.head, env));
                list = list.tail;
            }
            jCNewArray.type = type;
            return new Attribute.Array(type, listBuffer.toArray(new Attribute[listBuffer.length()]));
        }
        if (jCExpression.hasTag(JCTree.Tag.NEWARRAY)) {
            if (!type.isErroneous()) {
                this.log.error(jCExpression.pos(), "annotation.value.not.allowable.type", new Object[0]);
            }
            JCTree.JCNewArray jCNewArray = (JCTree.JCNewArray)jCExpression;
            if (jCNewArray.elemtype != null) {
                this.log.error(jCNewArray.elemtype.pos(), "new.not.allowed.in.annotation", new Object[0]);
            }
            List<JCTree.JCExpression> list = jCNewArray.elems;
            while (list.nonEmpty()) {
                this.enterAttributeValue(this.syms.errType, (JCTree.JCExpression)list.head, env);
                list = list.tail;
            }
            return new Attribute.Error(this.syms.errType);
        }
        if ((type.tsym.flags() & 0x2000L) != 0L) {
            if (jCExpression.hasTag(JCTree.Tag.ANNOTATION)) {
                return this.enterAnnotation((JCTree.JCAnnotation)jCExpression, type, env);
            }
            this.log.error(jCExpression.pos(), "annotation.value.must.be.annotation", new Object[0]);
            type = this.syms.errType;
        }
        if (jCExpression.hasTag(JCTree.Tag.ANNOTATION)) {
            if (!type.isErroneous()) {
                this.log.error(jCExpression.pos(), "annotation.not.valid.for.type", type);
            }
            this.enterAnnotation((JCTree.JCAnnotation)jCExpression, this.syms.errType, env);
            return new Attribute.Error(((JCTree.JCAnnotation)jCExpression).annotationType.type);
        }
        if (type.isPrimitive() || this.types.isSameType(type, this.syms.stringType) && !type.hasTag(TypeTag.ERROR)) {
            Type type2 = this.attr.attribExpr(jCExpression, env, type);
            if (type2.isErroneous()) {
                return new Attribute.Error(type2.getOriginalType());
            }
            if (type2.constValue() == null) {
                this.log.error(jCExpression.pos(), "attribute.value.must.be.constant", new Object[0]);
                return new Attribute.Error(type);
            }
            type2 = this.cfolder.coerce(type2, type);
            return new Attribute.Constant(type, type2.constValue());
        }
        if (type.tsym == this.syms.classType.tsym) {
            Type type3 = this.attr.attribExpr(jCExpression, env, type);
            if (type3.isErroneous()) {
                if (TreeInfo.name(jCExpression) == this.names._class && ((JCTree.JCFieldAccess)jCExpression).selected.type.isErroneous()) {
                    Name name = ((JCTree.JCFieldAccess)jCExpression).selected.type.tsym.flatName();
                    return new Attribute.UnresolvedClass(type, this.types.createErrorType(name, this.syms.unknownSymbol, this.syms.classType));
                }
                return new Attribute.Error(type3.getOriginalType());
            }
            if (TreeInfo.name(jCExpression) != this.names._class) {
                this.log.error(jCExpression.pos(), "annotation.value.must.be.class.literal", new Object[0]);
                return new Attribute.Error(this.syms.errType);
            }
            return new Attribute.Class(this.types, ((JCTree.JCFieldAccess)jCExpression).selected.type);
        }
        if (type.hasTag(TypeTag.CLASS) && (type.tsym.flags() & 0x4000L) != 0L) {
            Type type4 = this.attr.attribExpr(jCExpression, env, type);
            Symbol symbol = TreeInfo.symbol(jCExpression);
            if (symbol == null || TreeInfo.nonstaticSelect(jCExpression) || symbol.kind != 4 || (symbol.flags() & 0x4000L) == 0L) {
                this.log.error(jCExpression.pos(), "enum.annotation.must.be.enum.constant", new Object[0]);
                return new Attribute.Error(type4.getOriginalType());
            }
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
            return new Attribute.Enum(type, varSymbol);
        }
        if (!type.isErroneous()) {
            this.log.error(jCExpression.pos(), "annotation.value.not.allowable.type", new Object[0]);
        }
        return new Attribute.Error(this.attr.attribExpr(jCExpression, env, type));
    }

    private <T extends Attribute.Compound> T processRepeatedAnnotations(List<T> list, AnnotationContext<T> annotationContext, Symbol symbol) {
        Object object;
        Object object2;
        Attribute.Compound compound = (Attribute.Compound)list.head;
        List<Attribute> list2 = List.nil();
        Type type = null;
        Type.ArrayType arrayType = null;
        Type type2 = null;
        Symbol.MethodSymbol methodSymbol = null;
        Assert.check(!list.isEmpty() && !list.tail.isEmpty());
        int n = 0;
        List list3 = list;
        while (!list3.isEmpty()) {
            Assert.check(++n > 1 || !list3.tail.isEmpty());
            object2 = (Attribute.Compound)list3.head;
            type = ((Attribute.Compound)object2).type;
            if (arrayType == null) {
                arrayType = this.types.makeArrayType(type);
            }
            boolean bl = n > 1;
            object = this.getContainingType((Attribute.Compound)object2, annotationContext.pos.get(object2), bl);
            if (object != null) {
                Assert.check(type2 == null || object == type2);
                type2 = object;
                methodSymbol = this.validateContainer(type2, type, annotationContext.pos.get(object2));
                if (methodSymbol != null) {
                    list2 = list2.prepend((Attribute)object2);
                }
            }
            list3 = list3.tail;
        }
        if (!list2.isEmpty()) {
            list2 = list2.reverse();
            list3 = this.make.at(annotationContext.pos.get(compound));
            object2 = new Pair<Object, Attribute.Array>(methodSymbol, new Attribute.Array((Type)arrayType, list2));
            if (annotationContext.isTypeCompound) {
                Attribute.TypeCompound typeCompound = new Attribute.TypeCompound(type2, List.of(object2), ((Attribute.TypeCompound)list.head).position);
                typeCompound.setSynthesized(true);
                object = typeCompound;
                return (T)object;
            }
            Attribute.Compound compound2 = new Attribute.Compound(type2, List.of(object2));
            object = ((TreeMaker)((Object)list3)).Annotation(compound2);
            if (!this.chk.annotationApplicable((JCTree.JCAnnotation)object, symbol)) {
                this.log.error(((JCTree)object).pos(), "invalid.repeatable.annotation.incompatible.target", type2, type);
            }
            if (!this.chk.validateAnnotationDeferErrors((JCTree.JCAnnotation)object)) {
                this.log.error(((JCTree)object).pos(), "duplicate.annotation.invalid.repeated", type);
            }
            compound2 = this.enterAnnotation((JCTree.JCAnnotation)object, type2, annotationContext.env);
            compound2.setSynthesized(true);
            Attribute.Compound compound3 = compound2;
            return (T)compound3;
        }
        return null;
    }

    private Type getContainingType(Attribute.Compound compound, JCDiagnostic.DiagnosticPosition diagnosticPosition, boolean bl) {
        Type type = compound.type;
        Symbol.TypeSymbol typeSymbol = type.tsym;
        Attribute.Compound compound2 = typeSymbol.attribute(this.syms.repeatableType.tsym);
        if (compound2 == null) {
            if (bl) {
                this.log.error(diagnosticPosition, "duplicate.annotation.missing.container", type, this.syms.repeatableType);
            }
            return null;
        }
        return this.filterSame(this.extractContainingType(compound2, diagnosticPosition, typeSymbol), type);
    }

    private Type filterSame(Type type, Type type2) {
        if (type == null || type2 == null) {
            return type;
        }
        return this.types.isSameType(type, type2) ? null : type;
    }

    private Type extractContainingType(Attribute.Compound compound, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.TypeSymbol typeSymbol) {
        if (compound.values.isEmpty()) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation", typeSymbol);
            return null;
        }
        Pair pair = (Pair)compound.values.head;
        Name name = ((Symbol.MethodSymbol)pair.fst).name;
        if (name != this.names.value) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation", typeSymbol);
            return null;
        }
        if (!(pair.snd instanceof Attribute.Class)) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation", typeSymbol);
            return null;
        }
        return ((Attribute.Class)pair.snd).getValue();
    }

    private Symbol.MethodSymbol validateContainer(Type type, Type type2, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        AnnoConstruct annoConstruct2;
        Symbol.MethodSymbol methodSymbol = null;
        boolean bl = false;
        Scope.WriteableScope writeableScope = type.tsym.members();
        int n = 0;
        boolean bl2 = false;
        for (AnnoConstruct annoConstruct2 : writeableScope.getSymbolsByName(this.names.value)) {
            if (++n == 1 && annoConstruct2.kind == 16) {
                methodSymbol = (Symbol.MethodSymbol)annoConstruct2;
                continue;
            }
            bl2 = true;
        }
        if (bl2) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.multiple.values", type, n);
            return null;
        }
        if (n == 0) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.no.value", type);
            return null;
        }
        if (methodSymbol.kind != 16) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.invalid.value", type);
            bl = true;
        }
        Type type3 = methodSymbol.type.getReturnType();
        annoConstruct2 = this.types.makeArrayType(type2);
        if (!this.types.isArray(type3) || !this.types.isSameType((Type)annoConstruct2, type3)) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.value.return", type, type3, annoConstruct2);
            bl = true;
        }
        if (bl2) {
            bl = true;
        }
        return bl ? null : methodSymbol;
    }

    private <T extends Attribute.Compound> AnnotationContext<T> prepareEnterAnnotations(List<JCTree.JCAnnotation> list, Env<AttrContext> env, Symbol symbol, AttributeCreator<T> attributeCreator, boolean bl) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        HashMap<T, JCDiagnostic.DiagnosticPosition> hashMap = new HashMap<T, JCDiagnostic.DiagnosticPosition>();
        List<JCTree.JCAnnotation> list2 = list;
        while (!list2.isEmpty()) {
            JCTree.JCAnnotation jCAnnotation = (JCTree.JCAnnotation)list2.head;
            T t = attributeCreator.create(jCAnnotation, this.syms.annotationType, env);
            Assert.checkNonNull(t, "Failed to create annotation");
            if (linkedHashMap.containsKey(jCAnnotation.type.tsym)) {
                if (!this.allowRepeatedAnnos) {
                    this.log.error(jCAnnotation.pos(), "repeatable.annotations.not.supported.in.source", new Object[0]);
                    this.allowRepeatedAnnos = true;
                }
                ListBuffer<T> listBuffer = (ListBuffer<T>)linkedHashMap.get(jCAnnotation.type.tsym);
                listBuffer = listBuffer.append(t);
                linkedHashMap.put(jCAnnotation.type.tsym, listBuffer);
                hashMap.put(t, jCAnnotation.pos());
            } else {
                linkedHashMap.put(jCAnnotation.type.tsym, ListBuffer.of(t));
                hashMap.put(t, jCAnnotation.pos());
            }
            if (!((Attribute.Compound)t).type.isErroneous() && symbol.owner.kind != 16 && this.types.isSameType(((Attribute.Compound)t).type, this.syms.deprecatedType)) {
                symbol.flags_field |= 0x20000L;
            }
            list2 = list2.tail;
        }
        return new AnnotationContext(env, linkedHashMap, hashMap, bl);
    }

    private <T extends Attribute.Compound> void attachAttributesLater(List<JCTree.JCAnnotation> list, final Env<AttrContext> env, final Symbol symbol, boolean bl, AttributeCreator<T> attributeCreator, final AttributeAttacher<T> attributeAttacher) {
        final AnnotationContext<T> annotationContext = this.prepareEnterAnnotations(list, env, symbol, attributeCreator, bl);
        Map map = annotationContext.annotated;
        boolean bl2 = false;
        List<Object> list2 = List.nil();
        for (ListBuffer listBuffer : map.values()) {
            if (listBuffer.size() == 1) {
                list2 = list2.prepend(listBuffer.first());
                continue;
            }
            Placeholder<T> placeholder = new Placeholder<T>(annotationContext, listBuffer.toList(), symbol);
            list2 = list2.prepend(placeholder);
            bl2 = true;
        }
        final List list3 = list2.reverse();
        if (!bl) {
            attributeAttacher.attach(symbol, list3);
        }
        if (bl2) {
            this.repeated(new Worker(){

                @Override
                public String toString() {
                    return "repeated annotation pass of: " + symbol + " in: " + symbol.owner;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JavaFileObject javaFileObject = Annotate.this.log.useSource(env.toplevel.sourcefile);
                    try {
                        attributeAttacher.attach(symbol, Annotate.this.replacePlaceholders(list3, annotationContext, symbol));
                    }
                    finally {
                        Annotate.this.log.useSource(javaFileObject);
                    }
                }
            });
        } else {
            attributeAttacher.attach(symbol, list3);
        }
    }

    private <T extends Attribute.Compound> List<T> replacePlaceholders(List<T> list, AnnotationContext<T> annotationContext, Symbol symbol) {
        List<Object> list2 = List.nil();
        for (Attribute.Compound compound : list) {
            if (compound instanceof Placeholder) {
                T t = this.replaceOne((Placeholder)compound, annotationContext, symbol);
                if (null == t) continue;
                list2 = list2.prepend(t);
                continue;
            }
            list2 = list2.prepend(compound);
        }
        return list2.reverse();
    }

    private <T extends Attribute.Compound> T replaceOne(Placeholder<T> placeholder, AnnotationContext<T> annotationContext, Symbol symbol) {
        ListBuffer listBuffer;
        T t = this.processRepeatedAnnotations(placeholder.getPlaceholderFor(), annotationContext, symbol);
        if (t != null && (listBuffer = annotationContext.annotated.get(((Attribute.Compound)t).type.tsym)) != null) {
            this.log.error(annotationContext.pos.get(listBuffer.first()), "invalid.repeatable.annotation.repeated.and.container.present", ((Attribute.Compound)listBuffer.first()).type.tsym);
        }
        return t;
    }

    void annotateLater(final List<JCTree.JCAnnotation> list, final Env<AttrContext> env, final Symbol symbol, final JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        if (list.isEmpty()) {
            return;
        }
        if (symbol.kind != 1) {
            symbol.resetAnnotations();
        }
        this.normal(new Worker(){

            @Override
            public String toString() {
                return "annotate " + list + " onto " + symbol + " in " + symbol.owner;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Assert.check(symbol.kind == 1 || symbol.annotationsPendingCompletion());
                JavaFileObject javaFileObject = Annotate.this.log.useSource(env.toplevel.sourcefile);
                JCDiagnostic.DiagnosticPosition diagnosticPosition2 = diagnosticPosition != null ? Annotate.this.deferredLintHandler.setPos(diagnosticPosition) : Annotate.this.deferredLintHandler.immediate();
                Lint lint = diagnosticPosition != null ? null : Annotate.this.chk.setLint(Annotate.this.lint);
                try {
                    if (symbol.hasAnnotations() && list.nonEmpty()) {
                        Annotate.this.log.error(((JCTree.JCAnnotation)list.head).pos, "already.annotated", Kinds.kindName(symbol), symbol);
                    }
                    Annotate.this.actualEnterAnnotations(list, env, symbol);
                }
                finally {
                    if (lint != null) {
                        Annotate.this.chk.setLint(lint);
                    }
                    Annotate.this.deferredLintHandler.setPos(diagnosticPosition2);
                    Annotate.this.log.useSource(javaFileObject);
                }
            }
        });
        this.validate(new Worker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JavaFileObject javaFileObject = Annotate.this.log.useSource(env.toplevel.sourcefile);
                try {
                    Annotate.this.chk.validateAnnotations(list, symbol);
                }
                finally {
                    Annotate.this.log.useSource(javaFileObject);
                }
            }
        });
    }

    private void actualEnterAnnotations(List<JCTree.JCAnnotation> list, Env<AttrContext> env, Symbol symbol) {
        Assert.checkNonNull(symbol, "Symbol argument to actualEnterAnnotations is null");
        this.attachAttributesLater(list, env, symbol, false, this.enterAnnotationsCreator, this.declAnnotationsAttacher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualEnterTypeAnnotations(List<JCTree.JCAnnotation> list, Env<AttrContext> env, Symbol symbol, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        Assert.checkNonNull(symbol, "Symbol argument to actualEnterTypeAnnotations is nul/");
        JavaFileObject javaFileObject = this.log.useSource(env.toplevel.sourcefile);
        JCDiagnostic.DiagnosticPosition diagnosticPosition2 = null;
        if (diagnosticPosition != null) {
            diagnosticPosition2 = this.deferredLintHandler.setPos(diagnosticPosition);
        }
        try {
            this.attachAttributesLater(list, env, symbol, true, this.enterTypeAnnotationsCreator, this.typeAnnotationsAttacher);
        }
        finally {
            if (diagnosticPosition2 != null) {
                this.deferredLintHandler.setPos(diagnosticPosition2);
            }
            this.log.useSource(javaFileObject);
        }
    }

    public void annotateTypeLater(final JCTree jCTree, final Env<AttrContext> env, final Symbol symbol, final JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        Assert.checkNonNull(symbol);
        this.normal(new Worker(){

            @Override
            public String toString() {
                return "type annotate " + jCTree + " onto " + symbol + " in " + symbol.owner;
            }

            @Override
            public void run() {
                jCTree.accept(new TypeAnnotate(env, symbol, diagnosticPosition));
            }
        });
    }

    private class TypeAnnotate
    extends TreeScanner {
        private final Env<AttrContext> env;
        private final Symbol sym;
        private JCDiagnostic.DiagnosticPosition deferPos;

        public TypeAnnotate(Env<AttrContext> env, Symbol symbol, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
            this.env = env;
            this.sym = symbol;
            this.deferPos = diagnosticPosition;
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType jCAnnotatedType) {
            Annotate.this.actualEnterTypeAnnotations(jCAnnotatedType.annotations, this.env, this.sym, this.deferPos);
            super.visitAnnotatedType(jCAnnotatedType);
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
            Annotate.this.actualEnterTypeAnnotations(jCTypeParameter.annotations, this.env, this.sym, this.deferPos);
            super.visitTypeParameter(jCTypeParameter);
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray jCNewArray) {
            Annotate.this.actualEnterTypeAnnotations(jCNewArray.annotations, this.env, this.sym, this.deferPos);
            for (List<JCTree.JCAnnotation> list : jCNewArray.dimAnnotations) {
                Annotate.this.actualEnterTypeAnnotations(list, this.env, this.sym, this.deferPos);
            }
            super.visitNewArray(jCNewArray);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            this.scan(jCMethodDecl.mods);
            this.scan(jCMethodDecl.restype);
            this.scan(jCMethodDecl.typarams);
            this.scan(jCMethodDecl.recvparam);
            this.scan(jCMethodDecl.params);
            this.scan(jCMethodDecl.thrown);
            this.scan(jCMethodDecl.defaultValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            JCDiagnostic.DiagnosticPosition diagnosticPosition = this.deferPos;
            this.deferPos = jCVariableDecl.pos();
            try {
                if (this.sym != null && this.sym.kind == 4) {
                    this.scan(jCVariableDecl.mods);
                    this.scan(jCVariableDecl.vartype);
                }
                this.scan(jCVariableDecl.init);
            }
            finally {
                this.deferPos = diagnosticPosition;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            if (jCNewClass.def == null) {
                super.visitNewClass(jCNewClass);
            }
        }
    }

    private static interface AttributeCreator<T extends Attribute.Compound> {
        public T create(JCTree.JCAnnotation var1, Type var2, Env<AttrContext> var3);
    }

    private static interface AttributeAttacher<T extends Attribute.Compound> {
        public void attach(Symbol var1, List<T> var2);
    }

    private static class Placeholder<T extends Attribute.Compound>
    extends Attribute.Compound {
        private final AnnotationContext<T> ctx;
        private final List<T> placeholderFor;
        private final Symbol on;

        public Placeholder(AnnotationContext<T> annotationContext, List<T> list, Symbol symbol) {
            super(symbol.type, List.nil(), ((Attribute.Compound)list.head).position);
            this.ctx = annotationContext;
            this.placeholderFor = list;
            this.on = symbol;
        }

        @Override
        public String toString() {
            return "<placeholder: " + this.placeholderFor + " on: " + this.on + ">";
        }

        public List<T> getPlaceholderFor() {
            return this.placeholderFor;
        }

        public AnnotationContext<T> getRepeatedContext() {
            return this.ctx;
        }
    }

    private class AnnotationContext<T extends Attribute.Compound> {
        public final Env<AttrContext> env;
        public final Map<Symbol.TypeSymbol, ListBuffer<T>> annotated;
        public final Map<T, JCDiagnostic.DiagnosticPosition> pos;
        public final boolean isTypeCompound;

        public AnnotationContext(Env<AttrContext> env, Map<Symbol.TypeSymbol, ListBuffer<T>> map, Map<T, JCDiagnostic.DiagnosticPosition> map2, boolean bl) {
            Assert.checkNonNull(env);
            Assert.checkNonNull(map);
            Assert.checkNonNull(map2);
            this.env = env;
            this.annotated = map;
            this.pos = map2;
            this.isTypeCompound = bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("RepeatedContext[");
            for (Map.Entry<Symbol.TypeSymbol, ListBuffer<T>> entry : this.annotated.entrySet()) {
                stringBuilder.append(" ");
                stringBuilder.append(entry.getKey());
                stringBuilder.append(" = { ");
                stringBuilder.append(entry.getValue());
                stringBuilder.append(" }");
            }
            stringBuilder.append(" ]");
            return stringBuilder.toString();
        }
    }

    public static interface Worker {
        public void run();

        public String toString();
    }
}

