/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.tools.javac.api.Formattable;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Warner;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.ElementVisitor;

public class Resolve {
    protected static final Context.Key<Resolve> resolveKey = new Context.Key();
    Names names;
    Log log;
    Symtab syms;
    Attr attr;
    DeferredAttr deferredAttr;
    Check chk;
    Infer infer;
    ClassFinder finder;
    TreeInfo treeinfo;
    Types types;
    JCDiagnostic.Factory diags;
    public final boolean allowMethodHandles;
    public final boolean allowFunctionalInterfaceMostSpecific;
    public final boolean checkVarargsAccessAfterResolution;
    private final boolean debugResolve;
    private final boolean compactMethodDiags;
    final EnumSet<VerboseResolutionMode> verboseResolutionMode;
    Scope.WriteableScope polymorphicSignatureScope;
    private final SymbolNotFoundError varNotFound;
    private final SymbolNotFoundError methodNotFound;
    private final SymbolNotFoundError methodWithCorrectStaticnessNotFound;
    private final SymbolNotFoundError typeNotFound;
    Types.SimpleVisitor<Void, Env<AttrContext>> accessibilityChecker = new Types.SimpleVisitor<Void, Env<AttrContext>>(){

        void visit(List<Type> list, Env<AttrContext> env) {
            for (Type type : list) {
                this.visit(type, env);
            }
        }

        @Override
        public Void visitType(Type type, Env<AttrContext> env) {
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType arrayType, Env<AttrContext> env) {
            this.visit(arrayType.elemtype, env);
            return null;
        }

        @Override
        public Void visitClassType(Type.ClassType classType, Env<AttrContext> env) {
            this.visit((List<Type>)classType.getTypeArguments(), env);
            if (!Resolve.this.isAccessible(env, (Type)classType, true)) {
                Resolve.this.accessBase(new AccessError(classType.tsym), env.tree.pos(), env.enclClass.sym, classType, classType.tsym.name, true);
            }
            return null;
        }

        @Override
        public Void visitWildcardType(Type.WildcardType wildcardType, Env<AttrContext> env) {
            this.visit(wildcardType.type, env);
            return null;
        }

        @Override
        public Void visitMethodType(Type.MethodType methodType, Env<AttrContext> env) {
            this.visit((List<Type>)methodType.getParameterTypes(), env);
            this.visit(methodType.getReturnType(), env);
            this.visit((List<Type>)methodType.getThrownTypes(), env);
            return null;
        }
    };
    MethodCheck nilMethodCheck = new MethodCheck(){

        @Override
        public void argumentsAcceptable(Env<AttrContext> env, DeferredAttr.DeferredAttrContext deferredAttrContext, List<Type> list, List<Type> list2, Warner warner) {
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> list, boolean bl) {
            return this;
        }
    };
    MethodCheck arityMethodCheck = new AbstractMethodCheck(){

        @Override
        void checkArg(JCDiagnostic.DiagnosticPosition diagnosticPosition, boolean bl, Type type, Type type2, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warner) {
        }

        public String toString() {
            return "arityMethodCheck";
        }
    };
    MethodCheck resolveMethodCheck = new AbstractMethodCheck(){

        @Override
        void checkArg(JCDiagnostic.DiagnosticPosition diagnosticPosition, boolean bl, Type type, Type type2, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warner) {
            Attr.ResultInfo resultInfo = this.methodCheckResult(bl, type2, deferredAttrContext, warner);
            resultInfo.check(diagnosticPosition, type);
        }

        @Override
        public void argumentsAcceptable(Env<AttrContext> env, DeferredAttr.DeferredAttrContext deferredAttrContext, List<Type> list, List<Type> list2, Warner warner) {
            super.argumentsAcceptable(env, deferredAttrContext, list, list2, warner);
            if (deferredAttrContext.phase.isVarargsRequired()) {
                Type type = null;
                if (!Resolve.this.checkVarargsAccessAfterResolution) {
                    type = Resolve.this.types.elemtype(list2.last());
                } else if (deferredAttrContext.mode == DeferredAttr.AttrMode.CHECK) {
                    type = Resolve.this.types.erasure(Resolve.this.types.elemtype(list2.last()));
                }
                if (type != null) {
                    this.varargsAccessible(env, type, deferredAttrContext.inferenceContext);
                }
            }
        }

        private void varargsAccessible(final Env<AttrContext> env, final Type type, Infer.InferenceContext inferenceContext) {
            if (inferenceContext.free(type)) {
                inferenceContext.addFreeTypeListener(List.of(type), new Infer.FreeTypeListener(){

                    @Override
                    public void typesInferred(Infer.InferenceContext inferenceContext) {
                        this.varargsAccessible(env, inferenceContext.asInstType(type), inferenceContext);
                    }
                });
            } else if (!Resolve.this.isAccessible(env, type)) {
                Symbol.ClassSymbol classSymbol = env.enclClass.sym;
                this.reportMC(env.tree, MethodCheckDiag.INACCESSIBLE_VARARGS, inferenceContext, type, Kinds.kindName(classSymbol), classSymbol);
            }
        }

        private Attr.ResultInfo methodCheckResult(final boolean bl, Type type, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warner) {
            MethodCheckContext methodCheckContext = new MethodCheckContext(!deferredAttrContext.phase.isBoxingRequired(), deferredAttrContext, warner){
                MethodCheckDiag methodDiag;
                {
                    super(bl3, deferredAttrContext, warner);
                    this.methodDiag = bl ? MethodCheckDiag.VARARG_MISMATCH : MethodCheckDiag.ARG_MISMATCH;
                }

                @Override
                public void report(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic jCDiagnostic) {
                    this.reportMC(diagnosticPosition, this.methodDiag, this.deferredAttrContext.inferenceContext, jCDiagnostic);
                }
            };
            return new MethodResultInfo(type, methodCheckContext);
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> list, boolean bl) {
            return new MostSpecificCheck(bl, list);
        }

        public String toString() {
            return "resolveMethodCheck";
        }
    };
    private final InapplicableMethodException inapplicableMethodException;
    Warner noteWarner = new Warner();
    LogResolveHelper basicLogResolveHelper = new LogResolveHelper(){

        @Override
        public boolean resolveDiagnosticNeeded(Type type, List<Type> list, List<Type> list2) {
            return !type.isErroneous();
        }

        @Override
        public List<Type> getArgumentTypes(ResolveError resolveError, Symbol symbol, Name name, List<Type> list) {
            return list;
        }
    };
    LogResolveHelper methodLogResolveHelper = new LogResolveHelper(){

        @Override
        public boolean resolveDiagnosticNeeded(Type type, List<Type> list, List<Type> list2) {
            return !type.isErroneous() && !Type.isErroneous(list) && (list2 == null || !Type.isErroneous(list2));
        }

        @Override
        public List<Type> getArgumentTypes(ResolveError resolveError, Symbol symbol, Name name, List<Type> list) {
            return Resolve.this.syms.operatorNames.contains(name) ? list : Type.map(list, new ResolveDeferredRecoveryMap(DeferredAttr.AttrMode.SPECULATIVE, symbol, Resolve.this.currentResolutionContext.step));
        }
    };
    private final Formattable.LocalizedString noArgs = new Formattable.LocalizedString("compiler.misc.no.args");
    final List<MethodResolutionPhase> methodResolutionSteps = List.of(MethodResolutionPhase.BASIC, MethodResolutionPhase.BOX, MethodResolutionPhase.VARARITY);
    MethodResolutionContext currentResolutionContext = null;

    protected Resolve(Context context) {
        context.put(resolveKey, this);
        this.syms = Symtab.instance(context);
        this.varNotFound = new SymbolNotFoundError(133);
        this.methodNotFound = new SymbolNotFoundError(136);
        this.methodWithCorrectStaticnessNotFound = new SymbolNotFoundError(138, "method found has incorrect staticness");
        this.typeNotFound = new SymbolNotFoundError(137);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.attr = Attr.instance(context);
        this.deferredAttr = DeferredAttr.instance(context);
        this.chk = Check.instance(context);
        this.infer = Infer.instance(context);
        this.finder = ClassFinder.instance(context);
        this.treeinfo = TreeInfo.instance(context);
        this.types = Types.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        Source source = Source.instance(context);
        Options options = Options.instance(context);
        this.debugResolve = options.isSet("debugresolve");
        this.compactMethodDiags = options.isSet(Option.XDIAGS, "compact") || options.isUnset(Option.XDIAGS) && options.isUnset("rawDiagnostics");
        this.verboseResolutionMode = VerboseResolutionMode.getVerboseResolutionMode(options);
        Target target = Target.instance(context);
        this.allowMethodHandles = target.hasMethodHandles();
        this.allowFunctionalInterfaceMostSpecific = source.allowFunctionalInterfaceMostSpecific();
        this.checkVarargsAccessAfterResolution = source.allowPostApplicabilityVarargsAccessCheck();
        this.polymorphicSignatureScope = Scope.WriteableScope.create(this.syms.noSymbol);
        this.inapplicableMethodException = new InapplicableMethodException(this.diags);
    }

    public static Resolve instance(Context context) {
        Resolve resolve = context.get(resolveKey);
        if (resolve == null) {
            resolve = new Resolve(context);
        }
        return resolve;
    }

    void reportVerboseResolutionDiagnostic(JCDiagnostic.DiagnosticPosition diagnosticPosition, Name name, Type type, List<Type> list, List<Type> list2, Symbol symbol) {
        Object object2;
        boolean bl;
        boolean bl2 = bl = symbol.kind < 128;
        if (bl && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.SUCCESS)) {
            return;
        }
        if (!bl && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.FAILURE)) {
            return;
        }
        if (symbol.name == this.names.init && symbol.owner == this.syms.objectType.tsym && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.OBJECT_INIT)) {
            return;
        }
        if (type == this.syms.predefClass.type && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.PREDEF)) {
            return;
        }
        if (this.currentResolutionContext.internalResolution && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.INTERNAL)) {
            return;
        }
        int n = 0;
        int n2 = -1;
        ListBuffer<JCDiagnostic> listBuffer = new ListBuffer<JCDiagnostic>();
        for (Object object2 : this.currentResolutionContext.candidates) {
            if (this.currentResolutionContext.step != ((MethodResolutionContext.Candidate)object2).step || ((MethodResolutionContext.Candidate)object2).isApplicable() && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.APPLICABLE) || !((MethodResolutionContext.Candidate)object2).isApplicable() && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.INAPPLICABLE)) continue;
            listBuffer.append(((MethodResolutionContext.Candidate)object2).isApplicable() ? this.getVerboseApplicableCandidateDiag(n, ((MethodResolutionContext.Candidate)object2).sym, ((MethodResolutionContext.Candidate)object2).mtype) : this.getVerboseInapplicableCandidateDiag(n, ((MethodResolutionContext.Candidate)object2).sym, ((MethodResolutionContext.Candidate)object2).details));
            if (((MethodResolutionContext.Candidate)object2).sym == symbol) {
                n2 = n;
            }
            ++n;
        }
        String string = bl ? "verbose.resolve.multi" : "verbose.resolve.multi.1";
        DeferredAttr deferredAttr = this.deferredAttr;
        deferredAttr.getClass();
        object2 = Type.map(list, deferredAttr.new DeferredAttr.RecoveryDeferredTypeMap(DeferredAttr.AttrMode.SPECULATIVE, symbol, this.currentResolutionContext.step));
        JCDiagnostic jCDiagnostic = this.diags.note(this.log.currentSource(), diagnosticPosition, string, new Object[]{name, type.tsym, n2, this.currentResolutionContext.step, this.methodArguments((List<Type>)object2), this.methodArguments(list2)});
        JCDiagnostic.MultilineDiagnostic multilineDiagnostic = new JCDiagnostic.MultilineDiagnostic(jCDiagnostic, listBuffer.toList());
        this.log.report(multilineDiagnostic);
    }

    JCDiagnostic getVerboseApplicableCandidateDiag(int n, Symbol symbol, Type type) {
        JCDiagnostic jCDiagnostic = null;
        if (symbol.type.hasTag(TypeTag.FORALL)) {
            jCDiagnostic = this.diags.fragment("partial.inst.sig", type);
        }
        String string = jCDiagnostic == null ? "applicable.method.found" : "applicable.method.found.1";
        return this.diags.fragment(string, n, symbol, jCDiagnostic);
    }

    JCDiagnostic getVerboseInapplicableCandidateDiag(int n, Symbol symbol, JCDiagnostic jCDiagnostic) {
        return this.diags.fragment("not.applicable.method.found", n, symbol, jCDiagnostic);
    }

    protected static boolean isStatic(Env<AttrContext> env) {
        return env.outer != null && ((AttrContext)env.info).staticLevel > ((AttrContext)env.outer.info).staticLevel;
    }

    static boolean isInitializer(Env<AttrContext> env) {
        Symbol symbol = ((AttrContext)env.info).scope.owner;
        return symbol.isConstructor() || symbol.owner.kind == 2 && (symbol.kind == 4 || symbol.kind == 16 && (symbol.flags() & 0x100000L) != 0L) && (symbol.flags() & 8L) == 0L;
    }

    public boolean isAccessible(Env<AttrContext> env, Symbol.TypeSymbol typeSymbol) {
        return this.isAccessible(env, typeSymbol, false);
    }

    public boolean isAccessible(Env<AttrContext> env, Symbol.TypeSymbol typeSymbol, boolean bl) {
        boolean bl2 = false;
        switch ((short)(typeSymbol.flags() & 7L)) {
            case 2: {
                bl2 = env.enclClass.sym.outermostClass() == typeSymbol.owner.outermostClass();
                break;
            }
            case 0: {
                bl2 = env.toplevel.packge == typeSymbol.owner || env.toplevel.packge == typeSymbol.packge() || env.enclMethod != null && (env.enclMethod.mods.flags & 0x20000000L) != 0L;
                break;
            }
            default: {
                bl2 = true;
                break;
            }
            case 4: {
                boolean bl3 = bl2 = env.toplevel.packge == typeSymbol.owner || env.toplevel.packge == typeSymbol.packge() || this.isInnerSubClass(env.enclClass.sym, typeSymbol.owner);
            }
        }
        return !bl || typeSymbol.type.getEnclosingType() == Type.noType ? bl2 : bl2 && this.isAccessible(env, typeSymbol.type.getEnclosingType(), bl);
    }

    private boolean isInnerSubClass(Symbol.ClassSymbol classSymbol, Symbol symbol) {
        while (classSymbol != null && !classSymbol.isSubClass(symbol, this.types)) {
            classSymbol = classSymbol.owner.enclClass();
        }
        return classSymbol != null;
    }

    boolean isAccessible(Env<AttrContext> env, Type type) {
        return this.isAccessible(env, type, false);
    }

    boolean isAccessible(Env<AttrContext> env, Type type, boolean bl) {
        return type.hasTag(TypeTag.ARRAY) ? this.isAccessible(env, this.types.cvarUpperBound(this.types.elemtype(type))) : this.isAccessible(env, type.tsym, bl);
    }

    public boolean isAccessible(Env<AttrContext> env, Type type, Symbol symbol) {
        return this.isAccessible(env, type, symbol, false);
    }

    public boolean isAccessible(Env<AttrContext> env, Type type, Symbol symbol, boolean bl) {
        if (symbol.name == this.names.init && symbol.owner != type.tsym) {
            return false;
        }
        switch ((short)(symbol.flags() & 7L)) {
            case 2: {
                return (env.enclClass.sym == symbol.owner || env.enclClass.sym.outermostClass() == symbol.owner.outermostClass()) && symbol.isInheritedIn(type.tsym, this.types);
            }
            case 0: {
                return (env.toplevel.packge == symbol.owner.owner || env.toplevel.packge == symbol.packge()) && this.isAccessible(env, type, bl) && symbol.isInheritedIn(type.tsym, this.types) && this.notOverriddenIn(type, symbol);
            }
            case 4: {
                return (env.toplevel.packge == symbol.owner.owner || env.toplevel.packge == symbol.packge() || this.isProtectedAccessible(symbol, env.enclClass.sym, type) || ((AttrContext)env.info).selectSuper && (symbol.flags() & 8L) == 0L && symbol.kind != 2) && this.isAccessible(env, type, bl) && this.notOverriddenIn(type, symbol);
            }
        }
        return this.isAccessible(env, type, bl) && this.notOverriddenIn(type, symbol);
    }

    private boolean notOverriddenIn(Type type, Symbol symbol) {
        if (symbol.kind != 16 || symbol.isConstructor() || symbol.isStatic()) {
            return true;
        }
        Symbol.MethodSymbol methodSymbol = ((Symbol.MethodSymbol)symbol).implementation(type.tsym, this.types, true);
        return methodSymbol == null || methodSymbol == symbol || symbol.owner == methodSymbol.owner || !this.types.isSubSignature(this.types.memberType(type, methodSymbol), this.types.memberType(type, symbol));
    }

    private boolean isProtectedAccessible(Symbol symbol, Symbol.ClassSymbol classSymbol, Type type) {
        Type type2;
        Type type3 = type2 = type.hasTag(TypeTag.TYPEVAR) ? type.getUpperBound() : type;
        while (classSymbol != null && (!classSymbol.isSubClass(symbol.owner, this.types) || (classSymbol.flags() & 0x200L) != 0L || (symbol.flags() & 8L) == 0L && symbol.kind != 2 && !type2.tsym.isSubClass(classSymbol, this.types))) {
            classSymbol = classSymbol.owner.enclClass();
        }
        return classSymbol != null;
    }

    void checkAccessibleType(Env<AttrContext> env, Type type) {
        this.accessibilityChecker.visit(type, env);
    }

    Type rawInstantiate(Env<AttrContext> env, Type type, Symbol symbol, Attr.ResultInfo resultInfo, List<Type> list, List<Type> list2, boolean bl, boolean bl2, Warner warner) throws Infer.InferenceException {
        List list3;
        Type type2 = this.types.memberType(type, symbol);
        List<Type> list4 = List.nil();
        if (list2 == null) {
            list2 = List.nil();
        }
        if (type2.hasTag(TypeTag.FORALL) || !list2.nonEmpty()) {
            Type.ForAll forAll;
            if (type2.hasTag(TypeTag.FORALL) && list2.nonEmpty()) {
                forAll = (Type.ForAll)type2;
                if (list2.length() != forAll.tvars.length()) {
                    throw this.inapplicableMethodException.setMessage("arg.length.mismatch");
                }
                list3 = forAll.tvars;
                List<Type> list5 = list2;
                while (list3.nonEmpty() && list5.nonEmpty()) {
                    List<Type> list6 = this.types.subst(this.types.getBounds((Type.TypeVar)list3.head), forAll.tvars, list2);
                    while (list6.nonEmpty()) {
                        if (!this.types.isSubtypeUnchecked((Type)list5.head, (Type)list6.head, warner)) {
                            throw this.inapplicableMethodException.setMessage("explicit.param.do.not.conform.to.bounds", list5.head, list6);
                        }
                        list6 = list6.tail;
                    }
                    list3 = list3.tail;
                    list5 = list5.tail;
                }
                type2 = this.types.subst(forAll.qtype, forAll.tvars, list2);
            } else if (type2.hasTag(TypeTag.FORALL)) {
                forAll = (Type.ForAll)type2;
                list3 = this.types.newInstances(forAll.tvars);
                list4 = list4.appendList(list3);
                type2 = this.types.subst(forAll.qtype, forAll.tvars, (List<Type>)list3);
            }
        }
        boolean bl3 = list4.tail != null;
        list3 = list;
        while (list3.tail != null && !bl3) {
            if (((Type)list3.head).hasTag(TypeTag.FORALL)) {
                bl3 = true;
            }
            list3 = list3.tail;
        }
        if (bl3) {
            return this.infer.instantiateMethod(env, list4, (Type.MethodType)type2, resultInfo, (Symbol.MethodSymbol)symbol, list, bl, bl2, this.currentResolutionContext, warner);
        }
        list3 = this.currentResolutionContext.deferredAttrContext(symbol, this.infer.emptyContext, resultInfo, warner);
        this.currentResolutionContext.methodCheck.argumentsAcceptable(env, (DeferredAttr.DeferredAttrContext)((Object)list3), list, type2.getParameterTypes(), warner);
        ((DeferredAttr.DeferredAttrContext)((Object)list3)).complete();
        return type2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type checkMethod(Env<AttrContext> env, Type type, Symbol symbol, Attr.ResultInfo resultInfo, List<Type> list, List<Type> list2, Warner warner) {
        MethodResolutionContext methodResolutionContext = this.currentResolutionContext;
        try {
            this.currentResolutionContext = new MethodResolutionContext();
            this.currentResolutionContext.attrMode = DeferredAttr.AttrMode.CHECK;
            if (env.tree.hasTag(JCTree.Tag.REFERENCE)) {
                this.currentResolutionContext.methodCheck = new MethodReferenceCheck(resultInfo.checkContext.inferenceContext());
            }
            MethodResolutionPhase methodResolutionPhase = this.currentResolutionContext.step = ((AttrContext)env.info).pendingResolutionPhase;
            Type type2 = this.rawInstantiate(env, type, symbol, resultInfo, list, list2, methodResolutionPhase.isBoxingRequired(), methodResolutionPhase.isVarargsRequired(), warner);
            return type2;
        }
        finally {
            this.currentResolutionContext = methodResolutionContext;
        }
    }

    Type instantiate(Env<AttrContext> env, Type type, Symbol symbol, Attr.ResultInfo resultInfo, List<Type> list, List<Type> list2, boolean bl, boolean bl2, Warner warner) {
        try {
            return this.rawInstantiate(env, type, symbol, resultInfo, list, list2, bl, bl2, warner);
        }
        catch (InapplicableMethodException inapplicableMethodException) {
            return null;
        }
    }

    List<Type> dummyArgs(int n) {
        ListBuffer<Type.JCNoType> listBuffer = new ListBuffer<Type.JCNoType>();
        for (int i = 0; i < n; ++i) {
            listBuffer.append(Type.noType);
        }
        return listBuffer.toList();
    }

    /*
     * WARNING - void declaration
     */
    Symbol findField(Env<AttrContext> env, Type type, Name name, Symbol.TypeSymbol typeSymbol) {
        void var8_9;
        Symbol symbol;
        while (typeSymbol.type.hasTag(TypeTag.TYPEVAR)) {
            typeSymbol = typeSymbol.type.getUpperBound().tsym;
        }
        Symbol symbol2 = this.varNotFound;
        for (Symbol list2 : typeSymbol.members().getSymbolsByName(name)) {
            if (list2.kind != 4 || (list2.flags_field & 0x1000L) != 0L) continue;
            return this.isAccessible(env, type, list2) ? list2 : new AccessError(env, type, list2);
        }
        Type type2 = this.types.supertype(typeSymbol.type);
        if (type2 != null && (type2.hasTag(TypeTag.CLASS) || type2.hasTag(TypeTag.TYPEVAR))) {
            symbol = this.findField(env, type, name, type2.tsym);
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
        }
        List<Type> list = this.types.interfaces(typeSymbol.type);
        while (symbol2.kind != 129 && var8_9.nonEmpty()) {
            symbol = this.findField(env, type, name, ((Type)var8_9.head).tsym);
            if (symbol2.exists() && symbol.exists() && symbol.owner != symbol2.owner) {
                symbol2 = new AmbiguityError(symbol2, symbol);
            } else if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
            List list2 = var8_9.tail;
        }
        return symbol2;
    }

    public Symbol.VarSymbol resolveInternalField(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Type type, Name name) {
        Symbol symbol = this.findField(env, type, name, type.tsym);
        if (symbol.kind == 4) {
            return (Symbol.VarSymbol)symbol;
        }
        throw new FatalError(this.diags.fragment("fatal.err.cant.locate.field", name));
    }

    Symbol findVar(Env<AttrContext> env, Name name) {
        Symbol symbol;
        Symbol symbol2 = this.varNotFound;
        Env<AttrContext> env2 = env;
        boolean bl = false;
        while (env2.outer != null) {
            symbol = null;
            if (Resolve.isStatic(env2)) {
                bl = true;
            }
            for (Symbol scopeArray : ((AttrContext)env2.info).scope.getSymbolsByName(name)) {
                if (scopeArray.kind != 4 || (scopeArray.flags_field & 0x1000L) != 0L) continue;
                symbol = scopeArray;
                break;
            }
            if (symbol == null) {
                symbol = this.findField(env2, env2.enclClass.sym.type, name, env2.enclClass.sym);
            }
            if (symbol.exists()) {
                if (bl && symbol.kind == 4 && symbol.owner.kind == 2 && (symbol.flags() & 8L) == 0L) {
                    return new StaticError(symbol);
                }
                return symbol;
            }
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
            if ((env2.enclClass.sym.flags() & 8L) != 0L) {
                bl = true;
            }
            env2 = env2.outer;
        }
        symbol = this.findField(env, this.syms.predefClass.type, name, this.syms.predefClass);
        if (symbol.exists()) {
            return symbol;
        }
        if (symbol2.exists()) {
            return symbol2;
        }
        Object object = null;
        for (Scope scope : new Scope[]{env.toplevel.namedImportScope, env.toplevel.starImportScope}) {
            for (Symbol symbol3 : scope.getSymbolsByName(name)) {
                if (symbol3.kind != 4) continue;
                if (symbol2.kind < 129 && symbol3.owner != symbol2.owner) {
                    return new AmbiguityError(symbol2, symbol3);
                }
                if (symbol2.kind < 4) continue;
                object = scope.getOrigin((Symbol)symbol3).owner;
                symbol2 = this.isAccessible(env, ((Symbol)object).type, symbol3) ? symbol3 : new AccessError(env, ((Symbol)object).type, symbol3);
            }
            if (symbol2.exists()) break;
        }
        if (symbol2.kind == 4 && symbol2.owner.type != ((Symbol)object).type) {
            return symbol2.clone((Symbol)object);
        }
        return symbol2;
    }

    Symbol selectBest(Env<AttrContext> env, Type type, List<Type> list, List<Type> list2, Symbol symbol, Symbol symbol2, boolean bl, boolean bl2, boolean bl3) {
        if (symbol.kind == 63 || !symbol.isInheritedIn(type.tsym, this.types)) {
            return symbol2;
        }
        if (bl2 && (symbol.flags() & 0x400000000L) == 0L) {
            return symbol2.kind >= 128 ? new BadVarargsMethod((ResolveError)symbol2.baseSymbol()) : symbol2;
        }
        Assert.check(symbol.kind < 129);
        try {
            Type type2 = this.rawInstantiate(env, type, symbol, null, list, list2, bl, bl2, this.types.noWarnings);
            if (!bl3 || this.verboseResolutionMode.contains((Object)VerboseResolutionMode.PREDEF)) {
                this.currentResolutionContext.addApplicableCandidate(symbol, type2);
            }
        }
        catch (InapplicableMethodException inapplicableMethodException) {
            if (!bl3) {
                this.currentResolutionContext.addInapplicableCandidate(symbol, inapplicableMethodException.getDiagnostic());
            }
            switch (symbol2.kind) {
                case 136: {
                    return new InapplicableSymbolError(this.currentResolutionContext);
                }
                case 135: {
                    if (bl3) {
                        return symbol2;
                    }
                    symbol2 = new InapplicableSymbolsError(this.currentResolutionContext);
                }
            }
            return symbol2;
        }
        if (!this.isAccessible(env, type, symbol)) {
            return symbol2.kind == 136 ? new AccessError(env, type, symbol) : symbol2;
        }
        return symbol2.kind > 129 ? symbol : this.mostSpecific(list, symbol, symbol2, env, type, bl && bl3, bl2);
    }

    Symbol mostSpecific(List<Type> list, Symbol symbol, Symbol symbol2, Env<AttrContext> env, Type type, boolean bl, boolean bl2) {
        switch (symbol2.kind) {
            case 16: {
                if (symbol == symbol2) {
                    return symbol;
                }
                boolean bl3 = this.signatureMoreSpecific(list, env, type, symbol, symbol2, bl, bl2);
                boolean bl4 = this.signatureMoreSpecific(list, env, type, symbol2, symbol, bl, bl2);
                if (bl3 && bl4) {
                    boolean bl5;
                    Type type2;
                    Type type3 = this.types.memberType(type, symbol);
                    if (!this.types.overrideEquivalent(type3, type2 = this.types.memberType(type, symbol2))) {
                        return this.ambiguityError(symbol, symbol2);
                    }
                    if ((symbol.flags() & 0x80000000L) != (symbol2.flags() & 0x80000000L)) {
                        return (symbol.flags() & 0x80000000L) != 0L ? symbol2 : symbol;
                    }
                    Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)symbol.owner;
                    Symbol.TypeSymbol typeSymbol2 = (Symbol.TypeSymbol)symbol2.owner;
                    if (this.types.asSuper(typeSymbol.type, typeSymbol2) != null && ((symbol.owner.flags_field & 0x200L) == 0L || (symbol2.owner.flags_field & 0x200L) != 0L) && symbol.overrides(symbol2, typeSymbol, this.types, false)) {
                        return symbol;
                    }
                    if (this.types.asSuper(typeSymbol2.type, typeSymbol) != null && ((symbol2.owner.flags_field & 0x200L) == 0L || (symbol.owner.flags_field & 0x200L) != 0L) && symbol2.overrides(symbol, typeSymbol2, this.types, false)) {
                        return symbol2;
                    }
                    boolean bl6 = (symbol.flags() & 0x400L) != 0L;
                    boolean bl7 = bl5 = (symbol2.flags() & 0x400L) != 0L;
                    if (bl6 && !bl5) {
                        return symbol2;
                    }
                    if (bl5 && !bl6) {
                        return symbol;
                    }
                    return this.ambiguityError(symbol, symbol2);
                }
                if (bl3) {
                    return symbol;
                }
                if (bl4) {
                    return symbol2;
                }
                return this.ambiguityError(symbol, symbol2);
            }
            case 129: {
                AmbiguityError ambiguityError = (AmbiguityError)symbol2.baseSymbol();
                boolean bl8 = true;
                boolean bl9 = true;
                for (Symbol symbol3 : ambiguityError.ambiguousSyms) {
                    Symbol symbol4 = this.mostSpecific(list, symbol, symbol3, env, type, bl, bl2);
                    bl8 &= symbol4 == symbol;
                    bl9 &= symbol4 == symbol3;
                }
                if (bl8) {
                    return symbol;
                }
                if (!bl9) {
                    ambiguityError.addAmbiguousSymbol(symbol);
                }
                return ambiguityError;
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean signatureMoreSpecific(List<Type> list, Env<AttrContext> env, Type type, Symbol symbol, Symbol symbol2, boolean bl, boolean bl2) {
        this.noteWarner.clear();
        int n = Math.max(Math.max(symbol.type.getParameterTypes().length(), list.length()), symbol2.type.getParameterTypes().length());
        MethodResolutionContext methodResolutionContext = this.currentResolutionContext;
        try {
            this.currentResolutionContext = new MethodResolutionContext();
            this.currentResolutionContext.step = methodResolutionContext.step;
            this.currentResolutionContext.methodCheck = methodResolutionContext.methodCheck.mostSpecificCheck(list, !bl);
            Type type2 = this.instantiate(env, type, symbol2, null, this.adjustArgs(this.types.cvarLowerBounds(this.types.memberType(type, symbol).getParameterTypes()), symbol, n, bl2), null, bl, bl2, this.noteWarner);
            boolean bl3 = type2 != null && !this.noteWarner.hasLint(Lint.LintCategory.UNCHECKED);
            return bl3;
        }
        finally {
            this.currentResolutionContext = methodResolutionContext;
        }
    }

    List<Type> adjustArgs(List<Type> list, Symbol symbol, int n, boolean bl) {
        if ((symbol.flags() & 0x400000000L) != 0L && bl) {
            Type type = this.types.elemtype(list.last());
            if (type == null) {
                Assert.error("Bad varargs = " + list.last() + " " + symbol);
            }
            List<Type> list2 = list.reverse().tail.prepend(type).reverse();
            while (list2.length() < n) {
                list2 = list2.append(list2.last());
            }
            return list2;
        }
        return list;
    }

    Type mostSpecificReturnType(Type type, Type type2) {
        Type type3 = type.getReturnType();
        Type type4 = type2.getReturnType();
        if (type.hasTag(TypeTag.FORALL) && type2.hasTag(TypeTag.FORALL)) {
            type3 = this.types.subst(type3, type.getTypeArguments(), type2.getTypeArguments());
        }
        if (this.types.isSubtype(type3, type4)) {
            return type;
        }
        if (this.types.isSubtype(type4, type3)) {
            return type2;
        }
        if (this.types.returnTypeSubstitutable(type, type2)) {
            return type;
        }
        if (this.types.returnTypeSubstitutable(type2, type)) {
            return type2;
        }
        return null;
    }

    Symbol ambiguityError(Symbol symbol, Symbol symbol2) {
        if (((symbol.flags() | symbol2.flags()) & 0x40000000000L) != 0L) {
            return (symbol.flags() & 0x40000000000L) == 0L ? symbol : symbol2;
        }
        return new AmbiguityError(symbol, symbol2);
    }

    Symbol findMethodInScope(Env<AttrContext> env, Type type, Name name, List<Type> list, List<Type> list2, Scope scope, Symbol symbol, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        for (Symbol symbol2 : scope.getSymbolsByName(name, new LookupFilter(bl4))) {
            symbol = this.selectBest(env, type, list, list2, symbol2, symbol, bl, bl2, bl3);
        }
        return symbol;
    }

    Symbol findMethod(Env<AttrContext> env, Type type, Name name, List<Type> list, List<Type> list2, boolean bl, boolean bl2, boolean bl3) {
        Symbol symbol = this.methodNotFound;
        symbol = this.findMethod(env, type, name, list, list2, type.tsym.type, symbol, bl, bl2, bl3);
        return symbol;
    }

    private Symbol findMethod(Env<AttrContext> env, Type type, Name name, List<Type> list, List<Type> list2, Type type2, Symbol object, boolean bl, boolean bl2, boolean bl3) {
        List[] listArray = new List[]{List.nil(), List.nil()};
        InterfaceLookupPhase interfaceLookupPhase = InterfaceLookupPhase.ABSTRACT_OK;
        for (Symbol.TypeSymbol interfaceLookupPhaseArray : this.superclasses(type2)) {
            object = this.findMethodInScope(env, type, name, list, list2, interfaceLookupPhaseArray.members(), (Symbol)object, bl, bl2, bl3, true);
            if (name == this.names.init) {
                return object;
            }
            if ((interfaceLookupPhase = interfaceLookupPhase == null ? null : interfaceLookupPhase.update(interfaceLookupPhaseArray, this)) == null) continue;
            for (Type type3 : this.types.interfaces(interfaceLookupPhaseArray.type)) {
                listArray[interfaceLookupPhase.ordinal()] = this.types.union(this.types.closure(type3), listArray[interfaceLookupPhase.ordinal()]);
            }
        }
        Object object2 = ((Symbol)object).kind < 63 && (((Symbol)object).flags() & 0x400L) == 0L ? object : this.methodNotFound;
        for (InterfaceLookupPhase interfaceLookupPhase2 : InterfaceLookupPhase.values()) {
            for (Type type4 : listArray[interfaceLookupPhase2.ordinal()]) {
                if (!type4.isInterface() || interfaceLookupPhase2 == InterfaceLookupPhase.DEFAULT_OK && (type4.tsym.flags() & 0x80000000000L) == 0L || object2 == (object = this.findMethodInScope(env, type, name, list, list2, type4.tsym.members(), (Symbol)object, bl, bl2, bl3, true)) || ((Symbol)object2).kind >= 63 || ((Symbol)object).kind >= 63 || !this.types.isSubSignature(((Symbol)object2).type, ((Symbol)object).type)) continue;
                object = object2;
            }
        }
        return object;
    }

    Iterable<Symbol.TypeSymbol> superclasses(final Type type) {
        return new Iterable<Symbol.TypeSymbol>(){

            @Override
            public Iterator<Symbol.TypeSymbol> iterator() {
                return new Iterator<Symbol.TypeSymbol>(){
                    List<Symbol.TypeSymbol> seen = List.nil();
                    Symbol.TypeSymbol currentSym;
                    Symbol.TypeSymbol prevSym;
                    {
                        this.currentSym = this.symbolFor(type);
                        this.prevSym = null;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.currentSym == Resolve.this.syms.noSymbol) {
                            this.currentSym = this.symbolFor(Resolve.this.types.supertype(this.prevSym.type));
                        }
                        return this.currentSym != null;
                    }

                    @Override
                    public Symbol.TypeSymbol next() {
                        this.prevSym = this.currentSym;
                        this.currentSym = Resolve.this.syms.noSymbol;
                        Assert.check(this.prevSym != null || this.prevSym != Resolve.this.syms.noSymbol);
                        return this.prevSym;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    Symbol.TypeSymbol symbolFor(Type type) {
                        if (!type.hasTag(TypeTag.CLASS) && !type.hasTag(TypeTag.TYPEVAR)) {
                            return null;
                        }
                        while (type.hasTag(TypeTag.TYPEVAR)) {
                            type = type.getUpperBound();
                        }
                        if (this.seen.contains(type.tsym)) {
                            return null;
                        }
                        this.seen = this.seen.prepend(type.tsym);
                        return type.tsym;
                    }
                };
            }
        };
    }

    Symbol findFun(Env<AttrContext> env, Name name, List<Type> list, List<Type> list2, boolean bl, boolean bl2) {
        Symbol symbol;
        Symbol symbol2;
        Symbol symbol3 = this.methodNotFound;
        Env<AttrContext> env2 = env;
        boolean bl3 = false;
        while (env2.outer != null) {
            if (Resolve.isStatic(env2)) {
                bl3 = true;
            }
            if ((symbol2 = this.findMethod(env2, env2.enclClass.sym.type, name, list, list2, bl, bl2, false)).exists()) {
                if (bl3 && symbol2.kind == 16 && symbol2.owner.kind == 2 && (symbol2.flags() & 8L) == 0L) {
                    return new StaticError(symbol2);
                }
                return symbol2;
            }
            if (symbol2.kind < symbol3.kind) {
                symbol3 = symbol2;
            }
            if ((env2.enclClass.sym.flags() & 8L) != 0L) {
                bl3 = true;
            }
            env2 = env2.outer;
        }
        symbol2 = this.findMethod(env, this.syms.predefClass.type, name, list, list2, bl, bl2, false);
        if (symbol2.exists()) {
            return symbol2;
        }
        for (Symbol symbol4 : env.toplevel.namedImportScope.getSymbolsByName(name)) {
            symbol = env.toplevel.namedImportScope.getOrigin((Symbol)symbol4).owner;
            if (symbol4.kind != 16) continue;
            if (symbol4.owner.type != symbol.type) {
                symbol4 = symbol4.clone(symbol);
            }
            if (!this.isAccessible(env, symbol.type, symbol4)) {
                symbol4 = new AccessError(env, symbol.type, symbol4);
            }
            symbol3 = this.selectBest(env, symbol.type, list, list2, symbol4, symbol3, bl, bl2, false);
        }
        if (symbol3.exists()) {
            return symbol3;
        }
        for (Symbol symbol4 : env.toplevel.starImportScope.getSymbolsByName(name)) {
            symbol = env.toplevel.starImportScope.getOrigin((Symbol)symbol4).owner;
            if (symbol4.kind != 16) continue;
            if (symbol4.owner.type != symbol.type) {
                symbol4 = symbol4.clone(symbol);
            }
            if (!this.isAccessible(env, symbol.type, symbol4)) {
                symbol4 = new AccessError(env, symbol.type, symbol4);
            }
            symbol3 = this.selectBest(env, symbol.type, list, list2, symbol4, symbol3, bl, bl2, false);
        }
        return symbol3;
    }

    Symbol loadClass(Env<AttrContext> env, Name name) {
        try {
            Symbol.ClassSymbol classSymbol = this.finder.loadClass(name);
            return this.isAccessible(env, classSymbol) ? classSymbol : new AccessError(classSymbol);
        }
        catch (ClassFinder.BadClassFile badClassFile) {
            throw badClassFile;
        }
        catch (Symbol.CompletionFailure completionFailure) {
            return this.typeNotFound;
        }
    }

    Symbol findImmediateMemberType(Env<AttrContext> env, Type type, Name name, Symbol.TypeSymbol typeSymbol) {
        for (Symbol symbol : typeSymbol.members().getSymbolsByName(name)) {
            if (symbol.kind != 2) continue;
            return this.isAccessible(env, type, symbol) ? symbol : new AccessError(env, type, symbol);
        }
        return this.typeNotFound;
    }

    Symbol findInheritedMemberType(Env<AttrContext> env, Type type, Name name, Symbol.TypeSymbol typeSymbol) {
        Symbol symbol;
        Symbol symbol2 = this.typeNotFound;
        Type type2 = this.types.supertype(typeSymbol.type);
        if (type2 != null && type2.hasTag(TypeTag.CLASS)) {
            symbol = this.findMemberType(env, type, name, type2.tsym);
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
        }
        List<Type> list = this.types.interfaces(typeSymbol.type);
        while (symbol2.kind != 129 && list.nonEmpty()) {
            symbol = this.findMemberType(env, type, name, ((Type)list.head).tsym);
            if (symbol2.kind < 129 && symbol.kind < 129 && symbol.owner != symbol2.owner) {
                symbol2 = new AmbiguityError(symbol2, symbol);
            } else if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
            list = list.tail;
        }
        return symbol2;
    }

    Symbol findMemberType(Env<AttrContext> env, Type type, Name name, Symbol.TypeSymbol typeSymbol) {
        Symbol symbol = this.findImmediateMemberType(env, type, name, typeSymbol);
        if (symbol != this.typeNotFound) {
            return symbol;
        }
        return this.findInheritedMemberType(env, type, name, typeSymbol);
    }

    Symbol findGlobalType(Env<AttrContext> env, Scope scope, Name name) {
        Symbol symbol = this.typeNotFound;
        for (Symbol symbol2 : scope.getSymbolsByName(name)) {
            Symbol symbol3 = this.loadClass(env, symbol2.flatName());
            if (symbol.kind == 2 && symbol3.kind == 2 && symbol != symbol3) {
                return new AmbiguityError(symbol, symbol3);
            }
            if (symbol3.kind >= symbol.kind) continue;
            symbol = symbol3;
        }
        return symbol;
    }

    Symbol findTypeVar(Env<AttrContext> env, Name name, boolean bl) {
        for (Symbol symbol : ((AttrContext)env.info).scope.getSymbolsByName(name)) {
            if (symbol.kind != 2) continue;
            if (bl && symbol.type.hasTag(TypeTag.TYPEVAR) && symbol.owner.kind == 2) {
                return new StaticError(symbol);
            }
            return symbol;
        }
        return this.typeNotFound;
    }

    Symbol findType(Env<AttrContext> env, Name name) {
        Symbol symbol;
        Symbol symbol2 = this.typeNotFound;
        boolean bl = false;
        Env<AttrContext> env2 = env;
        while (env2.outer != null) {
            JCTree.JCClassDecl jCClassDecl;
            if (Resolve.isStatic(env2)) {
                bl = true;
            }
            Symbol symbol3 = this.findTypeVar(env2, name, bl);
            symbol = this.findImmediateMemberType(env2, env2.enclClass.sym.type, name, env2.enclClass.sym);
            if (symbol3 != this.typeNotFound && (symbol == this.typeNotFound || symbol3.kind == 2 && symbol3.exists() && symbol3.owner.kind == 16)) {
                return symbol3;
            }
            if (symbol == this.typeNotFound) {
                symbol = this.findInheritedMemberType(env2, env2.enclClass.sym.type, name, env2.enclClass.sym);
            }
            if (bl && symbol.kind == 2 && symbol.type.hasTag(TypeTag.CLASS) && symbol.type.getEnclosingType().hasTag(TypeTag.CLASS) && env2.enclClass.sym.type.isParameterized() && symbol.type.getEnclosingType().isParameterized()) {
                return new StaticError(symbol);
            }
            if (symbol.exists()) {
                return symbol;
            }
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
            JCTree.JCClassDecl jCClassDecl2 = jCClassDecl = env2.baseClause ? (JCTree.JCClassDecl)env2.tree : env2.enclClass;
            if ((jCClassDecl.sym.flags() & 8L) != 0L) {
                bl = true;
            }
            env2 = env2.outer;
        }
        if (!env.tree.hasTag(JCTree.Tag.IMPORT)) {
            symbol = this.findGlobalType(env, env.toplevel.namedImportScope, name);
            if (symbol.exists()) {
                return symbol;
            }
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
            if ((symbol = this.findGlobalType(env, env.toplevel.packge.members(), name)).exists()) {
                return symbol;
            }
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
            if ((symbol = this.findGlobalType(env, env.toplevel.starImportScope, name)).exists()) {
                return symbol;
            }
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
        }
        return symbol2;
    }

    Symbol findIdent(Env<AttrContext> env, Name name, int n) {
        Symbol symbol;
        Symbol symbol2 = this.typeNotFound;
        if ((n & 4) != 0) {
            symbol = this.findVar(env, name);
            if (symbol.exists()) {
                return symbol;
            }
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
        }
        if ((n & 2) != 0) {
            symbol = this.findType(env, name);
            if (symbol.kind == 2) {
                this.reportDependence(env.enclClass.sym, symbol);
            }
            if (symbol.exists()) {
                return symbol;
            }
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
        }
        if ((n & 1) != 0) {
            return this.syms.enterPackage(name);
        }
        return symbol2;
    }

    public void reportDependence(Symbol symbol, Symbol symbol2) {
    }

    Symbol findIdentInPackage(Env<AttrContext> env, Symbol.TypeSymbol typeSymbol, Name name, int n) {
        Name name2 = Symbol.TypeSymbol.formFullName(name, typeSymbol);
        Symbol symbol = this.typeNotFound;
        Symbol.PackageSymbol packageSymbol = null;
        if ((n & 1) != 0 && (packageSymbol = this.syms.enterPackage(name2)).exists()) {
            return packageSymbol;
        }
        if ((n & 2) != 0) {
            Symbol symbol2 = this.loadClass(env, name2);
            if (symbol2.exists()) {
                if (name == symbol2.name) {
                    return symbol2;
                }
            } else if (symbol2.kind < symbol.kind) {
                symbol = symbol2;
            }
        }
        return packageSymbol != null ? packageSymbol : symbol;
    }

    Symbol findIdentInType(Env<AttrContext> env, Type type, Name name, int n) {
        Symbol symbol;
        Symbol symbol2 = this.typeNotFound;
        if ((n & 4) != 0) {
            symbol = this.findField(env, type, name, type.tsym);
            if (symbol.exists()) {
                return symbol;
            }
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
        }
        if ((n & 2) != 0) {
            symbol = this.findMemberType(env, type, name, type.tsym);
            if (symbol.exists()) {
                return symbol;
            }
            if (symbol.kind < symbol2.kind) {
                symbol2 = symbol;
            }
        }
        return symbol2;
    }

    Symbol accessInternal(Symbol symbol, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol2, Type type, Name name, boolean bl, List<Type> list, List<Type> list2, LogResolveHelper logResolveHelper) {
        ResolveError resolveError;
        if (symbol.kind >= 129 && logResolveHelper.resolveDiagnosticNeeded(type, list = logResolveHelper.getArgumentTypes(resolveError = (ResolveError)symbol.baseSymbol(), symbol = resolveError.access(name, bl ? type.tsym : this.syms.noSymbol), name, list), list2)) {
            this.logResolveError(resolveError, diagnosticPosition, symbol2, type, name, list, list2);
        }
        return symbol;
    }

    Symbol accessMethod(Symbol symbol, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol2, Type type, Name name, boolean bl, List<Type> list, List<Type> list2) {
        return this.accessInternal(symbol, diagnosticPosition, symbol2, type, name, bl, list, list2, this.methodLogResolveHelper);
    }

    Symbol accessMethod(Symbol symbol, JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Name name, boolean bl, List<Type> list, List<Type> list2) {
        return this.accessMethod(symbol, diagnosticPosition, type.tsym, type, name, bl, list, list2);
    }

    Symbol accessBase(Symbol symbol, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol2, Type type, Name name, boolean bl) {
        return this.accessInternal(symbol, diagnosticPosition, symbol2, type, name, bl, List.nil(), null, this.basicLogResolveHelper);
    }

    Symbol accessBase(Symbol symbol, JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Name name, boolean bl) {
        return this.accessBase(symbol, diagnosticPosition, type.tsym, type, name, bl);
    }

    void checkNonAbstract(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if ((symbol.flags() & 0x400L) != 0L && (symbol.flags() & 0x80000000000L) == 0L) {
            this.log.error(diagnosticPosition, "abstract.cant.be.accessed.directly", Kinds.kindName(symbol), symbol, symbol.location());
        }
    }

    Symbol resolveIdent(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Name name, int n) {
        return this.accessBase(this.findIdent(env, name, n), diagnosticPosition, env.enclClass.sym.type, name, false);
    }

    Symbol resolveMethod(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Name name, List<Type> list, List<Type> list2) {
        return this.lookupMethod(env, diagnosticPosition, (Symbol)env.enclClass.sym, this.resolveMethodCheck, (LookupHelper)new BasicLookupHelper(name, env.enclClass.sym.type, (List)list, (List)list2){

            @Override
            Symbol doLookup(Env<AttrContext> env, MethodResolutionPhase methodResolutionPhase) {
                return Resolve.this.findFun(env, this.name, this.argtypes, this.typeargtypes, methodResolutionPhase.isBoxingRequired(), methodResolutionPhase.isVarargsRequired());
            }
        });
    }

    Symbol resolveQualifiedMethod(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Type type, Name name, List<Type> list, List<Type> list2) {
        return this.resolveQualifiedMethod(diagnosticPosition, env, type.tsym, type, name, list, list2);
    }

    Symbol resolveQualifiedMethod(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Symbol symbol, Type type, Name name, List<Type> list, List<Type> list2) {
        return this.resolveQualifiedMethod(new MethodResolutionContext(), diagnosticPosition, env, symbol, type, name, list, list2);
    }

    private Symbol resolveQualifiedMethod(MethodResolutionContext methodResolutionContext, JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Symbol symbol, Type type, Name name, List<Type> list, List<Type> list2) {
        return this.lookupMethod(env, diagnosticPosition, symbol, methodResolutionContext, (LookupHelper)new BasicLookupHelper(name, type, (List)list, (List)list2){

            @Override
            Symbol doLookup(Env<AttrContext> env, MethodResolutionPhase methodResolutionPhase) {
                return Resolve.this.findMethod(env, this.site, this.name, this.argtypes, this.typeargtypes, methodResolutionPhase.isBoxingRequired(), methodResolutionPhase.isVarargsRequired(), false);
            }

            @Override
            Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
                Symbol.MethodSymbol methodSymbol;
                if (symbol2.kind >= 129) {
                    symbol2 = super.access(env, diagnosticPosition, symbol, symbol2);
                } else if (Resolve.this.allowMethodHandles && ((methodSymbol = (Symbol.MethodSymbol)symbol2).flags() & 0x400000000000L) != 0L) {
                    return Resolve.this.findPolymorphicSignatureInstance(env, symbol2, this.argtypes);
                }
                return symbol2;
            }
        });
    }

    Symbol findPolymorphicSignatureInstance(Env<AttrContext> env, final Symbol symbol, List<Type> list) {
        Type type = this.infer.instantiatePolymorphicSignatureInstance(env, (Symbol.MethodSymbol)symbol, this.currentResolutionContext, list);
        for (Symbol symbol2 : this.polymorphicSignatureScope.getSymbolsByName(symbol.name)) {
            if (!this.types.isSameType(type, symbol2.type)) continue;
            return symbol2;
        }
        long l = 0x2000000400L | symbol.flags() & 7L;
        Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(l, symbol.name, type, symbol.owner){

            @Override
            public Symbol baseSymbol() {
                return symbol;
            }
        };
        this.polymorphicSignatureScope.enter(methodSymbol);
        return methodSymbol;
    }

    public Symbol.MethodSymbol resolveInternalMethod(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Type type, Name name, List<Type> list, List<Type> list2) {
        MethodResolutionContext methodResolutionContext = new MethodResolutionContext();
        methodResolutionContext.internalResolution = true;
        Symbol symbol = this.resolveQualifiedMethod(methodResolutionContext, diagnosticPosition, env, type.tsym, type, name, list, list2);
        if (symbol.kind == 16) {
            return (Symbol.MethodSymbol)symbol;
        }
        throw new FatalError(this.diags.fragment("fatal.err.cant.locate.meth", name));
    }

    Symbol resolveConstructor(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Type type, List<Type> list, List<Type> list2) {
        return this.resolveConstructor(new MethodResolutionContext(), diagnosticPosition, env, type, list, list2);
    }

    private Symbol resolveConstructor(MethodResolutionContext methodResolutionContext, final JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Type type, List<Type> list, List<Type> list2) {
        return this.lookupMethod(env, diagnosticPosition, (Symbol)type.tsym, methodResolutionContext, (LookupHelper)new BasicLookupHelper(this.names.init, type, list, list2){

            @Override
            Symbol doLookup(Env<AttrContext> env, MethodResolutionPhase methodResolutionPhase) {
                return Resolve.this.findConstructor(diagnosticPosition, env, this.site, this.argtypes, this.typeargtypes, methodResolutionPhase.isBoxingRequired(), methodResolutionPhase.isVarargsRequired());
            }
        });
    }

    public Symbol.MethodSymbol resolveInternalConstructor(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Type type, List<Type> list, List<Type> list2) {
        MethodResolutionContext methodResolutionContext = new MethodResolutionContext();
        methodResolutionContext.internalResolution = true;
        Symbol symbol = this.resolveConstructor(methodResolutionContext, diagnosticPosition, env, type, list, list2);
        if (symbol.kind == 16) {
            return (Symbol.MethodSymbol)symbol;
        }
        throw new FatalError(this.diags.fragment("fatal.err.cant.locate.ctor", type));
    }

    Symbol findConstructor(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Type type, List<Type> list, List<Type> list2, boolean bl, boolean bl2) {
        Symbol symbol = this.findMethod(env, type, this.names.init, list, list2, bl, bl2, false);
        this.chk.checkDeprecated(diagnosticPosition, ((AttrContext)env.info).scope.owner, symbol);
        return symbol;
    }

    Symbol resolveDiamond(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Type type, List<Type> list, List<Type> list2) {
        return this.lookupMethod(env, diagnosticPosition, (Symbol)type.tsym, this.resolveMethodCheck, (LookupHelper)new BasicLookupHelper(this.names.init, type, (List)list, (List)list2){

            @Override
            Symbol doLookup(Env<AttrContext> env, MethodResolutionPhase methodResolutionPhase) {
                return Resolve.this.findDiamond(env, this.site, this.argtypes, this.typeargtypes, methodResolutionPhase.isBoxingRequired(), methodResolutionPhase.isVarargsRequired());
            }

            @Override
            Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
                if (symbol2.kind >= 129) {
                    if (symbol2.kind != 135 && symbol2.kind != 134) {
                        symbol2 = super.access(env, diagnosticPosition, symbol, symbol2);
                    } else {
                        final JCDiagnostic jCDiagnostic = symbol2.kind == 135 ? (JCDiagnostic)((InapplicableSymbolError)symbol2.baseSymbol()).errCandidate().snd : null;
                        symbol2 = new InapplicableSymbolError(symbol2.kind, "diamondError", Resolve.this.currentResolutionContext){

                            @Override
                            JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType diagnosticType, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type, Name name, List<Type> list, List<Type> list2) {
                                String string = jCDiagnostic == null ? "cant.apply.diamond" : "cant.apply.diamond.1";
                                return Resolve.this.diags.create(diagnosticType, Resolve.this.log.currentSource(), diagnosticPosition, string, Resolve.this.diags.fragment("diamond", type.tsym), jCDiagnostic);
                            }
                        };
                        symbol2 = Resolve.this.accessMethod(symbol2, diagnosticPosition, this.site, Resolve.this.names.init, true, this.argtypes, this.typeargtypes);
                        ((AttrContext)env.info).pendingResolutionPhase = Resolve.this.currentResolutionContext.step;
                    }
                }
                return symbol2;
            }
        });
    }

    private Symbol findDiamond(Env<AttrContext> env, Type type, List<Type> list, List<Type> list2, boolean bl, boolean bl2) {
        Symbol symbol = this.methodNotFound;
        for (final Symbol symbol2 : type.tsym.members().getSymbolsByName(this.names.init)) {
            if (symbol2.kind != 16 || (symbol2.flags_field & 0x1000L) != 0L) continue;
            List list3 = symbol2.type.hasTag(TypeTag.FORALL) ? ((Type.ForAll)symbol2.type).tvars : List.nil();
            Type.ForAll forAll = new Type.ForAll(type.tsym.type.getTypeArguments().appendList(list3), this.types.createMethodTypeWithReturn(symbol2.type.asMethodType(), type));
            Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(symbol2.flags(), this.names.init, forAll, type.tsym){

                @Override
                public Symbol baseSymbol() {
                    return symbol2;
                }
            };
            symbol = this.selectBest(env, type, list, list2, methodSymbol, symbol, bl, bl2, false);
        }
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Symbol resolveOperator(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCTree.Tag tag, Env<AttrContext> env, List<Type> list) {
        MethodResolutionContext methodResolutionContext = this.currentResolutionContext;
        try {
            this.currentResolutionContext = new MethodResolutionContext();
            Name name = this.treeinfo.operatorName(tag);
            Symbol symbol = this.lookupMethod(env, diagnosticPosition, (Symbol)this.syms.predefClass, this.currentResolutionContext, (LookupHelper)new BasicLookupHelper(name, this.syms.predefClass.type, (List)list, null, MethodResolutionPhase.BOX){

                @Override
                Symbol doLookup(Env<AttrContext> env, MethodResolutionPhase methodResolutionPhase) {
                    return Resolve.this.findMethod(env, this.site, this.name, this.argtypes, this.typeargtypes, methodResolutionPhase.isBoxingRequired(), methodResolutionPhase.isVarargsRequired(), true);
                }

                @Override
                Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
                    return Resolve.this.accessMethod(symbol2, diagnosticPosition, env.enclClass.sym.type, this.name, false, this.argtypes, null);
                }
            });
            return symbol;
        }
        finally {
            this.currentResolutionContext = methodResolutionContext;
        }
    }

    Symbol resolveUnaryOperator(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCTree.Tag tag, Env<AttrContext> env, Type type) {
        return this.resolveOperator(diagnosticPosition, tag, env, List.of(type));
    }

    Symbol resolveBinaryOperator(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCTree.Tag tag, Env<AttrContext> env, Type type, Type type2) {
        return this.resolveOperator(diagnosticPosition, tag, env, List.of(type, type2));
    }

    Symbol getMemberReference(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, JCTree.JCMemberReference jCMemberReference, Type type, Name name) {
        type = this.types.capture(type);
        ReferenceLookupHelper referenceLookupHelper = this.makeReferenceLookupHelper(jCMemberReference, type, name, List.nil(), null, MethodResolutionPhase.VARARITY);
        Env<AttrContext> env2 = env.dup(env.tree, ((AttrContext)env.info).dup());
        Symbol symbol = this.lookupMethod(env2, env.tree.pos(), (Symbol)type.tsym, this.nilMethodCheck, (LookupHelper)referenceLookupHelper);
        ((AttrContext)env.info).pendingResolutionPhase = ((AttrContext)env2.info).pendingResolutionPhase;
        return symbol;
    }

    ReferenceLookupHelper makeReferenceLookupHelper(JCTree.JCMemberReference jCMemberReference, Type type, Name name, List<Type> list, List<Type> list2, MethodResolutionPhase methodResolutionPhase) {
        ReferenceLookupHelper referenceLookupHelper = !name.equals(this.names.init) ? new MethodReferenceLookupHelper(jCMemberReference, name, type, list, list2, methodResolutionPhase) : (type.hasTag(TypeTag.ARRAY) ? new ArrayConstructorReferenceLookupHelper(jCMemberReference, type, list, list2, methodResolutionPhase) : new ConstructorReferenceLookupHelper(jCMemberReference, type, list, list2, methodResolutionPhase));
        return referenceLookupHelper;
    }

    Symbol resolveMemberReferenceByArity(Env<AttrContext> env, JCTree.JCMemberReference jCMemberReference, Type type, Name name, List<Type> list, Infer.InferenceContext inferenceContext) {
        boolean bl = TreeInfo.isStaticSelector(jCMemberReference.expr, this.names);
        type = this.types.capture(type);
        ReferenceLookupHelper referenceLookupHelper = this.makeReferenceLookupHelper(jCMemberReference, type, name, list, null, MethodResolutionPhase.VARARITY);
        Env<AttrContext> env2 = env.dup(env.tree, ((AttrContext)env.info).dup());
        Symbol symbol = this.lookupMethod(env2, env.tree.pos(), (Symbol)type.tsym, this.arityMethodCheck, (LookupHelper)referenceLookupHelper);
        if (bl && !name.equals(this.names.init) && !symbol.isStatic() && symbol.kind < 128) {
            symbol = this.methodNotFound;
        }
        Symbol symbol2 = this.methodNotFound;
        ReferenceLookupHelper referenceLookupHelper2 = null;
        Env<AttrContext> env3 = env.dup(env.tree, ((AttrContext)env.info).dup());
        if (bl) {
            referenceLookupHelper2 = referenceLookupHelper.unboundLookup(inferenceContext);
            symbol2 = this.lookupMethod(env3, env.tree.pos(), (Symbol)type.tsym, this.arityMethodCheck, (LookupHelper)referenceLookupHelper2);
            if (symbol2.isStatic() && symbol2.kind < 128) {
                symbol2 = this.methodNotFound;
            }
        }
        Symbol symbol3 = this.choose(symbol, symbol2);
        ((AttrContext)env.info).pendingResolutionPhase = symbol3 == symbol2 ? ((AttrContext)env3.info).pendingResolutionPhase : ((AttrContext)env2.info).pendingResolutionPhase;
        return symbol3;
    }

    Pair<Symbol, ReferenceLookupHelper> resolveMemberReference(Env<AttrContext> env, JCTree.JCMemberReference jCMemberReference, Type type, Name name, List<Type> list, List<Type> list2, MethodCheck methodCheck, Infer.InferenceContext inferenceContext, DeferredAttr.AttrMode attrMode) {
        Object object;
        boolean bl;
        Symbol symbol;
        type = this.types.capture(type);
        ReferenceLookupHelper referenceLookupHelper = this.makeReferenceLookupHelper(jCMemberReference, type, name, list, list2, MethodResolutionPhase.VARARITY);
        Env<AttrContext> env2 = env.dup(env.tree, ((AttrContext)env.info).dup());
        boolean bl2 = false;
        MethodResolutionContext methodResolutionContext = new MethodResolutionContext();
        methodResolutionContext.methodCheck = methodCheck;
        Symbol symbol2 = symbol = this.lookupMethod(env2, env.tree.pos(), (Symbol)type.tsym, methodResolutionContext, (LookupHelper)referenceLookupHelper);
        SearchResultKind searchResultKind = SearchResultKind.NOT_APPLICABLE_MATCH;
        boolean bl3 = TreeInfo.isStaticSelector(jCMemberReference.expr, this.names);
        boolean bl4 = bl = bl3 && jCMemberReference.getMode() == MemberReferenceTree.ReferenceMode.INVOKE;
        if (symbol2.kind != 134 && symbol2.kind != 135 && bl) {
            if (!symbol2.isStatic()) {
                bl2 = true;
                if (this.hasAnotherApplicableMethod(methodResolutionContext, symbol2, true)) {
                    searchResultKind = SearchResultKind.BAD_MATCH_MORE_SPECIFIC;
                } else {
                    searchResultKind = SearchResultKind.BAD_MATCH;
                    if (symbol2.kind < 128) {
                        symbol2 = this.methodWithCorrectStaticnessNotFound;
                    }
                }
            } else if (symbol2.kind < 128) {
                searchResultKind = SearchResultKind.GOOD_MATCH;
            }
        }
        Symbol symbol3 = null;
        Symbol symbol4 = this.methodNotFound;
        ReferenceLookupHelper referenceLookupHelper2 = null;
        Env<AttrContext> env3 = env.dup(env.tree, ((AttrContext)env.info).dup());
        SearchResultKind searchResultKind2 = SearchResultKind.NOT_APPLICABLE_MATCH;
        boolean bl5 = false;
        if (bl3) {
            referenceLookupHelper2 = referenceLookupHelper.unboundLookup(inferenceContext);
            object = new MethodResolutionContext();
            ((MethodResolutionContext)object).methodCheck = methodCheck;
            symbol4 = symbol3 = this.lookupMethod(env3, env.tree.pos(), (Symbol)type.tsym, (MethodResolutionContext)object, (LookupHelper)referenceLookupHelper2);
            if (symbol4.kind != 135 && symbol4.kind != 134 && bl) {
                if (symbol4.isStatic()) {
                    bl5 = true;
                    if (this.hasAnotherApplicableMethod((MethodResolutionContext)object, symbol4, false)) {
                        searchResultKind2 = SearchResultKind.BAD_MATCH_MORE_SPECIFIC;
                    } else {
                        searchResultKind2 = SearchResultKind.BAD_MATCH;
                        if (symbol4.kind < 128) {
                            symbol4 = this.methodWithCorrectStaticnessNotFound;
                        }
                    }
                } else if (symbol4.kind < 128) {
                    searchResultKind2 = SearchResultKind.GOOD_MATCH;
                }
            }
        }
        Symbol symbol5 = this.choose(symbol2, symbol4);
        if (symbol5.kind < 128 && (bl2 || bl5)) {
            if (bl2) {
                symbol2 = this.methodWithCorrectStaticnessNotFound;
            }
            if (bl5) {
                symbol4 = this.methodWithCorrectStaticnessNotFound;
            }
            symbol5 = this.choose(symbol2, symbol4);
        }
        if (symbol5 == this.methodWithCorrectStaticnessNotFound && attrMode == DeferredAttr.AttrMode.CHECK) {
            Symbol symbol6 = symbol;
            String string = "non-static.cant.be.ref";
            if (bl2 && bl5) {
                if (searchResultKind2 == SearchResultKind.BAD_MATCH_MORE_SPECIFIC) {
                    symbol6 = symbol3;
                    string = "static.method.in.unbound.lookup";
                }
            } else if (!bl2) {
                symbol6 = symbol3;
                string = "static.method.in.unbound.lookup";
            }
            this.log.error(jCMemberReference.expr.pos(), "invalid.mref", Kinds.kindName(jCMemberReference.getMode()), this.diags.fragment(string, Kinds.kindName(symbol6), symbol6));
        }
        object = new Pair<Symbol, ReferenceLookupHelper>(symbol5, symbol5 == symbol4 ? referenceLookupHelper2 : referenceLookupHelper);
        ((AttrContext)env.info).pendingResolutionPhase = symbol5 == symbol4 ? ((AttrContext)env3.info).pendingResolutionPhase : ((AttrContext)env2.info).pendingResolutionPhase;
        return object;
    }

    boolean hasAnotherApplicableMethod(MethodResolutionContext methodResolutionContext, Symbol symbol, boolean bl) {
        for (MethodResolutionContext.Candidate candidate : methodResolutionContext.candidates) {
            if (methodResolutionContext.step != candidate.step || !candidate.isApplicable() || candidate.sym == symbol || candidate.sym.isStatic() != bl) continue;
            return true;
        }
        return false;
    }

    private Symbol choose(Symbol symbol, Symbol symbol2) {
        if (this.lookupSuccess(symbol) && this.lookupSuccess(symbol2)) {
            return this.ambiguityError(symbol, symbol2);
        }
        if (this.lookupSuccess(symbol) || this.canIgnore(symbol2) && !this.canIgnore(symbol)) {
            return symbol;
        }
        if (this.lookupSuccess(symbol2) || this.canIgnore(symbol) && !this.canIgnore(symbol2)) {
            return symbol2;
        }
        return symbol;
    }

    private boolean lookupSuccess(Symbol symbol) {
        return symbol.kind == 16 || symbol.kind == 129;
    }

    private boolean canIgnore(Symbol symbol) {
        switch (symbol.kind) {
            case 136: {
                return true;
            }
            case 135: {
                InapplicableSymbolError inapplicableSymbolError = (InapplicableSymbolError)symbol.baseSymbol();
                return new MethodResolutionDiagHelper.Template(MethodCheckDiag.ARITY_MISMATCH.regex(), new MethodResolutionDiagHelper.Template[0]).matches(inapplicableSymbolError.errCandidate().snd);
            }
            case 134: {
                InapplicableSymbolsError inapplicableSymbolsError = (InapplicableSymbolsError)symbol.baseSymbol();
                return inapplicableSymbolsError.filterCandidates(inapplicableSymbolsError.mapCandidates()).isEmpty();
            }
            case 138: {
                return false;
            }
        }
        return false;
    }

    Symbol lookupMethod(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, MethodCheck methodCheck, LookupHelper lookupHelper) {
        MethodResolutionContext methodResolutionContext = new MethodResolutionContext();
        methodResolutionContext.methodCheck = methodCheck;
        return this.lookupMethod(env, diagnosticPosition, symbol, methodResolutionContext, lookupHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Symbol lookupMethod(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, MethodResolutionContext methodResolutionContext, LookupHelper lookupHelper) {
        MethodResolutionContext methodResolutionContext2 = this.currentResolutionContext;
        try {
            Symbol symbol2 = this.methodNotFound;
            this.currentResolutionContext = methodResolutionContext;
            for (MethodResolutionPhase methodResolutionPhase : this.methodResolutionSteps) {
                if (lookupHelper.shouldStop(symbol2, methodResolutionPhase)) break;
                MethodResolutionPhase methodResolutionPhase2 = this.currentResolutionContext.step;
                SymbolNotFoundError symbolNotFoundError = symbol2;
                this.currentResolutionContext.step = methodResolutionPhase;
                Symbol symbol3 = lookupHelper.lookup(env, methodResolutionPhase);
                lookupHelper.debug(diagnosticPosition, symbol3);
                symbol2 = methodResolutionPhase.mergeResults(symbol2, symbol3);
                ((AttrContext)env.info).pendingResolutionPhase = symbolNotFoundError == symbol2 ? methodResolutionPhase2 : methodResolutionPhase;
            }
            Symbol symbol4 = lookupHelper.access(env, diagnosticPosition, symbol, symbol2);
            return symbol4;
        }
        finally {
            this.currentResolutionContext = methodResolutionContext2;
        }
    }

    Symbol resolveSelf(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Symbol.TypeSymbol typeSymbol, Name name) {
        Env<AttrContext> env2 = env;
        boolean bl = false;
        while (env2.outer != null) {
            Iterator<Type> iterator;
            if (Resolve.isStatic(env2)) {
                bl = true;
            }
            if (env2.enclClass.sym == typeSymbol && (iterator = ((AttrContext)env2.info).scope.findFirst(name)) != null) {
                if (bl) {
                    iterator = new StaticError((Symbol)((Object)iterator));
                }
                return this.accessBase((Symbol)((Object)iterator), diagnosticPosition, env.enclClass.sym.type, name, true);
            }
            if ((env2.enclClass.sym.flags() & 8L) != 0L) {
                bl = true;
            }
            env2 = env2.outer;
        }
        if (typeSymbol.isInterface() && name == this.names._super && !Resolve.isStatic(env) && this.types.isDirectSuperInterface(typeSymbol, env.enclClass.sym)) {
            for (Type type : this.pruneInterfaces(env.enclClass.type)) {
                if (type.tsym != typeSymbol) continue;
                ((AttrContext)env.info).defaultSuperCallSite = type;
                return new Symbol.VarSymbol(0L, this.names._super, this.types.asSuper(env.enclClass.type, typeSymbol), env.enclClass.sym);
            }
            for (Type type : this.types.interfaces(env.enclClass.type)) {
                if (!type.tsym.isSubClass(typeSymbol, this.types) || type.tsym == typeSymbol) continue;
                this.log.error(diagnosticPosition, "illegal.default.super.call", typeSymbol, this.diags.fragment("redundant.supertype", typeSymbol, type));
                return this.syms.errSymbol;
            }
            Assert.error();
        }
        this.log.error(diagnosticPosition, "not.encl.class", typeSymbol);
        return this.syms.errSymbol;
    }

    private List<Type> pruneInterfaces(Type type) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type2 : this.types.interfaces(type)) {
            boolean bl = true;
            for (Type type3 : this.types.interfaces(type)) {
                if (type2 == type3 || !this.types.isSubtypeNoCapture(type3, type2)) continue;
                bl = false;
            }
            if (!bl) continue;
            listBuffer.append(type2);
        }
        return listBuffer.toList();
    }

    Symbol resolveSelfContaining(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Symbol symbol, boolean bl) {
        Symbol symbol2 = this.resolveSelfContainingInternal(env, symbol, bl);
        if (symbol2 == null) {
            this.log.error(diagnosticPosition, "encl.class.required", symbol);
            return this.syms.errSymbol;
        }
        return this.accessBase(symbol2, diagnosticPosition, env.enclClass.sym.type, symbol2.name, true);
    }

    boolean hasEnclosingInstance(Env<AttrContext> env, Type type) {
        Symbol symbol = this.resolveSelfContainingInternal(env, type.tsym, false);
        return symbol != null && symbol.kind < 128;
    }

    private Symbol resolveSelfContainingInternal(Env<AttrContext> env, Symbol symbol, boolean bl) {
        Name name = this.names._this;
        Env<AttrContext> env2 = bl ? env.outer : env;
        boolean bl2 = false;
        if (env2 != null) {
            while (env2 != null && env2.outer != null) {
                Symbol symbol2;
                if (Resolve.isStatic(env2)) {
                    bl2 = true;
                }
                if (env2.enclClass.sym.isSubClass(symbol.owner, this.types) && (symbol2 = ((AttrContext)env2.info).scope.findFirst(name)) != null) {
                    if (bl2) {
                        symbol2 = new StaticError(symbol2);
                    }
                    return symbol2;
                }
                if ((env2.enclClass.sym.flags() & 8L) != 0L) {
                    bl2 = true;
                }
                env2 = env2.outer;
            }
        }
        return null;
    }

    Type resolveImplicitThis(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Type type) {
        return this.resolveImplicitThis(diagnosticPosition, env, type, false);
    }

    Type resolveImplicitThis(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Type type, boolean bl) {
        Type type2 = ((type.tsym.owner.kind & 0x14) != 0 ? this.resolveSelf((JCDiagnostic.DiagnosticPosition)diagnosticPosition, env, (Symbol.TypeSymbol)type.getEnclosingType().tsym, (Name)this.names._this) : this.resolveSelfContaining((JCDiagnostic.DiagnosticPosition)diagnosticPosition, env, (Symbol)type.tsym, (boolean)bl)).type;
        if (((AttrContext)env.info).isSelfCall && type2.tsym == env.enclClass.sym) {
            this.log.error(diagnosticPosition, "cant.ref.before.ctor.called", "this");
        }
        return type2;
    }

    public void logAccessErrorInternal(Env<AttrContext> env, JCTree jCTree, Type type) {
        AccessError accessError = new AccessError(env, env.enclClass.type, type.tsym);
        this.logResolveError(accessError, jCTree.pos(), env.enclClass.sym, env.enclClass.type, null, null, null);
    }

    private void logResolveError(ResolveError resolveError, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type, Name name, List<Type> list, List<Type> list2) {
        JCDiagnostic jCDiagnostic = resolveError.getDiagnostic(JCDiagnostic.DiagnosticType.ERROR, diagnosticPosition, symbol, type, name, list, list2);
        if (jCDiagnostic != null) {
            jCDiagnostic.setFlag(JCDiagnostic.DiagnosticFlag.RESOLVE_ERROR);
            this.log.report(jCDiagnostic);
        }
    }

    public Object methodArguments(List<Type> list) {
        if (list == null || list.isEmpty()) {
            return this.noArgs;
        }
        ListBuffer<Object> listBuffer = new ListBuffer<Object>();
        for (Type type : list) {
            if (type.hasTag(TypeTag.DEFERRED)) {
                listBuffer.append(((DeferredAttr.DeferredType)type).tree);
                continue;
            }
            listBuffer.append(type);
        }
        return listBuffer;
    }

    class MethodResolutionContext {
        private List<Candidate> candidates = List.nil();
        MethodResolutionPhase step = null;
        MethodCheck methodCheck;
        private boolean internalResolution;
        private DeferredAttr.AttrMode attrMode;

        MethodResolutionContext() {
            this.methodCheck = Resolve.this.resolveMethodCheck;
            this.internalResolution = false;
            this.attrMode = DeferredAttr.AttrMode.SPECULATIVE;
        }

        void addInapplicableCandidate(Symbol symbol, JCDiagnostic jCDiagnostic) {
            Candidate candidate = new Candidate(Resolve.this.currentResolutionContext.step, symbol, jCDiagnostic, null);
            this.candidates = this.candidates.append(candidate);
        }

        void addApplicableCandidate(Symbol symbol, Type type) {
            Candidate candidate = new Candidate(Resolve.this.currentResolutionContext.step, symbol, null, type);
            this.candidates = this.candidates.append(candidate);
        }

        DeferredAttr.DeferredAttrContext deferredAttrContext(Symbol symbol, Infer.InferenceContext inferenceContext, Attr.ResultInfo resultInfo, Warner warner) {
            DeferredAttr.DeferredAttrContext deferredAttrContext = resultInfo == null ? Resolve.this.deferredAttr.emptyDeferredAttrContext : resultInfo.checkContext.deferredAttrContext();
            DeferredAttr deferredAttr = Resolve.this.deferredAttr;
            deferredAttr.getClass();
            return deferredAttr.new DeferredAttr.DeferredAttrContext(this.attrMode, symbol, this.step, inferenceContext, deferredAttrContext, warner);
        }

        DeferredAttr.AttrMode attrMode() {
            return this.attrMode;
        }

        boolean internal() {
            return this.internalResolution;
        }

        class Candidate {
            final MethodResolutionPhase step;
            final Symbol sym;
            final JCDiagnostic details;
            final Type mtype;

            private Candidate(MethodResolutionPhase methodResolutionPhase, Symbol symbol, JCDiagnostic jCDiagnostic, Type type) {
                this.step = methodResolutionPhase;
                this.sym = symbol;
                this.details = jCDiagnostic;
                this.mtype = type;
            }

            public boolean equals(Object object) {
                Symbol symbol;
                Symbol symbol2;
                return object instanceof Candidate && ((symbol2 = this.sym) != (symbol = ((Candidate)object).sym) && (symbol2.overrides(symbol, symbol2.owner.type.tsym, Resolve.this.types, false) || symbol.overrides(symbol2, symbol.owner.type.tsym, Resolve.this.types, false)) || (symbol2.isConstructor() || symbol.isConstructor()) && symbol2.owner != symbol.owner);
            }

            boolean isApplicable() {
                return this.mtype != null;
            }
        }
    }

    static enum MethodResolutionPhase {
        BASIC(false, false),
        BOX(true, false),
        VARARITY(true, true){

            @Override
            public Symbol mergeResults(Symbol symbol, Symbol symbol2) {
                Assert.check(symbol.kind >= 128 && symbol.kind != 129);
                if (symbol2.kind < 128) {
                    return symbol2;
                }
                switch (symbol.kind) {
                    case 134: 
                    case 135: {
                        switch (symbol2.kind) {
                            case 135: {
                                return symbol.kind == 134 ? symbol : symbol2;
                            }
                            case 136: {
                                return symbol;
                            }
                        }
                        return symbol2;
                    }
                }
                return symbol;
            }
        };

        final boolean isBoxingRequired;
        final boolean isVarargsRequired;

        private MethodResolutionPhase(boolean bl, boolean bl2) {
            this.isBoxingRequired = bl;
            this.isVarargsRequired = bl2;
        }

        public boolean isBoxingRequired() {
            return this.isBoxingRequired;
        }

        public boolean isVarargsRequired() {
            return this.isVarargsRequired;
        }

        public Symbol mergeResults(Symbol symbol, Symbol symbol2) {
            return symbol2;
        }
    }

    static class MethodResolutionDiagHelper {
        static final Template skip = new Template("", new Template[0]){

            @Override
            boolean matches(Object object) {
                return true;
            }
        };
        static final Map<Template, DiagnosticRewriter> rewriters = new LinkedHashMap<Template, DiagnosticRewriter>();

        MethodResolutionDiagHelper() {
        }

        static {
            String string = MethodCheckDiag.ARG_MISMATCH.regex();
            rewriters.put(new Template(string, skip), new DiagnosticRewriter(){

                @Override
                public JCDiagnostic rewriteDiagnostic(JCDiagnostic.Factory factory, JCDiagnostic.DiagnosticPosition diagnosticPosition, DiagnosticSource diagnosticSource, JCDiagnostic.DiagnosticType diagnosticType, JCDiagnostic jCDiagnostic) {
                    JCDiagnostic jCDiagnostic2 = (JCDiagnostic)jCDiagnostic.getArgs()[0];
                    return factory.create(diagnosticType, diagnosticSource, jCDiagnostic.getDiagnosticPosition(), "prob.found.req", jCDiagnostic2);
                }
            });
        }

        static class Template {
            String regex;
            Template[] subTemplates;

            Template(String string, Template ... templateArray) {
                this.regex = string;
                this.subTemplates = templateArray;
            }

            boolean matches(Object object) {
                JCDiagnostic jCDiagnostic = (JCDiagnostic)object;
                Object[] objectArray = jCDiagnostic.getArgs();
                if (!jCDiagnostic.getCode().matches(this.regex) || this.subTemplates.length != jCDiagnostic.getArgs().length) {
                    return false;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.subTemplates[i].matches(objectArray[i])) continue;
                    return false;
                }
                return true;
            }
        }

        static interface DiagnosticRewriter {
            public JCDiagnostic rewriteDiagnostic(JCDiagnostic.Factory var1, JCDiagnostic.DiagnosticPosition var2, DiagnosticSource var3, JCDiagnostic.DiagnosticType var4, JCDiagnostic var5);
        }
    }

    class BadVarargsMethod
    extends ResolveError {
        ResolveError delegatedError;

        BadVarargsMethod(ResolveError resolveError) {
            super(resolveError.kind, "badVarargs");
            this.delegatedError = resolveError;
        }

        @Override
        public Symbol baseSymbol() {
            return this.delegatedError.baseSymbol();
        }

        @Override
        protected Symbol access(Name name, Symbol.TypeSymbol typeSymbol) {
            return this.delegatedError.access(name, typeSymbol);
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType diagnosticType, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type, Name name, List<Type> list, List<Type> list2) {
            return this.delegatedError.getDiagnostic(diagnosticType, diagnosticPosition, symbol, type, name, list, list2);
        }
    }

    class AmbiguityError
    extends ResolveError {
        List<Symbol> ambiguousSyms;

        @Override
        public boolean exists() {
            return true;
        }

        AmbiguityError(Symbol symbol, Symbol symbol2) {
            super(129, "ambiguity error");
            this.ambiguousSyms = List.nil();
            this.ambiguousSyms = this.flatten(symbol2).appendList(this.flatten(symbol));
        }

        private List<Symbol> flatten(Symbol symbol) {
            if (symbol.kind == 129) {
                return ((AmbiguityError)symbol.baseSymbol()).ambiguousSyms;
            }
            return List.of(symbol);
        }

        AmbiguityError addAmbiguousSymbol(Symbol symbol) {
            this.ambiguousSyms = this.ambiguousSyms.prepend(symbol);
            return this;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType diagnosticType, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type, Name name, List<Type> list, List<Type> list2) {
            List<Symbol> list3 = this.ambiguousSyms.reverse();
            Symbol symbol2 = (Symbol)list3.head;
            Symbol symbol3 = (Symbol)list3.tail.head;
            Name name2 = symbol2.name;
            if (name2 == Resolve.this.names.init) {
                name2 = symbol2.owner.name;
            }
            return Resolve.this.diags.create(diagnosticType, Resolve.this.log.currentSource(), diagnosticPosition, "ref.ambiguous", name2, Kinds.kindName(symbol2), symbol2, symbol2.location(type, Resolve.this.types), Kinds.kindName(symbol3), symbol3, symbol3.location(type, Resolve.this.types));
        }

        Symbol mergeAbstracts(Type type) {
            List<Symbol> list = this.ambiguousSyms.reverse();
            for (Symbol symbol : list) {
                Type type2 = Resolve.this.types.memberType(type, symbol);
                boolean bl = true;
                List<Type> list2 = type2.getThrownTypes();
                for (Symbol symbol2 : list) {
                    Type type3 = Resolve.this.types.memberType(type, symbol2);
                    if ((symbol2.flags() & 0x400L) == 0L || !Resolve.this.types.overrideEquivalent(type2, type3) || !Resolve.this.types.isSameTypes(symbol.erasure(Resolve.this.types).getParameterTypes(), symbol2.erasure(Resolve.this.types).getParameterTypes())) {
                        return this;
                    }
                    Type type4 = Resolve.this.mostSpecificReturnType(type2, type3);
                    if (type4 == null || type4 != type2) {
                        bl = false;
                        break;
                    }
                    list2 = Resolve.this.chk.intersect(list2, type3.getThrownTypes());
                }
                if (!bl) continue;
                return list2 == type2.getThrownTypes() ? symbol : new Symbol.MethodSymbol(symbol.flags(), symbol.name, Resolve.this.types.createMethodTypeWithThrown(type2, list2), symbol.owner);
            }
            return this;
        }

        @Override
        protected Symbol access(Name name, Symbol.TypeSymbol typeSymbol) {
            Symbol symbol = this.ambiguousSyms.last();
            return symbol.kind == 2 ? Resolve.this.types.createErrorType((Name)name, (Symbol.TypeSymbol)typeSymbol, (Type)symbol.type).tsym : symbol;
        }
    }

    class StaticError
    extends InvalidSymbolError {
        StaticError(Symbol symbol) {
            super(131, symbol, "static error");
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType diagnosticType, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type, Name name, List<Type> list, List<Type> list2) {
            Symbol symbol2 = this.sym.kind == 2 && this.sym.type.hasTag(TypeTag.CLASS) ? Resolve.this.types.erasure((Type)this.sym.type).tsym : this.sym;
            return Resolve.this.diags.create(diagnosticType, Resolve.this.log.currentSource(), diagnosticPosition, "non-static.cant.be.ref", Kinds.kindName(this.sym), symbol2);
        }
    }

    class AccessError
    extends InvalidSymbolError {
        private Env<AttrContext> env;
        private Type site;

        AccessError(Symbol symbol) {
            this(null, null, symbol);
        }

        AccessError(Env<AttrContext> env, Type type, Symbol symbol) {
            super(130, symbol, "access error");
            this.env = env;
            this.site = type;
            if (Resolve.this.debugResolve) {
                Resolve.this.log.error("proc.messager", symbol + " @ " + type + " is inaccessible.");
            }
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType diagnosticType, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type, Name name, List<Type> list, List<Type> list2) {
            if (this.sym.owner.type.hasTag(TypeTag.ERROR)) {
                return null;
            }
            if (this.sym.name == Resolve.this.names.init && this.sym.owner != type.tsym) {
                return new SymbolNotFoundError(136).getDiagnostic(diagnosticType, diagnosticPosition, symbol, type, name, list, list2);
            }
            if ((this.sym.flags() & 1L) != 0L || this.env != null && this.site != null && !Resolve.this.isAccessible(this.env, this.site)) {
                return Resolve.this.diags.create(diagnosticType, Resolve.this.log.currentSource(), diagnosticPosition, "not.def.access.class.intf.cant.access", this.sym, this.sym.location());
            }
            if ((this.sym.flags() & 6L) != 0L) {
                return Resolve.this.diags.create(diagnosticType, Resolve.this.log.currentSource(), diagnosticPosition, "report.access", this.sym, Flags.asFlagSet(this.sym.flags() & 6L), this.sym.location());
            }
            return Resolve.this.diags.create(diagnosticType, Resolve.this.log.currentSource(), diagnosticPosition, "not.def.public.cant.access", this.sym, this.sym.location());
        }
    }

    class InapplicableSymbolsError
    extends InapplicableSymbolError {
        InapplicableSymbolsError(MethodResolutionContext methodResolutionContext) {
            super(134, "inapplicable symbols", methodResolutionContext);
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType diagnosticType, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type, Name name, List<Type> list, List<Type> list2) {
            boolean bl;
            Map<Symbol, JCDiagnostic> map;
            Map<Symbol, JCDiagnostic> map2 = this.mapCandidates();
            Map<Symbol, JCDiagnostic> map3 = map = Resolve.this.compactMethodDiags ? this.filterCandidates(map2) : this.mapCandidates();
            if (map.isEmpty()) {
                map = map2;
            }
            boolean bl2 = bl = map2.size() != map.size();
            if (map.size() > 1) {
                JCDiagnostic jCDiagnostic = Resolve.this.diags.create(diagnosticType, null, bl ? EnumSet.of(JCDiagnostic.DiagnosticFlag.COMPRESSED) : EnumSet.noneOf(JCDiagnostic.DiagnosticFlag.class), Resolve.this.log.currentSource(), diagnosticPosition, "cant.apply.symbols", name == Resolve.this.names.init ? Kinds.KindName.CONSTRUCTOR : Kinds.absentKind(this.kind), name == Resolve.this.names.init ? type.tsym.name : name, Resolve.this.methodArguments(list));
                return new JCDiagnostic.MultilineDiagnostic(jCDiagnostic, this.candidateDetails(map, type));
            }
            if (map.size() == 1) {
                Map.Entry<Symbol, JCDiagnostic> entry = map.entrySet().iterator().next();
                final Pair<Symbol, JCDiagnostic> pair = new Pair<Symbol, JCDiagnostic>(entry.getKey(), entry.getValue());
                JCDiagnostic jCDiagnostic = new InapplicableSymbolError(this.resolveContext){

                    @Override
                    protected Pair<Symbol, JCDiagnostic> errCandidate() {
                        return pair;
                    }
                }.getDiagnostic(diagnosticType, diagnosticPosition, symbol, type, name, list, list2);
                if (bl) {
                    jCDiagnostic.setFlag(JCDiagnostic.DiagnosticFlag.COMPRESSED);
                }
                return jCDiagnostic;
            }
            return new SymbolNotFoundError(136).getDiagnostic(diagnosticType, diagnosticPosition, symbol, type, name, list, list2);
        }

        private Map<Symbol, JCDiagnostic> mapCandidates() {
            LinkedHashMap<Symbol, JCDiagnostic> linkedHashMap = new LinkedHashMap<Symbol, JCDiagnostic>();
            for (MethodResolutionContext.Candidate candidate : this.resolveContext.candidates) {
                if (candidate.isApplicable()) continue;
                linkedHashMap.put(candidate.sym, candidate.details);
            }
            return linkedHashMap;
        }

        Map<Symbol, JCDiagnostic> filterCandidates(Map<Symbol, JCDiagnostic> map) {
            LinkedHashMap<Symbol, JCDiagnostic> linkedHashMap = new LinkedHashMap<Symbol, JCDiagnostic>();
            for (Map.Entry<Symbol, JCDiagnostic> entry : map.entrySet()) {
                JCDiagnostic jCDiagnostic = entry.getValue();
                if (new MethodResolutionDiagHelper.Template(MethodCheckDiag.ARITY_MISMATCH.regex(), new MethodResolutionDiagHelper.Template[0]).matches(jCDiagnostic)) continue;
                linkedHashMap.put(entry.getKey(), jCDiagnostic);
            }
            return linkedHashMap;
        }

        private List<JCDiagnostic> candidateDetails(Map<Symbol, JCDiagnostic> map, Type type) {
            List<JCDiagnostic> list = List.nil();
            for (Map.Entry<Symbol, JCDiagnostic> entry : map.entrySet()) {
                Symbol symbol = entry.getKey();
                JCDiagnostic jCDiagnostic = Resolve.this.diags.fragment("inapplicable.method", Kinds.kindName(symbol), symbol.location(type, Resolve.this.types), symbol.asMemberOf(type, Resolve.this.types), entry.getValue());
                list = list.prepend(jCDiagnostic);
            }
            return list;
        }
    }

    class InapplicableSymbolError
    extends ResolveError {
        protected MethodResolutionContext resolveContext;

        InapplicableSymbolError(MethodResolutionContext methodResolutionContext) {
            this(135, "inapplicable symbol error", methodResolutionContext);
        }

        protected InapplicableSymbolError(int n, String string, MethodResolutionContext methodResolutionContext) {
            super(n, string);
            this.resolveContext = methodResolutionContext;
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType diagnosticType, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type, Name name, List<Type> list, List<Type> list2) {
            if (name == Resolve.this.names.error) {
                return null;
            }
            if (Resolve.this.syms.operatorNames.contains(name)) {
                boolean bl = list.size() == 1;
                String string = list.size() == 1 ? "operator.cant.be.applied" : "operator.cant.be.applied.1";
                Type type2 = (Type)list.head;
                Type type3 = !bl ? (Type)list.tail.head : null;
                return Resolve.this.diags.create(diagnosticType, Resolve.this.log.currentSource(), diagnosticPosition, string, name, type2, type3);
            }
            Pair<Symbol, JCDiagnostic> pair = this.errCandidate();
            if (Resolve.this.compactMethodDiags) {
                for (Map.Entry<MethodResolutionDiagHelper.Template, MethodResolutionDiagHelper.DiagnosticRewriter> entry : MethodResolutionDiagHelper.rewriters.entrySet()) {
                    if (!entry.getKey().matches(pair.snd)) continue;
                    JCDiagnostic jCDiagnostic = entry.getValue().rewriteDiagnostic(Resolve.this.diags, diagnosticPosition, Resolve.this.log.currentSource(), diagnosticType, (JCDiagnostic)pair.snd);
                    jCDiagnostic.setFlag(JCDiagnostic.DiagnosticFlag.COMPRESSED);
                    return jCDiagnostic;
                }
            }
            Symbol symbol2 = ((Symbol)pair.fst).asMemberOf(type, Resolve.this.types);
            return Resolve.this.diags.create(diagnosticType, Resolve.this.log.currentSource(), diagnosticPosition, "cant.apply.symbol", Kinds.kindName(symbol2), symbol2.name == Resolve.this.names.init ? symbol2.owner.name : symbol2.name, Resolve.this.methodArguments(symbol2.type.getParameterTypes()), Resolve.this.methodArguments(list), Kinds.kindName(symbol2.owner), symbol2.owner.type, pair.snd);
        }

        @Override
        public Symbol access(Name name, Symbol.TypeSymbol typeSymbol) {
            return Resolve.this.types.createErrorType((Name)name, (Symbol.TypeSymbol)typeSymbol, (Type)Resolve.this.syms.errSymbol.type).tsym;
        }

        protected Pair<Symbol, JCDiagnostic> errCandidate() {
            MethodResolutionContext.Candidate candidate = null;
            for (MethodResolutionContext.Candidate candidate2 : this.resolveContext.candidates) {
                if (candidate2.isApplicable()) continue;
                candidate = candidate2;
            }
            Assert.checkNonNull(candidate);
            return new Pair<Symbol, JCDiagnostic>(candidate.sym, candidate.details);
        }
    }

    class SymbolNotFoundError
    extends ResolveError {
        SymbolNotFoundError(int n) {
            this(n, "symbol not found error");
        }

        SymbolNotFoundError(int n, String string) {
            super(n, string);
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType diagnosticType, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type, Name name, List<Type> list, List<Type> list2) {
            list = list == null ? List.nil() : list;
            List<Object> list3 = list2 = list2 == null ? List.nil() : list2;
            if (name == Resolve.this.names.error) {
                return null;
            }
            if (Resolve.this.syms.operatorNames.contains(name)) {
                boolean bl = list.size() == 1;
                String string = list.size() == 1 ? "operator.cant.be.applied" : "operator.cant.be.applied.1";
                Type type2 = (Type)list.head;
                Type type3 = !bl ? (Type)list.tail.head : null;
                return Resolve.this.diags.create(diagnosticType, Resolve.this.log.currentSource(), diagnosticPosition, string, name, type2, type3);
            }
            boolean bl = false;
            if (symbol == null) {
                symbol = type.tsym;
            }
            if (!symbol.name.isEmpty()) {
                if (symbol.kind == 1 && !type.tsym.exists()) {
                    return Resolve.this.diags.create(diagnosticType, Resolve.this.log.currentSource(), diagnosticPosition, "doesnt.exist", symbol);
                }
                bl = !symbol.name.equals(Resolve.this.names._this) && !symbol.name.equals(Resolve.this.names._super);
            }
            boolean bl2 = (this.kind == 136 || this.kind == 138) && name == Resolve.this.names.init;
            Kinds.KindName kindName = bl2 ? Kinds.KindName.CONSTRUCTOR : Kinds.absentKind(this.kind);
            Name name2 = bl2 ? type.tsym.name : name;
            String string = this.getErrorKey(kindName, list2.nonEmpty(), bl);
            if (bl) {
                return Resolve.this.diags.create(diagnosticType, Resolve.this.log.currentSource(), diagnosticPosition, string, kindName, name2, list2, this.args(list), this.getLocationDiag(symbol, type));
            }
            return Resolve.this.diags.create(diagnosticType, Resolve.this.log.currentSource(), diagnosticPosition, string, kindName, name2, list2, this.args(list));
        }

        private Object args(List<Type> list) {
            return list.isEmpty() ? list : Resolve.this.methodArguments(list);
        }

        private String getErrorKey(Kinds.KindName kindName, boolean bl, boolean bl2) {
            String string = "cant.resolve";
            String string2 = bl2 ? ".location" : "";
            switch (kindName) {
                case METHOD: 
                case CONSTRUCTOR: {
                    string2 = string2 + ".args";
                    string2 = string2 + (bl ? ".params" : "");
                }
            }
            return string + string2;
        }

        private JCDiagnostic getLocationDiag(Symbol symbol, Type type) {
            if (symbol.kind == 4) {
                return Resolve.this.diags.fragment("location.1", Kinds.kindName(symbol), symbol, symbol.type);
            }
            return Resolve.this.diags.fragment("location", Kinds.typeKindName(type), type, null);
        }
    }

    abstract class InvalidSymbolError
    extends ResolveError {
        Symbol sym;

        InvalidSymbolError(int n, Symbol symbol, String string) {
            super(n, string);
            this.sym = symbol;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + " wrongSym=" + this.sym;
        }

        @Override
        public Symbol access(Name name, Symbol.TypeSymbol typeSymbol) {
            if ((this.sym.kind & 0x80) == 0 && (this.sym.kind & 2) != 0) {
                return Resolve.this.types.createErrorType((Name)name, (Symbol.TypeSymbol)typeSymbol, (Type)this.sym.type).tsym;
            }
            return this.sym;
        }
    }

    abstract class ResolveError
    extends Symbol {
        final String debugName;

        ResolveError(int n, String string) {
            super(n, 0L, null, null, null);
            this.debugName = string;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
            throw new AssertionError();
        }

        @Override
        public String toString() {
            return this.debugName;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        protected Symbol access(Name name, Symbol.TypeSymbol typeSymbol) {
            return Resolve.this.types.createErrorType((Name)name, (Symbol.TypeSymbol)typeSymbol, (Type)Resolve.this.syms.errSymbol.type).tsym;
        }

        abstract JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType var1, JCDiagnostic.DiagnosticPosition var2, Symbol var3, Type var4, Name var5, List<Type> var6, List<Type> var7);
    }

    class ConstructorReferenceLookupHelper
    extends ReferenceLookupHelper {
        boolean needsInference;

        ConstructorReferenceLookupHelper(JCTree.JCMemberReference jCMemberReference, Type type, List<Type> list, List<Type> list2, MethodResolutionPhase methodResolutionPhase) {
            super(jCMemberReference, Resolve.this.names.init, type, list, list2, methodResolutionPhase);
            if (type.isRaw()) {
                this.site = new Type.ClassType(type.getEnclosingType(), type.tsym.type.getTypeArguments(), type.tsym, (List<Attribute.TypeCompound>)type.getAnnotationMirrors());
                this.needsInference = true;
            }
        }

        @Override
        protected Symbol lookup(Env<AttrContext> env, MethodResolutionPhase methodResolutionPhase) {
            Symbol symbol = this.needsInference ? Resolve.this.findDiamond(env, this.site, this.argtypes, this.typeargtypes, methodResolutionPhase.isBoxingRequired(), methodResolutionPhase.isVarargsRequired()) : Resolve.this.findMethod(env, this.site, this.name, this.argtypes, this.typeargtypes, methodResolutionPhase.isBoxingRequired(), methodResolutionPhase.isVarargsRequired(), Resolve.this.syms.operatorNames.contains(this.name));
            return symbol.kind != 16 || this.site.getEnclosingType().hasTag(TypeTag.NONE) || Resolve.this.hasEnclosingInstance(env, this.site) ? symbol : new InvalidSymbolError(132, symbol, null){

                @Override
                JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType diagnosticType, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type, Name name, List<Type> list, List<Type> list2) {
                    return Resolve.this.diags.create(diagnosticType, Resolve.this.log.currentSource(), diagnosticPosition, "cant.access.inner.cls.constr", type.tsym.name, list, type.getEnclosingType());
                }
            };
        }

        @Override
        JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol symbol) {
            return this.site.getEnclosingType().hasTag(TypeTag.NONE) ? JCTree.JCMemberReference.ReferenceKind.TOPLEVEL : JCTree.JCMemberReference.ReferenceKind.IMPLICIT_INNER;
        }
    }

    class ArrayConstructorReferenceLookupHelper
    extends ReferenceLookupHelper {
        ArrayConstructorReferenceLookupHelper(JCTree.JCMemberReference jCMemberReference, Type type, List<Type> list, List<Type> list2, MethodResolutionPhase methodResolutionPhase) {
            super(jCMemberReference, Resolve.this.names.init, type, list, list2, methodResolutionPhase);
        }

        @Override
        protected Symbol lookup(Env<AttrContext> env, MethodResolutionPhase methodResolutionPhase) {
            Scope.WriteableScope writeableScope = Scope.WriteableScope.create(Resolve.this.syms.arrayClass);
            Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(1L, this.name, null, this.site.tsym);
            methodSymbol.type = new Type.MethodType(List.of(Resolve.this.syms.intType), this.site, List.nil(), Resolve.this.syms.methodClass);
            writeableScope.enter(methodSymbol);
            return Resolve.this.findMethodInScope(env, this.site, this.name, this.argtypes, this.typeargtypes, writeableScope, Resolve.this.methodNotFound, methodResolutionPhase.isBoxingRequired(), methodResolutionPhase.isVarargsRequired(), false, false);
        }

        @Override
        JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol symbol) {
            return JCTree.JCMemberReference.ReferenceKind.ARRAY_CTOR;
        }
    }

    class UnboundMethodReferenceLookupHelper
    extends MethodReferenceLookupHelper {
        UnboundMethodReferenceLookupHelper(JCTree.JCMemberReference jCMemberReference, Name name, Type type, List<Type> list, List<Type> list2, MethodResolutionPhase methodResolutionPhase) {
            super(jCMemberReference, name, type, list.tail, list2, methodResolutionPhase);
            if (type.isRaw() && !((Type)list.head).hasTag(TypeTag.NONE)) {
                Type type2;
                this.site = type2 = Resolve.this.types.asSuper((Type)list.head, type.tsym);
            }
        }

        @Override
        ReferenceLookupHelper unboundLookup(Infer.InferenceContext inferenceContext) {
            return this;
        }

        @Override
        JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol symbol) {
            return JCTree.JCMemberReference.ReferenceKind.UNBOUND;
        }
    }

    class MethodReferenceLookupHelper
    extends ReferenceLookupHelper {
        MethodReferenceLookupHelper(JCTree.JCMemberReference jCMemberReference, Name name, Type type, List<Type> list, List<Type> list2, MethodResolutionPhase methodResolutionPhase) {
            super(jCMemberReference, name, type, list, list2, methodResolutionPhase);
        }

        @Override
        final Symbol lookup(Env<AttrContext> env, MethodResolutionPhase methodResolutionPhase) {
            return Resolve.this.findMethod(env, this.site, this.name, this.argtypes, this.typeargtypes, methodResolutionPhase.isBoxingRequired(), methodResolutionPhase.isVarargsRequired(), Resolve.this.syms.operatorNames.contains(this.name));
        }

        @Override
        ReferenceLookupHelper unboundLookup(Infer.InferenceContext inferenceContext) {
            if (TreeInfo.isStaticSelector(this.referenceTree.expr, Resolve.this.names) && this.argtypes.nonEmpty() && (((Type)this.argtypes.head).hasTag(TypeTag.NONE) || Resolve.this.types.isSubtypeUnchecked(inferenceContext.asUndetVar((Type)this.argtypes.head), this.site))) {
                return new UnboundMethodReferenceLookupHelper(this.referenceTree, this.name, this.site, this.argtypes, this.typeargtypes, this.maxPhase);
            }
            return super.unboundLookup(inferenceContext);
        }

        @Override
        JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol symbol) {
            if (symbol.isStatic()) {
                return JCTree.JCMemberReference.ReferenceKind.STATIC;
            }
            Name name = TreeInfo.name(this.referenceTree.getQualifierExpression());
            return name != null && name == Resolve.this.names._super ? JCTree.JCMemberReference.ReferenceKind.SUPER : JCTree.JCMemberReference.ReferenceKind.BOUND;
        }
    }

    abstract class ReferenceLookupHelper
    extends LookupHelper {
        JCTree.JCMemberReference referenceTree;

        ReferenceLookupHelper(JCTree.JCMemberReference jCMemberReference, Name name, Type type, List<Type> list, List<Type> list2, MethodResolutionPhase methodResolutionPhase) {
            super(name, type, list, list2, methodResolutionPhase);
            this.referenceTree = jCMemberReference;
        }

        ReferenceLookupHelper unboundLookup(Infer.InferenceContext inferenceContext) {
            return new ReferenceLookupHelper(this.referenceTree, this.name, this.site, this.argtypes, this.typeargtypes, this.maxPhase){

                @Override
                ReferenceLookupHelper unboundLookup(Infer.InferenceContext inferenceContext) {
                    return this;
                }

                @Override
                Symbol lookup(Env<AttrContext> env, MethodResolutionPhase methodResolutionPhase) {
                    return Resolve.this.methodNotFound;
                }

                @Override
                JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol symbol) {
                    Assert.error();
                    return null;
                }
            };
        }

        abstract JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol var1);

        @Override
        Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
            if (symbol2.kind == 129) {
                AmbiguityError ambiguityError = (AmbiguityError)symbol2.baseSymbol();
                symbol2 = ambiguityError.mergeAbstracts(this.site);
            }
            return symbol2;
        }
    }

    abstract class BasicLookupHelper
    extends LookupHelper {
        BasicLookupHelper(Name name, Type type, List<Type> list, List<Type> list2) {
            this(name, type, list, list2, MethodResolutionPhase.VARARITY);
        }

        BasicLookupHelper(Name name, Type type, List<Type> list, List<Type> list2, MethodResolutionPhase methodResolutionPhase) {
            super(name, type, list, list2, methodResolutionPhase);
        }

        @Override
        final Symbol lookup(Env<AttrContext> env, MethodResolutionPhase methodResolutionPhase) {
            Symbol symbol = this.doLookup(env, methodResolutionPhase);
            if (symbol.kind == 129) {
                AmbiguityError ambiguityError = (AmbiguityError)symbol.baseSymbol();
                symbol = ambiguityError.mergeAbstracts(this.site);
            }
            return symbol;
        }

        abstract Symbol doLookup(Env<AttrContext> var1, MethodResolutionPhase var2);

        @Override
        Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
            if (symbol2.kind >= 129) {
                symbol2 = Resolve.this.accessMethod(symbol2, diagnosticPosition, symbol, this.site, this.name, true, this.argtypes, this.typeargtypes);
            }
            return symbol2;
        }

        @Override
        void debug(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
            Resolve.this.reportVerboseResolutionDiagnostic(diagnosticPosition, this.name, this.site, this.argtypes, this.typeargtypes, symbol);
        }
    }

    abstract class LookupHelper {
        Name name;
        Type site;
        List<Type> argtypes;
        List<Type> typeargtypes;
        MethodResolutionPhase maxPhase;

        LookupHelper(Name name, Type type, List<Type> list, List<Type> list2, MethodResolutionPhase methodResolutionPhase) {
            this.name = name;
            this.site = type;
            this.argtypes = list;
            this.typeargtypes = list2;
            this.maxPhase = methodResolutionPhase;
        }

        final boolean shouldStop(Symbol symbol, MethodResolutionPhase methodResolutionPhase) {
            return methodResolutionPhase.ordinal() > this.maxPhase.ordinal() || symbol.kind < 128 || symbol.kind == 129;
        }

        abstract Symbol lookup(Env<AttrContext> var1, MethodResolutionPhase var2);

        void debug(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        }

        abstract Symbol access(Env<AttrContext> var1, JCDiagnostic.DiagnosticPosition var2, Symbol var3, Symbol var4);
    }

    static enum SearchResultKind {
        GOOD_MATCH,
        BAD_MATCH_MORE_SPECIFIC,
        BAD_MATCH,
        NOT_APPLICABLE_MATCH;

    }

    class ResolveDeferredRecoveryMap
    extends DeferredAttr.RecoveryDeferredTypeMap {
        public ResolveDeferredRecoveryMap(DeferredAttr.AttrMode attrMode, Symbol symbol, MethodResolutionPhase methodResolutionPhase) {
            DeferredAttr deferredAttr = Resolve.this.deferredAttr;
            deferredAttr.getClass();
            super(attrMode, symbol, methodResolutionPhase);
        }

        @Override
        protected Type typeOf(DeferredAttr.DeferredType deferredType) {
            Type type = super.typeOf(deferredType);
            if (!type.isErroneous()) {
                switch (TreeInfo.skipParens(deferredType.tree).getTag()) {
                    case LAMBDA: 
                    case REFERENCE: {
                        return deferredType;
                    }
                    case CONDEXPR: {
                        return type == Type.recoveryType ? deferredType : type;
                    }
                }
            }
            return type;
        }
    }

    static interface LogResolveHelper {
        public boolean resolveDiagnosticNeeded(Type var1, List<Type> var2, List<Type> var3);

        public List<Type> getArgumentTypes(ResolveError var1, Symbol var2, Name var3, List<Type> var4);
    }

    static enum InterfaceLookupPhase {
        ABSTRACT_OK{

            @Override
            InterfaceLookupPhase update(Symbol symbol, Resolve resolve) {
                if ((symbol.flags() & 0x4600L) != 0L) {
                    return this;
                }
                return DEFAULT_OK;
            }
        }
        ,
        DEFAULT_OK{

            @Override
            InterfaceLookupPhase update(Symbol symbol, Resolve resolve) {
                return this;
            }
        };


        abstract InterfaceLookupPhase update(Symbol var1, Resolve var2);
    }

    class LookupFilter
    implements Filter<Symbol> {
        boolean abstractOk;

        LookupFilter(boolean bl) {
            this.abstractOk = bl;
        }

        @Override
        public boolean accepts(Symbol symbol) {
            long l = symbol.flags();
            return symbol.kind == 16 && (l & 0x1000L) == 0L && (this.abstractOk || (l & 0x80000000000L) != 0L || (l & 0x400L) == 0L);
        }
    }

    public static class InapplicableMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
        JCDiagnostic diagnostic = null;
        JCDiagnostic.Factory diags;

        InapplicableMethodException(JCDiagnostic.Factory factory) {
            this.diags = factory;
        }

        InapplicableMethodException setMessage() {
            return this.setMessage((JCDiagnostic)null);
        }

        InapplicableMethodException setMessage(String string) {
            return this.setMessage(string != null ? this.diags.fragment(string, new Object[0]) : null);
        }

        InapplicableMethodException setMessage(String string, Object ... objectArray) {
            return this.setMessage(string != null ? this.diags.fragment(string, objectArray) : null);
        }

        InapplicableMethodException setMessage(JCDiagnostic jCDiagnostic) {
            this.diagnostic = jCDiagnostic;
            return this;
        }

        public JCDiagnostic getDiagnostic() {
            return this.diagnostic;
        }
    }

    class MostSpecificCheck
    implements MethodCheck {
        boolean strict;
        List<Type> actuals;

        MostSpecificCheck(boolean bl, List<Type> list) {
            this.strict = bl;
            this.actuals = list;
        }

        @Override
        public void argumentsAcceptable(Env<AttrContext> env, DeferredAttr.DeferredAttrContext deferredAttrContext, List<Type> list, List<Type> list2, Warner warner) {
            list2 = Resolve.this.adjustArgs(list2, deferredAttrContext.msym, list.length(), deferredAttrContext.phase.isVarargsRequired());
            while (list2.nonEmpty()) {
                Attr.ResultInfo resultInfo = this.methodCheckResult((Type)list2.head, deferredAttrContext, warner, (Type)this.actuals.head);
                resultInfo.check(null, (Type)list.head);
                list = list.tail;
                list2 = list2.tail;
                this.actuals = this.actuals.isEmpty() ? this.actuals : this.actuals.tail;
            }
        }

        Attr.ResultInfo methodCheckResult(Type type, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warner, Type type2) {
            Attr attr = Resolve.this.attr;
            attr.getClass();
            return attr.new Attr.ResultInfo(12, type, new MostSpecificCheckContext(this.strict, deferredAttrContext, warner, type2));
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> list, boolean bl) {
            Assert.error("Cannot get here!");
            return null;
        }

        class MostSpecificCheckContext
        extends MethodCheckContext {
            Type actual;

            public MostSpecificCheckContext(boolean bl, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warner, Type type) {
                super(bl, deferredAttrContext, warner);
                this.actual = type;
            }

            @Override
            public boolean compatible(Type type, Type type2, Warner warner) {
                if (Resolve.this.allowFunctionalInterfaceMostSpecific && this.unrelatedFunctionalInterfaces(type, type2) && this.actual != null && this.actual.getTag() == TypeTag.DEFERRED) {
                    DeferredAttr.DeferredType deferredType = (DeferredAttr.DeferredType)this.actual;
                    DeferredAttr.DeferredType.SpeculativeCache.Entry entry = deferredType.speculativeCache.get(this.deferredAttrContext.msym, this.deferredAttrContext.phase);
                    if (entry != null && entry.speculativeTree != Resolve.this.deferredAttr.stuckTree) {
                        return this.functionalInterfaceMostSpecific(type, type2, entry.speculativeTree, warner);
                    }
                }
                return super.compatible(type, type2, warner);
            }

            private boolean unrelatedFunctionalInterfaces(Type type, Type type2) {
                return Resolve.this.types.isFunctionalInterface(type.tsym) && Resolve.this.types.isFunctionalInterface(type2.tsym) && Resolve.this.types.asSuper(type, type2.tsym) == null && Resolve.this.types.asSuper(type2, type.tsym) == null;
            }

            private boolean functionalInterfaceMostSpecific(Type type, Type type2, JCTree jCTree, Warner warner) {
                FunctionalInterfaceMostSpecificChecker functionalInterfaceMostSpecificChecker = new FunctionalInterfaceMostSpecificChecker(type, type2, warner);
                functionalInterfaceMostSpecificChecker.scan(jCTree);
                return functionalInterfaceMostSpecificChecker.result;
            }

            class FunctionalInterfaceMostSpecificChecker
            extends DeferredAttr.PolyScanner {
                final Type t;
                final Type s;
                final Warner warn;
                boolean result;

                FunctionalInterfaceMostSpecificChecker(Type type, Type type2, Warner warner) {
                    this.t = type;
                    this.s = type2;
                    this.warn = warner;
                    this.result = true;
                }

                @Override
                void skip(JCTree jCTree) {
                    this.result &= false;
                }

                @Override
                public void visitConditional(JCTree.JCConditional jCConditional) {
                    this.scan(jCConditional.truepart);
                    this.scan(jCConditional.falsepart);
                }

                @Override
                public void visitReference(JCTree.JCMemberReference jCMemberReference) {
                    Type type = Resolve.this.types.findDescriptorType(this.t);
                    Type type2 = Resolve.this.types.findDescriptorType(this.s);
                    if (!Resolve.this.types.isSameTypes(type.getParameterTypes(), MostSpecificCheckContext.this.inferenceContext().asUndetVars(type2.getParameterTypes()))) {
                        this.result &= false;
                    } else {
                        Type type3 = type.getReturnType();
                        Type type4 = type2.getReturnType();
                        if (type4.hasTag(TypeTag.VOID)) {
                            this.result &= true;
                        } else if (type3.hasTag(TypeTag.VOID)) {
                            this.result &= false;
                        } else if (type3.isPrimitive() != type4.isPrimitive()) {
                            boolean bl = jCMemberReference.refPolyKind == JCTree.JCPolyExpression.PolyKind.STANDALONE && jCMemberReference.sym.type.getReturnType().isPrimitive();
                            this.result &= bl == type3.isPrimitive() && bl != type4.isPrimitive();
                        } else {
                            this.result &= MostSpecificCheckContext.super.compatible(type3, type4, this.warn);
                        }
                    }
                }

                @Override
                public void visitLambda(JCTree.JCLambda jCLambda) {
                    Type type = Resolve.this.types.findDescriptorType(this.t);
                    Type type2 = Resolve.this.types.findDescriptorType(this.s);
                    if (!Resolve.this.types.isSameTypes(type.getParameterTypes(), MostSpecificCheckContext.this.inferenceContext().asUndetVars(type2.getParameterTypes()))) {
                        this.result &= false;
                    } else {
                        Type type3 = type.getReturnType();
                        Type type4 = type2.getReturnType();
                        if (type4.hasTag(TypeTag.VOID)) {
                            this.result &= true;
                        } else if (type3.hasTag(TypeTag.VOID)) {
                            this.result &= false;
                        } else if (MostSpecificCheckContext.this.unrelatedFunctionalInterfaces(type3, type4)) {
                            for (JCTree.JCExpression jCExpression : this.lambdaResults(jCLambda)) {
                                this.result &= MostSpecificCheckContext.this.functionalInterfaceMostSpecific(type3, type4, jCExpression, this.warn);
                            }
                        } else if (type3.isPrimitive() != type4.isPrimitive()) {
                            for (JCTree.JCExpression jCExpression : this.lambdaResults(jCLambda)) {
                                boolean bl = jCExpression.isStandalone() && jCExpression.type.isPrimitive();
                                this.result &= bl == type3.isPrimitive() && bl != type4.isPrimitive();
                            }
                        } else {
                            this.result &= MostSpecificCheckContext.super.compatible(type3, type4, this.warn);
                        }
                    }
                }

                private List<JCTree.JCExpression> lambdaResults(JCTree.JCLambda jCLambda) {
                    if (jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                        return List.of((JCTree.JCExpression)jCLambda.body);
                    }
                    final ListBuffer listBuffer = new ListBuffer();
                    DeferredAttr.LambdaReturnScanner lambdaReturnScanner = new DeferredAttr.LambdaReturnScanner(){

                        @Override
                        public void visitReturn(JCTree.JCReturn jCReturn) {
                            if (jCReturn.expr != null) {
                                listBuffer.append(jCReturn.expr);
                            }
                        }
                    };
                    lambdaReturnScanner.scan(jCLambda.body);
                    return listBuffer.toList();
                }
            }
        }
    }

    class MethodResultInfo
    extends Attr.ResultInfo {
        public MethodResultInfo(Type type, Check.CheckContext checkContext) {
            Attr attr = Resolve.this.attr;
            attr.getClass();
            super(12, type, checkContext);
        }

        @Override
        protected Type check(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
            if (type.hasTag(TypeTag.DEFERRED)) {
                DeferredAttr.DeferredType deferredType = (DeferredAttr.DeferredType)type;
                return deferredType.check(this);
            }
            Type type2 = this.U(type.baseType());
            Type type3 = diagnosticPosition == null || diagnosticPosition.getTree() == null ? Resolve.this.types.capture(type2) : this.checkContext.inferenceContext().cachedCapture(diagnosticPosition.getTree(), type2, true);
            return super.check(diagnosticPosition, Resolve.this.chk.checkNonVoid(diagnosticPosition, type3));
        }

        private Type U(Type type) {
            return type == this.pt ? type : Resolve.this.types.cvarUpperBound(type);
        }

        @Override
        protected MethodResultInfo dup(Type type) {
            return new MethodResultInfo(type, this.checkContext);
        }

        @Override
        protected Attr.ResultInfo dup(Check.CheckContext checkContext) {
            return new MethodResultInfo(this.pt, checkContext);
        }
    }

    abstract class MethodCheckContext
    implements Check.CheckContext {
        boolean strict;
        DeferredAttr.DeferredAttrContext deferredAttrContext;
        Warner rsWarner;

        public MethodCheckContext(boolean bl, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warner) {
            this.strict = bl;
            this.deferredAttrContext = deferredAttrContext;
            this.rsWarner = warner;
        }

        @Override
        public boolean compatible(Type type, Type type2, Warner warner) {
            Infer.InferenceContext inferenceContext = this.deferredAttrContext.inferenceContext;
            return this.strict ? Resolve.this.types.isSubtypeUnchecked(inferenceContext.asUndetVar(type), inferenceContext.asUndetVar(type2), warner) : Resolve.this.types.isConvertible(inferenceContext.asUndetVar(type), inferenceContext.asUndetVar(type2), warner);
        }

        @Override
        public void report(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic jCDiagnostic) {
            throw Resolve.this.inapplicableMethodException.setMessage(jCDiagnostic);
        }

        @Override
        public Warner checkWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
            return this.rsWarner;
        }

        @Override
        public Infer.InferenceContext inferenceContext() {
            return this.deferredAttrContext.inferenceContext;
        }

        @Override
        public DeferredAttr.DeferredAttrContext deferredAttrContext() {
            return this.deferredAttrContext;
        }

        public String toString() {
            return "MethodCheckContext";
        }
    }

    class MethodReferenceCheck
    extends AbstractMethodCheck {
        Infer.InferenceContext pendingInferenceContext;

        MethodReferenceCheck(Infer.InferenceContext inferenceContext) {
            this.pendingInferenceContext = inferenceContext;
        }

        @Override
        void checkArg(JCDiagnostic.DiagnosticPosition diagnosticPosition, boolean bl, Type type, Type type2, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warner) {
            Attr.ResultInfo resultInfo = this.methodCheckResult(bl, type2, deferredAttrContext, warner);
            resultInfo.check(diagnosticPosition, type);
        }

        private Attr.ResultInfo methodCheckResult(final boolean bl, Type type, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warner) {
            MethodCheckContext methodCheckContext = new MethodCheckContext(!deferredAttrContext.phase.isBoxingRequired(), deferredAttrContext, warner){
                MethodCheckDiag methodDiag;
                {
                    super(bl3, deferredAttrContext, warner);
                    this.methodDiag = bl ? MethodCheckDiag.VARARG_MISMATCH : MethodCheckDiag.ARG_MISMATCH;
                }

                @Override
                public boolean compatible(Type type, Type type2, Warner warner) {
                    if ((type = MethodReferenceCheck.this.pendingInferenceContext.asUndetVar(type)).hasTag(TypeTag.UNDETVAR) && type2.isPrimitive()) {
                        type2 = Resolve.this.types.boxedClass((Type)type2).type;
                    }
                    return super.compatible(type, type2, warner);
                }

                @Override
                public void report(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic jCDiagnostic) {
                    MethodReferenceCheck.this.reportMC(diagnosticPosition, this.methodDiag, this.deferredAttrContext.inferenceContext, jCDiagnostic);
                }
            };
            return new MethodResultInfo(type, methodCheckContext);
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> list, boolean bl) {
            return new MostSpecificCheck(bl, list);
        }

        public String toString() {
            return "MethodReferenceCheck";
        }
    }

    abstract class AbstractMethodCheck
    implements MethodCheck {
        AbstractMethodCheck() {
        }

        @Override
        public void argumentsAcceptable(Env<AttrContext> env, DeferredAttr.DeferredAttrContext deferredAttrContext, List<Type> list, List<Type> list2, Warner warner) {
            Object object;
            Type type;
            boolean bl = deferredAttrContext.phase.isVarargsRequired();
            List<JCTree.JCExpression> list3 = TreeInfo.args(env.tree);
            Infer.InferenceContext inferenceContext = deferredAttrContext.inferenceContext;
            Type type2 = type = bl ? list2.last() : null;
            if (type == null && list.size() != list2.size()) {
                this.reportMC(env.tree, MethodCheckDiag.ARITY_MISMATCH, inferenceContext, new Object[0]);
            }
            while (list.nonEmpty() && list2.head != type) {
                object = list3 != null ? (JCTree.JCExpression)list3.head : null;
                this.checkArg((JCDiagnostic.DiagnosticPosition)object, false, (Type)list.head, (Type)list2.head, deferredAttrContext, warner);
                list = list.tail;
                list2 = list2.tail;
                list3 = list3 != null ? list3.tail : list3;
            }
            if (list2.head != type) {
                this.reportMC(env.tree, MethodCheckDiag.ARITY_MISMATCH, inferenceContext, new Object[0]);
            }
            if (bl) {
                object = Resolve.this.types.elemtype(type);
                while (list.nonEmpty()) {
                    JCTree.JCExpression jCExpression = list3 != null ? (JCTree.JCExpression)list3.head : null;
                    this.checkArg(jCExpression, true, (Type)list.head, (Type)object, deferredAttrContext, warner);
                    list = list.tail;
                    list3 = list3 != null ? list3.tail : list3;
                }
            }
        }

        abstract void checkArg(JCDiagnostic.DiagnosticPosition var1, boolean var2, Type var3, Type var4, DeferredAttr.DeferredAttrContext var5, Warner var6);

        protected void reportMC(JCDiagnostic.DiagnosticPosition diagnosticPosition, MethodCheckDiag methodCheckDiag, Infer.InferenceContext inferenceContext, Object ... objectArray) {
            Object[] objectArray2;
            InapplicableMethodException inapplicableMethodException;
            boolean bl = inferenceContext != Resolve.this.infer.emptyContext;
            InapplicableMethodException inapplicableMethodException2 = inapplicableMethodException = bl ? Resolve.this.infer.inferenceException : Resolve.this.inapplicableMethodException;
            if (bl && !methodCheckDiag.inferKey.equals(methodCheckDiag.basicKey)) {
                objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                objectArray2[0] = inferenceContext.inferenceVars();
                objectArray = objectArray2;
            }
            objectArray2 = bl ? methodCheckDiag.inferKey : methodCheckDiag.basicKey;
            throw inapplicableMethodException.setMessage(Resolve.this.diags.create(JCDiagnostic.DiagnosticType.FRAGMENT, Resolve.this.log.currentSource(), diagnosticPosition, (String)objectArray2, objectArray));
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> list, boolean bl) {
            return Resolve.this.nilMethodCheck;
        }
    }

    static enum MethodCheckDiag {
        ARITY_MISMATCH("arg.length.mismatch", "infer.arg.length.mismatch"),
        ARG_MISMATCH("no.conforming.assignment.exists", "infer.no.conforming.assignment.exists"),
        VARARG_MISMATCH("varargs.argument.mismatch", "infer.varargs.argument.mismatch"),
        INACCESSIBLE_VARARGS("inaccessible.varargs.type", "inaccessible.varargs.type");

        final String basicKey;
        final String inferKey;

        private MethodCheckDiag(String string2, String string3) {
            this.basicKey = string2;
            this.inferKey = string3;
        }

        String regex() {
            return String.format("([a-z]*\\.)*(%s|%s)", this.basicKey, this.inferKey);
        }
    }

    static interface MethodCheck {
        public void argumentsAcceptable(Env<AttrContext> var1, DeferredAttr.DeferredAttrContext var2, List<Type> var3, List<Type> var4, Warner var5);

        public MethodCheck mostSpecificCheck(List<Type> var1, boolean var2);
    }

    static enum VerboseResolutionMode {
        SUCCESS("success"),
        FAILURE("failure"),
        APPLICABLE("applicable"),
        INAPPLICABLE("inapplicable"),
        DEFERRED_INST("deferred-inference"),
        PREDEF("predef"),
        OBJECT_INIT("object-init"),
        INTERNAL("internal");

        final String opt;

        private VerboseResolutionMode(String string2) {
            this.opt = string2;
        }

        static EnumSet<VerboseResolutionMode> getVerboseResolutionMode(Options options) {
            String string = options.get("verboseResolution");
            EnumSet<VerboseResolutionMode> enumSet = EnumSet.noneOf(VerboseResolutionMode.class);
            if (string == null) {
                return enumSet;
            }
            if (string.contains("all")) {
                enumSet = EnumSet.allOf(VerboseResolutionMode.class);
            }
            java.util.List<String> list = Arrays.asList(string.split(","));
            for (VerboseResolutionMode verboseResolutionMode : VerboseResolutionMode.values()) {
                if (list.contains(verboseResolutionMode.opt)) {
                    enumSet.add(verboseResolutionMode);
                    continue;
                }
                if (!list.contains("-" + verboseResolutionMode.opt)) continue;
                enumSet.remove((Object)verboseResolutionMode);
            }
            return enumSet;
        }
    }
}

