/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;

public class ZipArchive
implements JavacFileManager.Archive {
    protected JavacFileManager fileManager;
    protected final Map<RelativePath.RelativeDirectory, List<String>> map;
    protected final ZipFile zfile;
    protected Reference<File> absFileRef;

    public ZipArchive(JavacFileManager javacFileManager, ZipFile zipFile) throws IOException {
        this(javacFileManager, zipFile, true);
    }

    protected ZipArchive(JavacFileManager javacFileManager, ZipFile zipFile, boolean bl) throws IOException {
        this.fileManager = javacFileManager;
        this.zfile = zipFile;
        this.map = new HashMap<RelativePath.RelativeDirectory, List<String>>();
        if (bl) {
            this.initMap();
        }
    }

    protected void initMap() throws IOException {
        Enumeration<? extends ZipEntry> enumeration = this.zfile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry;
            try {
                zipEntry = enumeration.nextElement();
            }
            catch (InternalError internalError) {
                IOException iOException = new IOException();
                iOException.initCause(internalError);
                throw iOException;
            }
            this.addZipEntry(zipEntry);
        }
    }

    void addZipEntry(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        int n = string.lastIndexOf(47);
        RelativePath.RelativeDirectory relativeDirectory = new RelativePath.RelativeDirectory(string.substring(0, n + 1));
        String string2 = string.substring(n + 1);
        if (string2.length() == 0) {
            return;
        }
        List<String> list = this.map.get(relativeDirectory);
        if (list == null) {
            list = List.nil();
        }
        list = list.prepend(string2);
        this.map.put(relativeDirectory, list);
    }

    @Override
    public boolean contains(RelativePath relativePath) {
        RelativePath.RelativeDirectory relativeDirectory = relativePath.dirname();
        String string = relativePath.basename();
        if (string.length() == 0) {
            return false;
        }
        List<String> list = this.map.get(relativeDirectory);
        return list != null && list.contains(string);
    }

    @Override
    public List<String> getFiles(RelativePath.RelativeDirectory relativeDirectory) {
        return this.map.get(relativeDirectory);
    }

    @Override
    public JavaFileObject getFileObject(RelativePath.RelativeDirectory relativeDirectory, String string) {
        ZipEntry zipEntry = new RelativePath.RelativeFile(relativeDirectory, string).getZipEntry(this.zfile);
        return new ZipFileObject(this, string, zipEntry);
    }

    @Override
    public Set<RelativePath.RelativeDirectory> getSubdirectories() {
        return this.map.keySet();
    }

    @Override
    public void close() throws IOException {
        this.zfile.close();
    }

    public String toString() {
        return "ZipArchive[" + this.zfile.getName() + "]";
    }

    private File getAbsoluteFile() {
        File file;
        File file2 = file = this.absFileRef == null ? null : this.absFileRef.get();
        if (file == null) {
            file = new File(this.zfile.getName()).getAbsoluteFile();
            this.absFileRef = new SoftReference<File>(file);
        }
        return file;
    }

    public static class ZipFileObject
    extends BaseFileObject {
        private String name;
        ZipArchive zarch;
        ZipEntry entry;

        protected ZipFileObject(ZipArchive zipArchive, String string, ZipEntry zipEntry) {
            super(zipArchive.fileManager);
            this.zarch = zipArchive;
            this.name = string;
            this.entry = zipEntry;
        }

        @Override
        public URI toUri() {
            File file = new File(this.zarch.zfile.getName());
            return ZipFileObject.createJarUri(file, this.entry.getName());
        }

        @Override
        public String getName() {
            return this.zarch.zfile.getName() + "(" + this.entry.getName() + ")";
        }

        @Override
        public String getShortName() {
            return new File(this.zarch.zfile.getName()).getName() + "(" + this.entry + ")";
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return ZipFileObject.getKind(this.entry.getName());
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.zarch.zfile.getInputStream(this.entry);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharBuffer getCharContent(boolean bl) throws IOException {
            CharBuffer charBuffer = this.fileManager.getCachedContent(this);
            if (charBuffer == null) {
                try (InputStream inputStream = this.zarch.zfile.getInputStream(this.entry);){
                    ByteBuffer byteBuffer = this.fileManager.makeByteBuffer(inputStream);
                    JavaFileObject javaFileObject = this.fileManager.log.useSource(this);
                    try {
                        charBuffer = this.fileManager.decode(byteBuffer, bl);
                    }
                    finally {
                        this.fileManager.log.useSource(javaFileObject);
                    }
                    this.fileManager.recycleByteBuffer(byteBuffer);
                    if (!bl) {
                        this.fileManager.cache(this, charBuffer);
                    }
                }
            }
            return charBuffer;
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            return this.entry.getTime();
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected CharsetDecoder getDecoder(boolean bl) {
            return this.fileManager.getDecoder(this.fileManager.getEncodingName(), bl);
        }

        @Override
        protected String inferBinaryName(Iterable<? extends File> iterable) {
            String string = this.entry.getName();
            return ZipFileObject.removeExtension(string).replace('/', '.');
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            string.getClass();
            if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
                return false;
            }
            return this.name.equals(string + kind.extension);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ZipFileObject)) {
                return false;
            }
            ZipFileObject zipFileObject = (ZipFileObject)object;
            return this.zarch.getAbsoluteFile().equals(zipFileObject.zarch.getAbsoluteFile()) && this.name.equals(zipFileObject.name);
        }

        @Override
        public int hashCode() {
            return this.zarch.getAbsoluteFile().hashCode() + this.name.hashCode();
        }
    }
}

