/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.util.BaseFileManager;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import javax.tools.JavaFileManager;

public class Main {
    String ownName;
    PrintWriter out;
    public Log log;
    boolean apiMode;
    private JavaFileManager fileManager;
    public static final String javacBundleName = "com.sun.tools.javac.resources.javac";

    public Main(String string) {
        this(string, new PrintWriter(System.err, true));
    }

    public Main(String string, PrintWriter printWriter) {
        this.ownName = string;
        this.out = printWriter;
    }

    void error(String string, Object ... objectArray) {
        if (this.apiMode) {
            String string2 = this.log.localize(Log.PrefixKind.JAVAC, string, objectArray);
            throw new PropagatedException(new IllegalStateException(string2));
        }
        this.warning(string, objectArray);
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.usage", this.ownName);
    }

    void warning(String string, Object ... objectArray) {
        this.log.printRawLines(this.ownName + ": " + this.log.localize(Log.PrefixKind.JAVAC, string, objectArray));
    }

    public Result compile(String[] stringArray) {
        Context context = new Context();
        JavacFileManager.preRegister(context);
        Result result = this.compile(stringArray, context);
        if (this.fileManager instanceof JavacFileManager) {
            ((JavacFileManager)this.fileManager).close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result compile(String[] stringArray, Context context) {
        Object object;
        Object object2;
        boolean bl;
        String string;
        boolean bl2;
        context.put(Log.outKey, this.out);
        this.log = Log.instance(context);
        if (stringArray.length == 0) {
            Option.HELP.process(new OptionHelper.GrumpyHelper(this.log){

                @Override
                public String getOwnName() {
                    return Main.this.ownName;
                }
            }, "-help");
            return Result.CMDERR;
        }
        try {
            stringArray = CommandLine.parse(stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.warning("err.file.not.found", fileNotFoundException.getMessage());
            return Result.SYSERR;
        }
        catch (IOException iOException) {
            this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
            iOException.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
            return Result.SYSERR;
        }
        Arguments arguments = Arguments.instance(context);
        arguments.init(this.ownName, stringArray);
        if (this.log.nerrors > 0) {
            return Result.CMDERR;
        }
        Options options = Options.instance(context);
        boolean bl3 = options.isSet("stdout");
        if (bl3) {
            this.log.flush();
            this.log.setWriters(new PrintWriter(System.out, true));
        }
        boolean bl4 = bl2 = options.isUnset("nonBatchMode") && System.getProperty("nonBatchMode") == null;
        if (bl2) {
            CacheFSInfo.preRegister(context);
        }
        this.fileManager = context.get(JavaFileManager.class);
        if (this.fileManager instanceof BaseFileManager) {
            ((BaseFileManager)this.fileManager).setContext(context);
            ((BaseFileManager)this.fileManager).handleOptions(arguments.getDeferredFileManagerOptions());
        }
        if ((string = options.get("showClass")) != null) {
            if (string.equals("showClass")) {
                string = "com.sun.tools.javac.Main";
            }
            this.showClass(string);
        }
        if (!(bl = arguments.validate()) || this.log.nerrors > 0) {
            return Result.CMDERR;
        }
        if (arguments.isEmpty()) {
            return Result.OK;
        }
        Set<List<String>> set = arguments.getPluginOpts();
        if (!set.isEmpty()) {
            object2 = (BasicJavacTask)BasicJavacTask.instance(context);
            ((BasicJavacTask)object2).initPlugins(set);
        }
        if (!((List)(object2 = arguments.getDocLintOpts())).isEmpty()) {
            object = (BasicJavacTask)BasicJavacTask.instance(context);
            ((BasicJavacTask)object).initDocLint((List<String>)object2);
        }
        if (options.isSet("completionDeps")) {
            Dependencies.GraphDependencies.preRegister(context);
        }
        object = JavaCompiler.instance(context);
        if (options.get(Option.XSTDOUT) != null) {
            ((JavaCompiler)object).closeables = ((JavaCompiler)object).closeables.prepend(this.log.getWriter(Log.WriterKind.NOTICE));
        }
        try {
            ((JavaCompiler)object).compile(arguments.getFileObjects(), arguments.getClassNames(), null);
            if (this.log.expectDiagKeys != null) {
                if (this.log.expectDiagKeys.isEmpty()) {
                    this.log.printRawLines("all expected diagnostics found");
                    Result result = Result.OK;
                    return result;
                }
                this.log.printRawLines("expected diagnostic keys not found: " + this.log.expectDiagKeys);
                Result result = Result.ERROR;
                return result;
            }
            Result result = ((JavaCompiler)object).errorCount() == 0 ? Result.OK : Result.ERROR;
            return result;
        }
        catch (OutOfMemoryError | StackOverflowError virtualMachineError) {
            this.resourceMessage(virtualMachineError);
            Result result = Result.SYSERR;
            return result;
        }
        catch (FatalError fatalError) {
            this.feMessage(fatalError, options);
            Result result = Result.SYSERR;
            return result;
        }
        catch (AnnotationProcessingError annotationProcessingError) {
            this.apMessage(annotationProcessingError);
            Result result = Result.SYSERR;
            return result;
        }
        catch (PropagatedException propagatedException) {
            throw propagatedException.getCause();
        }
        catch (Throwable throwable) {
            if (object == null || ((JavaCompiler)object).errorCount() == 0 || options.isSet("dev")) {
                this.bugMessage(throwable);
            }
            Result result = Result.ABNORMAL;
            return result;
        }
        finally {
            if (object != null) {
                try {
                    ((JavaCompiler)object).close();
                }
                catch (ClientCodeException clientCodeException) {
                    throw new RuntimeException(clientCodeException.getCause());
                }
            }
        }
    }

    void bugMessage(Throwable throwable) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.bug", JavaCompiler.version());
        throwable.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void feMessage(Throwable throwable, Options options) {
        this.log.printRawLines(throwable.getMessage());
        if (throwable.getCause() != null && options.isSet("dev")) {
            throwable.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
        }
    }

    void ioMessage(Throwable throwable) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
        throwable.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void resourceMessage(Throwable throwable) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.resource", new Object[0]);
        throwable.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void apMessage(AnnotationProcessingError annotationProcessingError) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.proc.annotation.uncaught.exception", new Object[0]);
        annotationProcessingError.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void pluginMessage(Throwable throwable) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.plugin.uncaught.exception", new Object[0]);
        throwable.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void showClass(String string) {
        PrintWriter printWriter = this.log.getWriter(Log.WriterKind.NOTICE);
        printWriter.println("javac: show class: " + string);
        URL uRL = this.getClass().getResource('/' + string.replace('.', '/') + ".class");
        if (uRL == null) {
            printWriter.println("  class not found");
        } else {
            printWriter.println("  " + uRL);
            try {
                byte[] byArray;
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                Object object = new DigestInputStream(uRL.openStream(), messageDigest);
                Object object2 = null;
                try {
                    int n;
                    byte[] byArray2 = new byte[8192];
                    while ((n = ((FilterInputStream)object).read(byArray2)) > 0) {
                    }
                    byArray = messageDigest.digest();
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    if (object != null) {
                        if (object2 != null) {
                            try {
                                ((FilterInputStream)object).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                        } else {
                            ((FilterInputStream)object).close();
                        }
                    }
                }
                object = new StringBuilder();
                for (Object object3 : (Object)byArray) {
                    ((StringBuilder)object).append(String.format("%02x", (byte)object3));
                }
                printWriter.println("  MD5 checksum: " + object);
            }
            catch (IOException | NoSuchAlgorithmException exception) {
                printWriter.println("  cannot compute digest: " + exception);
            }
        }
    }

    public static enum Result {
        OK(0),
        ERROR(1),
        CMDERR(2),
        SYSERR(3),
        ABNORMAL(4);

        public final int exitCode;

        private Result(int n2) {
            this.exitCode = n2;
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }
    }
}

