/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.Preconditions;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MethodSignature;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.SubcomponentWriter;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.TypeSpecs;
import dagger.internal.codegen.UniqueNameSet;
import dagger.internal.codegen.Util;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

abstract class AbstractComponentWriter {
    private static final String NOOP_BUILDER_METHOD_JAVADOC = "This module is declared, but an instance is not used in the component. This method is a no-op. For more, see https://google.github.io/dagger/unused-modules.\n";
    protected final Elements elements;
    protected final Types types;
    protected final Key.Factory keyFactory;
    protected final CompilerOptions compilerOptions;
    protected final ClassName name;
    protected final BindingGraph graph;
    protected final ImmutableMap<ComponentDescriptor, String> subcomponentNames;
    private final Map<BindingKey, InitializationState> initializationStates = new HashMap<BindingKey, InitializationState>();
    protected TypeSpec.Builder component;
    private final UniqueNameSet componentFieldNames = new UniqueNameSet();
    private final Map<BindingKey, MemberSelect> memberSelects = new HashMap<BindingKey, MemberSelect>();
    private final Map<BindingKey, MemberSelect> producerFromProviderMemberSelects = new HashMap<BindingKey, MemberSelect>();
    protected final MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE);
    protected Optional<ClassName> builderName = Optional.absent();
    private ImmutableMap<TypeElement, FieldSpec> builderFields = ImmutableMap.of();
    protected final Map<TypeElement, MemberSelect> componentContributionFields = Maps.newHashMap();
    private static final int INITIALIZATIONS_PER_INITIALIZE_METHOD = 100;

    AbstractComponentWriter(Types types, Elements elements, Key.Factory keyFactory, CompilerOptions compilerOptions, ClassName name, BindingGraph graph, ImmutableMap<ComponentDescriptor, String> subcomponentNames) {
        this.types = types;
        this.elements = elements;
        this.keyFactory = keyFactory;
        this.compilerOptions = compilerOptions;
        this.name = name;
        this.graph = graph;
        this.subcomponentNames = subcomponentNames;
    }

    protected final TypeElement componentDefinitionType() {
        return this.graph.componentDescriptor().componentDefinitionType();
    }

    protected final ClassName componentDefinitionTypeName() {
        return ClassName.get(this.componentDefinitionType());
    }

    private CodeBlock getComponentContributionExpression(TypeElement contributionType) {
        if (this.builderFields.containsKey((Object)contributionType)) {
            return CodeBlock.of("builder.$N", this.builderFields.get((Object)contributionType));
        }
        Optional<CodeBlock> codeBlock = this.getOrCreateComponentContributionFieldExpression(contributionType);
        com.google.common.base.Preconditions.checkState((boolean)codeBlock.isPresent(), (String)"no builder or component field for %s", (Object[])new Object[]{contributionType});
        return (CodeBlock)codeBlock.get();
    }

    protected Optional<CodeBlock> getOrCreateComponentContributionFieldExpression(TypeElement contributionType) {
        MemberSelect fieldSelect = this.componentContributionFields.get(contributionType);
        if (fieldSelect == null) {
            if (!this.builderFields.containsKey((Object)contributionType)) {
                return Optional.absent();
            }
            FieldSpec componentField = this.componentField(ClassName.get(contributionType), AbstractComponentWriter.simpleVariableName(contributionType)).addModifiers(Modifier.PRIVATE, Modifier.FINAL).build();
            this.component.addField(componentField);
            this.constructor.addCode("this.$N = builder.$N;", componentField, this.builderFields.get((Object)contributionType));
            fieldSelect = MemberSelect.localField(this.name, componentField.name);
            this.componentContributionFields.put(contributionType, fieldSelect);
        }
        return Optional.of((Object)fieldSelect.getExpressionFor(this.name));
    }

    protected final FieldSpec.Builder componentField(TypeName type, String name) {
        return FieldSpec.builder(type, this.componentFieldNames.getUniqueName(name), new Modifier[0]);
    }

    private CodeBlock getMemberSelectExpression(BindingKey key) {
        return this.getMemberSelect(key).getExpressionFor(this.name);
    }

    protected MemberSelect getMemberSelect(BindingKey key) {
        return this.memberSelects.get(key);
    }

    protected InitializationState getInitializationState(BindingKey bindingKey) {
        return this.initializationStates.containsKey(bindingKey) ? this.initializationStates.get(bindingKey) : InitializationState.UNINITIALIZED;
    }

    private void setInitializationState(BindingKey bindingKey, InitializationState state) {
        this.initializationStates.put(bindingKey, state);
    }

    final TypeSpec.Builder write() {
        com.google.common.base.Preconditions.checkState((this.component == null ? 1 : 0) != 0, (Object)"ComponentWriter has already been generated.");
        this.component = this.createComponentClass();
        this.addBuilder();
        this.addFactoryMethods();
        this.addFields();
        this.initializeFrameworkTypes();
        this.implementInterfaceMethods();
        this.addSubcomponents();
        this.component.addMethod(this.constructor.build());
        return this.component;
    }

    protected abstract TypeSpec.Builder createComponentClass();

    protected void addBuilder() {
        this.builderName = Optional.of((Object)this.builderName());
        TypeSpec.Builder componentBuilder = this.createBuilder(((ClassName)this.builderName.get()).simpleName()).addModifiers(Modifier.FINAL);
        Optional<ComponentDescriptor.BuilderSpec> builderSpec = this.graph.componentDescriptor().builderSpec();
        if (builderSpec.isPresent()) {
            componentBuilder.addModifiers(Modifier.PRIVATE);
            TypeSpecs.addSupertype(componentBuilder, ((ComponentDescriptor.BuilderSpec)builderSpec.get()).builderDefinitionType());
        } else {
            componentBuilder.addModifiers(Modifier.PUBLIC).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        }
        this.builderFields = this.addBuilderFields(componentBuilder);
        this.addBuildMethod(componentBuilder, builderSpec);
        this.addBuilderMethods(componentBuilder, builderSpec);
        this.addBuilderClass(componentBuilder.build());
        this.constructor.addParameter((TypeName)this.builderName.get(), "builder", new Modifier[0]);
        this.constructor.addStatement("assert builder != null", new Object[0]);
    }

    protected abstract void addBuilderClass(TypeSpec var1);

    private ImmutableMap<TypeElement, FieldSpec> addBuilderFields(TypeSpec.Builder componentBuilder) {
        UniqueNameSet builderFieldNames = new UniqueNameSet();
        ImmutableMap.Builder builderFields = ImmutableMap.builder();
        for (TypeElement contributionElement : this.graph.componentRequirements()) {
            String contributionName = builderFieldNames.getUniqueName(AbstractComponentWriter.simpleVariableName(contributionElement));
            FieldSpec builderField = FieldSpec.builder(ClassName.get(contributionElement), contributionName, Modifier.PRIVATE).build();
            componentBuilder.addField(builderField);
            builderFields.put((Object)contributionElement, (Object)builderField);
        }
        return builderFields.build();
    }

    private void addBuildMethod(TypeSpec.Builder componentBuilder, Optional<ComponentDescriptor.BuilderSpec> builderSpec) {
        MethodSpec.Builder buildMethod;
        if (builderSpec.isPresent()) {
            ExecutableElement specBuildMethod = ((ComponentDescriptor.BuilderSpec)builderSpec.get()).buildMethod();
            buildMethod = MethodSpec.methodBuilder(specBuildMethod.getSimpleName().toString()).addAnnotation(Override.class);
        } else {
            buildMethod = MethodSpec.methodBuilder("build");
        }
        buildMethod.returns(this.componentDefinitionTypeName()).addModifiers(Modifier.PUBLIC);
        for (Map.Entry builderFieldEntry : this.builderFields.entrySet()) {
            FieldSpec builderField = (FieldSpec)builderFieldEntry.getValue();
            if (Util.componentCanMakeNewInstances((TypeElement)builderFieldEntry.getKey())) {
                buildMethod.addCode("if ($1N == null) { this.$1N = new $2T(); }", builderField, builderField.type);
                continue;
            }
            if (!Util.requiresAPassedInstance(this.elements, (TypeElement)builderFieldEntry.getKey())) continue;
            buildMethod.addCode("if ($N == null) { throw new $T($T.class.getCanonicalName() + $S); }", builderField, TypeNames.ILLEGAL_STATE_EXCEPTION, builderField.type, " must be set");
        }
        buildMethod.addStatement("return new $T(this)", this.name);
        componentBuilder.addMethod(buildMethod.build());
    }

    private void addBuilderMethods(TypeSpec.Builder componentBuilder, Optional<ComponentDescriptor.BuilderSpec> builderSpec) {
        ImmutableSet<TypeElement> componentRequirements = this.graph.componentRequirements();
        if (builderSpec.isPresent()) {
            UniqueNameSet parameterNames = new UniqueNameSet();
            for (Map.Entry<TypeElement, ExecutableElement> builderMethodEntry : ((ComponentDescriptor.BuilderSpec)builderSpec.get()).methodMap().entrySet()) {
                TypeElement builderMethodType = builderMethodEntry.getKey();
                ExecutableElement specMethod = builderMethodEntry.getValue();
                MethodSpec.Builder builderMethod = this.addBuilderMethodFromSpec(specMethod);
                String parameterName = parameterNames.getUniqueName(((VariableElement)Iterables.getOnlyElement(specMethod.getParameters())).getSimpleName());
                builderMethod.addParameter(ClassName.get(builderMethodType), parameterName, new Modifier[0]);
                if (componentRequirements.contains((Object)builderMethodType)) {
                    builderMethod.addStatement("this.$N = $T.checkNotNull($L)", this.builderFields.get((Object)builderMethodType), Preconditions.class, parameterName);
                    this.addBuilderMethodReturnStatementForSpec(specMethod, builderMethod);
                } else if (this.graph.ownedModuleTypes().contains((Object)builderMethodType)) {
                    builderMethod.addJavadoc(NOOP_BUILDER_METHOD_JAVADOC, new Object[0]);
                    this.addBuilderMethodReturnStatementForSpec(specMethod, builderMethod);
                } else {
                    builderMethod.addStatement("throw new $T($T.format($S, $T.class.getCanonicalName()))", TypeNames.UNSUPPORTED_OPERATION_EXCEPTION, TypeNames.STRING, "%s cannot be set because it is inherited from the enclosing component", ClassName.get(builderMethodType));
                }
                componentBuilder.addMethod(builderMethod.build());
            }
        } else {
            for (TypeElement componentRequirement : this.graph.availableDependencies()) {
                String componentRequirementName = AbstractComponentWriter.simpleVariableName(componentRequirement);
                MethodSpec.Builder builderMethod = MethodSpec.methodBuilder(componentRequirementName).returns((TypeName)this.builderName.get()).addModifiers(Modifier.PUBLIC).addParameter(ClassName.get(componentRequirement), componentRequirementName, new Modifier[0]);
                if (componentRequirements.contains((Object)componentRequirement)) {
                    builderMethod.addStatement("this.$N = $T.checkNotNull($L)", this.builderFields.get((Object)componentRequirement), Preconditions.class, componentRequirementName);
                } else {
                    builderMethod.addStatement("$T.checkNotNull($L)", Preconditions.class, componentRequirementName);
                    builderMethod.addJavadoc("@deprecated This module is declared, but an instance is not used in the component. This method is a no-op. For more, see https://google.github.io/dagger/unused-modules.\n", new Object[0]);
                    builderMethod.addAnnotation(Deprecated.class);
                }
                builderMethod.addStatement("return this", new Object[0]);
                componentBuilder.addMethod(builderMethod.build());
            }
        }
    }

    private void addBuilderMethodReturnStatementForSpec(ExecutableElement specMethod, MethodSpec.Builder builderMethod) {
        if (!specMethod.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
            builderMethod.addStatement("return this", new Object[0]);
        }
    }

    private MethodSpec.Builder addBuilderMethodFromSpec(ExecutableElement method) {
        TypeMirror returnType = method.getReturnType();
        MethodSpec.Builder builderMethod = MethodSpec.methodBuilder(method.getSimpleName().toString()).addAnnotation(Override.class).addModifiers((Iterable<Modifier>)Sets.difference(method.getModifiers(), (Set)ImmutableSet.of((Object)((Object)Modifier.ABSTRACT))));
        if (!returnType.getKind().equals((Object)TypeKind.VOID)) {
            builderMethod.returns((TypeName)this.builderName.get());
        }
        return builderMethod;
    }

    protected abstract TypeSpec.Builder createBuilder(String var1);

    protected abstract ClassName builderName();

    protected abstract void addFactoryMethods();

    private void addFields() {
        for (ResolvedBindings resolvedBindings : this.graph.resolvedBindings().values()) {
            this.addField(resolvedBindings);
        }
    }

    private void addField(ResolvedBindings resolvedBindings) {
        BindingKey bindingKey = resolvedBindings.bindingKey();
        Optional<MemberSelect> staticMemberSelect = this.staticMemberSelect(resolvedBindings);
        if (staticMemberSelect.isPresent()) {
            this.memberSelects.put(bindingKey, (MemberSelect)staticMemberSelect.get());
            return;
        }
        if (resolvedBindings.ownedBindings().isEmpty()) {
            return;
        }
        FieldSpec frameworkField = this.addFrameworkField(resolvedBindings, (Optional<ClassName>)Optional.absent());
        this.memberSelects.put(bindingKey, MemberSelect.localField(this.name, frameworkField.name));
    }

    private FieldSpec addFrameworkField(ResolvedBindings resolvedBindings, Optional<ClassName> frameworkClass) {
        boolean useRawType = this.useRawType(resolvedBindings);
        FrameworkField contributionBindingField = FrameworkField.forResolvedBindings(resolvedBindings, frameworkClass);
        FieldSpec.Builder contributionField = this.componentField(useRawType ? contributionBindingField.type().rawType : contributionBindingField.type(), contributionBindingField.name());
        contributionField.addModifiers(Modifier.PRIVATE);
        if (useRawType) {
            contributionField.addAnnotation(AnnotationSpecs.SUPPRESS_WARNINGS_RAWTYPES);
        }
        FieldSpec field = contributionField.build();
        this.component.addField(field);
        return field;
    }

    private boolean useRawType(ResolvedBindings resolvedBindings) {
        return this.useRawType(resolvedBindings.bindingPackage());
    }

    private boolean useRawType(Binding binding) {
        return this.useRawType(binding.bindingPackage());
    }

    private boolean useRawType(Optional<String> bindingPackage) {
        return bindingPackage.isPresent() && !((String)bindingPackage.get()).equals(this.name.packageName());
    }

    private Optional<MemberSelect> staticMemberSelect(ResolvedBindings resolvedBindings) {
        BindingKey bindingKey = resolvedBindings.bindingKey();
        switch (bindingKey.kind()) {
            case CONTRIBUTION: {
                ContributionBinding contributionBinding = resolvedBindings.contributionBinding();
                if (!contributionBinding.factoryCreationStrategy().equals((Object)ContributionBinding.FactoryCreationStrategy.ENUM_INSTANCE) || contributionBinding.scope().isPresent()) break;
                switch (contributionBinding.bindingKind()) {
                    case SYNTHETIC_MULTIBOUND_MAP: {
                        BindingType bindingType = contributionBinding.bindingType();
                        MapType mapType = MapType.from(contributionBinding.key());
                        return Optional.of((Object)MemberSelect.emptyFrameworkMapFactory(AbstractComponentWriter.frameworkMapFactoryClassName(bindingType), mapType.keyType(), mapType.unwrappedValueType(bindingType.frameworkClass())));
                    }
                    case SYNTHETIC_MULTIBOUND_SET: {
                        return Optional.of((Object)AbstractComponentWriter.emptySetFactoryStaticMemberSelect(contributionBinding.bindingType(), contributionBinding.key()));
                    }
                    case INJECTION: 
                    case PROVISION: {
                        ImmutableList<TypeVariableName> typeVariables;
                        if (!bindingKey.key().type().getKind().equals((Object)TypeKind.DECLARED) || (typeVariables = SourceFiles.bindingTypeElementTypeVariableNames(contributionBinding)).isEmpty()) break;
                        List<? extends TypeMirror> typeArguments = ((DeclaredType)bindingKey.key().type()).getTypeArguments();
                        return Optional.of((Object)MemberSelect.parameterizedFactoryCreateMethod(SourceFiles.generatedClassNameForBinding(contributionBinding), typeArguments));
                    }
                }
                return Optional.of((Object)MemberSelect.staticMethod(SourceFiles.generatedClassNameForBinding(contributionBinding), CodeBlock.of("create()", new Object[0])));
            }
            case MEMBERS_INJECTION: {
                Optional<MembersInjectionBinding> membersInjectionBinding = resolvedBindings.membersInjectionBinding();
                if (!membersInjectionBinding.isPresent() || !((MembersInjectionBinding)membersInjectionBinding.get()).injectionStrategy().equals((Object)MembersInjectionBinding.Strategy.NO_OP)) break;
                return Optional.of((Object)MemberSelect.noOpMembersInjector(((MembersInjectionBinding)membersInjectionBinding.get()).key().type()));
            }
            default: {
                throw new AssertionError();
            }
        }
        return Optional.absent();
    }

    private static MemberSelect emptySetFactoryStaticMemberSelect(BindingType bindingType, Key key) {
        return MemberSelect.emptySetProvider(AbstractComponentWriter.setFactoryClassName(bindingType, key), SetType.from(key));
    }

    private static ClassName setFactoryClassName(BindingType bindingType, Key key) {
        if (bindingType.equals((Object)BindingType.PROVISION)) {
            return TypeNames.SET_FACTORY;
        }
        SetType setType = SetType.from(key);
        return setType.elementsAreTypeOf(Produced.class) ? TypeNames.SET_OF_PRODUCED_PRODUCER : TypeNames.SET_PRODUCER;
    }

    private static ClassName mapFactoryClassName(ContributionBinding binding) {
        switch (binding.bindingType()) {
            case PRODUCTION: {
                return MapType.from(binding.key()).valuesAreTypeOf(Produced.class) ? TypeNames.MAP_OF_PRODUCED_PRODUCER : TypeNames.MAP_PRODUCER;
            }
            case PROVISION: 
            case MEMBERS_INJECTION: {
                return TypeNames.MAP_FACTORY;
            }
        }
        throw new AssertionError((Object)binding.toString());
    }

    private static ClassName frameworkMapFactoryClassName(BindingType bindingType) {
        return bindingType.equals((Object)BindingType.PRODUCTION) ? TypeNames.MAP_OF_PRODUCER_PRODUCER : TypeNames.MAP_PROVIDER_FACTORY;
    }

    private void implementInterfaceMethods() {
        HashSet interfaceMethods = Sets.newHashSet();
        for (ComponentDescriptor.ComponentMethodDescriptor componentMethod : this.graph.componentDescriptor().componentMethods()) {
            if (!componentMethod.dependencyRequest().isPresent()) continue;
            DependencyRequest interfaceRequest = (DependencyRequest)componentMethod.dependencyRequest().get();
            ExecutableElement requestElement = MoreElements.asExecutable(interfaceRequest.requestElement());
            ExecutableType requestType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(this.componentDefinitionType().asType()), requestElement));
            MethodSignature signature = MethodSignature.fromExecutableType(requestElement.getSimpleName().toString(), requestType);
            if (interfaceMethods.contains(signature)) continue;
            interfaceMethods.add(signature);
            MethodSpec.Builder interfaceMethod = MethodSpec.methodBuilder(requestElement.getSimpleName().toString()).addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(TypeName.get(requestType.getReturnType()));
            BindingKey bindingKey = interfaceRequest.bindingKey();
            MemberSelect memberSelect = this.getMemberSelect(bindingKey);
            CodeBlock memberSelectCodeBlock = memberSelect.getExpressionFor(this.name);
            switch (interfaceRequest.kind()) {
                case MEMBERS_INJECTOR: {
                    List<? extends VariableElement> parameters = requestElement.getParameters();
                    if (parameters.isEmpty()) {
                        interfaceMethod.addStatement("return $L", memberSelectCodeBlock);
                        break;
                    }
                    Name parameterName = ((VariableElement)Iterables.getOnlyElement(parameters)).getSimpleName();
                    interfaceMethod.addParameter(TypeName.get((TypeMirror)Iterables.getOnlyElement(requestType.getParameterTypes())), parameterName.toString(), new Modifier[0]);
                    interfaceMethod.addStatement("$L.injectMembers($L)", memberSelectCodeBlock, parameterName);
                    if (requestType.getReturnType().getKind().equals((Object)TypeKind.VOID)) break;
                    interfaceMethod.addStatement("return $L", parameterName);
                    break;
                }
                case INSTANCE: 
                case LAZY: 
                case PRODUCED: 
                case PRODUCER: 
                case PROVIDER: 
                case PROVIDER_OF_LAZY: 
                case FUTURE: {
                    interfaceMethod.addStatement("return $L", SourceFiles.frameworkTypeUsageStatement(memberSelectCodeBlock, interfaceRequest.kind()));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.component.addMethod(interfaceMethod.build());
        }
    }

    private void addSubcomponents() {
        for (Map.Entry subgraphEntry : this.graph.subgraphs().entrySet()) {
            SubcomponentWriter subcomponent = new SubcomponentWriter(this, (ExecutableElement)subgraphEntry.getKey(), (BindingGraph)subgraphEntry.getValue());
            this.component.addType(subcomponent.write().build());
        }
    }

    private void initializeFrameworkTypes() {
        ImmutableList.Builder codeBlocks = ImmutableList.builder();
        for (BindingKey bindingKey : this.graph.resolvedBindings().keySet()) {
            codeBlocks.addAll((Iterable)this.initializeFrameworkType(bindingKey).asSet());
        }
        List partitions = Lists.partition((List)codeBlocks.build(), (int)100);
        UniqueNameSet methodNames = new UniqueNameSet();
        for (List partition : partitions) {
            String methodName = methodNames.getUniqueName("initialize");
            MethodSpec.Builder initializeMethod = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PRIVATE).addAnnotation(AnnotationSpecs.SUPPRESS_WARNINGS_UNCHECKED).addCode(CodeBlocks.concat(partition));
            if (this.builderName.isPresent()) {
                initializeMethod.addParameter((TypeName)this.builderName.get(), "builder", Modifier.FINAL);
                this.constructor.addStatement("$L(builder)", methodName);
            } else {
                this.constructor.addStatement("$L()", methodName);
            }
            this.component.addMethod(initializeMethod.build());
        }
    }

    private Optional<CodeBlock> initializeFrameworkType(BindingKey bindingKey) {
        MemberSelect memberSelect = this.getMemberSelect(bindingKey);
        if (memberSelect.staticMember() || !memberSelect.owningClass().equals(this.name)) {
            return Optional.absent();
        }
        switch (bindingKey.kind()) {
            case CONTRIBUTION: {
                return this.initializeContributionBinding(bindingKey);
            }
            case MEMBERS_INJECTION: {
                return this.initializeMembersInjectionBinding(bindingKey);
            }
        }
        throw new AssertionError();
    }

    private Optional<CodeBlock> initializeContributionBinding(BindingKey bindingKey) {
        ContributionBinding binding = ((ResolvedBindings)this.graph.resolvedBindings().get((Object)bindingKey)).contributionBinding();
        switch (binding.factoryCreationStrategy()) {
            case DELEGATE: {
                CodeBlock delegatingCodeBlock = CodeBlock.of("($T) $L", binding.frameworkClass(), this.getMemberSelect(((DependencyRequest)Iterables.getOnlyElement(binding.dependencies())).bindingKey()).getExpressionFor(this.name));
                return Optional.of((Object)CodeBlocks.concat((Iterable<CodeBlock>)ImmutableList.of((Object)this.initializeDeferredDependencies(binding), (Object)this.initializeMember(bindingKey, binding.scope().isPresent() ? this.decorateForScope(delegatingCodeBlock, (Scope)binding.scope().get()) : delegatingCodeBlock))));
            }
            case ENUM_INSTANCE: {
                if (!binding.scope().isPresent()) {
                    return Optional.absent();
                }
            }
            case CLASS_CONSTRUCTOR: {
                return Optional.of((Object)CodeBlocks.concat((Iterable<CodeBlock>)ImmutableList.of((Object)this.initializeDeferredDependencies(binding), (Object)this.initializeMember(bindingKey, this.initializeFactoryForContributionBinding(binding)))));
            }
        }
        throw new AssertionError();
    }

    private Optional<CodeBlock> initializeMembersInjectionBinding(BindingKey bindingKey) {
        MembersInjectionBinding binding = (MembersInjectionBinding)((ResolvedBindings)this.graph.resolvedBindings().get((Object)bindingKey)).membersInjectionBinding().get();
        if (binding.injectionStrategy().equals((Object)MembersInjectionBinding.Strategy.NO_OP)) {
            return Optional.absent();
        }
        return Optional.of((Object)CodeBlocks.concat((Iterable<CodeBlock>)ImmutableList.of((Object)this.initializeDeferredDependencies(binding), (Object)this.initializeMember(bindingKey, this.initializeMembersInjectorForBinding(binding)))));
    }

    private CodeBlock initializeDeferredDependencies(Binding binding) {
        return CodeBlocks.concat((Iterable<CodeBlock>)ImmutableList.of((Object)this.initializeDelegateFactoriesForUninitializedDependencies(binding), (Object)this.initializeProducersFromProviderDependencies(binding)));
    }

    private CodeBlock initializeDelegateFactoriesForUninitializedDependencies(Binding binding) {
        ImmutableList.Builder initializations = ImmutableList.builder();
        for (BindingKey dependencyKey : FluentIterable.from(binding.implicitDependencies()).transform(DependencyRequest.BINDING_KEY_FUNCTION).toSet()) {
            if (this.getMemberSelect(dependencyKey).staticMember() || !this.getInitializationState(dependencyKey).equals((Object)InitializationState.UNINITIALIZED)) continue;
            initializations.add((Object)CodeBlock.of("this.$L = new $T();", this.getMemberSelectExpression(dependencyKey), TypeNames.DELEGATE_FACTORY));
            this.setInitializationState(dependencyKey, InitializationState.DELEGATED);
        }
        return CodeBlocks.concat((Iterable<CodeBlock>)initializations.build());
    }

    private CodeBlock initializeProducersFromProviderDependencies(Binding binding) {
        ImmutableList.Builder initializations = ImmutableList.builder();
        for (FrameworkDependency frameworkDependency : FrameworkDependency.frameworkDependenciesForBinding(binding)) {
            MemberSelect memberSelect;
            ResolvedBindings resolvedBindings = (ResolvedBindings)this.graph.resolvedBindings().get((Object)frameworkDependency.bindingKey());
            if (!resolvedBindings.frameworkClass().equals(Provider.class) || !frameworkDependency.frameworkClass().equals(Producer.class) || (memberSelect = this.producerFromProviderMemberSelects.get(frameworkDependency.bindingKey())) != null) continue;
            FieldSpec frameworkField = this.addFrameworkField(resolvedBindings, (Optional<ClassName>)Optional.of((Object)TypeNames.PRODUCER));
            memberSelect = MemberSelect.localField(this.name, frameworkField.name);
            this.producerFromProviderMemberSelects.put(frameworkDependency.bindingKey(), memberSelect);
            initializations.add((Object)CodeBlock.of("this.$L = $T.producerFromProvider($L);", memberSelect.getExpressionFor(this.name), TypeNames.PRODUCERS, this.getMemberSelectExpression(frameworkDependency.bindingKey())));
        }
        return CodeBlocks.concat((Iterable<CodeBlock>)initializations.build());
    }

    private CodeBlock initializeMember(BindingKey bindingKey, CodeBlock initializationCodeBlock) {
        ImmutableList.Builder initializations = ImmutableList.builder();
        CodeBlock memberSelect = this.getMemberSelectExpression(bindingKey);
        CodeBlock delegateFactoryVariable = this.delegateFactoryVariableExpression(bindingKey);
        if (this.getInitializationState(bindingKey).equals((Object)InitializationState.DELEGATED)) {
            initializations.add((Object)CodeBlock.of("$1T $2L = ($1T) $3L;", TypeNames.DELEGATE_FACTORY, delegateFactoryVariable, memberSelect));
        }
        initializations.add((Object)CodeBlock.of("this.$L = $L;", memberSelect, initializationCodeBlock));
        if (this.getInitializationState(bindingKey).equals((Object)InitializationState.DELEGATED)) {
            initializations.add((Object)CodeBlock.of("$L.setDelegatedProvider($L);", delegateFactoryVariable, memberSelect));
        }
        this.setInitializationState(bindingKey, InitializationState.INITIALIZED);
        return CodeBlocks.concat((Iterable<CodeBlock>)initializations.build());
    }

    private CodeBlock delegateFactoryVariableExpression(BindingKey key) {
        return CodeBlock.of("$LDelegate", this.getMemberSelectExpression(key).toString().replace('.', '_'));
    }

    private CodeBlock initializeFactoryForContributionBinding(ContributionBinding binding) {
        TypeName bindingKeyTypeName = TypeName.get(binding.key().type());
        switch (binding.bindingKind()) {
            case COMPONENT: {
                return CodeBlock.of("$T.<$T>create($L)", TypeNames.INSTANCE_FACTORY, bindingKeyTypeName, bindingKeyTypeName.equals(this.componentDefinitionTypeName()) ? "this" : this.getComponentContributionExpression(MoreTypes.asTypeElement(binding.key().type())));
            }
            case COMPONENT_PROVISION: {
                TypeElement bindingTypeElement = (TypeElement)this.graph.componentDescriptor().dependencyMethodIndex().get((Object)binding.bindingElement());
                String localFactoryVariable = AbstractComponentWriter.simpleVariableName(bindingTypeElement);
                CodeBlock callFactoryMethod = CodeBlock.of("$L.$L()", localFactoryVariable, binding.bindingElement().getSimpleName().toString());
                CodeBlock getMethodBody = binding.nullableType().isPresent() || this.compilerOptions.nullableValidationKind().equals((Object)Diagnostic.Kind.WARNING) ? CodeBlock.of("return $L;", callFactoryMethod) : CodeBlock.of("return $T.checkNotNull($L, $S);", Preconditions.class, callFactoryMethod, "Cannot return null from a non-@Nullable component method");
                return CodeBlock.of(Joiner.on((char)'\n').join((Object)"new $1T<$2T>() {", (Object)"  private final $5T $6L = $3L;", new Object[]{"  $4L@Override public $2T get() {", "    $7L", "  }", "}"}), TypeNames.FACTORY, bindingKeyTypeName, this.getComponentContributionExpression(bindingTypeElement), this.nullableAnnotation(binding.nullableType()), TypeName.get(bindingTypeElement.asType()), localFactoryVariable, getMethodBody);
            }
            case SUBCOMPONENT_BUILDER: {
                return CodeBlock.of(Joiner.on((char)'\n').join((Object)"new $1T<$2T>() {", (Object)"  @Override public $2T get() {", new Object[]{"    return $3L();", "  }", "}"}), TypeNames.FACTORY, bindingKeyTypeName, binding.bindingElement().getSimpleName().toString());
            }
            case INJECTION: 
            case PROVISION: {
                ArrayList arguments = Lists.newArrayListWithCapacity((int)(binding.dependencies().size() + 1));
                if (binding.bindingKind().equals((Object)ContributionBinding.Kind.PROVISION) && !binding.bindingElement().getModifiers().contains((Object)Modifier.STATIC)) {
                    arguments.add(this.getComponentContributionExpression((TypeElement)binding.contributingModule().get()));
                }
                arguments.addAll(this.getDependencyArguments(binding));
                CodeBlock factoryCreate = CodeBlock.of("$T.create($L)", SourceFiles.generatedClassNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(arguments));
                return binding.scope().isPresent() ? this.decorateForScope(factoryCreate, (Scope)binding.scope().get()) : factoryCreate;
            }
            case COMPONENT_PRODUCTION: {
                TypeElement bindingTypeElement = (TypeElement)this.graph.componentDescriptor().dependencyMethodIndex().get((Object)binding.bindingElement());
                return CodeBlock.of(Joiner.on((char)'\n').join((Object)"new $1T<$2T>() {", (Object)"  private final $6T $7L = $4L;", new Object[]{"  @Override public $3T<$2T> get() {", "    return $7L.$5L();", "  }", "}"}), TypeNames.PRODUCER, TypeName.get(binding.key().type()), TypeNames.LISTENABLE_FUTURE, this.getComponentContributionExpression(bindingTypeElement), binding.bindingElement().getSimpleName().toString(), TypeName.get(bindingTypeElement.asType()), AbstractComponentWriter.simpleVariableName(bindingTypeElement));
            }
            case IMMEDIATE: 
            case FUTURE_PRODUCTION: {
                ArrayList arguments = Lists.newArrayListWithCapacity((int)(binding.implicitDependencies().size() + 2));
                if (!binding.bindingElement().getModifiers().contains((Object)Modifier.STATIC)) {
                    arguments.add(this.getComponentContributionExpression(binding.bindingTypeElement()));
                }
                arguments.addAll(this.getDependencyArguments(binding));
                return CodeBlock.of("new $T($L)", SourceFiles.generatedClassNameForBinding(binding), CodeBlocks.makeParametersCodeBlock(arguments));
            }
            case SYNTHETIC_MAP: {
                return CodeBlock.of("$T.create($L)", AbstractComponentWriter.mapFactoryClassName(binding), this.getMemberSelectExpression(((DependencyRequest)Iterables.getOnlyElement(binding.dependencies())).bindingKey()));
            }
            case SYNTHETIC_MULTIBOUND_SET: {
                return this.initializeFactoryForSetMultibinding(binding);
            }
            case SYNTHETIC_MULTIBOUND_MAP: {
                return this.initializeFactoryForMapMultibinding(binding);
            }
        }
        throw new AssertionError((Object)binding.toString());
    }

    private CodeBlock decorateForScope(CodeBlock factoryCreate, Scope scope) {
        return CodeBlock.of("$T.provider($L)", scope.equals(Scope.reusableScope(this.elements)) ? TypeNames.SINGLE_CHECK : TypeNames.DOUBLE_CHECK, factoryCreate);
    }

    private CodeBlock nullableAnnotation(Optional<DeclaredType> nullableType) {
        return nullableType.isPresent() ? CodeBlock.of("@$T ", TypeName.get((TypeMirror)nullableType.get())) : CodeBlock.of("", new Object[0]);
    }

    private CodeBlock initializeMembersInjectorForBinding(MembersInjectionBinding binding) {
        switch (binding.injectionStrategy()) {
            case NO_OP: {
                return CodeBlock.of("$T.noOp()", TypeNames.MEMBERS_INJECTORS);
            }
            case INJECT_MEMBERS: {
                return CodeBlock.of("$T.create($L)", SourceFiles.membersInjectorNameForType(binding.membersInjectedType()), CodeBlocks.makeParametersCodeBlock(this.getDependencyArguments(binding)));
            }
        }
        throw new AssertionError();
    }

    private ImmutableList<CodeBlock> getDependencyArguments(Binding binding) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (FrameworkDependency frameworkDependency : FrameworkDependency.frameworkDependenciesForBinding(binding)) {
            parameters.add((Object)this.getDependencyArgument(frameworkDependency));
        }
        return parameters.build();
    }

    private CodeBlock getDependencyArgument(FrameworkDependency frameworkDependency) {
        BindingKey requestedKey = frameworkDependency.bindingKey();
        ResolvedBindings resolvedBindings = (ResolvedBindings)this.graph.resolvedBindings().get((Object)requestedKey);
        if (resolvedBindings.frameworkClass().equals(Provider.class) && frameworkDependency.frameworkClass().equals(Producer.class)) {
            return this.producerFromProviderMemberSelects.get(requestedKey).getExpressionFor(this.name);
        }
        return this.getMemberSelectExpression(requestedKey);
    }

    private CodeBlock initializeFactoryForSetMultibinding(ContributionBinding binding) {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.", AbstractComponentWriter.setFactoryClassName(binding.bindingType(), binding.key()));
        boolean useRawTypes = this.useRawType(binding);
        if (!useRawTypes) {
            SetType setType = SetType.from(binding.key());
            builder.add("<$T>", setType.elementsAreTypeOf(Produced.class) ? setType.unwrappedElementType(Produced.class) : setType.elementType());
        }
        int individualProviders = 0;
        int setProviders = 0;
        CodeBlock.Builder builderMethodCalls = CodeBlock.builder();
        for (FrameworkDependency frameworkDependency : FrameworkDependency.frameworkDependenciesForBinding(binding)) {
            String methodName;
            ContributionType contributionType = ((ResolvedBindings)this.graph.resolvedBindings().get((Object)frameworkDependency.bindingKey())).contributionType();
            String methodNameSuffix = frameworkDependency.frameworkClass().getSimpleName();
            switch (contributionType) {
                case SET: {
                    ++individualProviders;
                    String string = String.valueOf(methodNameSuffix);
                    methodName = string.length() != 0 ? "add".concat(string) : new String("add");
                    break;
                }
                case SET_VALUES: {
                    ++setProviders;
                    String string = String.valueOf(methodNameSuffix);
                    methodName = string.length() != 0 ? "addCollection".concat(string) : new String("addCollection");
                    break;
                }
                default: {
                    String string = String.valueOf(frameworkDependency);
                    throw new AssertionError((Object)new StringBuilder(26 + String.valueOf(string).length()).append(string).append(" is not a set multibinding").toString());
                }
            }
            builderMethodCalls.add(".$L($L)", methodName, this.potentiallyCast(useRawTypes, frameworkDependency.frameworkClass(), this.getDependencyArgument(frameworkDependency)));
        }
        builder.add("builder($L, $L)", individualProviders, setProviders);
        builder.add(builderMethodCalls.build());
        return builder.add(".build()", new Object[0]).build();
    }

    private CodeBlock initializeFactoryForMapMultibinding(ContributionBinding binding) {
        ImmutableSet<FrameworkDependency> frameworkDependencies = FrameworkDependency.frameworkDependenciesForBinding(binding);
        ImmutableList.Builder codeBlocks = ImmutableList.builder();
        MapType mapType = MapType.from(binding.key().type());
        CodeBlock.Builder builderCall = CodeBlock.builder().add("$T.", AbstractComponentWriter.frameworkMapFactoryClassName(binding.bindingType()));
        boolean useRawTypes = this.useRawType(binding);
        if (!useRawTypes) {
            builderCall.add("<$T, $T>", TypeName.get(mapType.keyType()), TypeName.get(mapType.unwrappedValueType(binding.bindingType().frameworkClass())));
        }
        builderCall.add("builder($L)", frameworkDependencies.size());
        codeBlocks.add((Object)builderCall.build());
        for (FrameworkDependency frameworkDependency : frameworkDependencies) {
            BindingKey bindingKey = frameworkDependency.bindingKey();
            ContributionBinding contributionBinding = ((ResolvedBindings)this.graph.resolvedBindings().get((Object)bindingKey)).contributionBinding();
            CodeBlock value = this.potentiallyCast(useRawTypes, frameworkDependency.frameworkClass(), this.getDependencyArgument(frameworkDependency));
            if (binding.bindingType().frameworkClass().equals(Producer.class) && frameworkDependency.frameworkClass().equals(Provider.class)) {
                value = CodeBlock.of("$T.producerFromProvider($L)", TypeNames.PRODUCERS, value);
            }
            codeBlocks.add((Object)CodeBlock.of(".put($L, $L)", MapKeys.getMapKeyExpression((AnnotationMirror)contributionBinding.mapKey().get()), value));
        }
        codeBlocks.add((Object)CodeBlock.of(".build()", new Object[0]));
        return CodeBlocks.concat((Iterable<CodeBlock>)codeBlocks.build());
    }

    private CodeBlock potentiallyCast(boolean shouldCast, Class<?> classToCast, CodeBlock notCasted) {
        if (!shouldCast) {
            return notCasted;
        }
        return CodeBlock.of("($T) $L", classToCast, notCasted);
    }

    private static String simpleVariableName(TypeElement typeElement) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, typeElement.getSimpleName().toString());
    }

    static enum InitializationState {
        UNINITIALIZED,
        DELEGATED,
        INITIALIZED;

    }
}

