/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dagger.internal.codegen.AutoValue_MethodSignature;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

abstract class MethodSignature {
    MethodSignature() {
    }

    abstract String name();

    abstract ImmutableList<Equivalence.Wrapper<TypeMirror>> parameterTypes();

    abstract ImmutableList<Equivalence.Wrapper<TypeMirror>> thrownTypes();

    static MethodSignature fromExecutableType(String methodName, ExecutableType methodType) {
        Preconditions.checkNotNull((Object)methodType);
        ImmutableList.Builder parameters = ImmutableList.builder();
        ImmutableList.Builder thrownTypes = ImmutableList.builder();
        for (TypeMirror typeMirror : methodType.getParameterTypes()) {
            parameters.add((Object)MoreTypes.equivalence().wrap((Object)typeMirror));
        }
        for (TypeMirror typeMirror : methodType.getThrownTypes()) {
            thrownTypes.add((Object)MoreTypes.equivalence().wrap((Object)typeMirror));
        }
        return new AutoValue_MethodSignature(methodName, (ImmutableList<Equivalence.Wrapper<TypeMirror>>)parameters.build(), (ImmutableList<Equivalence.Wrapper<TypeMirror>>)thrownTypes.build());
    }
}

