/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.producers.Producer;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class ProducerFactoryGenerator
extends SourceFileGenerator<ProductionBinding> {
    private final CompilerOptions compilerOptions;

    ProducerFactoryGenerator(Filer filer, Elements elements, CompilerOptions compilerOptions) {
        super(filer, elements);
        this.compilerOptions = compilerOptions;
    }

    @Override
    ClassName nameGeneratedType(ProductionBinding binding) {
        return SourceFiles.generatedClassNameForBinding(binding);
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(ProductionBinding binding) {
        return Optional.of((Object)binding.bindingElement());
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName generatedTypeName, ProductionBinding binding) {
        TypeName providedTypeName = TypeName.get(binding.factoryType());
        ParameterizedTypeName futureTypeName = TypeNames.listenableFutureOf(providedTypeName);
        TypeSpec.Builder factoryBuilder = TypeSpec.classBuilder(generatedTypeName).addModifiers(Modifier.PUBLIC, Modifier.FINAL).superclass(TypeNames.abstractProducerOf(providedTypeName));
        ImmutableMap<BindingKey, FrameworkField> fields = SourceFiles.generateBindingFieldsForDependencies(binding);
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addStatement("super($L, $L)", ((FrameworkField)fields.get((Object)((DependencyRequest)binding.monitorRequest().get()).bindingKey())).name(), this.producerTokenConstruction(generatedTypeName, binding));
        if (!binding.bindingElement().getModifiers().contains((Object)Modifier.STATIC)) {
            TypeName moduleType = TypeName.get(binding.bindingTypeElement().asType());
            ProducerFactoryGenerator.addFieldAndConstructorParameter(factoryBuilder, constructorBuilder, "module", moduleType);
        }
        for (FrameworkField bindingField : fields.values()) {
            ProducerFactoryGenerator.addFieldAndConstructorParameter(factoryBuilder, constructorBuilder, bindingField.name(), bindingField.type());
        }
        MethodSpec.Builder computeMethodBuilder = MethodSpec.methodBuilder("compute").returns(futureTypeName).addAnnotation(Override.class).addModifiers(Modifier.PROTECTED);
        ImmutableList<DependencyRequest> asyncDependencies = ProducerFactoryGenerator.asyncDependencies(binding);
        for (DependencyRequest dependency : asyncDependencies) {
            ParameterizedTypeName futureType = TypeNames.listenableFutureOf(ProducerFactoryGenerator.asyncDependencyType(dependency));
            CodeBlock futureAccess = CodeBlock.of("$L.get()", ((FrameworkField)fields.get((Object)dependency.bindingKey())).name());
            computeMethodBuilder.addStatement("$T $L = $L", futureType, ProducerFactoryGenerator.dependencyFutureName(dependency), dependency.kind().equals((Object)DependencyRequest.Kind.PRODUCED) ? CodeBlock.of("$T.createFutureProduced($L)", TypeNames.PRODUCERS, futureAccess) : futureAccess);
        }
        FutureTransform futureTransform = FutureTransform.create(fields, binding, asyncDependencies);
        computeMethodBuilder.addStatement("return $T.transformAsync($L, this, executorProvider.get())", TypeNames.FUTURES, futureTransform.futureCodeBlock());
        factoryBuilder.addSuperinterface(ParameterizedTypeName.get(TypeNames.ASYNC_FUNCTION, futureTransform.applyArgType(), providedTypeName));
        MethodSpec.Builder applyMethodBuilder = MethodSpec.methodBuilder("apply").returns(futureTypeName).addJavadoc("@deprecated this may only be called from the internal {@link #compute()}", new Object[0]).addAnnotation(Deprecated.class).addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addParameter(futureTransform.applyArgType(), futureTransform.applyArgName(), new Modifier[0]).addExceptions((Iterable<? extends TypeName>)this.getThrownTypeNames((Iterable<? extends TypeMirror>)binding.thrownTypes())).addStatement("assert monitor != null : $S", "apply() may only be called internally from compute(); if it's called explicitly, the monitor might be null").addCode(this.getInvocationCodeBlock(generatedTypeName, binding, providedTypeName, futureTransform.parameterCodeBlocks()));
        if (futureTransform.hasUncheckedCast()) {
            applyMethodBuilder.addAnnotation(AnnotationSpecs.SUPPRESS_WARNINGS_UNCHECKED);
        }
        factoryBuilder.addMethod(constructorBuilder.build());
        factoryBuilder.addMethod(computeMethodBuilder.build());
        factoryBuilder.addMethod(applyMethodBuilder.build());
        return Optional.of((Object)factoryBuilder);
    }

    private static void addFieldAndConstructorParameter(TypeSpec.Builder typeBuilder, MethodSpec.Builder constructorBuilder, String variableName, TypeName variableType) {
        typeBuilder.addField(variableType, variableName, Modifier.PRIVATE, Modifier.FINAL);
        constructorBuilder.addParameter(variableType, variableName, new Modifier[0]).addStatement("assert $L != null", variableName).addStatement("this.$1L = $1L", variableName);
    }

    private static ImmutableList<DependencyRequest> asyncDependencies(Binding binding) {
        final ImmutableMap<DependencyRequest, FrameworkDependency> frameworkDependencies = FrameworkDependency.indexByDependencyRequest(FrameworkDependency.frameworkDependenciesForBinding(binding));
        return FluentIterable.from(binding.implicitDependencies()).filter((Predicate)new Predicate<DependencyRequest>(){

            public boolean apply(DependencyRequest dependency) {
                return ProducerFactoryGenerator.isAsyncDependency(dependency) && ((FrameworkDependency)frameworkDependencies.get((Object)dependency)).frameworkClass().equals(Producer.class);
            }
        }).toList();
    }

    private CodeBlock producerTokenConstruction(ClassName generatedTypeName, ProductionBinding binding) {
        CodeBlock producerTokenArgs = this.compilerOptions.writeProducerNameInToken() ? CodeBlock.of("$S", String.format("%s#%s", ClassName.get(binding.bindingTypeElement()), binding.bindingElement().getSimpleName())) : CodeBlock.of("$T.class", generatedTypeName);
        return CodeBlock.of("$T.create($L)", TypeNames.PRODUCER_TOKEN, producerTokenArgs);
    }

    private static String dependencyFutureName(DependencyRequest dependency) {
        String string = String.valueOf(dependency.requestElement().getSimpleName());
        return new StringBuilder(6 + String.valueOf(string).length()).append(string).append("Future").toString();
    }

    private static boolean isAsyncDependency(DependencyRequest dependency) {
        switch (dependency.kind()) {
            case INSTANCE: 
            case PRODUCED: {
                return true;
            }
        }
        return false;
    }

    private static TypeName asyncDependencyType(DependencyRequest dependency) {
        TypeName keyName = TypeName.get(dependency.key().type());
        switch (dependency.kind()) {
            case INSTANCE: {
                return keyName;
            }
            case PRODUCED: {
                return TypeNames.producedOf(keyName);
            }
        }
        throw new AssertionError();
    }

    private static ImmutableList<CodeBlock> getParameterCodeBlocks(ProductionBinding binding, ImmutableMap<BindingKey, FrameworkField> fields, String listArgName) {
        int argIndex = 0;
        ImmutableList.Builder codeBlocks = ImmutableList.builder();
        for (DependencyRequest dependency : binding.dependencies()) {
            if (ProducerFactoryGenerator.isAsyncDependency(dependency)) {
                codeBlocks.add((Object)CodeBlock.of("($T) $L.get($L)", ProducerFactoryGenerator.asyncDependencyType(dependency), listArgName, argIndex));
                ++argIndex;
                continue;
            }
            codeBlocks.add((Object)SourceFiles.frameworkTypeUsageStatement(CodeBlock.of("$L", ((FrameworkField)fields.get((Object)dependency.bindingKey())).name()), dependency.kind()));
        }
        return codeBlocks.build();
    }

    private CodeBlock getInvocationCodeBlock(ClassName generatedTypeName, ProductionBinding binding, TypeName providedTypeName, ImmutableList<CodeBlock> parameterCodeBlocks) {
        CodeBlock moduleCodeBlock = CodeBlock.of("$L.$L($L)", binding.bindingElement().getModifiers().contains((Object)Modifier.STATIC) ? CodeBlock.of("$T", ClassName.get(binding.bindingTypeElement())) : CodeBlock.of("$T.this.module", generatedTypeName), binding.bindingElement().getSimpleName(), CodeBlocks.makeParametersCodeBlock(parameterCodeBlocks));
        ImmutableList.Builder codeBlocks = ImmutableList.builder();
        codeBlocks.add((Object)CodeBlock.of("monitor.methodStarting();", new Object[0]));
        CodeBlock returnCodeBlock = binding.bindingKind().equals((Object)ContributionBinding.Kind.FUTURE_PRODUCTION) ? moduleCodeBlock : CodeBlock.of("$T.<$T>immediateFuture($L)", TypeNames.FUTURES, providedTypeName, moduleCodeBlock);
        return CodeBlock.of(Joiner.on((char)'\n').join((Object)"monitor.methodStarting();", (Object)"try {", new Object[]{"  return $L;", "} finally {", "  monitor.methodFinished();", "}"}), returnCodeBlock);
    }

    private FluentIterable<? extends TypeName> getThrownTypeNames(Iterable<? extends TypeMirror> thrownTypes) {
        return FluentIterable.from(thrownTypes).transform((Function)new Function<TypeMirror, TypeName>(){

            public TypeName apply(TypeMirror type) {
                return TypeName.get(type);
            }
        });
    }

    static final class MultiArgFutureTransform
    extends FutureTransform {
        private final ImmutableList<DependencyRequest> asyncDependencies;

        MultiArgFutureTransform(ImmutableMap<BindingKey, FrameworkField> fields, ProductionBinding binding, ImmutableList<DependencyRequest> asyncDependencies) {
            super(fields, binding);
            this.asyncDependencies = asyncDependencies;
        }

        @Override
        CodeBlock futureCodeBlock() {
            return CodeBlock.of("$T.<$T>allAsList($L)", TypeNames.FUTURES, ClassName.OBJECT, CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)FluentIterable.from(this.asyncDependencies).transform((Function)new Function<DependencyRequest, CodeBlock>(){

                public CodeBlock apply(DependencyRequest dependency) {
                    return CodeBlock.of("$L", ProducerFactoryGenerator.dependencyFutureName(dependency));
                }
            })));
        }

        @Override
        TypeName applyArgType() {
            return TypeNames.listOf(ClassName.OBJECT);
        }

        @Override
        String applyArgName() {
            return "args";
        }

        @Override
        ImmutableList<CodeBlock> parameterCodeBlocks() {
            return ProducerFactoryGenerator.getParameterCodeBlocks(this.binding, (ImmutableMap<BindingKey, FrameworkField>)this.fields, this.applyArgName());
        }

        @Override
        boolean hasUncheckedCast() {
            return true;
        }
    }

    static final class SingleArgFutureTransform
    extends FutureTransform {
        private final DependencyRequest asyncDependency;

        SingleArgFutureTransform(ImmutableMap<BindingKey, FrameworkField> fields, ProductionBinding binding, DependencyRequest asyncDependency) {
            super(fields, binding);
            this.asyncDependency = asyncDependency;
        }

        @Override
        CodeBlock futureCodeBlock() {
            return CodeBlock.of("$L", ProducerFactoryGenerator.dependencyFutureName(this.asyncDependency));
        }

        @Override
        TypeName applyArgType() {
            return ProducerFactoryGenerator.asyncDependencyType(this.asyncDependency);
        }

        @Override
        String applyArgName() {
            return this.asyncDependency.requestElement().getSimpleName().toString();
        }

        @Override
        ImmutableList<CodeBlock> parameterCodeBlocks() {
            ImmutableList.Builder parameterCodeBlocks = ImmutableList.builder();
            for (DependencyRequest dependency : this.binding.dependencies()) {
                if (dependency == this.asyncDependency) {
                    parameterCodeBlocks.add((Object)CodeBlock.of("$L", this.applyArgName()));
                    continue;
                }
                parameterCodeBlocks.add((Object)SourceFiles.frameworkTypeUsageStatement(CodeBlock.of("$L", ((FrameworkField)this.fields.get((Object)dependency.bindingKey())).name()), dependency.kind()));
            }
            return parameterCodeBlocks.build();
        }
    }

    static final class NoArgFutureTransform
    extends FutureTransform {
        NoArgFutureTransform(ImmutableMap<BindingKey, FrameworkField> fields, ProductionBinding binding) {
            super(fields, binding);
        }

        @Override
        CodeBlock futureCodeBlock() {
            return CodeBlock.of("$T.<$T>immediateFuture(null)", TypeNames.FUTURES, TypeNames.VOID_CLASS);
        }

        @Override
        TypeName applyArgType() {
            return TypeNames.VOID_CLASS;
        }

        @Override
        String applyArgName() {
            return "ignoredVoidArg";
        }

        @Override
        ImmutableList<CodeBlock> parameterCodeBlocks() {
            ImmutableList.Builder parameterCodeBlocks = ImmutableList.builder();
            for (DependencyRequest dependency : this.binding.dependencies()) {
                parameterCodeBlocks.add((Object)SourceFiles.frameworkTypeUsageStatement(CodeBlock.of("$L", ((FrameworkField)this.fields.get((Object)dependency.bindingKey())).name()), dependency.kind()));
            }
            return parameterCodeBlocks.build();
        }
    }

    static abstract class FutureTransform {
        protected final ImmutableMap<BindingKey, FrameworkField> fields;
        protected final ProductionBinding binding;

        FutureTransform(ImmutableMap<BindingKey, FrameworkField> fields, ProductionBinding binding) {
            this.fields = fields;
            this.binding = binding;
        }

        abstract CodeBlock futureCodeBlock();

        abstract TypeName applyArgType();

        abstract String applyArgName();

        abstract ImmutableList<CodeBlock> parameterCodeBlocks();

        boolean hasUncheckedCast() {
            return false;
        }

        static FutureTransform create(ImmutableMap<BindingKey, FrameworkField> fields, ProductionBinding binding, ImmutableList<DependencyRequest> asyncDependencies) {
            if (asyncDependencies.isEmpty()) {
                return new NoArgFutureTransform(fields, binding);
            }
            if (asyncDependencies.size() == 1) {
                return new SingleArgFutureTransform(fields, binding, (DependencyRequest)Iterables.getOnlyElement(asyncDependencies));
            }
            return new MultiArgFutureTransform(fields, binding, asyncDependencies);
        }
    }
}

