/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.operation.MapReplicationOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.util.Clock;
import java.util.Iterator;

class MapMigrationAwareService
implements MigrationAwareService {
    protected final MapServiceContext mapServiceContext;
    protected final SerializationService serializationService;

    MapMigrationAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.serializationService = mapServiceContext.getNodeEngine().getSerializationService();
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(event.getPartitionId());
        MapReplicationOperation operation = new MapReplicationOperation(this.mapServiceContext.getService(), container, event.getPartitionId(), event.getReplicaIndex());
        operation.setService(this.mapServiceContext.getService());
        return operation;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        this.migrateIndex(event);
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.mapServiceContext.clearPartitionData(event.getPartitionId());
        }
        this.mapServiceContext.reloadOwnedPartitions();
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.mapServiceContext.clearPartitionData(event.getPartitionId());
        }
        this.mapServiceContext.reloadOwnedPartitions();
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.mapServiceContext.clearPartitionData(partitionId);
    }

    protected void migrateIndex(PartitionMigrationEvent event) {
        long now = this.getNow();
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(event.getPartitionId());
        for (RecordStore recordStore : container.getMaps().values()) {
            MapContainer mapContainer = this.mapServiceContext.getMapContainer(recordStore.getName());
            Indexes indexes = mapContainer.getIndexes();
            if (!indexes.hasIndex()) continue;
            Iterator<Record> iterator = recordStore.iterator(now, false);
            while (iterator.hasNext()) {
                Object value;
                Record record = iterator.next();
                Data key = record.getKey();
                if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
                    value = Records.getValueOrCachedValue(record, this.serializationService);
                    indexes.removeEntryIndex(key, value);
                    continue;
                }
                value = Records.getValueOrCachedValue(record, this.serializationService);
                if (value == null) continue;
                QueryableEntry queryEntry = mapContainer.newQueryEntry(record.getKey(), value);
                indexes.saveEntryIndex(queryEntry, null);
            }
        }
    }

    protected long getNow() {
        return Clock.currentTimeMillis();
    }
}

