/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.annotations.NonNull;
import com.android.builder.model.ClassField;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Set;

public final class ClassFieldImpl
implements ClassField,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String type;
    @NonNull
    private final String name;
    @NonNull
    private final String value;
    @NonNull
    private final Set<String> annotations;
    @NonNull
    private final String documentation;

    public ClassFieldImpl(@NonNull String type, @NonNull String name, @NonNull String value) {
        this(type, name, value, (Set<String>)ImmutableSet.of(), "");
    }

    public ClassFieldImpl(@NonNull String type, @NonNull String name, @NonNull String value, @NonNull Set<String> annotations, @NonNull String documentation) {
        if (type == null || name == null || value == null || annotations == null || documentation == null) {
            throw new NullPointerException("Build Config field cannot have a null parameter");
        }
        this.type = type;
        this.name = name;
        this.value = value;
        this.annotations = ImmutableSet.copyOf(annotations);
        this.documentation = documentation;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    @NonNull
    public String getDocumentation() {
        return this.documentation;
    }

    @NonNull
    public Set<String> getAnnotations() {
        return this.annotations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassFieldImpl that = (ClassFieldImpl)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.value.equals(that.value)) {
            return false;
        }
        if (!((Object)this.annotations).equals(that.annotations)) {
            return false;
        }
        return this.documentation.equals(that.documentation);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + ((Object)this.annotations).hashCode();
        result = 31 * result + this.documentation.hashCode();
        return result;
    }
}

