/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.testing;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ddmlib.testrunner.XmlTestRunListener;
import com.android.utils.ILogger;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.kxml2.io.KXmlSerializer;

public class CustomTestRunListener
extends XmlTestRunListener {
    @NonNull
    private final String mDeviceName;
    @NonNull
    private final String mProjectName;
    @NonNull
    private final String mFlavorName;
    private final ILogger mLogger;
    private final Set<TestIdentifier> mFailedTests = Sets.newHashSet();

    public CustomTestRunListener(@NonNull String deviceName, @NonNull String projectName, @NonNull String flavorName, @Nullable ILogger logger) {
        this.mDeviceName = deviceName;
        this.mProjectName = projectName;
        this.mFlavorName = flavorName;
        this.mLogger = logger;
    }

    protected File getResultFile(File reportDir) throws IOException {
        return new File(reportDir, "TEST-" + this.mDeviceName + "-" + this.mProjectName + "-" + this.mFlavorName + ".xml");
    }

    protected String getTestSuiteName() {
        Map testResults = this.getRunResult().getTestResults();
        if (testResults.isEmpty()) {
            return null;
        }
        Map.Entry testEntry = testResults.entrySet().iterator().next();
        return ((TestIdentifier)testEntry.getKey()).getClassName();
    }

    protected void setPropertiesAttributes(KXmlSerializer serializer, String namespace) throws IOException {
        super.setPropertiesAttributes(serializer, namespace);
        serializer.attribute(null, "device", this.mDeviceName);
        serializer.attribute(null, "flavor", this.mFlavorName);
        serializer.attribute(null, "project", this.mProjectName);
    }

    public void testRunStarted(String runName, int testCount) {
        if (this.mLogger != null) {
            this.mLogger.info(String.format("Starting %1$d tests on %2$s", testCount, this.mDeviceName), new Object[0]);
        }
        super.testRunStarted(runName, testCount);
    }

    public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
        if (this.mLogger != null) {
            this.mLogger.warning(String.format("\n%1$s > %2$s[%3$s] \u001b[31mFAILED \u001b[0m", test.getClassName(), test.getTestName(), this.mDeviceName), new Object[0]);
            this.mLogger.warning(this.getModifiedTrace(trace), new Object[0]);
        }
        this.mFailedTests.add(test);
        super.testFailed(ITestRunListener.TestFailure.FAILURE, test, trace);
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        if (!this.mFailedTests.remove(test) && this.mLogger != null) {
            this.mLogger.info(String.format("\n%1$s > %2$s[%3$s] \u001b[32mSUCCESS \u001b[0m", test.getClassName(), test.getTestName(), this.mDeviceName), new Object[0]);
        }
        super.testEnded(test, testMetrics);
    }

    public void testRunFailed(String errorMessage) {
        if (this.mLogger != null) {
            this.mLogger.warning("Tests on %1$s failed: %2$s", new Object[]{this.mDeviceName, errorMessage});
        }
        super.testRunFailed(errorMessage);
    }

    private String getModifiedTrace(String trace) {
        String[] lines = trace.split("\n");
        if (lines.length < 2) {
            return trace;
        }
        return "\t" + lines[0] + "\n\t" + lines[1];
    }
}

