/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v1;

import com.android.apksig.ApkVerifier;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.jar.ManifestParser;
import com.android.apksig.internal.util.InclusiveIntRange;
import com.android.apksig.internal.util.MessageDigestSink;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.internal.zip.LocalFileRecord;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipFormatException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;

public abstract class V1SchemeVerifier {
    private static final String MANIFEST_ENTRY_NAME = "META-INF/MANIFEST.MF";
    private static final String[] JB_MR2_AND_NEWER_DIGEST_ALGS = new String[]{"SHA-512", "SHA-384", "SHA-256", "SHA-1"};
    private static final Map<String, String> UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL = new HashMap<String, String>(8);
    private static final Map<String, Integer> MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST;

    private V1SchemeVerifier() {
    }

    public static Result verify(DataSource dataSource, ApkUtils.ZipSections zipSections, Map<Integer, String> map, Set<Integer> set, int n, int n2) throws IOException, ZipFormatException, NoSuchAlgorithmException {
        if (n > n2) {
            throw new IllegalArgumentException("minSdkVersion (" + n + ") > maxSdkVersion (" + n2 + ")");
        }
        Result result = new Result();
        List<CentralDirectoryRecord> list = V1SchemeVerifier.parseZipCentralDirectory(dataSource, zipSections);
        Set<String> set2 = V1SchemeVerifier.checkForDuplicateEntries(list, result);
        if (result.containsErrors()) {
            return result;
        }
        Signers.verify(dataSource, zipSections.getZipCentralDirectoryOffset(), list, set2, map, set, n, n2, result);
        return result;
    }

    private static Set<String> checkForDuplicateEntries(List<CentralDirectoryRecord> list, Result result) {
        HashSet<String> hashSet = new HashSet<String>(list.size());
        HashSet<String> hashSet2 = null;
        for (CentralDirectoryRecord centralDirectoryRecord : list) {
            String string = centralDirectoryRecord.getName();
            if (hashSet.add(string)) continue;
            if (hashSet2 == null) {
                hashSet2 = new HashSet<String>();
            }
            if (!hashSet2.add(string)) continue;
            result.addError(ApkVerifier.Issue.JAR_SIG_DUPLICATE_ZIP_ENTRY, new Object[]{string});
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<NamedDigest> getDigestsToVerify(ManifestParser.Section section, String string, int n, int n2) {
        String string2;
        Base64.Decoder decoder = Base64.getDecoder();
        ArrayList<NamedDigest> arrayList = new ArrayList<NamedDigest>(1);
        if (n < 18) {
            void var6_8;
            String object = section.getAttributeValue("Digest-Algorithms");
            if (object == null) {
                String string3 = "SHA SHA1";
            }
            StringTokenizer stringTokenizer = new StringTokenizer((String)var6_8);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                String string5 = string4 + string;
                string2 = section.getAttributeValue(string5);
                if (string2 == null || (string4 = V1SchemeVerifier.getCanonicalJcaMessageDigestAlgorithm(string4)) == null || V1SchemeVerifier.getMinSdkVersionFromWhichSupportedInManifestOrSignatureFile(string4) > n) continue;
                arrayList.add(new NamedDigest(string4, decoder.decode(string2)));
                break;
            }
            if (arrayList.isEmpty()) {
                return arrayList;
            }
        }
        if (n2 >= 18) {
            for (String string5 : JB_MR2_AND_NEWER_DIGEST_ALGS) {
                string2 = V1SchemeVerifier.getJarDigestAttributeName(string5, string);
                String string6 = section.getAttributeValue(string2);
                if (string6 == null) continue;
                byte[] byArray = decoder.decode(string6);
                byte[] byArray2 = V1SchemeVerifier.getDigest(arrayList, string5);
                if (byArray2 != null && Arrays.equals(byArray2, byArray)) break;
                arrayList.add(new NamedDigest(string5, byArray));
                break;
            }
        }
        return arrayList;
    }

    private static String getCanonicalJcaMessageDigestAlgorithm(String string) {
        return UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.get(string.toUpperCase(Locale.US));
    }

    public static int getMinSdkVersionFromWhichSupportedInManifestOrSignatureFile(String string) {
        Integer n = MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.get(string.toUpperCase(Locale.US));
        return n != null ? n : Integer.MAX_VALUE;
    }

    private static String getJarDigestAttributeName(String string, String string2) {
        if ("SHA-1".equalsIgnoreCase(string)) {
            return "SHA1" + string2;
        }
        return string + string2;
    }

    private static byte[] getDigest(Collection<NamedDigest> collection, String string) {
        for (NamedDigest namedDigest : collection) {
            if (!namedDigest.jcaDigestAlgorithm.equalsIgnoreCase(string)) continue;
            return namedDigest.digest;
        }
        return null;
    }

    private static List<CentralDirectoryRecord> parseZipCentralDirectory(DataSource dataSource, ApkUtils.ZipSections zipSections) throws IOException, ZipFormatException {
        long l = zipSections.getZipCentralDirectorySizeBytes();
        if (l > Integer.MAX_VALUE) {
            throw new ZipFormatException("ZIP Central Directory too large: " + l);
        }
        long l2 = zipSections.getZipCentralDirectoryOffset();
        ByteBuffer byteBuffer = dataSource.getByteBuffer(l2, (int)l);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = zipSections.getZipCentralDirectoryRecordCount();
        ArrayList<CentralDirectoryRecord> arrayList = new ArrayList<CentralDirectoryRecord>(n);
        for (int i = 0; i < n; ++i) {
            CentralDirectoryRecord centralDirectoryRecord;
            int n2 = byteBuffer.position();
            try {
                centralDirectoryRecord = CentralDirectoryRecord.getRecord(byteBuffer);
            }
            catch (ZipFormatException zipFormatException) {
                throw new ZipFormatException("Failed to parse Central Directory record #" + (i + 1) + " at file offset " + (l2 + (long)n2), zipFormatException);
            }
            String string = centralDirectoryRecord.getName();
            if (string.endsWith("/")) continue;
            arrayList.add(centralDirectoryRecord);
        }
        return arrayList;
    }

    private static boolean isJarEntryDigestNeededInManifest(String string) {
        if (string.startsWith("META-INF/")) {
            return false;
        }
        return !string.endsWith("/");
    }

    private static Set<Signer> verifyJarEntriesAgainstManifestAndSigners(DataSource dataSource, long l, Collection<CentralDirectoryRecord> collection, Map<String, ManifestParser.Section> map, List<Signer> list, int n, int n2, Result result) throws ZipFormatException, IOException, NoSuchAlgorithmException {
        ArrayList<CentralDirectoryRecord> arrayList = new ArrayList<CentralDirectoryRecord>(collection);
        Collections.sort(arrayList, CentralDirectoryRecord.BY_LOCAL_FILE_HEADER_OFFSET_COMPARATOR);
        HashSet<String> hashSet = new HashSet<String>(map.keySet());
        ArrayList<Signer> arrayList2 = null;
        String string = null;
        for (CentralDirectoryRecord centralDirectoryRecord : arrayList) {
            NamedDigest namedDigest;
            String string2 = centralDirectoryRecord.getName();
            hashSet.remove(string2);
            if (!V1SchemeVerifier.isJarEntryDigestNeededInManifest(string2)) continue;
            ManifestParser.Section section = map.get(string2);
            if (section == null) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_MANIFEST, new Object[]{string2});
                continue;
            }
            ArrayList<Signer> arrayList3 = new ArrayList<Signer>(list.size());
            for (Signer signer : list) {
                if (!signer.getSigFileEntryNames().contains(string2)) continue;
                arrayList3.add(signer);
            }
            if (arrayList3.isEmpty()) {
                result.addError(ApkVerifier.Issue.JAR_SIG_ZIP_ENTRY_NOT_SIGNED, new Object[]{string2});
                continue;
            }
            if (arrayList2 == null) {
                arrayList2 = arrayList3;
                string = string2;
            } else if (!arrayList3.equals(arrayList2)) {
                result.addError(ApkVerifier.Issue.JAR_SIG_ZIP_ENTRY_SIGNERS_MISMATCH, new Object[]{string, V1SchemeVerifier.getSignerNames(arrayList2), string2, V1SchemeVerifier.getSignerNames(arrayList3)});
                continue;
            }
            Collection<NamedDigest> collection2 = V1SchemeVerifier.getDigestsToVerify(section, "-Digest", n, n2);
            if (collection2.isEmpty()) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_MANIFEST, new Object[]{string2});
                continue;
            }
            MessageDigest[] messageDigestArray = new MessageDigest[collection2.size()];
            int n3 = 0;
            Iterator iOException = collection2.iterator();
            while (iOException.hasNext()) {
                namedDigest = (NamedDigest)iOException.next();
                messageDigestArray[n3] = V1SchemeVerifier.getMessageDigest(namedDigest.jcaDigestAlgorithm);
                ++n3;
            }
            try {
                LocalFileRecord.outputUncompressedData(dataSource, centralDirectoryRecord, l, new MessageDigestSink(messageDigestArray));
            }
            catch (ZipFormatException zipFormatException) {
                throw new ZipFormatException("Malformed entry: " + string2, zipFormatException);
            }
            catch (IOException iOException2) {
                throw new IOException("Failed to read entry: " + string2, iOException2);
            }
            n3 = 0;
            iOException = collection2.iterator();
            while (iOException.hasNext()) {
                namedDigest = (NamedDigest)iOException.next();
                byte[] byArray = messageDigestArray[n3].digest();
                if (Arrays.equals(namedDigest.digest, byArray)) continue;
                result.addError(ApkVerifier.Issue.JAR_SIG_ZIP_ENTRY_DIGEST_DID_NOT_VERIFY, new Object[]{string2, namedDigest.jcaDigestAlgorithm, MANIFEST_ENTRY_NAME, Base64.getEncoder().encodeToString(byArray), Base64.getEncoder().encodeToString(namedDigest.digest)});
            }
        }
        if (arrayList2 == null) {
            result.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNED_ZIP_ENTRIES, new Object[0]);
            return Collections.emptySet();
        }
        return new HashSet<Signer>(arrayList2);
    }

    private static List<String> getSignerNames(List<Signer> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Signer signer : list) {
            arrayList.add(signer.getName());
        }
        return arrayList;
    }

    private static MessageDigest getMessageDigest(String string) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(string);
    }

    private static byte[] digest(String string, byte[] byArray, int n, int n2) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = V1SchemeVerifier.getMessageDigest(string);
        messageDigest.update(byArray, n, n2);
        return messageDigest.digest();
    }

    private static byte[] digest(String string, byte[] byArray) throws NoSuchAlgorithmException {
        return V1SchemeVerifier.getMessageDigest(string).digest(byArray);
    }

    static {
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("MD5", "MD5");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA", "SHA-1");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA1", "SHA-1");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA-1", "SHA-1");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA-256", "SHA-256");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA-384", "SHA-384");
        UPPER_CASE_JCA_DIGEST_ALG_TO_CANONICAL.put("SHA-512", "SHA-512");
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST = new HashMap<String, Integer>(5);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("MD5", 0);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("SHA-1", 0);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("SHA-256", 0);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("SHA-384", 9);
        MIN_SDK_VESION_FROM_WHICH_DIGEST_SUPPORTED_IN_MANIFEST.put("SHA-512", 9);
    }

    public static class Result {
        public boolean verified;
        public final List<SignerInfo> signers = new ArrayList<SignerInfo>();
        public final List<SignerInfo> ignoredSigners = new ArrayList<SignerInfo>();
        private final List<ApkVerifier.IssueWithParams> mWarnings = new ArrayList<ApkVerifier.IssueWithParams>();
        private final List<ApkVerifier.IssueWithParams> mErrors = new ArrayList<ApkVerifier.IssueWithParams>();

        private boolean containsErrors() {
            if (!this.mErrors.isEmpty()) {
                return true;
            }
            for (SignerInfo signerInfo : this.signers) {
                if (!signerInfo.containsErrors()) continue;
                return true;
            }
            return false;
        }

        private void addError(ApkVerifier.Issue issue, Object ... objectArray) {
            this.mErrors.add(new ApkVerifier.IssueWithParams(issue, objectArray));
        }

        private void addWarning(ApkVerifier.Issue issue, Object ... objectArray) {
            this.mWarnings.add(new ApkVerifier.IssueWithParams(issue, objectArray));
        }

        public List<ApkVerifier.IssueWithParams> getErrors() {
            return this.mErrors;
        }

        public List<ApkVerifier.IssueWithParams> getWarnings() {
            return this.mWarnings;
        }

        public static class SignerInfo {
            public final String name;
            public final String signatureFileName;
            public final String signatureBlockFileName;
            public final List<X509Certificate> certChain = new ArrayList<X509Certificate>();
            private final List<ApkVerifier.IssueWithParams> mWarnings = new ArrayList<ApkVerifier.IssueWithParams>();
            private final List<ApkVerifier.IssueWithParams> mErrors = new ArrayList<ApkVerifier.IssueWithParams>();

            private SignerInfo(String string, String string2, String string3) {
                this.name = string;
                this.signatureBlockFileName = string2;
                this.signatureFileName = string3;
            }

            private boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            private void addError(ApkVerifier.Issue issue, Object ... objectArray) {
                this.mErrors.add(new ApkVerifier.IssueWithParams(issue, objectArray));
            }

            private void addWarning(ApkVerifier.Issue issue, Object ... objectArray) {
                this.mWarnings.add(new ApkVerifier.IssueWithParams(issue, objectArray));
            }

            public List<ApkVerifier.IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<ApkVerifier.IssueWithParams> getWarnings() {
                return this.mWarnings;
            }
        }
    }

    private static class NamedDigest {
        private final String jcaDigestAlgorithm;
        private final byte[] digest;

        private NamedDigest(String string, byte[] byArray) {
            this.jcaDigestAlgorithm = string;
            this.digest = byArray;
        }
    }

    private static class Signer {
        private final String mName;
        private final Result.SignerInfo mResult;
        private final CentralDirectoryRecord mSignatureFileEntry;
        private final CentralDirectoryRecord mSignatureBlockEntry;
        private boolean mIgnored;
        private byte[] mSigFileBytes;
        private Set<String> mSigFileEntryNames;
        private static final String OID_DIGEST_MD5 = "1.2.840.113549.2.5";
        private static final String OID_DIGEST_SHA1 = "1.3.14.3.2.26";
        private static final String OID_DIGEST_SHA224 = "2.16.840.1.101.3.4.2.4";
        private static final String OID_DIGEST_SHA256 = "2.16.840.1.101.3.4.2.1";
        private static final String OID_DIGEST_SHA384 = "2.16.840.1.101.3.4.2.2";
        private static final String OID_DIGEST_SHA512 = "2.16.840.1.101.3.4.2.3";
        private static final String OID_SIG_RSA = "1.2.840.113549.1.1.1";
        private static final String OID_SIG_MD5_WITH_RSA = "1.2.840.113549.1.1.4";
        private static final String OID_SIG_SHA1_WITH_RSA = "1.2.840.113549.1.1.5";
        private static final String OID_SIG_SHA224_WITH_RSA = "1.2.840.113549.1.1.14";
        private static final String OID_SIG_SHA256_WITH_RSA = "1.2.840.113549.1.1.11";
        private static final String OID_SIG_SHA384_WITH_RSA = "1.2.840.113549.1.1.12";
        private static final String OID_SIG_SHA512_WITH_RSA = "1.2.840.113549.1.1.13";
        private static final String OID_SIG_DSA = "1.2.840.10040.4.1";
        private static final String OID_SIG_SHA1_WITH_DSA = "1.2.840.10040.4.3";
        private static final String OID_SIG_SHA224_WITH_DSA = "2.16.840.1.101.3.4.3.1";
        private static final String OID_SIG_SHA256_WITH_DSA = "2.16.840.1.101.3.4.3.2";
        private static final String OID_SIG_SHA1_WITH_ECDSA = "1.2.840.10045.4.1";
        private static final String OID_SIG_SHA224_WITH_ECDSA = "1.2.840.10045.4.3.1";
        private static final String OID_SIG_SHA256_WITH_ECDSA = "1.2.840.10045.4.3.2";
        private static final String OID_SIG_SHA384_WITH_ECDSA = "1.2.840.10045.4.3.3";
        private static final String OID_SIG_SHA512_WITH_ECDSA = "1.2.840.10045.4.3.4";
        private static final Map<String, List<InclusiveIntRange>> SUPPORTED_SIG_ALG_OIDS = new HashMap<String, List<InclusiveIntRange>>();

        private Signer(String string, CentralDirectoryRecord centralDirectoryRecord, CentralDirectoryRecord centralDirectoryRecord2, Result.SignerInfo signerInfo) {
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_RSA, InclusiveIntRange.from(0));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_MD5_WITH_RSA, InclusiveIntRange.fromTo(0, 8), InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA1_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA224_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA256_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA384_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA512_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_RSA, InclusiveIntRange.from(0));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_MD5_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA1_WITH_RSA, InclusiveIntRange.from(0));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA224_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA256_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA384_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA512_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_RSA, InclusiveIntRange.fromTo(0, 8), InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_MD5_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA1_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA224_WITH_RSA, InclusiveIntRange.fromTo(0, 8), InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA256_WITH_RSA, InclusiveIntRange.fromTo(21, 21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA384_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA512_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_RSA, InclusiveIntRange.fromTo(0, 8), InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_MD5_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA1_WITH_RSA, InclusiveIntRange.fromTo(21, 21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA224_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA256_WITH_RSA, InclusiveIntRange.fromTo(0, 8), InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA384_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA512_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_RSA, InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_MD5_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA1_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA224_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA256_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA384_WITH_RSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA512_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_RSA, InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_MD5_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA1_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA224_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA256_WITH_RSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA384_WITH_RSA, InclusiveIntRange.fromTo(21, 21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA512_WITH_RSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA1_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA224_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA256_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_DSA, InclusiveIntRange.from(0));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA1_WITH_DSA, InclusiveIntRange.from(9));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA224_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA256_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_DSA, InclusiveIntRange.from(22));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA1_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA224_WITH_DSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA256_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_DSA, InclusiveIntRange.from(22));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA1_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA224_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA256_WITH_DSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA1_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA224_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA256_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA1_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA224_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA256_WITH_DSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA1_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA224_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA256_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA384_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_MD5, OID_SIG_SHA512_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA1_WITH_ECDSA, InclusiveIntRange.from(18));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA224_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA256_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA384_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA1, OID_SIG_SHA512_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA1_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA224_WITH_ECDSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA256_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA384_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA224, OID_SIG_SHA512_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA1_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA224_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA256_WITH_ECDSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA384_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA256, OID_SIG_SHA512_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA1_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA224_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA256_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA384_WITH_ECDSA, InclusiveIntRange.from(21));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA384, OID_SIG_SHA512_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA1_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA224_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA256_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA384_WITH_ECDSA, InclusiveIntRange.fromTo(21, 23));
            Signer.addSupportedSigAlg(OID_DIGEST_SHA512, OID_SIG_SHA512_WITH_ECDSA, InclusiveIntRange.from(21));
            this.mName = string;
            this.mResult = signerInfo;
            this.mSignatureBlockEntry = centralDirectoryRecord;
            this.mSignatureFileEntry = centralDirectoryRecord2;
        }

        public String getName() {
            return this.mName;
        }

        public String getSignatureFileEntryName() {
            return this.mSignatureFileEntry.getName();
        }

        public String getSignatureBlockEntryName() {
            return this.mSignatureBlockEntry.getName();
        }

        void setIgnored() {
            this.mIgnored = true;
        }

        public boolean isIgnored() {
            return this.mIgnored;
        }

        public Set<String> getSigFileEntryNames() {
            return this.mSigFileEntryNames;
        }

        public Result.SignerInfo getResult() {
            return this.mResult;
        }

        public void verifySigBlockAgainstSigFile(DataSource dataSource, long l, int n, int n2) throws IOException, ZipFormatException, NoSuchAlgorithmException {
            ArrayList<X509Certificate> arrayList;
            PKCS7 pKCS7;
            byte[] byArray = LocalFileRecord.getUncompressedData(dataSource, this.mSignatureBlockEntry, l);
            this.mSigFileBytes = LocalFileRecord.getUncompressedData(dataSource, this.mSignatureFileEntry, l);
            try {
                pKCS7 = new PKCS7(byArray);
            }
            catch (IOException iOException) {
                if (iOException.getCause() instanceof CertificateException) {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MALFORMED_CERTIFICATE, new Object[]{this.mSignatureBlockEntry.getName(), iOException});
                } else {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_PARSE_EXCEPTION, new Object[]{this.mSignatureBlockEntry.getName(), iOException});
                }
                return;
            }
            SignerInfo[] signerInfoArray = pKCS7.getSignerInfos();
            if (signerInfoArray == null || signerInfoArray.length == 0) {
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNERS, new Object[]{this.mSignatureBlockEntry.getName()});
                return;
            }
            SignerInfo signerInfo = null;
            if (signerInfoArray != null && signerInfoArray.length > 0) {
                for (int i = 0; i < signerInfoArray.length; ++i) {
                    List<InclusiveIntRange> list;
                    SignerInfo signerInfo2 = signerInfoArray[i];
                    String string = signerInfo2.getDigestAlgorithmId().getOID().toString();
                    String string2 = signerInfo2.getDigestEncryptionAlgorithmId().getOID().toString();
                    InclusiveIntRange inclusiveIntRange = InclusiveIntRange.fromTo(n, n2);
                    List<InclusiveIntRange> list2 = inclusiveIntRange.getValuesNotIn(list = this.getSigAlgSupportedApiLevels(string, string2));
                    if (!list2.isEmpty()) {
                        this.mResult.addError(ApkVerifier.Issue.JAR_SIG_UNSUPPORTED_SIG_ALG, new Object[]{this.mSignatureBlockEntry.getName(), string, string2, String.valueOf(list2)});
                        return;
                    }
                    try {
                        signerInfo = pKCS7.verify(signerInfo2, this.mSigFileBytes);
                    }
                    catch (SignatureException signatureException) {
                        this.mResult.addError(ApkVerifier.Issue.JAR_SIG_VERIFY_EXCEPTION, new Object[]{this.mSignatureBlockEntry.getName(), this.mSignatureFileEntry.getName(), signatureException});
                        return;
                    }
                    if (signerInfo != null) break;
                    if (n >= 24) continue;
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_DID_NOT_VERIFY, new Object[]{this.mSignatureBlockEntry.getName(), this.mSignatureFileEntry.getName()});
                    return;
                }
            }
            if (signerInfo == null) {
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNERS, new Object[]{this.mSignatureBlockEntry.getName()});
                return;
            }
            try {
                arrayList = signerInfo.getCertificateChain(pKCS7);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to obtain cert chain from " + this.mSignatureBlockEntry.getName(), iOException);
            }
            if (arrayList == null || arrayList.isEmpty()) {
                throw new RuntimeException("Verified SignerInfo does not have a certificate chain");
            }
            this.mResult.certChain.clear();
            this.mResult.certChain.addAll(arrayList);
        }

        private static void addSupportedSigAlg(String string, String string2, InclusiveIntRange ... inclusiveIntRangeArray) {
            SUPPORTED_SIG_ALG_OIDS.put(string + "with" + string2, Arrays.asList(inclusiveIntRangeArray));
        }

        private List<InclusiveIntRange> getSigAlgSupportedApiLevels(String string, String string2) {
            List<InclusiveIntRange> list = SUPPORTED_SIG_ALG_OIDS.get(string + "with" + string2);
            return list != null ? list : Collections.emptyList();
        }

        public void verifySigFileAgainstManifest(byte[] byArray, ManifestParser.Section section, Map<String, ManifestParser.Section> map, Map<Integer, String> map2, Set<Integer> set, int n, int n2) throws NoSuchAlgorithmException {
            ManifestParser manifestParser = new ManifestParser(this.mSigFileBytes);
            ManifestParser.Section section2 = manifestParser.readSection();
            if (section2.getAttributeValue(Attributes.Name.SIGNATURE_VERSION) == null) {
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MISSING_VERSION_ATTR_IN_SIG_FILE, new Object[]{this.mSignatureFileEntry.getName()});
                this.setIgnored();
                return;
            }
            if (n2 >= 24) {
                this.checkForStrippedApkSignatures(section2, map2, set);
                if (this.mResult.containsErrors()) {
                    return;
                }
            }
            boolean bl = false;
            String string = section2.getAttributeValue("Created-By");
            if (string != null) {
                bl = string.indexOf("signtool") != -1;
            }
            boolean bl2 = this.verifyManifestDigest(section2, bl, byArray, n, n2);
            if (!bl) {
                this.verifyManifestMainSectionDigest(section2, section, byArray, n, n2);
            }
            if (this.mResult.containsErrors()) {
                return;
            }
            List<ManifestParser.Section> list = manifestParser.readAllSections();
            HashSet<String> hashSet = new HashSet<String>(list.size());
            int n3 = 0;
            for (ManifestParser.Section section3 : list) {
                ++n3;
                String string2 = section3.getName();
                if (string2 == null) {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_UNNNAMED_SIG_FILE_SECTION, new Object[]{this.mSignatureFileEntry.getName(), n3});
                    this.setIgnored();
                    return;
                }
                if (!hashSet.add(string2)) {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_DUPLICATE_SIG_FILE_SECTION, new Object[]{this.mSignatureFileEntry.getName(), string2});
                    this.setIgnored();
                    return;
                }
                if (bl2) continue;
                ManifestParser.Section section4 = map.get(string2);
                if (section4 == null) {
                    this.mResult.addError(ApkVerifier.Issue.JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_SIG_FILE, new Object[]{string2, this.mSignatureFileEntry.getName()});
                    this.setIgnored();
                    continue;
                }
                this.verifyManifestIndividualSectionDigest(section3, bl, section4, byArray, n, n2);
            }
            this.mSigFileEntryNames = hashSet;
        }

        private boolean verifyManifestDigest(ManifestParser.Section section, boolean bl, byte[] byArray, int n, int n2) throws NoSuchAlgorithmException {
            boolean bl2;
            Collection collection = V1SchemeVerifier.getDigestsToVerify(section, bl ? "-Digest" : "-Digest-Manifest", n, n2);
            boolean bl3 = bl2 = !collection.isEmpty();
            if (!bl2) {
                this.mResult.addWarning(ApkVerifier.Issue.JAR_SIG_NO_MANIFEST_DIGEST_IN_SIG_FILE, new Object[]{this.mSignatureFileEntry.getName()});
                return false;
            }
            boolean bl4 = true;
            for (NamedDigest namedDigest : collection) {
                String string = namedDigest.jcaDigestAlgorithm;
                byte[] byArray2 = V1SchemeVerifier.digest(string, byArray);
                byte[] byArray3 = namedDigest.digest;
                if (Arrays.equals(byArray3, byArray2)) continue;
                this.mResult.addWarning(ApkVerifier.Issue.JAR_SIG_ZIP_ENTRY_DIGEST_DID_NOT_VERIFY, new Object[]{V1SchemeVerifier.MANIFEST_ENTRY_NAME, string, this.mSignatureFileEntry.getName(), Base64.getEncoder().encodeToString(byArray2), Base64.getEncoder().encodeToString(byArray3)});
                bl4 = false;
            }
            return bl4;
        }

        private void verifyManifestMainSectionDigest(ManifestParser.Section section, ManifestParser.Section section2, byte[] byArray, int n, int n2) throws NoSuchAlgorithmException {
            Collection collection = V1SchemeVerifier.getDigestsToVerify(section, "-Digest-Manifest-Main-Attributes", n, n2);
            if (collection.isEmpty()) {
                return;
            }
            for (NamedDigest namedDigest : collection) {
                String string = namedDigest.jcaDigestAlgorithm;
                byte[] byArray2 = V1SchemeVerifier.digest(string, byArray, section2.getStartOffset(), section2.getSizeBytes());
                byte[] byArray3 = namedDigest.digest;
                if (Arrays.equals(byArray3, byArray2)) continue;
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MANIFEST_MAIN_SECTION_DIGEST_DID_NOT_VERIFY, new Object[]{string, this.mSignatureFileEntry.getName(), Base64.getEncoder().encodeToString(byArray2), Base64.getEncoder().encodeToString(byArray3)});
            }
        }

        private void verifyManifestIndividualSectionDigest(ManifestParser.Section section, boolean bl, ManifestParser.Section section2, byte[] byArray, int n, int n2) throws NoSuchAlgorithmException {
            int n3;
            String string = section.getName();
            Collection collection = V1SchemeVerifier.getDigestsToVerify(section, "-Digest", n, n2);
            if (collection.isEmpty()) {
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_SIG_FILE, new Object[]{string, this.mSignatureFileEntry.getName()});
                return;
            }
            int n4 = section2.getStartOffset();
            int n5 = section2.getSizeBytes();
            if (bl && byArray[(n3 = n4 + n5) - 1] == 10 && byArray[n3 - 2] == 10) {
                --n5;
            }
            for (NamedDigest namedDigest : collection) {
                String string2 = namedDigest.jcaDigestAlgorithm;
                byte[] byArray2 = V1SchemeVerifier.digest(string2, byArray, n4, n5);
                byte[] byArray3 = namedDigest.digest;
                if (Arrays.equals(byArray3, byArray2)) continue;
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MANIFEST_SECTION_DIGEST_DID_NOT_VERIFY, new Object[]{string, string2, this.mSignatureFileEntry.getName(), Base64.getEncoder().encodeToString(byArray2), Base64.getEncoder().encodeToString(byArray3)});
            }
        }

        private void checkForStrippedApkSignatures(ManifestParser.Section section, Map<Integer, String> map, Set<Integer> set) {
            int n;
            Object object;
            String string = section.getAttributeValue("X-Android-APK-Signed");
            if (string == null) {
                if (!set.isEmpty()) {
                    this.mResult.addWarning(ApkVerifier.Issue.JAR_SIG_NO_APK_SIG_STRIP_PROTECTION, new Object[]{this.mSignatureFileEntry.getName()});
                }
                return;
            }
            if (map.isEmpty()) {
                return;
            }
            Set<Integer> set2 = map.keySet();
            HashSet<Integer> hashSet = new HashSet<Integer>(1);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                if (((String)object).isEmpty()) continue;
                try {
                    n = Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    continue;
                }
                if (set2.contains(n)) {
                    hashSet.add(n);
                    continue;
                }
                this.mResult.addWarning(ApkVerifier.Issue.JAR_SIG_UNKNOWN_APK_SIG_SCHEME_ID, new Object[]{this.mSignatureFileEntry.getName(), n});
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                n = (Integer)object.next();
                if (set.contains(n)) continue;
                String string2 = map.get(n);
                this.mResult.addError(ApkVerifier.Issue.JAR_SIG_MISSING_APK_SIG_REFERENCED, new Object[]{this.mSignatureFileEntry.getName(), n, string2});
            }
        }
    }

    private static class Signers {
        private Signers() {
        }

        private static void verify(DataSource dataSource, long l, List<CentralDirectoryRecord> list, Set<String> set, Map<Integer, String> map, Set<Integer> set2, int n, int n2, Result result) throws ZipFormatException, IOException, NoSuchAlgorithmException {
            Object object;
            Object object22;
            Object object3;
            CentralDirectoryRecord centralDirectoryRecord = null;
            HashMap<Object, CentralDirectoryRecord> hashMap = new HashMap<Object, CentralDirectoryRecord>(1);
            ArrayList<CentralDirectoryRecord> arrayList = new ArrayList<CentralDirectoryRecord>(1);
            for (CentralDirectoryRecord object72 : list) {
                object3 = object72.getName();
                if (!((String)object3).startsWith("META-INF/")) continue;
                if (centralDirectoryRecord == null && V1SchemeVerifier.MANIFEST_ENTRY_NAME.equals(object3)) {
                    centralDirectoryRecord = object72;
                    continue;
                }
                if (((String)object3).endsWith(".SF")) {
                    hashMap.put(object3, object72);
                    continue;
                }
                if (!((String)object3).endsWith(".RSA") && !((String)object3).endsWith(".DSA") && !((String)object3).endsWith(".EC")) continue;
                arrayList.add(object72);
            }
            if (centralDirectoryRecord == null) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_MANIFEST, new Object[0]);
                return;
            }
            Object object8 = LocalFileRecord.getUncompressedData(dataSource, centralDirectoryRecord, l);
            Object var14_14 = null;
            object3 = new ManifestParser((byte[])object8);
            ManifestParser.Section section = ((ManifestParser)object3).readSection();
            List<ManifestParser.Section> list2 = ((ManifestParser)object3).readAllSections();
            HashMap<String, ManifestParser.Section> hashMap2 = new HashMap<String, ManifestParser.Section>(list2.size());
            int n3 = 0;
            for (ManifestParser.Section section2 : list2) {
                ++n3;
                String string = section2.getName();
                if (string == null) {
                    result.addError(ApkVerifier.Issue.JAR_SIG_UNNNAMED_MANIFEST_SECTION, new Object[]{n3});
                    continue;
                }
                if (hashMap2.put(string, section2) != null) {
                    result.addError(ApkVerifier.Issue.JAR_SIG_DUPLICATE_MANIFEST_SECTION, new Object[]{string});
                    continue;
                }
                if (set.contains(string)) continue;
                result.addError(ApkVerifier.Issue.JAR_SIG_MISSING_ZIP_ENTRY_REFERENCED_IN_MANIFEST, new Object[]{string});
            }
            if (result.containsErrors()) {
                return;
            }
            ArrayList<Object> arrayList2 = new ArrayList(arrayList.size());
            for (CentralDirectoryRecord centralDirectoryRecord2 : arrayList) {
                object22 = centralDirectoryRecord2.getName();
                int n4 = ((String)object22).lastIndexOf(46);
                if (n4 == -1) {
                    throw new RuntimeException("Signature block file name does not contain extension: " + (String)object22);
                }
                String string = ((String)object22).substring(0, n4) + ".SF";
                object = (CentralDirectoryRecord)hashMap.get(string);
                if (object == null) {
                    result.addWarning(ApkVerifier.Issue.JAR_SIG_MISSING_FILE, new Object[]{object22, string});
                    continue;
                }
                String string2 = ((String)object22).substring("META-INF/".length());
                Result.SignerInfo signerInfo = new Result.SignerInfo(string2, (String)object22, ((CentralDirectoryRecord)object).getName());
                Signer signer = new Signer(string2, centralDirectoryRecord2, (CentralDirectoryRecord)object, signerInfo);
                arrayList2.add(signer);
            }
            if (arrayList2.isEmpty()) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNATURES, new Object[0]);
                return;
            }
            for (Signer signer : arrayList2) {
                signer.verifySigBlockAgainstSigFile(dataSource, l, n, n2);
                if (!signer.getResult().containsErrors()) continue;
                result.signers.add(signer.getResult());
            }
            if (result.containsErrors()) {
                return;
            }
            ArrayList<Object> arrayList3 = new ArrayList<Object>(arrayList2.size());
            for (Object object22 : arrayList2) {
                ((Signer)object22).verifySigFileAgainstManifest((byte[])object8, section, hashMap2, map, set2, n, n2);
                if (((Signer)object22).isIgnored()) {
                    result.ignoredSigners.add(((Signer)object22).getResult());
                    continue;
                }
                if (((Signer)object22).getResult().containsErrors()) {
                    result.signers.add(((Signer)object22).getResult());
                    continue;
                }
                arrayList3.add(object22);
            }
            if (result.containsErrors()) {
                return;
            }
            arrayList2 = arrayList3;
            if (arrayList2.isEmpty()) {
                result.addError(ApkVerifier.Issue.JAR_SIG_NO_SIGNATURES, new Object[0]);
                return;
            }
            Set set3 = V1SchemeVerifier.verifyJarEntriesAgainstManifestAndSigners(dataSource, l, list, hashMap2, arrayList2, n, n2, result);
            if (result.containsErrors()) {
                return;
            }
            object22 = new HashSet<String>(1 + result.signers.size() * 2);
            object22.add(centralDirectoryRecord.getName());
            for (Signer signer : set3) {
                object22.add(signer.getSignatureBlockEntryName());
                object22.add(signer.getSignatureFileEntryName());
            }
            for (CentralDirectoryRecord centralDirectoryRecord3 : list) {
                object = centralDirectoryRecord3.getName();
                if (!((String)object).startsWith("META-INF/") || ((String)object).endsWith("/") || object22.contains(object)) continue;
                result.addWarning(ApkVerifier.Issue.JAR_SIG_UNPROTECTED_ZIP_ENTRY, new Object[]{object});
            }
            for (Signer signer : arrayList2) {
                if (set3.contains(signer)) {
                    result.signers.add(signer.getResult());
                    continue;
                }
                result.ignoredSigners.add(signer.getResult());
            }
            result.verified = true;
        }
    }
}

