/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v2;

import com.android.apksig.internal.apk.v2.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.v2.SignatureAlgorithm;
import com.android.apksig.internal.util.MessageDigestSink;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class V2SchemeSigner {
    private static final int CONTENT_DIGESTED_CHUNK_MAX_SIZE_BYTES = 0x100000;
    private static final byte[] APK_SIGNING_BLOCK_MAGIC = new byte[]{65, 80, 75, 32, 83, 105, 103, 32, 66, 108, 111, 99, 107, 32, 52, 50};
    private static final int APK_SIGNATURE_SCHEME_V2_BLOCK_ID = 1896449818;

    private V2SchemeSigner() {
    }

    public static List<SignatureAlgorithm> getSuggestedSignatureAlgorithms(PublicKey publicKey, int n) throws InvalidKeyException {
        String string = publicKey.getAlgorithm();
        if ("RSA".equalsIgnoreCase(string)) {
            int n2 = ((RSAKey)((Object)publicKey)).getModulus().bitLength();
            if (n2 <= 3072) {
                return Collections.singletonList(SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA256);
            }
            return Collections.singletonList(SignatureAlgorithm.RSA_PKCS1_V1_5_WITH_SHA512);
        }
        if ("DSA".equalsIgnoreCase(string)) {
            return Collections.singletonList(SignatureAlgorithm.DSA_WITH_SHA256);
        }
        if ("EC".equalsIgnoreCase(string)) {
            int n3 = ((ECKey)((Object)publicKey)).getParams().getOrder().bitLength();
            if (n3 <= 256) {
                return Collections.singletonList(SignatureAlgorithm.ECDSA_WITH_SHA256);
            }
            return Collections.singletonList(SignatureAlgorithm.ECDSA_WITH_SHA512);
        }
        throw new InvalidKeyException("Unsupported key algorithm: " + string);
    }

    public static byte[] generateApkSigningBlock(DataSource dataSource, DataSource dataSource2, DataSource dataSource3, List<SignerConfig> list) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Object object2;
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No signer configs provided. At least one is required");
        }
        HashSet<ContentDigestAlgorithm> hashSet = new HashSet<ContentDigestAlgorithm>(1);
        for (SignerConfig signerConfig : list) {
            for (Object object2 : signerConfig.signatureAlgorithms) {
                hashSet.add(object2.getContentDigestAlgorithm());
            }
        }
        long l = dataSource.size();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)dataSource3.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        dataSource3.copyTo(0L, (int)dataSource3.size(), byteBuffer);
        byteBuffer.flip();
        ZipUtils.setZipEocdCentralDirectoryOffset(byteBuffer, l);
        try {
            object2 = V2SchemeSigner.computeContentDigests(hashSet, new DataSource[]{dataSource, dataSource2, DataSources.asDataSource(byteBuffer)});
        }
        catch (IOException iOException) {
            throw new IOException("Failed to read APK being signed", iOException);
        }
        catch (DigestException digestException) {
            throw new SignatureException("Failed to compute digests of APK", digestException);
        }
        return V2SchemeSigner.generateApkSigningBlock(list, (Map<ContentDigestAlgorithm, byte[]>)object2);
    }

    static Map<ContentDigestAlgorithm, byte[]> computeContentDigests(Set<ContentDigestAlgorithm> set, DataSource[] dataSourceArray) throws IOException, NoSuchAlgorithmException, DigestException {
        Object object;
        int n;
        Object object2;
        long l = 0L;
        for (DataSource object32 : dataSourceArray) {
            l += V2SchemeSigner.getChunkCount(object32.size(), 0x100000);
        }
        if (l > Integer.MAX_VALUE) {
            throw new DigestException("Input too long: " + l + " chunks");
        }
        int n2 = (int)l;
        ContentDigestAlgorithm[] contentDigestAlgorithmArray = set.toArray(new ContentDigestAlgorithm[set.size()]);
        MessageDigest[] messageDigestArray = new MessageDigest[contentDigestAlgorithmArray.length];
        byte[][] byArrayArray = new byte[contentDigestAlgorithmArray.length][];
        int[] nArray = new int[contentDigestAlgorithmArray.length];
        for (int messageDigestSink = 0; messageDigestSink < contentDigestAlgorithmArray.length; ++messageDigestSink) {
            object2 = contentDigestAlgorithmArray[messageDigestSink];
            nArray[messageDigestSink] = n = ((ContentDigestAlgorithm)((Object)object2)).getChunkDigestOutputSizeBytes();
            object = new byte[5 + n2 * n];
            object[0] = (DataSource)90;
            V2SchemeSigner.setUnsignedInt32LittleEndian(n2, (byte[])object, 1);
            byArrayArray[messageDigestSink] = (byte[])object;
            String i = ((ContentDigestAlgorithm)((Object)object2)).getJcaMessageDigestAlgorithm();
            messageDigestArray[messageDigestSink] = MessageDigest.getInstance(i);
        }
        MessageDigestSink messageDigestSink = new MessageDigestSink(messageDigestArray);
        object2 = new byte[5];
        object2[0] = (ContentDigestAlgorithm)-91;
        n = 0;
        for (DataSource dataSource : dataSourceArray) {
            long l2 = 0L;
            long l3 = dataSource.size();
            while (l3 > 0L) {
                int n3;
                int n4 = (int)Math.min(l3, 0x100000L);
                V2SchemeSigner.setUnsignedInt32LittleEndian(n4, (byte[])object2, 1);
                for (n3 = 0; n3 < messageDigestArray.length; ++n3) {
                    messageDigestArray[n3].update((byte[])object2);
                }
                try {
                    dataSource.feed(l2, n4, messageDigestSink);
                }
                catch (IOException iOException) {
                    throw new IOException("Failed to read chunk #" + n, iOException);
                }
                for (n3 = 0; n3 < contentDigestAlgorithmArray.length; ++n3) {
                    MessageDigest messageDigest = messageDigestArray[n3];
                    byte[] byArray = byArrayArray[n3];
                    int n5 = nArray[n3];
                    int n6 = messageDigest.digest(byArray, 5 + n * n5, n5);
                    if (n6 == n5) continue;
                    throw new RuntimeException("Unexpected output size of " + messageDigest.getAlgorithm() + " digest: " + n6);
                }
                l2 += (long)n4;
                l3 -= (long)n4;
                ++n;
            }
        }
        object = new HashMap(contentDigestAlgorithmArray.length);
        for (int i = 0; i < contentDigestAlgorithmArray.length; ++i) {
            ContentDigestAlgorithm contentDigestAlgorithm = contentDigestAlgorithmArray[i];
            byte[] byArray = byArrayArray[i];
            MessageDigest messageDigest = messageDigestArray[i];
            byte[] byArray2 = messageDigest.digest(byArray);
            object.put(contentDigestAlgorithm, byArray2);
        }
        return object;
    }

    private static final long getChunkCount(long l, int n) {
        return (l + (long)n - 1L) / (long)n;
    }

    private static void setUnsignedInt32LittleEndian(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 3] = (byte)(n >> 24 & 0xFF);
    }

    private static byte[] generateApkSigningBlock(List<SignerConfig> list, Map<ContentDigestAlgorithm, byte[]> map) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        byte[] byArray = V2SchemeSigner.generateApkSignatureSchemeV2Block(list, map);
        return V2SchemeSigner.generateApkSigningBlock(byArray);
    }

    private static byte[] generateApkSigningBlock(byte[] byArray) {
        int n = 20 + byArray.length + 8 + 16;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        long l = n - 8;
        byteBuffer.putLong(l);
        long l2 = 4 + byArray.length;
        byteBuffer.putLong(l2);
        byteBuffer.putInt(1896449818);
        byteBuffer.put(byArray);
        byteBuffer.putLong(l);
        byteBuffer.put(APK_SIGNING_BLOCK_MAGIC);
        return byteBuffer.array();
    }

    private static byte[] generateApkSignatureSchemeV2Block(List<SignerConfig> list, Map<ContentDigestAlgorithm, byte[]> map) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(list.size());
        int n = 0;
        for (SignerConfig signerConfig : list) {
            byte[] byArray;
            ++n;
            try {
                byArray = V2SchemeSigner.generateSignerBlock(signerConfig, map);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeyException("Signer #" + n + " failed", invalidKeyException);
            }
            catch (SignatureException signatureException) {
                throw new SignatureException("Signer #" + n + " failed", signatureException);
            }
            arrayList.add(byArray);
        }
        return V2SchemeSigner.encodeAsSequenceOfLengthPrefixedElements(new byte[][]{V2SchemeSigner.encodeAsSequenceOfLengthPrefixedElements(arrayList)});
    }

    private static byte[] generateSignerBlock(SignerConfig signerConfig, Map<ContentDigestAlgorithm, byte[]> map) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Object object;
        if (signerConfig.certificates.isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        PublicKey publicKey = signerConfig.certificates.get(0).getPublicKey();
        byte[] byArray = V2SchemeSigner.encodePublicKey(publicKey);
        V2SignatureSchemeBlock.SignedData signedData = new V2SignatureSchemeBlock.SignedData();
        try {
            signedData.certificates = V2SchemeSigner.encodeCertificates(signerConfig.certificates);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new SignatureException("Failed to encode certificates", certificateEncodingException);
        }
        ArrayList<Pair<Integer, byte[]>> arrayList = new ArrayList<Pair<Integer, byte[]>>(signerConfig.signatureAlgorithms.size());
        for (Object object2 : signerConfig.signatureAlgorithms) {
            ContentDigestAlgorithm enum_ = object2.getContentDigestAlgorithm();
            object = map.get((Object)enum_);
            if (object == null) {
                throw new RuntimeException((Object)((Object)enum_) + " content digest for " + (Object)object2 + " not computed");
            }
            arrayList.add(Pair.of(object2.getId(), object));
        }
        signedData.digests = arrayList;
        V2SignatureSchemeBlock.Signer signer = new V2SignatureSchemeBlock.Signer();
        signer.signedData = V2SchemeSigner.encodeAsSequenceOfLengthPrefixedElements(new byte[][]{V2SchemeSigner.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(signedData.digests), V2SchemeSigner.encodeAsSequenceOfLengthPrefixedElements(signedData.certificates), new byte[0]});
        signer.publicKey = byArray;
        signer.signatures = new ArrayList<Pair<Integer, byte[]>>(signerConfig.signatureAlgorithms.size());
        for (SignatureAlgorithm signatureAlgorithm : signerConfig.signatureAlgorithms) {
            byte[] byArray2;
            Signature generalSecurityException;
            object = signatureAlgorithm.getJcaSignatureAlgorithmAndParams();
            String string = (String)object.getFirst();
            AlgorithmParameterSpec algorithmParameterSpec = (AlgorithmParameterSpec)object.getSecond();
            try {
                generalSecurityException = Signature.getInstance(string);
                generalSecurityException.initSign(signerConfig.privateKey);
                if (algorithmParameterSpec != null) {
                    generalSecurityException.setParameter(algorithmParameterSpec);
                }
                generalSecurityException.update(signer.signedData);
                byArray2 = generalSecurityException.sign();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeyException("Failed to sign using " + string, invalidKeyException);
            }
            catch (InvalidAlgorithmParameterException | SignatureException generalSecurityException2) {
                throw new SignatureException("Failed to sign using " + string, generalSecurityException2);
            }
            try {
                generalSecurityException = Signature.getInstance(string);
                generalSecurityException.initVerify(publicKey);
                if (algorithmParameterSpec != null) {
                    generalSecurityException.setParameter(algorithmParameterSpec);
                }
                generalSecurityException.update(signer.signedData);
                if (!generalSecurityException.verify(byArray2)) {
                    throw new SignatureException("Signature did not verify");
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeyException("Failed to verify generated " + string + " signature using" + " public key from certificate", invalidKeyException);
            }
            catch (InvalidAlgorithmParameterException | SignatureException generalSecurityException3) {
                throw new SignatureException("Failed to verify generated " + string + " signature using" + " public key from certificate", generalSecurityException3);
            }
            signer.signatures.add(Pair.of(signatureAlgorithm.getId(), byArray2));
        }
        return V2SchemeSigner.encodeAsSequenceOfLengthPrefixedElements(new byte[][]{signer.signedData, V2SchemeSigner.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(signer.signatures), signer.publicKey});
    }

    private static byte[] encodePublicKey(PublicKey publicKey) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray = null;
        if ("X.509".equals(publicKey.getFormat())) {
            byArray = publicKey.getEncoded();
        }
        if (byArray == null) {
            try {
                byArray = KeyFactory.getInstance(publicKey.getAlgorithm()).getKeySpec(publicKey, X509EncodedKeySpec.class).getEncoded();
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException("Failed to obtain X.509 encoded form of public key " + publicKey + " of class " + publicKey.getClass().getName(), invalidKeySpecException);
            }
        }
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Failed to obtain X.509 encoded form of public key " + publicKey + " of class " + publicKey.getClass().getName());
        }
        return byArray;
    }

    private static List<byte[]> encodeCertificates(List<X509Certificate> list) throws CertificateEncodingException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(list.size());
        for (X509Certificate x509Certificate : list) {
            arrayList.add(x509Certificate.getEncoded());
        }
        return arrayList;
    }

    private static byte[] encodeAsSequenceOfLengthPrefixedElements(List<byte[]> list) {
        return V2SchemeSigner.encodeAsSequenceOfLengthPrefixedElements((byte[][])list.toArray((T[])new byte[list.size()][]));
    }

    private static byte[] encodeAsSequenceOfLengthPrefixedElements(byte[][] byArray) {
        int n = 0;
        for (byte[] byArray2 : byArray) {
            n += 4 + byArray2.length;
        }
        Object object = ByteBuffer.allocate(n);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        for (byte[] byArray3 : byArray) {
            ((ByteBuffer)object).putInt(byArray3.length);
            ((ByteBuffer)object).put(byArray3);
        }
        return ((ByteBuffer)object).array();
    }

    private static byte[] encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(List<Pair<Integer, byte[]>> list) {
        int n = 0;
        for (Pair<Integer, byte[]> object : list) {
            n += 12 + object.getSecond().length;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (Pair<Integer, byte[]> pair : list) {
            byte[] byArray = pair.getSecond();
            byteBuffer.putInt(8 + byArray.length);
            byteBuffer.putInt(pair.getFirst());
            byteBuffer.putInt(byArray.length);
            byteBuffer.put(byArray);
        }
        return byteBuffer.array();
    }

    private static final class V2SignatureSchemeBlock {
        private V2SignatureSchemeBlock() {
        }

        private static final class SignedData {
            public List<Pair<Integer, byte[]>> digests;
            public List<byte[]> certificates;

            private SignedData() {
            }
        }

        private static final class Signer {
            public byte[] signedData;
            public List<Pair<Integer, byte[]>> signatures;
            public byte[] publicKey;

            private Signer() {
            }
        }
    }

    public static class SignerConfig {
        public PrivateKey privateKey;
        public List<X509Certificate> certificates;
        public List<SignatureAlgorithm> signatureAlgorithms;
    }
}

