/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.jar;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;

public class ManifestParser {
    private final byte[] mManifest;
    private int mOffset;
    private int mEndOffset;
    private String mBufferedLine;

    public ManifestParser(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ManifestParser(byte[] byArray, int n, int n2) {
        this.mManifest = byArray;
        this.mOffset = n;
        this.mEndOffset = n + n2;
    }

    public List<Section> readAllSections() {
        Section section;
        ArrayList<Section> arrayList = new ArrayList<Section>();
        while ((section = this.readSection()) != null) {
            arrayList.add(section);
        }
        return arrayList;
    }

    public Section readSection() {
        int n;
        String string;
        do {
            n = this.mOffset;
            string = this.readAttribute();
            if (string != null) continue;
            return null;
        } while (string.length() == 0);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        arrayList.add(ManifestParser.parseAttr(string));
        while ((string = this.readAttribute()) != null && string.length() != 0) {
            arrayList.add(ManifestParser.parseAttr(string));
        }
        int n2 = this.mOffset;
        int n3 = n2 - n;
        return new Section(n, n3, arrayList);
    }

    private static Attribute parseAttr(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return new Attribute(string.trim(), "");
        }
        return new Attribute(string.substring(0, n).trim(), string.substring(n + 1).trim());
    }

    private String readAttribute() {
        StringBuilder stringBuilder;
        if (this.mBufferedLine != null && this.mBufferedLine.length() == 0) {
            this.mBufferedLine = null;
            return "";
        }
        String string = this.readLine();
        if (string == null) {
            if (this.mBufferedLine != null) {
                String string2 = this.mBufferedLine;
                this.mBufferedLine = null;
                return string2;
            }
            return null;
        }
        if (string.length() == 0) {
            if (this.mBufferedLine != null) {
                String string3 = this.mBufferedLine;
                this.mBufferedLine = "";
                return string3;
            }
            return "";
        }
        if (this.mBufferedLine == null) {
            stringBuilder = new StringBuilder(string);
        } else {
            if (!string.startsWith(" ")) {
                String string4 = this.mBufferedLine;
                this.mBufferedLine = string;
                return string4;
            }
            stringBuilder = new StringBuilder(this.mBufferedLine);
            this.mBufferedLine = null;
            stringBuilder.append(string.substring(1));
        }
        while (true) {
            if ((string = this.readLine()) == null) {
                return stringBuilder.toString();
            }
            if (string.length() == 0) {
                this.mBufferedLine = "";
                return stringBuilder.toString();
            }
            if (!string.startsWith(" ")) break;
            stringBuilder.append(string.substring(1));
        }
        this.mBufferedLine = string;
        return stringBuilder.toString();
    }

    private String readLine() {
        int n;
        if (this.mOffset >= this.mEndOffset) {
            return null;
        }
        int n2 = this.mOffset;
        int n3 = -1;
        int n4 = -1;
        for (n = n2; n < this.mEndOffset; ++n) {
            byte by = this.mManifest[n];
            if (by == 13) {
                n3 = n;
                int n5 = n + 1;
                if (n5 < this.mEndOffset && this.mManifest[n5] == 10) {
                    n4 = n5 + 1;
                    break;
                }
                n4 = n5;
                break;
            }
            if (by != 10) continue;
            n3 = n;
            n4 = n + 1;
            break;
        }
        if (n3 == -1) {
            n3 = this.mEndOffset;
            n4 = this.mEndOffset;
        }
        this.mOffset = n4;
        n = n3 - n2;
        if (n == 0) {
            return "";
        }
        return new String(this.mManifest, n2, n, StandardCharsets.UTF_8);
    }

    public static class Section {
        private final int mStartOffset;
        private final int mSizeBytes;
        private final String mName;
        private final List<Attribute> mAttributes;

        public Section(int n, int n2, List<Attribute> list) {
            Attribute attribute;
            this.mStartOffset = n;
            this.mSizeBytes = n2;
            String string = null;
            if (!list.isEmpty() && "Name".equalsIgnoreCase((attribute = list.get(0)).getName())) {
                string = attribute.getValue();
            }
            this.mName = string;
            this.mAttributes = Collections.unmodifiableList(new ArrayList<Attribute>(list));
        }

        public String getName() {
            return this.mName;
        }

        public int getStartOffset() {
            return this.mStartOffset;
        }

        public int getSizeBytes() {
            return this.mSizeBytes;
        }

        public List<Attribute> getAttributes() {
            return this.mAttributes;
        }

        public String getAttributeValue(Attributes.Name name) {
            return this.getAttributeValue(name.toString());
        }

        public String getAttributeValue(String string) {
            for (Attribute attribute : this.mAttributes) {
                if (!attribute.getName().equalsIgnoreCase(string)) continue;
                return attribute.getValue();
            }
            return null;
        }
    }

    public static class Attribute {
        private final String mName;
        private final String mValue;

        public Attribute(String string, String string2) {
            this.mName = string;
            this.mValue = string2;
        }

        public String getName() {
            return this.mName;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

