/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.jar;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Attributes;

public abstract class ManifestWriter {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final int MAX_LINE_LENGTH = 70;

    private ManifestWriter() {
    }

    public static void writeMainSection(OutputStream outputStream, Attributes attributes) throws IOException {
        String string = attributes.getValue(Attributes.Name.MANIFEST_VERSION);
        if (string == null) {
            throw new IllegalArgumentException("Mandatory " + Attributes.Name.MANIFEST_VERSION + " attribute missing");
        }
        ManifestWriter.writeAttribute(outputStream, Attributes.Name.MANIFEST_VERSION, string);
        if (attributes.size() > 1) {
            SortedMap<String, String> sortedMap = ManifestWriter.getAttributesSortedByName(attributes);
            sortedMap.remove(Attributes.Name.MANIFEST_VERSION.toString());
            ManifestWriter.writeAttributes(outputStream, sortedMap);
        }
        ManifestWriter.writeSectionDelimiter(outputStream);
    }

    public static void writeIndividualSection(OutputStream outputStream, String string, Attributes attributes) throws IOException {
        ManifestWriter.writeAttribute(outputStream, "Name", string);
        if (!attributes.isEmpty()) {
            ManifestWriter.writeAttributes(outputStream, ManifestWriter.getAttributesSortedByName(attributes));
        }
        ManifestWriter.writeSectionDelimiter(outputStream);
    }

    static void writeSectionDelimiter(OutputStream outputStream) throws IOException {
        outputStream.write(CRLF);
    }

    static void writeAttribute(OutputStream outputStream, Attributes.Name name, String string) throws IOException {
        ManifestWriter.writeAttribute(outputStream, name.toString(), string);
    }

    private static void writeAttribute(OutputStream outputStream, String string, String string2) throws IOException {
        ManifestWriter.writeLine(outputStream, string + ": " + string2);
    }

    private static void writeLine(OutputStream outputStream, String string) throws IOException {
        int n;
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        int n2 = 0;
        boolean bl = true;
        for (int i = byArray.length; i > 0; i -= n) {
            if (bl) {
                n = Math.min(i, 70);
            } else {
                outputStream.write(CRLF);
                outputStream.write(32);
                n = Math.min(i, 69);
            }
            outputStream.write(byArray, n2, n);
            n2 += n;
            bl = false;
        }
        outputStream.write(CRLF);
    }

    static SortedMap<String, String> getAttributesSortedByName(Attributes attributes) {
        Set<Map.Entry<Object, Object>> set = attributes.entrySet();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> entry : set) {
            String string = entry.getKey().toString();
            String string2 = entry.getValue().toString();
            treeMap.put(string, string2);
        }
        return treeMap;
    }

    static void writeAttributes(OutputStream outputStream, SortedMap<String, String> sortedMap) throws IOException {
        for (Map.Entry<String, String> entry : sortedMap.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            ManifestWriter.writeAttribute(outputStream, string, string2);
        }
    }
}

