/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.jar;

import com.android.apksig.internal.jar.ManifestWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.SortedMap;
import java.util.jar.Attributes;

public abstract class SignatureFileWriter {
    private SignatureFileWriter() {
    }

    public static void writeMainSection(OutputStream outputStream, Attributes attributes) throws IOException {
        String string = attributes.getValue(Attributes.Name.SIGNATURE_VERSION);
        if (string == null) {
            throw new IllegalArgumentException("Mandatory " + Attributes.Name.SIGNATURE_VERSION + " attribute missing");
        }
        ManifestWriter.writeAttribute(outputStream, Attributes.Name.SIGNATURE_VERSION, string);
        if (attributes.size() > 1) {
            SortedMap<String, String> sortedMap = ManifestWriter.getAttributesSortedByName(attributes);
            sortedMap.remove(Attributes.Name.SIGNATURE_VERSION.toString());
            ManifestWriter.writeAttributes(outputStream, sortedMap);
        }
        SignatureFileWriter.writeSectionDelimiter(outputStream);
    }

    public static void writeIndividualSection(OutputStream outputStream, String string, Attributes attributes) throws IOException {
        ManifestWriter.writeIndividualSection(outputStream, string, attributes);
    }

    public static void writeSectionDelimiter(OutputStream outputStream) throws IOException {
        ManifestWriter.writeSectionDelimiter(outputStream);
    }
}

