/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSource;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class RandomAccessFileDataSource
implements DataSource {
    private static final int MAX_READ_CHUNK_SIZE = 65536;
    private final RandomAccessFile mFile;
    private final long mOffset;
    private final long mSize;

    public RandomAccessFileDataSource(RandomAccessFile randomAccessFile) {
        this.mFile = randomAccessFile;
        this.mOffset = 0L;
        this.mSize = -1L;
    }

    public RandomAccessFileDataSource(RandomAccessFile randomAccessFile, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("offset: " + l2);
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("size: " + l2);
        }
        this.mFile = randomAccessFile;
        this.mOffset = l;
        this.mSize = l2;
    }

    @Override
    public long size() {
        if (this.mSize == -1L) {
            try {
                return this.mFile.length();
            }
            catch (IOException iOException) {
                return 0L;
            }
        }
        return this.mSize;
    }

    @Override
    public RandomAccessFileDataSource slice(long l, long l2) {
        long l3 = this.size();
        RandomAccessFileDataSource.checkChunkValid(l, l2, l3);
        if (l == 0L && l2 == l3) {
            return this;
        }
        return new RandomAccessFileDataSource(this.mFile, this.mOffset + l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feed(long l, long l2, DataSink dataSink) throws IOException {
        int n;
        long l3;
        long l4 = this.size();
        RandomAccessFileDataSource.checkChunkValid(l, l2, l4);
        if (l2 == 0L) {
            return;
        }
        long l5 = this.mOffset + l;
        byte[] byArray = new byte[(int)Math.min(l3, 65536L)];
        for (l3 = l2; l3 > 0L; l3 -= (long)n) {
            n = (int)Math.min(l3, (long)byArray.length);
            RandomAccessFile randomAccessFile = this.mFile;
            synchronized (randomAccessFile) {
                this.mFile.seek(l5);
                this.mFile.readFully(byArray, 0, n);
            }
            dataSink.consume(byArray, 0, n);
            l5 += (long)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(long l, int n, ByteBuffer byteBuffer) throws IOException {
        long l2 = this.size();
        RandomAccessFileDataSource.checkChunkValid(l, n, l2);
        if (n == 0) {
            return;
        }
        long l3 = this.mOffset + l;
        int n2 = byteBuffer.limit();
        try {
            int n3;
            byteBuffer.limit(byteBuffer.position() + n);
            FileChannel fileChannel = this.mFile.getChannel();
            for (int i = n; i > 0; i -= n3) {
                RandomAccessFile randomAccessFile = this.mFile;
                synchronized (randomAccessFile) {
                    fileChannel.position(l3);
                    n3 = fileChannel.read(byteBuffer);
                }
                l3 += (long)n3;
            }
        }
        finally {
            byteBuffer.limit(n2);
        }
    }

    @Override
    public ByteBuffer getByteBuffer(long l, int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        this.copyTo(l, n, byteBuffer);
        byteBuffer.flip();
        return byteBuffer;
    }

    private static void checkChunkValid(long l, long l2, long l3) {
        if (l < 0L) {
            throw new IllegalArgumentException("offset: " + l);
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("size: " + l2);
        }
        if (l > l3) {
            throw new IllegalArgumentException("offset (" + l + ") > source size (" + l3 + ")");
        }
        long l4 = l + l2;
        if (l4 < l) {
            throw new IllegalArgumentException("offset (" + l + ") + size (" + l2 + ") overflow");
        }
        if (l4 > l3) {
            throw new IllegalArgumentException("offset (" + l + ") + size (" + l2 + ") > source size (" + l3 + ")");
        }
    }
}

