/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.zip;

import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.zip.ZipFormatException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;

public class CentralDirectoryRecord {
    public static final Comparator<CentralDirectoryRecord> BY_LOCAL_FILE_HEADER_OFFSET_COMPARATOR = new ByLocalFileHeaderOffsetComparator();
    private static final int RECORD_SIGNATURE = 33639248;
    private static final int HEADER_SIZE_BYTES = 46;
    private static final int LAST_MODIFICATION_TIME_OFFSET = 12;
    private static final int LOCAL_FILE_HEADER_OFFSET_OFFSET = 42;
    private static final int NAME_OFFSET = 46;
    private final ByteBuffer mData;
    private final int mLastModificationTime;
    private final int mLastModificationDate;
    private final long mCrc32;
    private final long mCompressedSize;
    private final long mUncompressedSize;
    private final long mLocalFileHeaderOffset;
    private final String mName;
    private final int mNameSizeBytes;

    private CentralDirectoryRecord(ByteBuffer byteBuffer, int n, int n2, long l, long l2, long l3, long l4, String string, int n3) {
        this.mData = byteBuffer;
        this.mLastModificationDate = n2;
        this.mLastModificationTime = n;
        this.mCrc32 = l;
        this.mCompressedSize = l2;
        this.mUncompressedSize = l3;
        this.mLocalFileHeaderOffset = l4;
        this.mName = string;
        this.mNameSizeBytes = n3;
    }

    public int getSize() {
        return this.mData.remaining();
    }

    public String getName() {
        return this.mName;
    }

    public int getNameSizeBytes() {
        return this.mNameSizeBytes;
    }

    public int getLastModificationTime() {
        return this.mLastModificationTime;
    }

    public int getLastModificationDate() {
        return this.mLastModificationDate;
    }

    public long getCrc32() {
        return this.mCrc32;
    }

    public long getCompressedSize() {
        return this.mCompressedSize;
    }

    public long getUncompressedSize() {
        return this.mUncompressedSize;
    }

    public long getLocalFileHeaderOffset() {
        return this.mLocalFileHeaderOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CentralDirectoryRecord getRecord(ByteBuffer byteBuffer) throws ZipFormatException {
        ByteBuffer byteBuffer2;
        ZipUtils.assertByteOrderLittleEndian(byteBuffer);
        if (byteBuffer.remaining() < 46) {
            throw new ZipFormatException("Input too short. Need at least: 46 bytes, available: " + byteBuffer.remaining() + " bytes", new BufferUnderflowException());
        }
        int n = byteBuffer.position();
        int n2 = byteBuffer.getInt();
        if (n2 != 33639248) {
            throw new ZipFormatException("Not a Central Directory record. Signature: 0x" + Long.toHexString((long)n2 & 0xFFFFFFFFL));
        }
        byteBuffer.position(n + 12);
        int n3 = ZipUtils.getUnsignedInt16(byteBuffer);
        int n4 = ZipUtils.getUnsignedInt16(byteBuffer);
        long l = ZipUtils.getUnsignedInt32(byteBuffer);
        long l2 = ZipUtils.getUnsignedInt32(byteBuffer);
        long l3 = ZipUtils.getUnsignedInt32(byteBuffer);
        int n5 = ZipUtils.getUnsignedInt16(byteBuffer);
        int n6 = ZipUtils.getUnsignedInt16(byteBuffer);
        int n7 = ZipUtils.getUnsignedInt16(byteBuffer);
        byteBuffer.position(n + 42);
        long l4 = ZipUtils.getUnsignedInt32(byteBuffer);
        byteBuffer.position(n);
        int n8 = 46 + n5 + n6 + n7;
        if (n8 > byteBuffer.remaining()) {
            throw new ZipFormatException("Input too short. Need: " + n8 + " bytes, available: " + byteBuffer.remaining() + " bytes", new BufferUnderflowException());
        }
        String string = CentralDirectoryRecord.getName(byteBuffer, n + 46, n5);
        byteBuffer.position(n);
        int n9 = byteBuffer.limit();
        int n10 = n + n8;
        try {
            byteBuffer.limit(n10);
            byteBuffer2 = byteBuffer.slice();
        }
        finally {
            byteBuffer.limit(n9);
        }
        byteBuffer.position(n10);
        return new CentralDirectoryRecord(byteBuffer2, n3, n4, l, l2, l3, l4, string, n5);
    }

    public void copyTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.mData.slice());
    }

    public CentralDirectoryRecord createWithModifiedLocalFileHeaderOffset(long l) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.mData.remaining());
        byteBuffer.put(this.mData.slice());
        byteBuffer.flip();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ZipUtils.setUnsignedInt32(byteBuffer, 42, l);
        return new CentralDirectoryRecord(byteBuffer, this.mLastModificationTime, this.mLastModificationDate, this.mCrc32, this.mCompressedSize, this.mUncompressedSize, l, this.mName, this.mNameSizeBytes);
    }

    public static CentralDirectoryRecord createWithDeflateCompressedData(String string, int n, int n2, long l, long l2, long l3, long l4) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        int n3 = 46 + byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(33639248);
        ZipUtils.putUnsignedInt16(byteBuffer, 20);
        ZipUtils.putUnsignedInt16(byteBuffer, 20);
        byteBuffer.putShort((short)2048);
        byteBuffer.putShort((short)8);
        ZipUtils.putUnsignedInt16(byteBuffer, n);
        ZipUtils.putUnsignedInt16(byteBuffer, n2);
        ZipUtils.putUnsignedInt32(byteBuffer, l);
        ZipUtils.putUnsignedInt32(byteBuffer, l2);
        ZipUtils.putUnsignedInt32(byteBuffer, l3);
        ZipUtils.putUnsignedInt16(byteBuffer, byArray.length);
        ZipUtils.putUnsignedInt16(byteBuffer, 0);
        ZipUtils.putUnsignedInt16(byteBuffer, 0);
        ZipUtils.putUnsignedInt16(byteBuffer, 0);
        ZipUtils.putUnsignedInt16(byteBuffer, 0);
        ZipUtils.putUnsignedInt32(byteBuffer, 0L);
        ZipUtils.putUnsignedInt32(byteBuffer, l4);
        byteBuffer.put(byArray);
        if (byteBuffer.hasRemaining()) {
            throw new RuntimeException("pos: " + byteBuffer.position() + ", limit: " + byteBuffer.limit());
        }
        byteBuffer.flip();
        return new CentralDirectoryRecord(byteBuffer, n, n2, l, l2, l3, l4, string, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getName(ByteBuffer byteBuffer, int n, int n2) {
        int n3;
        byte[] byArray;
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
            n3 = byteBuffer.arrayOffset() + n;
        } else {
            byArray = new byte[n2];
            n3 = 0;
            int n4 = byteBuffer.position();
            try {
                byteBuffer.position(n);
                byteBuffer.get(byArray);
            }
            finally {
                byteBuffer.position(n4);
            }
        }
        return new String(byArray, n3, n2, StandardCharsets.UTF_8);
    }

    private static class ByLocalFileHeaderOffsetComparator
    implements Comparator<CentralDirectoryRecord> {
        private ByLocalFileHeaderOffsetComparator() {
        }

        @Override
        public int compare(CentralDirectoryRecord centralDirectoryRecord, CentralDirectoryRecord centralDirectoryRecord2) {
            long l;
            long l2 = centralDirectoryRecord.getLocalFileHeaderOffset();
            if (l2 > (l = centralDirectoryRecord2.getLocalFileHeaderOffset())) {
                return 1;
            }
            if (l2 < l) {
                return -1;
            }
            return 0;
        }
    }
}

