/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksigner;

import com.android.apksig.ApkVerifier;
import com.android.apksigner.AndroidBinXmlParser;
import com.android.apksigner.HexEncoding;
import com.android.apksigner.OptionsParser;
import com.android.apksigner.PasswordRetriever;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class ApkSignerTool {
    private static final String VERSION = "0.0.0";
    private static final String HELP_PAGE_GENERAL = "help.txt";
    private static final String HELP_PAGE_SIGN = "help_sign.txt";
    private static final String HELP_PAGE_VERIFY = "help_verify.txt";

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0 || "--help".equals(stringArray[0]) || "-h".equals(stringArray[0])) {
            ApkSignerTool.printUsage(HELP_PAGE_GENERAL);
            return;
        }
        if ("--version".equals(stringArray[0])) {
            System.out.println(VERSION);
            return;
        }
        String string = stringArray[0];
        try {
            if ("sign".equals(string)) {
                ApkSignerTool.sign(Arrays.copyOfRange(stringArray, 1, stringArray.length));
                return;
            }
            if ("verify".equals(string)) {
                ApkSignerTool.verify(Arrays.copyOfRange(stringArray, 1, stringArray.length));
                return;
            }
            if ("help".equals(string)) {
                ApkSignerTool.printUsage(HELP_PAGE_GENERAL);
                return;
            }
            if ("version".equals(string)) {
                System.out.println(VERSION);
                return;
            }
            throw new ParameterException("Unsupported command: " + string + ". See --help for supported commands");
        }
        catch (ParameterException | OptionsParser.OptionsException exception) {
            System.err.println(exception.getMessage());
            System.exit(1);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private static void sign(String[] var0) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void verify(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Object object3;
        String string;
        if (stringArray.length == 0) {
            ApkSignerTool.printUsage(HELP_PAGE_VERIFY);
            return;
        }
        int n = 1;
        boolean bl = false;
        int n2 = Integer.MAX_VALUE;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        OptionsParser optionsParser = new OptionsParser(stringArray);
        while ((string = optionsParser.nextOption()) != null) {
            object3 = optionsParser.getOptionOriginalForm();
            if ("min-sdk-version".equals(string)) {
                n = optionsParser.getRequiredIntValue("Mininimum API Level");
                bl = true;
                continue;
            }
            if ("max-sdk-version".equals(string)) {
                n2 = optionsParser.getRequiredIntValue("Maximum API Level");
                continue;
            }
            if ("print-certs".equals(string)) {
                bl2 = optionsParser.getOptionalBooleanValue(true);
                continue;
            }
            if ("v".equals(string) || "verbose".equals(string)) {
                bl3 = optionsParser.getOptionalBooleanValue(true);
                continue;
            }
            if ("Werr".equals(string)) {
                bl4 = optionsParser.getOptionalBooleanValue(true);
                continue;
            }
            if ("help".equals(string) || "h".equals(string)) {
                ApkSignerTool.printUsage(HELP_PAGE_VERIFY);
                return;
            }
            throw new ParameterException("Unsupported option: " + (String)object3 + ". See --help for supported" + " options.");
        }
        stringArray = optionsParser.getRemainingParams();
        if (stringArray.length < 1) {
            throw new ParameterException("Missing APK");
        }
        if (stringArray.length > 1) {
            throw new ParameterException("Unexpected parameter(s) after APK (" + stringArray[0] + ")");
        }
        object3 = new File(stringArray[0]);
        if (!bl) {
            try {
                n = ApkSignerTool.getMinSdkVersionFromAndroidManifest((File)object3);
            }
            catch (AndroidBinXmlParser.XmlParserException | IOException exception) {
                throw new IOException("Failed to deduce Min API Level from APK's AndroidManifest.xml. Use --min-sdk-version to override.", exception);
            }
        }
        if (n > n2) {
            throw new ParameterException("Min API Level (" + n + ") > max API Level (" + n2 + ")");
        }
        ApkVerifier.Result result = new ApkVerifier.Builder((File)object3).setCheckedPlatformVersions(n, n2).build().verify();
        boolean bl5 = result.isVerified();
        boolean bl6 = false;
        if (bl5) {
            object2 = result.getSignerCertificates();
            if (bl3) {
                System.out.println("Verifies");
                System.out.println("Verified using v1 scheme (JAR signing): " + result.isVerifiedUsingV1Scheme());
                System.out.println("Verified using v2 scheme (APK Signature Scheme v2): " + result.isVerifiedUsingV2Scheme());
                System.out.println("Number of signers: " + object2.size());
            }
            if (bl2) {
                int n3 = 0;
                MessageDigest object4 = MessageDigest.getInstance("SHA-256");
                object = MessageDigest.getInstance("SHA-1");
                Iterator<Object> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object object5;
                    X509Certificate x509Certificate = (X509Certificate)iterator.next();
                    System.out.println("Signer #" + ++n3 + " certificate DN" + ": " + x509Certificate.getSubjectDN());
                    byte[] byArray = x509Certificate.getEncoded();
                    System.out.println("Signer #" + n3 + " certificate SHA-256 digest: " + HexEncoding.encode(object4.digest(byArray)));
                    System.out.println("Signer #" + n3 + " certificate SHA-1 digest: " + HexEncoding.encode(((MessageDigest)object).digest(byArray)));
                    if (!bl3) continue;
                    PublicKey publicKey = x509Certificate.getPublicKey();
                    System.out.println("Signer #" + n3 + " key algorithm: " + publicKey.getAlgorithm());
                    int n4 = -1;
                    if (publicKey instanceof RSAKey) {
                        n4 = ((RSAKey)((Object)publicKey)).getModulus().bitLength();
                    } else if (publicKey instanceof ECKey) {
                        n4 = ((ECKey)((Object)publicKey)).getParams().getOrder().bitLength();
                    } else if (publicKey instanceof DSAKey && (object5 = ((DSAKey)((Object)publicKey)).getParams()) != null) {
                        n4 = object5.getP().bitLength();
                    }
                    System.out.println("Signer #" + n3 + " key size (bits): " + (n4 != -1 ? String.valueOf(n4) : "n/a"));
                    object5 = publicKey.getEncoded();
                    System.out.println("Signer #" + n3 + " public key SHA-256 digest: " + HexEncoding.encode(object4.digest((byte[])object5)));
                    System.out.println("Signer #" + n3 + " public key SHA-1 digest: " + HexEncoding.encode(((MessageDigest)object).digest((byte[])object5)));
                }
            }
        } else {
            System.err.println("DOES NOT VERIFY");
        }
        for (ApkVerifier.IssueWithParams issueWithParams : result.getErrors()) {
            System.err.println("ERROR: " + issueWithParams);
        }
        object2 = bl4 ? System.err : System.out;
        for (ApkVerifier.IssueWithParams issueWithParams : result.getWarnings()) {
            bl6 = true;
            ((PrintStream)object2).println("WARNING: " + issueWithParams);
        }
        for (ApkVerifier.Result.V1SchemeSignerInfo v1SchemeSignerInfo : result.getV1SchemeSigners()) {
            object = v1SchemeSignerInfo.getName();
            for (ApkVerifier.IssueWithParams issueWithParams : v1SchemeSignerInfo.getErrors()) {
                System.err.println("ERROR: JAR signer " + (String)object + ": " + issueWithParams);
            }
            for (ApkVerifier.IssueWithParams issueWithParams : v1SchemeSignerInfo.getWarnings()) {
                bl6 = true;
                ((PrintStream)object2).println("WARNING: JAR signer " + (String)object + ": " + issueWithParams);
            }
        }
        for (ApkVerifier.Result.V2SchemeSignerInfo v2SchemeSignerInfo : result.getV2SchemeSigners()) {
            object = "signer #" + (v2SchemeSignerInfo.getIndex() + 1);
            for (ApkVerifier.IssueWithParams issueWithParams : v2SchemeSignerInfo.getErrors()) {
                System.err.println("ERROR: APK Signature Scheme v2 " + (String)object + ": " + issueWithParams);
            }
            for (ApkVerifier.IssueWithParams issueWithParams : v2SchemeSignerInfo.getWarnings()) {
                bl6 = true;
                ((PrintStream)object2).println("WARNING: APK Signature Scheme v2 " + (String)object + ": " + issueWithParams);
            }
        }
        if (!bl5) {
            System.exit(1);
            return;
        }
        if (bl4 && bl6) {
            System.exit(1);
            return;
        }
    }

    private static void printUsage(String string) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ApkSignerTool.class.getResourceAsStream(string), StandardCharsets.UTF_8));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                System.out.println(string2);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to read " + string + " resource");
        }
    }

    private static int getMinSdkVersionFromAndroidManifest(File file) throws IOException, AndroidBinXmlParser.XmlParserException, ParameterException {
        ByteBuffer byteBuffer;
        ZipFile zipFile = new ZipFile(file);
        Object object = null;
        try {
            ZipEntry zipEntry = zipFile.getEntry("AndroidManifest.xml");
            if (zipEntry == null) {
                throw new ParameterException("Failed to deduce min API Level: APK does not contain AndroidManifest.xml. Please specify --min-sdk-version.");
            }
            long l = zipEntry.getSize();
            if (l > Integer.MAX_VALUE) {
                throw new IOException(zipEntry.getName() + " too large: " + l + " bytes");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)l);
            try (Object object2 = zipFile.getInputStream(zipEntry);){
                ApkSignerTool.drain((InputStream)object2, byteArrayOutputStream);
            }
            object2 = byteArrayOutputStream.toByteArray();
            byteBuffer = ByteBuffer.wrap((byte[])object2);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (zipFile != null) {
                if (object != null) {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    zipFile.close();
                }
            }
        }
        int n = 1;
        object = new AndroidBinXmlParser(byteBuffer);
        int n2 = ((AndroidBinXmlParser)object).getEventType();
        while (n2 != 2) {
            if (n2 == 3 && ((AndroidBinXmlParser)object).getDepth() == 2 && "uses-sdk".equals(((AndroidBinXmlParser)object).getName()) && ((AndroidBinXmlParser)object).getNamespace().isEmpty()) {
                int n3 = 1;
                block23: for (int i = 0; i < ((AndroidBinXmlParser)object).getAttributeCount(); ++i) {
                    if (!"minSdkVersion".equals(((AndroidBinXmlParser)object).getAttributeName(i)) || !"http://schemas.android.com/apk/res/android".equals(((AndroidBinXmlParser)object).getAttributeNamespace(i))) continue;
                    int n4 = ((AndroidBinXmlParser)object).getAttributeValueType(i);
                    switch (n4) {
                        case 2: {
                            n3 = ((AndroidBinXmlParser)object).getAttributeIntValue(i);
                            break block23;
                        }
                        case 1: {
                            throw new ParameterException("Codenames in AndroidManifest.xml's minSdkVersion not supported. Use --min-sdk-version to override.");
                        }
                        default: {
                            throw new ParameterException("Unsupported value type in AndroidManifest.xml's minSdkVersion. Only numeric values supported. Use --min-sdk-version to override.");
                        }
                    }
                }
                n = Math.max(n, n3);
            }
            n2 = ((AndroidBinXmlParser)object).next();
        }
        return n;
    }

    private static byte[] readFully(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ApkSignerTool.drain(fileInputStream, byteArrayOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static void drain(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    private static class ParameterException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ParameterException(String string) {
            super(string);
        }
    }

    private static class SignerParams {
        String name;
        String keystoreFile;
        String keystoreKeyAlias;
        String keystorePasswordSpec;
        String keyPasswordSpec;
        String keystoreType;
        String keystoreProviderName;
        String keystoreProviderClass;
        String keystoreProviderArg;
        String keyFile;
        String certFile;
        String v1SigFileBasename;
        PrivateKey privateKey;
        List<X509Certificate> certs;

        private SignerParams() {
        }

        private boolean isEmpty() {
            return this.name == null && this.keystoreFile == null && this.keystoreKeyAlias == null && this.keystorePasswordSpec == null && this.keyPasswordSpec == null && this.keystoreType == null && this.keystoreProviderName == null && this.keystoreProviderClass == null && this.keystoreProviderArg == null && this.keyFile == null && this.certFile == null && this.v1SigFileBasename == null && this.privateKey == null && this.certs == null;
        }

        private void loadPrivateKeyAndCerts(PasswordRetriever passwordRetriever) throws Exception {
            if (this.keystoreFile != null) {
                if (this.keyFile != null) {
                    throw new ParameterException("--ks and --key may not be specified at the same time");
                }
                if (this.certFile != null) {
                    throw new ParameterException("--ks and --cert may not be specified at the same time");
                }
                this.loadPrivateKeyAndCertsFromKeyStore(passwordRetriever);
            } else if (this.keyFile != null) {
                this.loadPrivateKeyAndCertsFromFiles(passwordRetriever);
            } else {
                throw new ParameterException("KeyStore (--ks) or private key file (--key) must be specified");
            }
        }

        private void loadPrivateKeyAndCertsFromKeyStore(PasswordRetriever passwordRetriever) throws Exception {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Class<?> clazz;
            KeyStore keyStore;
            String string;
            if (this.keystoreFile == null) {
                throw new ParameterException("KeyStore (--ks) must be specified");
            }
            String string2 = string = this.keystoreType != null ? this.keystoreType : KeyStore.getDefaultType();
            if (this.keystoreProviderName != null) {
                keyStore = KeyStore.getInstance(string, this.keystoreProviderName);
            } else if (this.keystoreProviderClass != null) {
                clazz = Class.forName(this.keystoreProviderClass);
                if (!Provider.class.isAssignableFrom(clazz)) {
                    throw new ParameterException("Keystore Provider class " + this.keystoreProviderClass + " not subclass of " + Provider.class.getName());
                }
                Provider provider = this.keystoreProviderArg != null ? (Provider)clazz.getConstructor(String.class).newInstance(this.keystoreProviderArg) : (Provider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                keyStore = KeyStore.getInstance(string, provider);
            } else {
                keyStore = KeyStore.getInstance(string);
            }
            clazz = null;
            if ("NONE".equals(this.keystoreFile)) {
                keyStore.load(null);
            } else {
                boolean bl = false;
                if (this.keystorePasswordSpec == null) {
                    try {
                        object4 = new FileInputStream(this.keystoreFile);
                        object3 = null;
                        try {
                            keyStore.load((InputStream)object4, null);
                            bl = true;
                        }
                        catch (Throwable throwable) {
                            object3 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (object4 != null) {
                                if (object3 != null) {
                                    try {
                                        ((FileInputStream)object4).close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object3).addSuppressed(throwable);
                                    }
                                } else {
                                    ((FileInputStream)object4).close();
                                }
                            }
                        }
                    }
                    catch (IOException iOException) {
                        if (iOException.getCause() instanceof UnrecoverableKeyException) {
                            bl = false;
                        }
                        throw iOException;
                    }
                }
                if (!bl) {
                    object4 = this.keystorePasswordSpec != null ? this.keystorePasswordSpec : "stdin";
                    object3 = passwordRetriever.getPassword((String)object4, "Keystore password for " + this.name);
                    clazz = (Class<?>)((String)object3).toCharArray();
                    object2 = new FileInputStream(this.keystoreFile);
                    object = null;
                    try {
                        keyStore.load((InputStream)object2, (char[])clazz);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object2 != null) {
                            if (object != null) {
                                try {
                                    ((FileInputStream)object2).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                ((FileInputStream)object2).close();
                            }
                        }
                    }
                }
            }
            Object object5 = this.keyPasswordSpec == null ? clazz : (Object)passwordRetriever.getPassword(this.keyPasswordSpec, "Key password for " + this.name).toCharArray();
            object4 = null;
            object3 = null;
            try {
                if (this.keystoreKeyAlias == null) {
                    object2 = keyStore.aliases();
                    if (object2 != null) {
                        while (object2.hasMoreElements()) {
                            object = object2.nextElement();
                            if (!keyStore.isKeyEntry((String)object)) continue;
                            object4 = object;
                            if (this.keystoreKeyAlias != null) {
                                throw new ParameterException(this.keystoreFile + " contains multiple key entries" + ". --ks-key-alias option must be used to specify" + " which entry to use.");
                            }
                            this.keystoreKeyAlias = object4;
                        }
                    }
                    if (this.keystoreKeyAlias == null) {
                        throw new ParameterException(this.keystoreFile + " does not contain key entries");
                    }
                }
                if (!keyStore.isKeyEntry((String)(object4 = this.keystoreKeyAlias))) {
                    throw new ParameterException(this.keystoreFile + " entry \"" + (String)object4 + "\" does not contain a key");
                }
                if (object5 != null) {
                    object2 = keyStore.getKey((String)object4, (char[])object5);
                } else {
                    try {
                        object2 = keyStore.getKey((String)object4, null);
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                        object5 = passwordRetriever.getPassword("stdin", "Password for key with alias \"" + (String)object4 + "\"").toCharArray();
                        object2 = keyStore.getKey((String)object4, (char[])object5);
                    }
                }
                if (object2 == null) {
                    throw new ParameterException(this.keystoreFile + " entry \"" + (String)object4 + "\" does not contain a key");
                }
                if (!(object2 instanceof PrivateKey)) {
                    throw new ParameterException(this.keystoreFile + " entry \"" + (String)object4 + "\" does not contain a private" + " key. It contains a key of algorithm: " + object2.getAlgorithm());
                }
                object3 = (PrivateKey)object2;
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw new IOException("Failed to obtain key with alias \"" + (String)object4 + "\" from " + this.keystoreFile + ". Wrong password?", unrecoverableKeyException);
            }
            this.privateKey = object3;
            object2 = keyStore.getCertificateChain((String)object4);
            if (object2 == null || ((Certificate[])object2).length == 0) {
                throw new ParameterException(this.keystoreFile + " entry \"" + (String)object4 + "\" does not contain certificates");
            }
            this.certs = new ArrayList<X509Certificate>(((Object)object2).length);
            for (Object object6 : object2) {
                this.certs.add((X509Certificate)object6);
            }
        }

        private void loadPrivateKeyAndCertsFromFiles(PasswordRetriever passwordRetriever) throws Exception {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec;
            Object object;
            Iterator iterator;
            ArrayList<X509Certificate> arrayList;
            Object object2;
            if (this.keyFile == null) {
                throw new ParameterException("Private key file (--key) must be specified");
            }
            if (this.certFile == null) {
                throw new ParameterException("Certificate file (--cert) must be specified");
            }
            byte[] byArray = ApkSignerTool.readFully(new File(this.keyFile));
            try {
                object2 = new EncryptedPrivateKeyInfo(byArray);
                arrayList = this.keyPasswordSpec != null ? this.keyPasswordSpec : "stdin";
                iterator = passwordRetriever.getPassword((String)((Object)arrayList), "Private key password for " + this.name);
                object = new PBEKeySpec(((String)((Object)iterator)).toCharArray());
                SecretKey secretKey = SecretKeyFactory.getInstance(((EncryptedPrivateKeyInfo)object2).getAlgName()).generateSecret((KeySpec)object);
                pKCS8EncodedKeySpec = ((EncryptedPrivateKeyInfo)object2).getKeySpec(secretKey);
            }
            catch (IOException iOException) {
                if (this.keyPasswordSpec == null) {
                    pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                }
                throw new InvalidKeySpecException("Failed to parse encrypted private key blob " + this.keyFile, iOException);
            }
            try {
                this.privateKey = SignerParams.loadPkcs8EncodedPrivateKey(pKCS8EncodedKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeySpecException("Failed to load PKCS #8 encoded private key from " + this.keyFile, invalidKeySpecException);
            }
            arrayList = new FileInputStream(this.certFile);
            iterator = null;
            try {
                object2 = CertificateFactory.getInstance("X.509").generateCertificates((InputStream)((Object)arrayList));
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (arrayList != null) {
                    if (iterator != null) {
                        try {
                            ((FileInputStream)((Object)arrayList)).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        ((FileInputStream)((Object)arrayList)).close();
                    }
                }
            }
            arrayList = new ArrayList<X509Certificate>(object2.size());
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Certificate)iterator.next();
                arrayList.add((X509Certificate)object);
            }
            this.certs = arrayList;
        }

        private static PrivateKey loadPkcs8EncodedPrivateKey(PKCS8EncodedKeySpec pKCS8EncodedKeySpec) throws InvalidKeySpecException, NoSuchAlgorithmException {
            try {
                return KeyFactory.getInstance("RSA").generatePrivate(pKCS8EncodedKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                try {
                    return KeyFactory.getInstance("EC").generatePrivate(pKCS8EncodedKeySpec);
                }
                catch (InvalidKeySpecException invalidKeySpecException2) {
                    try {
                        return KeyFactory.getInstance("DSA").generatePrivate(pKCS8EncodedKeySpec);
                    }
                    catch (InvalidKeySpecException invalidKeySpecException3) {
                        throw new InvalidKeySpecException("Not an RSA, EC, or DSA private key");
                    }
                }
            }
        }

        static /* synthetic */ boolean access$100(SignerParams signerParams) {
            return signerParams.isEmpty();
        }

        static /* synthetic */ void access$200(SignerParams signerParams, PasswordRetriever passwordRetriever) throws Exception {
            signerParams.loadPrivateKeyAndCerts(passwordRetriever);
        }
    }
}

