/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksigner;

import java.util.Arrays;

class OptionsParser {
    private final String[] mParams;
    private int mIndex;
    private String mLastOptionValue;
    private String mLastOptionOriginalForm;

    public OptionsParser(String[] stringArray) {
        this.mParams = (String[])stringArray.clone();
    }

    public String nextOption() {
        if (this.mIndex >= this.mParams.length) {
            return null;
        }
        String string = this.mParams[this.mIndex];
        if (!string.startsWith("-")) {
            return null;
        }
        ++this.mIndex;
        this.mLastOptionOriginalForm = string;
        this.mLastOptionValue = null;
        if (string.startsWith("--")) {
            if ("--".equals(string)) {
                return null;
            }
            int n = string.indexOf(61);
            if (n != -1) {
                this.mLastOptionValue = string.substring(n + 1);
                this.mLastOptionOriginalForm = string.substring(0, n);
                return string.substring("--".length(), n);
            }
            return string.substring("--".length());
        }
        return string.substring("-".length());
    }

    public String getOptionOriginalForm() {
        return this.mLastOptionOriginalForm;
    }

    public String getRequiredValue(String string) throws OptionsException {
        if (this.mLastOptionValue != null) {
            String string2 = this.mLastOptionValue;
            this.mLastOptionValue = null;
            return string2;
        }
        if (this.mIndex >= this.mParams.length) {
            throw new OptionsException(string + " missing after " + this.mLastOptionOriginalForm);
        }
        String string3 = this.mParams[this.mIndex];
        if ("--".equals(string3)) {
            throw new OptionsException(string + " missing after " + this.mLastOptionOriginalForm);
        }
        ++this.mIndex;
        return string3;
    }

    public int getRequiredIntValue(String string) throws OptionsException {
        String string2 = this.getRequiredValue(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OptionsException(string + " (" + this.mLastOptionOriginalForm + ") must be a decimal number: " + string2);
        }
    }

    public boolean getOptionalBooleanValue(boolean bl) throws OptionsException {
        if (this.mLastOptionValue != null) {
            String string = this.mLastOptionValue;
            this.mLastOptionValue = null;
            if ("true".equals(string)) {
                return true;
            }
            if ("false".equals(string)) {
                return false;
            }
            throw new OptionsException("Unsupported value for " + this.mLastOptionOriginalForm + ": " + string + ". Only true or false supported.");
        }
        if (this.mIndex >= this.mParams.length) {
            return bl;
        }
        String string = this.mParams[this.mIndex];
        if ("true".equals(string)) {
            ++this.mIndex;
            return true;
        }
        if ("false".equals(string)) {
            ++this.mIndex;
            return false;
        }
        return bl;
    }

    public String[] getRemainingParams() {
        if (this.mIndex >= this.mParams.length) {
            return new String[0];
        }
        String string = this.mParams[this.mIndex];
        if ("--".equals(string)) {
            return Arrays.copyOfRange(this.mParams, this.mIndex + 1, this.mParams.length);
        }
        return Arrays.copyOfRange(this.mParams, this.mIndex, this.mParams.length);
    }

    public static class OptionsException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public OptionsException(String string) {
            super(string);
        }
    }
}

