/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CacheContext;
import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.client.CacheInvalidationListener;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;
import java.security.Permission;

public class CacheAddInvalidationListenerRequest
extends CallableClientRequest
implements RetryableRequest {
    private String name;

    public CacheAddInvalidationListenerRequest() {
    }

    public CacheAddInvalidationListenerRequest(String name) {
        this.name = name;
    }

    public Object call() {
        ClientEndpoint endpoint = this.getEndpoint();
        CacheService cacheService = (CacheService)this.getService();
        CacheContext cacheContext = cacheService.getOrCreateCacheContext(this.name);
        CacheInvalidationListener listener = new CacheInvalidationListener(endpoint, this.getCallId(), cacheContext);
        String registrationId = cacheService.addInvalidationListener(this.name, listener);
        endpoint.addListenerDestroyAction("hz:impl:cacheService", this.name, registrationId);
        return registrationId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 12;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("n");
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

