/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.operation.AbstractMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.ReadonlyOperation;
import java.io.IOException;

public class PartitionCheckIfLoadedOperation
extends AbstractMapOperation
implements PartitionAwareOperation,
ReadonlyOperation {
    private boolean isFinished;
    private boolean doLoad;
    private boolean waitForKeyLoad;

    public PartitionCheckIfLoadedOperation() {
    }

    public PartitionCheckIfLoadedOperation(String name) {
        super(name);
    }

    public PartitionCheckIfLoadedOperation(String name, boolean doLoad) {
        super(name);
        this.doLoad = doLoad;
    }

    public PartitionCheckIfLoadedOperation(String name, boolean doLoad, boolean waitForKeyLoad) {
        super(name);
        this.doLoad = doLoad;
        this.waitForKeyLoad = waitForKeyLoad;
    }

    @Override
    public void run() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        RecordStore recordStore = mapServiceContext.getRecordStore(this.getPartitionId(), this.name);
        this.isFinished = recordStore.isLoaded();
        if (this.doLoad) {
            recordStore.maybeDoInitialLoad();
        }
        if (this.waitForKeyLoad) {
            recordStore.onKeyLoad(new CallbackResponseSender());
        }
    }

    @Override
    public Object getResponse() {
        return this.isFinished;
    }

    @Override
    public boolean returnsResponse() {
        return !this.waitForKeyLoad;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.doLoad);
        out.writeBoolean(this.waitForKeyLoad);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.doLoad = in.readBoolean();
        this.waitForKeyLoad = in.readBoolean();
    }

    private class CallbackResponseSender
    implements ExecutionCallback<Boolean> {
        private CallbackResponseSender() {
        }

        @Override
        public void onResponse(Boolean response) {
            PartitionCheckIfLoadedOperation.this.getResponseHandler().sendResponse(response);
        }

        @Override
        public void onFailure(Throwable error) {
            PartitionCheckIfLoadedOperation.this.getResponseHandler().sendResponse(error);
        }
    }
}

