/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.Logger;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.QuickMath;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class UTFEncoderDecoder {
    private static final int STRING_CHUNK_SIZE = 16384;
    private static final UTFEncoderDecoder INSTANCE;
    private static final boolean ASCII_AWARE;
    private final StringCreator stringCreator;
    private final UtfWriter utfWriter;
    private final boolean hazelcastEnterpriseActive;

    UTFEncoderDecoder(StringCreator stringCreator, UtfWriter utfWriter) {
        this(stringCreator, utfWriter, false);
    }

    UTFEncoderDecoder(StringCreator stringCreator, UtfWriter utfWriter, boolean hazelcastEnterpriseActive) {
        this.stringCreator = stringCreator;
        this.utfWriter = utfWriter;
        this.hazelcastEnterpriseActive = hazelcastEnterpriseActive;
    }

    public boolean isHazelcastEnterpriseActive() {
        return this.hazelcastEnterpriseActive;
    }

    public static void writeUTF(DataOutput out, String str, byte[] buffer) throws IOException {
        INSTANCE.writeUTF0(out, str, buffer);
    }

    public static String readUTF(DataInput in, byte[] buffer) throws IOException {
        return INSTANCE.readUTF0(in, buffer);
    }

    public void writeUTF0(DataOutput out, String str, byte[] buffer) throws IOException {
        if (!QuickMath.isPowerOfTwo(buffer.length)) {
            throw new IllegalArgumentException("Size of the buffer has to be power of two, was " + buffer.length);
        }
        boolean isNull = str == null;
        out.writeBoolean(isNull);
        if (isNull) {
            return;
        }
        int length = str.length();
        out.writeInt(length);
        out.writeInt(length);
        if (length > 0) {
            int chunkSize = length / 16384 + 1;
            for (int i = 0; i < chunkSize; ++i) {
                int beginIndex = Math.max(0, i * 16384 - 1);
                int endIndex = Math.min((i + 1) * 16384 - 1, length);
                this.utfWriter.writeShortUTF(out, str, beginIndex, endIndex, buffer);
            }
        }
    }

    public String readUTF0(DataInput in, byte[] buffer) throws IOException {
        int lengthCheck;
        if (!QuickMath.isPowerOfTwo(buffer.length)) {
            throw new IllegalArgumentException("Size of the buffer has to be power of two, was " + buffer.length);
        }
        boolean isNull = in.readBoolean();
        if (isNull) {
            return null;
        }
        int length = in.readInt();
        if (length != (lengthCheck = in.readInt())) {
            throw new UTFDataFormatException("Length check failed, maybe broken bytestream or wrong stream position");
        }
        char[] data = new char[length];
        if (length > 0) {
            int chunkSize = length / 16384 + 1;
            for (int i = 0; i < chunkSize; ++i) {
                int beginIndex = Math.max(0, i * 16384 - 1);
                this.readShortUTF(in, data, beginIndex, buffer);
            }
        }
        return this.stringCreator.buildString(data);
    }

    private void readShortUTF(DataInput in, char[] data, int beginIndex, byte[] buffer) throws IOException {
        int utfLength = in.readShort() & 0xFFFF;
        boolean allAscii = ASCII_AWARE ? in.readBoolean() : false;
        int minUtfLenght = Math.min(utfLength, buffer.length - 1);
        int bufferLimit = minUtfLenght + 1;
        int readCount = 0;
        int bufferPos = 1;
        int c1 = 0;
        int c2 = 0;
        int c3 = 0;
        int cTemp = 0;
        int charArrCount = beginIndex;
        in.readFully(buffer, 1, minUtfLenght);
        if (allAscii) {
            while (bufferPos != bufferLimit) {
                data[charArrCount++] = (char)(buffer[bufferPos++] & 0xFF);
            }
            for (readCount = bufferPos - 1; readCount < utfLength; ++readCount) {
                bufferPos = this.buffered(buffer, bufferPos, utfLength, readCount, in);
                data[charArrCount++] = (char)(buffer[0] & 0xFF);
            }
        } else {
            c1 = buffer[bufferPos++] & 0xFF;
            while (bufferPos != bufferLimit && c1 <= 127) {
                data[charArrCount++] = (char)c1;
                c1 = buffer[bufferPos++] & 0xFF;
            }
            readCount = --bufferPos - 1;
            while (readCount < utfLength) {
                bufferPos = this.buffered(buffer, bufferPos, utfLength, readCount++, in);
                c1 = buffer[0] & 0xFF;
                cTemp = c1 >> 4;
                if (cTemp >> 3 == 0) {
                    data[charArrCount++] = (char)c1;
                    continue;
                }
                if (cTemp == 12 || cTemp == 13) {
                    if (readCount + 1 > utfLength) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    bufferPos = this.buffered(buffer, bufferPos, utfLength, readCount++, in);
                    c2 = buffer[0] & 0xFF;
                    if ((c2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + beginIndex + readCount + 1);
                    }
                    data[charArrCount++] = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                    continue;
                }
                if (cTemp == 14) {
                    if (readCount + 2 > utfLength) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    bufferPos = this.buffered(buffer, bufferPos, utfLength, readCount++, in);
                    c2 = buffer[0] & 0xFF;
                    bufferPos = this.buffered(buffer, bufferPos, utfLength, readCount++, in);
                    c3 = buffer[0] & 0xFF;
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (beginIndex + readCount + 1));
                    }
                    data[charArrCount++] = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    continue;
                }
                throw new UTFDataFormatException("malformed input around byte " + (beginIndex + readCount));
            }
        }
    }

    private static int calculateUtf8Length(char[] value, int beginIndex, int endIndex) {
        int utfLength = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = value[i];
            if (c <= '\u007f' && c >= '\u0001') {
                ++utfLength;
                continue;
            }
            if (c > '\u07ff') {
                utfLength += 3;
                continue;
            }
            utfLength += 2;
        }
        return utfLength;
    }

    private static int calculateUtf8Length(String str, int beginIndex, int endIndex) {
        int utfLength = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f' && c >= '\u0001') {
                ++utfLength;
                continue;
            }
            if (c > '\u07ff') {
                utfLength += 3;
                continue;
            }
            utfLength += 2;
        }
        return utfLength;
    }

    private static int buffering(byte[] buffer, int pos, byte value, DataOutput out) throws IOException {
        try {
            buffer[pos] = value;
            return pos + 1;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            out.write(buffer, 0, buffer.length);
            buffer[0] = value;
            return 1;
        }
    }

    private int buffered(byte[] buffer, int pos, int utfLength, int readCount, DataInput in) throws IOException {
        try {
            buffer[0] = buffer[pos];
            return pos + 1;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            in.readFully(buffer, 1, Math.min(buffer.length - 1, utfLength - readCount));
            buffer[0] = buffer[1];
            return 2;
        }
    }

    private static boolean useOldStringConstructor() {
        try {
            Class<String> clazz = String.class;
            clazz.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class);
            return true;
        }
        catch (Throwable t) {
            Logger.getLogger(UTFEncoderDecoder.class).finest("Old String constructor doesn't seem available", t);
            return false;
        }
    }

    private static UTFEncoderDecoder buildUTFUtil() {
        UtfWriter utfWriter = UTFEncoderDecoder.createUtfWriter();
        StringCreator stringCreator = UTFEncoderDecoder.createStringCreator();
        return new UTFEncoderDecoder(stringCreator, utfWriter, false);
    }

    static StringCreator createStringCreator() {
        boolean fastStringEnabled = Boolean.parseBoolean(System.getProperty("hazelcast.nio.faststring", "true"));
        return UTFEncoderDecoder.createStringCreator(fastStringEnabled);
    }

    static StringCreator createStringCreator(boolean fastStringEnabled) {
        StringCreator stringCreator;
        StringCreator stringCreator2 = stringCreator = fastStringEnabled ? UTFEncoderDecoder.buildFastStringCreator() : new DefaultStringCreator();
        if (stringCreator == null) {
            stringCreator = new DefaultStringCreator();
        }
        return stringCreator;
    }

    static UtfWriter createUtfWriter() {
        UnsafeBasedCharArrayUtfWriter unsafeBasedUtfWriter = new UnsafeBasedCharArrayUtfWriter();
        if (unsafeBasedUtfWriter.isAvailable()) {
            return unsafeBasedUtfWriter;
        }
        ReflectionBasedCharArrayUtfWriter reflectionBasedUtfWriter = new ReflectionBasedCharArrayUtfWriter();
        if (reflectionBasedUtfWriter.isAvailable()) {
            return reflectionBasedUtfWriter;
        }
        return new StringBasedUtfWriter();
    }

    private static StringCreator buildFastStringCreator() {
        try {
            Constructor<String> constructor = UTFEncoderDecoder.useOldStringConstructor() ? String.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class) : String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            if (constructor != null) {
                constructor.setAccessible(true);
                return new FastStringCreator(constructor);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(UTFEncoderDecoder.class).finest("No fast string creator seems to available, falling back to reflection", t);
        }
        return null;
    }

    static {
        ASCII_AWARE = Boolean.parseBoolean(System.getProperty("hazelcast.nio.asciiaware", "false"));
        INSTANCE = UTFEncoderDecoder.buildUTFUtil();
    }

    private static class FastStringCreator
    implements StringCreator {
        private final Constructor<String> constructor;
        private final boolean useOldStringConstructor;

        public FastStringCreator(Constructor<String> constructor) {
            this.constructor = constructor;
            this.useOldStringConstructor = constructor.getParameterTypes().length == 3;
        }

        @Override
        public String buildString(char[] chars) {
            try {
                if (this.useOldStringConstructor) {
                    return this.constructor.newInstance(0, chars.length, chars);
                }
                return this.constructor.newInstance(chars, Boolean.TRUE);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class DefaultStringCreator
    implements StringCreator {
        private DefaultStringCreator() {
        }

        @Override
        public String buildString(char[] chars) {
            return new String(chars);
        }
    }

    static interface StringCreator {
        public String buildString(char[] var1);
    }

    static class StringBasedUtfWriter
    implements UtfWriter {
        StringBasedUtfWriter() {
        }

        @Override
        public void writeShortUTF(DataOutput out, String str, int beginIndex, int endIndex, byte[] buffer) throws IOException {
            int utfLengthLimit;
            boolean isBufferObjectDataOutput = out instanceof BufferObjectDataOutput;
            BufferObjectDataOutput bufferObjectDataOutput = isBufferObjectDataOutput ? (BufferObjectDataOutput)out : null;
            int bufferPos = 0;
            int utfLength = 0;
            int pos = 0;
            if (isBufferObjectDataOutput) {
                utfLengthLimit = str.length() * 3;
                pos = bufferObjectDataOutput.position();
                bufferObjectDataOutput.writeShort(0);
                if (ASCII_AWARE) {
                    bufferObjectDataOutput.writeBoolean(false);
                }
            } else {
                utfLength = UTFEncoderDecoder.calculateUtf8Length(str, beginIndex, endIndex);
                if (utfLength > 65535) {
                    throw new UTFDataFormatException("encoded string too long:" + utfLength + " bytes");
                }
                utfLengthLimit = utfLength;
                out.writeShort(utfLength);
                if (ASCII_AWARE) {
                    out.writeBoolean(false);
                }
            }
            if (buffer.length >= utfLengthLimit) {
                char c;
                int i;
                for (i = beginIndex; i < endIndex && (c = str.charAt(i)) <= '\u007f' && c >= '\u0001'; ++i) {
                    buffer[bufferPos++] = (byte)c;
                }
                while (i < endIndex) {
                    c = str.charAt(i);
                    if (c >= '\u0001' && c <= '\u007f') {
                        buffer[bufferPos++] = (byte)c;
                    } else if (c > '\u07ff') {
                        buffer[bufferPos++] = (byte)(0xE0 | c >> 12 & 0xF);
                        buffer[bufferPos++] = (byte)(0x80 | c >> 6 & 0x3F);
                        buffer[bufferPos++] = (byte)(0x80 | c & 0x3F);
                    } else {
                        buffer[bufferPos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                        buffer[bufferPos++] = (byte)(0x80 | c & 0x3F);
                    }
                    ++i;
                }
                out.write(buffer, 0, bufferPos);
                if (isBufferObjectDataOutput) {
                    utfLength = bufferPos;
                }
            } else {
                char c;
                int i;
                for (i = beginIndex; i < endIndex && (c = str.charAt(i)) <= '\u007f' && c >= '\u0001'; ++i) {
                    bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)c, out);
                }
                if (isBufferObjectDataOutput) {
                    utfLength = i - beginIndex;
                }
                while (i < endIndex) {
                    c = str.charAt(i);
                    if (c <= '\u007f' && c >= '\u0001') {
                        bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)c, out);
                        if (isBufferObjectDataOutput) {
                            ++utfLength;
                        }
                    } else if (c > '\u07ff') {
                        bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)(0xE0 | c >> 12 & 0xF), out);
                        bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)(0x80 | c >> 6 & 0x3F), out);
                        bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)(0x80 | c & 0x3F), out);
                        if (isBufferObjectDataOutput) {
                            utfLength += 3;
                        }
                    } else {
                        bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)(0xC0 | c >> 6 & 0x1F), out);
                        bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)(0x80 | c & 0x3F), out);
                        if (isBufferObjectDataOutput) {
                            utfLength += 2;
                        }
                    }
                    ++i;
                }
                int length = bufferPos % buffer.length;
                out.write(buffer, 0, length == 0 ? buffer.length : length);
            }
            if (isBufferObjectDataOutput) {
                if (utfLength > 65535) {
                    throw new UTFDataFormatException("encoded string too long:" + utfLength + " bytes");
                }
                bufferObjectDataOutput.writeShort(pos, utfLength);
                if (ASCII_AWARE) {
                    bufferObjectDataOutput.writeBoolean(pos + 2, utfLength == str.length());
                }
            }
        }
    }

    static class ReflectionBasedCharArrayUtfWriter
    extends AbstractCharArrayUtfWriter {
        private static final Field VALUE_FIELD;

        ReflectionBasedCharArrayUtfWriter() {
        }

        @Override
        public boolean isAvailable() {
            return VALUE_FIELD != null;
        }

        @Override
        protected char[] getCharArray(String str) {
            try {
                char[] chars = (char[])VALUE_FIELD.get(str);
                if (chars.length > str.length()) {
                    chars = str.toCharArray();
                }
                return chars;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }

        static {
            Field field;
            try {
                field = String.class.getDeclaredField("value");
                if (char[].class.equals(field.getType())) {
                    field.setAccessible(true);
                } else {
                    field = null;
                }
            }
            catch (Throwable t) {
                EmptyStatement.ignore(t);
                field = null;
            }
            VALUE_FIELD = field;
        }
    }

    static class UnsafeBasedCharArrayUtfWriter
    extends AbstractCharArrayUtfWriter {
        private static final Unsafe UNSAFE = UnsafeHelper.UNSAFE;
        private static final long VALUE_FIELD_OFFSET;

        UnsafeBasedCharArrayUtfWriter() {
        }

        @Override
        public boolean isAvailable() {
            return UnsafeHelper.UNSAFE_AVAILABLE && VALUE_FIELD_OFFSET != -1L;
        }

        @Override
        protected char[] getCharArray(String str) {
            char[] chars = (char[])UNSAFE.getObject(str, VALUE_FIELD_OFFSET);
            if (chars.length > str.length()) {
                chars = str.toCharArray();
            }
            return chars;
        }

        static {
            long offset = -1L;
            if (UnsafeHelper.UNSAFE_AVAILABLE) {
                try {
                    Field valueField = String.class.getDeclaredField("value");
                    if (char[].class.equals(valueField.getType())) {
                        offset = UNSAFE.objectFieldOffset(valueField);
                    }
                }
                catch (Throwable t) {
                    EmptyStatement.ignore(t);
                }
            }
            VALUE_FIELD_OFFSET = offset;
        }
    }

    private static abstract class AbstractCharArrayUtfWriter
    implements UtfWriter {
        private AbstractCharArrayUtfWriter() {
        }

        @Override
        public final void writeShortUTF(DataOutput out, String str, int beginIndex, int endIndex, byte[] buffer) throws IOException {
            int utfLengthLimit;
            boolean isBufferObjectDataOutput = out instanceof BufferObjectDataOutput;
            BufferObjectDataOutput bufferObjectDataOutput = isBufferObjectDataOutput ? (BufferObjectDataOutput)out : null;
            char[] value = this.getCharArray(str);
            int bufferPos = 0;
            int utfLength = 0;
            int pos = 0;
            if (isBufferObjectDataOutput) {
                utfLengthLimit = str.length() * 3;
                pos = bufferObjectDataOutput.position();
                bufferObjectDataOutput.writeShort(0);
                if (ASCII_AWARE) {
                    bufferObjectDataOutput.writeBoolean(false);
                }
            } else {
                utfLength = UTFEncoderDecoder.calculateUtf8Length(value, beginIndex, endIndex);
                if (utfLength > 65535) {
                    throw new UTFDataFormatException("encoded string too long:" + utfLength + " bytes");
                }
                utfLengthLimit = utfLength;
                out.writeShort(utfLength);
                if (ASCII_AWARE) {
                    out.writeBoolean(false);
                }
            }
            if (buffer.length >= utfLengthLimit) {
                char c;
                int i;
                for (i = beginIndex; i < endIndex && (c = value[i]) <= '\u007f' && c >= '\u0001'; ++i) {
                    buffer[bufferPos++] = (byte)c;
                }
                while (i < endIndex) {
                    c = value[i];
                    if (c <= '\u007f' && c >= '\u0001') {
                        buffer[bufferPos++] = (byte)c;
                    } else if (c > '\u07ff') {
                        buffer[bufferPos++] = (byte)(0xE0 | c >> 12 & 0xF);
                        buffer[bufferPos++] = (byte)(0x80 | c >> 6 & 0x3F);
                        buffer[bufferPos++] = (byte)(0x80 | c & 0x3F);
                    } else {
                        buffer[bufferPos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                        buffer[bufferPos++] = (byte)(0x80 | c & 0x3F);
                    }
                    ++i;
                }
                out.write(buffer, 0, bufferPos);
                if (isBufferObjectDataOutput) {
                    utfLength = bufferPos;
                }
            } else {
                char c;
                int i;
                for (i = beginIndex; i < endIndex && (c = value[i]) <= '\u007f' && c >= '\u0001'; ++i) {
                    bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)c, out);
                }
                if (isBufferObjectDataOutput) {
                    utfLength = i - beginIndex;
                }
                while (i < endIndex) {
                    c = value[i];
                    if (c <= '\u007f' && c >= '\u0001') {
                        bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)c, out);
                        if (isBufferObjectDataOutput) {
                            ++utfLength;
                        }
                    } else if (c > '\u07ff') {
                        bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)(0xE0 | c >> 12 & 0xF), out);
                        bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)(0x80 | c >> 6 & 0x3F), out);
                        bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)(0x80 | c & 0x3F), out);
                        if (isBufferObjectDataOutput) {
                            utfLength += 3;
                        }
                    } else {
                        bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)(0xC0 | c >> 6 & 0x1F), out);
                        bufferPos = UTFEncoderDecoder.buffering(buffer, bufferPos, (byte)(0x80 | c & 0x3F), out);
                        if (isBufferObjectDataOutput) {
                            utfLength += 2;
                        }
                    }
                    ++i;
                }
                int length = bufferPos % buffer.length;
                out.write(buffer, 0, length == 0 ? buffer.length : length);
            }
            if (isBufferObjectDataOutput) {
                if (utfLength > 65535) {
                    throw new UTFDataFormatException("encoded string too long:" + utfLength + " bytes");
                }
                bufferObjectDataOutput.writeShort(pos, utfLength);
                if (ASCII_AWARE) {
                    bufferObjectDataOutput.writeBoolean(pos + 2, utfLength == str.length());
                }
            }
        }

        protected abstract boolean isAvailable();

        protected abstract char[] getCharArray(String var1);
    }

    static interface UtfWriter {
        public void writeShortUTF(DataOutput var1, String var2, int var3, int var4, byte[] var5) throws IOException;
    }
}

