/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.core.MigrationEvent;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.InternalPartitionLostEvent;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.impl.InternalPartitionImpl;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.partition.impl.PartitionReplicaChangeReason;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.PartitionAwareService;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

final class PromoteFromBackupOperation
extends AbstractOperation
implements PartitionAwareOperation,
MigrationCycleOperation {
    private final PartitionReplicaChangeReason reason;
    private final Address oldAddress;
    private ILogger logger;

    public PromoteFromBackupOperation(PartitionReplicaChangeReason reason, Address oldAddress) {
        this.reason = reason;
        this.oldAddress = oldAddress;
    }

    void initLogger() {
        this.logger = this.getLogger();
    }

    @Override
    public void beforeRun() throws Exception {
        this.initLogger();
        this.sendMigrationEvent(MigrationEvent.MigrationStatus.STARTED);
    }

    @Override
    public void run() throws Exception {
        this.handleLostBackups();
        this.promoteFromBackups();
    }

    @Override
    public void afterRun() throws Exception {
        this.sendMigrationEvent(MigrationEvent.MigrationStatus.COMPLETED);
    }

    private void sendMigrationEvent(MigrationEvent.MigrationStatus status) {
        if (this.reason != PartitionReplicaChangeReason.MEMBER_REMOVED) {
            return;
        }
        int partitionId = this.getPartitionId();
        NodeEngine nodeEngine = this.getNodeEngine();
        MemberImpl localMember = nodeEngine.getLocalMember();
        MemberImpl deadMember = new MemberImpl(this.oldAddress, false);
        MigrationEvent event = new MigrationEvent(partitionId, deadMember, localMember, status);
        EventService eventService = nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:core:partitionService", ".migration");
        eventService.publishEvent("hz:core:partitionService", registrations, (Object)event, partitionId);
    }

    void handleLostBackups() {
        int partitionId = this.getPartitionId();
        try {
            InternalPartitionService partitionService = (InternalPartitionService)this.getService();
            long[] versions = partitionService.getPartitionReplicaVersions(partitionId);
            if (this.reason == PartitionReplicaChangeReason.MEMBER_REMOVED) {
                int lostReplicaIndex = this.getLostReplicaIndex(versions);
                if (lostReplicaIndex > 0) {
                    this.overwriteLostReplicaVersionsWithFirstAvailableVersion(partitionId, versions, lostReplicaIndex);
                }
                this.sendPartitionLostEvent(partitionId, lostReplicaIndex);
            } else {
                this.resetSyncWaitingVersions(partitionId, versions);
            }
        }
        catch (Throwable e) {
            this.logger.warning("Partition lost detection failed. partitionId=" + partitionId, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void promoteFromBackups() {
        if (this.reason != PartitionReplicaChangeReason.MEMBER_REMOVED) {
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Promoting partitionId=" + this.getPartitionId());
        }
        try {
            this.sendToAllMigrationAwareServices(new PartitionMigrationEvent(MigrationEndpoint.DESTINATION, this.getPartitionId()));
        }
        finally {
            this.clearPartitionMigratingFlag();
        }
    }

    private int getLostReplicaIndex(long[] versions) {
        int biggestLostReplicaIndex = 0;
        for (int replicaIndex = 1; replicaIndex <= versions.length; ++replicaIndex) {
            if (versions[replicaIndex - 1] != -1L) continue;
            biggestLostReplicaIndex = replicaIndex;
        }
        return biggestLostReplicaIndex;
    }

    private void overwriteLostReplicaVersionsWithFirstAvailableVersion(int partitionId, long[] versions, int lostReplicaIndex) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Partition replica is lost! partitionId=" + partitionId + " lost-replicaIndex=" + lostReplicaIndex + " replicaVersions=" + Arrays.toString(versions));
        }
        long forcedVersion = lostReplicaIndex < versions.length ? versions[lostReplicaIndex] : 0L;
        for (int replicaIndex = lostReplicaIndex; replicaIndex > 0; --replicaIndex) {
            versions[replicaIndex - 1] = forcedVersion;
        }
    }

    private void resetSyncWaitingVersions(int partitionId, long[] versions) {
        long[] versionsBeforeReset = null;
        for (int replicaIndex = 1; replicaIndex <= versions.length; ++replicaIndex) {
            if (versions[replicaIndex - 1] != -1L) continue;
            if (versionsBeforeReset == null) {
                versionsBeforeReset = Arrays.copyOf(versions, versions.length);
            }
            versions[replicaIndex - 1] = 0L;
        }
        if (this.logger.isFinestEnabled() && versionsBeforeReset != null) {
            this.logger.finest("Resetting all SYNC_WAITING Versions. partitionId=" + partitionId + " versionsBeforeReset=" + Arrays.toString(versionsBeforeReset));
        }
    }

    private void sendPartitionLostEvent(int partitionId, int lostReplicaIndex) {
        InternalPartitionLostEvent event = new InternalPartitionLostEvent(partitionId, lostReplicaIndex, this.getNodeEngine().getThisAddress());
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        InternalPartitionLostEventPublisher publisher = new InternalPartitionLostEventPublisher(nodeEngine, event);
        nodeEngine.getExecutionService().execute("hz:system", publisher);
    }

    private void sendToAllMigrationAwareServices(PartitionMigrationEvent event) {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        for (MigrationAwareService service : nodeEngine.getServices(MigrationAwareService.class)) {
            try {
                service.beforeMigration(event);
                service.commitMigration(event);
            }
            catch (Throwable e) {
                this.getLogger().warning("While promoting partitionId=" + this.getPartitionId(), e);
            }
        }
    }

    private void clearPartitionMigratingFlag() {
        InternalPartitionServiceImpl service = (InternalPartitionServiceImpl)this.getService();
        InternalPartitionImpl partition = service.getPartition(this.getPartitionId());
        partition.setMigrating(false);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    static class InternalPartitionLostEventPublisher
    implements Runnable {
        private final NodeEngineImpl nodeEngine;
        private final InternalPartitionLostEvent event;

        public InternalPartitionLostEventPublisher(NodeEngineImpl nodeEngine, InternalPartitionLostEvent event) {
            this.nodeEngine = nodeEngine;
            this.event = event;
        }

        @Override
        public void run() {
            for (PartitionAwareService service : this.nodeEngine.getServices(PartitionAwareService.class)) {
                try {
                    service.onPartitionLost(this.event);
                }
                catch (Exception e) {
                    ILogger logger = this.nodeEngine.getLogger(InternalPartitionLostEventPublisher.class);
                    logger.warning("Handling partitionLostEvent failed. Service: " + service.getClass() + " Event: " + this.event, e);
                }
            }
        }

        public InternalPartitionLostEvent getEvent() {
            return this.event;
        }
    }
}

