/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.ExecutionTracingService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.TraceableOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.TargetInvocation;
import com.hazelcast.spi.impl.operationservice.impl.operations.IsStillExecutingOperation;
import com.hazelcast.spi.impl.operationservice.impl.operations.TraceableIsStillExecutingOperation;
import java.util.concurrent.TimeUnit;

public class IsStillRunningService {
    private static final int IS_EXECUTING_CALL_TIMEOUT = 5000;
    private final ILogger logger;
    private final NodeEngineImpl nodeEngine;
    private final OperationExecutor operationExecutor;

    public IsStillRunningService(OperationExecutor operationExecutor, NodeEngineImpl nodeEngine, ILogger logger) {
        this.operationExecutor = operationExecutor;
        this.logger = logger;
        this.nodeEngine = nodeEngine;
    }

    public boolean isOperationExecuting(Invocation invocation) {
        if (this.isStillRunningOperation(invocation)) {
            return false;
        }
        Boolean executing = Boolean.FALSE;
        try {
            Operation isStillExecuting = this.createCheckOperation(invocation);
            TargetInvocation inv = new TargetInvocation(invocation.nodeEngine, invocation.serviceName, isStillExecuting, invocation.getTarget(), 0, 0L, 5000L, null, true);
            InvocationFuture f = inv.invoke();
            invocation.logger.warning("Asking if operation execution has been started: " + invocation);
            executing = (Boolean)invocation.nodeEngine.toObject(f.get(5000L, TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            invocation.logger.warning("While asking 'is-executing': " + invocation, e);
        }
        invocation.logger.warning("'is-executing': " + executing + " -> " + invocation);
        return executing;
    }

    private boolean isStillRunningOperation(Invocation invocation) {
        Operation op = invocation.op;
        return op instanceof IsStillExecutingOperation || op instanceof TraceableIsStillExecutingOperation;
    }

    public void timeoutInvocationIfNotExecuting(Invocation invocation) {
        if (this.isStillRunningOperation(invocation)) {
            InvocationFuture future = invocation.invocationFuture;
            future.set(false);
            return;
        }
        try {
            Operation isStillExecuting = this.createCheckOperation(invocation);
            IsOperationStillRunningCallback callback = new IsOperationStillRunningCallback(invocation);
            this.nodeEngine.getExecutionService().execute("hz:system", new InvokeIsStillRunningOperationRunnable(invocation, isStillExecuting, callback));
        }
        catch (Exception e) {
            invocation.logger.warning("While asking 'is-executing': " + this.toString(), e);
        }
    }

    private Operation createCheckOperation(Invocation invocation) {
        Operation op = invocation.op;
        if (op instanceof TraceableOperation) {
            TraceableOperation traceable = (TraceableOperation)((Object)op);
            return new TraceableIsStillExecutingOperation(invocation.serviceName, traceable.getTraceIdentifier());
        }
        return new IsStillExecutingOperation(op.getCallId(), op.getPartitionId());
    }

    public boolean isOperationExecuting(Address callerAddress, String callerUuid, String serviceName, Object identifier) {
        Object service = this.nodeEngine.getService(serviceName);
        if (service == null) {
            this.logger.severe("Not able to find operation execution info. Invalid service: " + serviceName);
            return false;
        }
        if (service instanceof ExecutionTracingService) {
            return ((ExecutionTracingService)service).isOperationExecuting(callerAddress, callerUuid, identifier);
        }
        this.logger.severe("Not able to find operation execution info. Invalid service: " + service);
        return false;
    }

    public boolean isOperationExecuting(Address callerAddress, int partitionId, long operationCallId) {
        if (partitionId < 0) {
            return this.isGenericOperationExecuting(callerAddress, operationCallId);
        }
        return this.isPartitionSpecificOperationExecuting(callerAddress, partitionId, operationCallId);
    }

    private boolean isPartitionSpecificOperationExecuting(Address callerAddress, int partitionId, long operationCallId) {
        OperationRunner[] partitionOperationRunners = this.operationExecutor.getPartitionOperationRunners();
        OperationRunner operationRunner = partitionOperationRunners[partitionId];
        Object task = operationRunner.currentTask();
        if (!(task instanceof Operation)) {
            return false;
        }
        Operation op = (Operation)task;
        return IsStillRunningService.matches(op, callerAddress, operationCallId);
    }

    private boolean isGenericOperationExecuting(Address callerAddress, long operationCallId) {
        OperationRunner[] genericOperationRunners;
        for (OperationRunner genericOperationRunner : genericOperationRunners = this.operationExecutor.getGenericOperationRunners()) {
            Operation op;
            Object task = genericOperationRunner.currentTask();
            if (!(task instanceof Operation) || !IsStillRunningService.matches(op = (Operation)task, callerAddress, operationCallId)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(Operation op, Address callerAddress, long operationCallId) {
        if (op == null) {
            return false;
        }
        if (op.getCallId() != operationCallId) {
            return false;
        }
        return op.getCallerAddress().equals(callerAddress);
    }

    private static class InvokeIsStillRunningOperationRunnable
    implements Runnable {
        private final Invocation invocation;
        private final Operation isStillRunningOperation;
        private final ExecutionCallback<Object> callback;

        public InvokeIsStillRunningOperationRunnable(Invocation invocation, Operation isStillRunningOperation, ExecutionCallback<Object> callback) {
            this.invocation = invocation;
            this.isStillRunningOperation = isStillRunningOperation;
            this.callback = callback;
        }

        @Override
        public void run() {
            TargetInvocation inv = new TargetInvocation(this.invocation.nodeEngine, this.invocation.serviceName, this.isStillRunningOperation, this.invocation.getTarget(), 0, 0L, 5000L, this.callback, true);
            this.invocation.logger.warning("Asking if operation execution has been started: " + this.toString());
            inv.invoke();
        }
    }

    static class IsOperationStillRunningCallback
    implements ExecutionCallback<Object> {
        private final Invocation invocation;

        public IsOperationStillRunningCallback(Invocation invocation) {
            this.invocation = invocation;
        }

        @Override
        public void onResponse(Object response) {
            boolean executing = Boolean.TRUE.equals(response);
            this.invocation.logger.warning("'is-executing': " + executing + " -> " + this.invocation);
            if (!executing) {
                this.setOperationTimeout();
            }
        }

        @Override
        public void onFailure(Throwable t) {
            this.invocation.logger.warning("While asking 'is-executing': " + this.invocation, t);
            this.setOperationTimeout();
        }

        private void setOperationTimeout() {
            InvocationFuture future = this.invocation.invocationFuture;
            future.set(this.invocation.newOperationTimeoutException(future.getMaxCallTimeout()));
        }
    }
}

