/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.ClientAwareService;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionManagerService;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.transaction.impl.BroadcastTxRollbackOperation;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionContextImpl;
import com.hazelcast.transaction.impl.TransactionImpl;
import com.hazelcast.transaction.impl.TransactionLog;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class TransactionManagerServiceImpl
implements TransactionManagerService,
ManagedService,
MembershipAwareService,
ClientAwareService {
    public static final String SERVICE_NAME = "hz:core:txManagerService";
    private final FutureUtil.ExceptionHandler finalizeExceptionHandler;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final ConcurrentMap<String, TxBackupLog> txBackupLogs = new ConcurrentHashMap<String, TxBackupLog>();

    public TransactionManagerServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(TransactionManagerService.class);
        this.finalizeExceptionHandler = FutureUtil.logAllExceptions(this.logger, "Error while rolling-back tx!", Level.WARNING);
    }

    public String getGroupName() {
        return this.nodeEngine.getConfig().getGroupConfig().getName();
    }

    @Override
    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        Preconditions.checkNotNull(task, "TransactionalTask is required!");
        TransactionContextImpl context = new TransactionContextImpl(this, this.nodeEngine, options, null);
        context.beginTransaction();
        try {
            T value = task.execute(context);
            context.commitTransaction();
            return value;
        }
        catch (Throwable e) {
            context.rollbackTransaction();
            if (e instanceof TransactionException) {
                throw (TransactionException)e;
            }
            if (e.getCause() instanceof TransactionException) {
                throw (TransactionException)e.getCause();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionException(e);
        }
    }

    @Override
    public TransactionContext newTransactionContext(TransactionOptions options) {
        return new TransactionContextImpl(this, this.nodeEngine, options, null);
    }

    @Override
    public TransactionContext newClientTransactionContext(TransactionOptions options, String clientUuid) {
        return new TransactionContextImpl(this, this.nodeEngine, options, clientUuid);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    @Override
    public void reset() {
        this.txBackupLogs.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        MemberImpl member = event.getMember();
        final String uuid = member.getUuid();
        this.nodeEngine.getExecutionService().execute("hz:system", new Runnable(){

            @Override
            public void run() {
                TransactionManagerServiceImpl.this.finalizeTransactionsOf(uuid);
            }
        });
    }

    @Override
    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    private void finalizeTransactionsOf(String uuid) {
        for (Map.Entry entry : this.txBackupLogs.entrySet()) {
            this.finalize(uuid, (String)entry.getKey(), (TxBackupLog)entry.getValue());
        }
    }

    private void finalize(String uuid, String txnId, TxBackupLog log) {
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        if (!uuid.equals(log.callerUuid)) {
            return;
        }
        if (log.state == Transaction.State.ACTIVE) {
            Collection<MemberImpl> memberList = this.nodeEngine.getClusterService().getMemberList();
            ArrayList<Future> futures = new ArrayList<Future>(memberList.size());
            for (MemberImpl member : memberList) {
                BroadcastTxRollbackOperation op = new BroadcastTxRollbackOperation(txnId);
                InternalCompletableFuture f = operationService.invokeOnTarget(SERVICE_NAME, op, member.getAddress());
                futures.add(f);
            }
            long timeoutMillis = TransactionOptions.getDefault().getTimeoutMillis();
            FutureUtil.waitWithDeadline(futures, timeoutMillis, TimeUnit.MILLISECONDS, this.finalizeExceptionHandler);
        } else {
            TransactionImpl tx = new TransactionImpl(this, this.nodeEngine, txnId, log.txLogs, log.timeoutMillis, log.startTime, log.callerUuid);
            if (log.state == Transaction.State.COMMITTING) {
                try {
                    tx.commit();
                }
                catch (Throwable e) {
                    this.logger.warning("Error during committing from tx backup!", e);
                }
            } else {
                try {
                    tx.rollback();
                }
                catch (Throwable e) {
                    this.logger.warning("Error during rolling-back from tx backup!", e);
                }
            }
        }
    }

    @Override
    public void clientDisconnected(String clientUuid) {
        this.finalizeTransactionsOf(clientUuid);
    }

    Address[] pickBackupAddresses(int durability) {
        ClusterService clusterService = this.nodeEngine.getClusterService();
        ArrayList<MemberImpl> members = new ArrayList<MemberImpl>(clusterService.getMemberList());
        members.remove(this.nodeEngine.getLocalMember());
        int c = Math.min(members.size(), durability);
        Collections.shuffle(members);
        Address[] addresses = new Address[c];
        for (int i = 0; i < c; ++i) {
            addresses[i] = ((MemberImpl)members.get(i)).getAddress();
        }
        return addresses;
    }

    void beginTxBackupLog(String callerUuid, String txnId) {
        TxBackupLog log = new TxBackupLog(Collections.emptyList(), callerUuid, Transaction.State.ACTIVE, -1L, -1L);
        if (this.txBackupLogs.putIfAbsent(txnId, log) != null) {
            throw new TransactionException("TxLog already exists!");
        }
    }

    void prepareTxBackupLog(List<TransactionLog> txLogs, String callerUuid, String txnId, long timeoutMillis, long startTime) {
        TxBackupLog beginLog = (TxBackupLog)this.txBackupLogs.get(txnId);
        if (beginLog == null) {
            throw new TransactionException("Could not find begin tx log!");
        }
        if (beginLog.state != Transaction.State.ACTIVE) {
            throw new TransactionException("TxLog already exists!");
        }
        TxBackupLog newTxBackupLog = new TxBackupLog(txLogs, callerUuid, Transaction.State.COMMITTING, timeoutMillis, startTime);
        if (!this.txBackupLogs.replace(txnId, beginLog, newTxBackupLog)) {
            throw new TransactionException("TxLog already exists!");
        }
    }

    void rollbackTxBackupLog(String txnId) {
        TxBackupLog log = (TxBackupLog)this.txBackupLogs.get(txnId);
        if (log != null) {
            log.state = Transaction.State.ROLLING_BACK;
        } else {
            this.logger.warning("No tx backup log is found, tx -> " + txnId);
        }
    }

    void purgeTxBackupLog(String txnId) {
        this.txBackupLogs.remove(txnId);
    }

    private static final class TxBackupLog {
        private final List<TransactionLog> txLogs;
        private final String callerUuid;
        private final long timeoutMillis;
        private final long startTime;
        private volatile Transaction.State state;

        private TxBackupLog(List<TransactionLog> txLogs, String callerUuid, Transaction.State state, long timeoutMillis, long startTime) {
            this.txLogs = txLogs;
            this.callerUuid = callerUuid;
            this.state = state;
            this.timeoutMillis = timeoutMillis;
            this.startTime = startTime;
        }

        public String toString() {
            return "TxBackupLog{txLogs=" + this.txLogs + ", callerUuid='" + this.callerUuid + '\'' + ", timeoutMillis=" + this.timeoutMillis + ", startTime=" + this.startTime + ", state=" + (Object)((Object)this.state) + '}';
        }
    }
}

