---
layout: posts
title: Bazel 0.4.0 Released
---

We are delighted to announce the [0.4.0 release of Bazel](https://github.com/bazelbuild/bazel/releases/tag/0.4.0).  This release marks major improvements in support for Windows, sandboxing and performance.

We are also moving also moving to a new domain. [https://bazel.build](https://bazel.build) is already up and running and we are slowly moving every reference to point to that new domain..

## Improvements from our [roadmap](http://bazel.build/roadmap.html)

### Java workers are now used by default

Java workers reduce the time of java compilation by keeping a hot JVM in the background. [It improves java compilation speed by 5x](https://bazel.build/blog/2015/12/10/java-workers.html) and we decided to make it the default.

### Sandboxing is now working also on OS X

With our [Beta release](https://bazel.build/blog/2015/09/01/beta-release.html), we added sandboxing of action to Linux. This feature ensured that the rule set does not access undeclared input, allowing correct execution of actions. We leveraged the [sandbox-exec](https://developer.apple.com/legacy/library/documentation/Darwin/Reference/ManPages/man1/sandbox-exec.1.html) command to generate a similar sandbox on OS X.

## Other major changes since 0.3.0

### We provide Bazel binaries for Windows

As announced in our Bazel on Windows blog post, we are now providing binary distribution of [Bazel for Windows](https://bazel.build/blog/2016/10/07/bazel-windows.html). A [chocolatey package](https://chocolatey.org/packages/bazel) was contributed by [Peter Mounce](https://github.com/petemounce) so you can just do choco install bazel to get Bazel installed on Windows, big thanks to Peter Mounce! This release also marks a big step for us: TensorFlow PIP package can now be built on Windows with Bazel!

## Skylark implementation of repository rules

We now have implementation of two repository rules (git_repository and maven_jar) in Skylark and we recommend using them instead of the native ones, to do so simply adds the following lines at the top of your WORKSPACE file:

```python
load(
    "@bazel_tools//tools/build_defs/repo:git.bzl",
    "git_repository",
    "new_git_repository",
)
load("@bazel_tools//tools/build_defs/repo:maven_rules.bzl", "maven_jar")
```

### And various more

* The --watchfs flag is ready to be turned on by default. It improves performance of Bazel, try it out!
* The Linux sandbox got revamped for better performance and usability: no performance hit should be perceptible and accessing system tools should be possible.

For changes since 0.3.2 (the minor version before 0.4.0), see the release notes for changes.

## Future plans

### Looking ahead to 0.5.0:

* With the help of your feedback, we will resolve the last issue to make our Windows port work seamlessly for Java, C++ and Python.
* The new distributed execution API will be stabilized.

## Finally...

A big thank you to our community for your continued support.  Particular shout-outs to the following contributors:

* [Yugui](https://github.com/yugui) for her contribution to [rules_go](https://github.com/bazelbuild/rules_go).
* [Paul Bethe](https://github.com/pmbethe09) for his contribution to [rules_go](https://github.com/bazelbuild/rules_go) and open-sourcing [buildifier](https://github.com/bazelbuild/buildifier).
* [Peter Mounce](https://github.com/petemounce) for the [chocolatey package of Bazel](https://chocolatey.org/packages/bazel).


Thank you all, keep the discussion and bug reports coming!
