/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;

public class ArgumentParameterSimilarityMetrics {
    private static final Pattern ONLY_UNDERSCORES = Pattern.compile("^_+$");
    private static final Pattern UNDERSCORES_OR_CASE_TRANSITIONS = Pattern.compile("_|(?<=[a-z0-9])(?=[A-Z])");

    public static double computeNormalizedTermIntersection(String arg, String param) {
        Set<String> argSplit = ArgumentParameterSimilarityMetrics.splitStringTerms(arg);
        Set<String> paramSplit = ArgumentParameterSimilarityMetrics.splitStringTerms(param);
        double commonTerms = Sets.intersection(argSplit, paramSplit).size() * 2;
        double totalTerms = argSplit.size() + paramSplit.size();
        return commonTerms / totalTerms;
    }

    @VisibleForTesting
    static Set<String> splitStringTerms(String name) {
        if (ONLY_UNDERSCORES.matcher(name).matches()) {
            return ImmutableSet.of((Object)name);
        }
        return (Set)Arrays.stream(UNDERSCORES_OR_CASE_TRANSITIONS.split(name)).map(String::toLowerCase).collect(ImmutableSet.toImmutableSet());
    }

    private ArgumentParameterSimilarityMetrics() {
    }
}

