/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;

@BugPattern(name="InfiniteRecursion", category=BugPattern.Category.JDK, summary="This method always recurses, and will cause a StackOverflowError", severity=BugPattern.SeverityLevel.ERROR)
public class InfiniteRecursion
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getBody() == null || tree.getBody().getStatements().size() != 1) {
            return Description.NO_MATCH;
        }
        JCTree statement = TreeInfo.skipParens((JCTree)Iterables.getOnlyElement(tree.getBody().getStatements()));
        ExpressionTree expr = statement.accept(new SimpleTreeVisitor<ExpressionTree, Void>(){

            @Override
            public ExpressionTree visitExpressionStatement(ExpressionStatementTree tree, Void unused) {
                return tree.getExpression();
            }

            @Override
            public ExpressionTree visitReturn(ReturnTree tree, Void unused) {
                return tree.getExpression();
            }
        }, null);
        if (!(expr instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        ExpressionTree select = ((MethodInvocationTree)expr).getMethodSelect();
        switch (select.getKind()) {
            case IDENTIFIER: {
                break;
            }
            case MEMBER_SELECT: {
                ExpressionTree receiver = ((MemberSelectTree)select).getExpression();
                if (receiver.getKind() != Tree.Kind.IDENTIFIER) {
                    return Description.NO_MATCH;
                }
                if (((IdentifierTree)receiver).getName().contentEquals("this")) break;
                return Description.NO_MATCH;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
        if (sym == null || !sym.equals(ASTHelpers.getSymbol((Tree)expr))) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(statement);
    }
}

