/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.googlejavaformat.CloseOp;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.Indent;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpenOp;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.Output;
import com.google.googlejavaformat.java.TypeNameClassifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotatableType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;

public final class JavaInputAstVisitor
extends ASTVisitor {
    private final OpsBuilder builder;
    private static final Indent.Const ZERO = Indent.Const.ZERO;
    private final int indentMultiplier;
    private final Indent.Const minusTwo;
    private final Indent.Const minusFour;
    private final Indent.Const plusTwo;
    private final Indent.Const plusFour;
    private final Indent.Const plusEight;
    private static final ImmutableList<Op> EMPTY_LIST = ImmutableList.of();
    private static final Map<String, Integer> PRECEDENCE = new HashMap<String, Integer>();
    private static final int MAX_ITEM_LENGTH_FOR_FILLING = 10;
    private final Deque<Boolean> inExpression = new ArrayDeque<Boolean>(Arrays.asList(false));

    private static final ImmutableList<Op> breakList(Optional<Output.BreakTag> breakTag) {
        return ImmutableList.of((Object)Doc.Break.make(Doc.FillMode.UNIFIED, " ", ZERO, breakTag));
    }

    private static final ImmutableList<Op> breakFillList(Optional<Output.BreakTag> breakTag) {
        return ImmutableList.of((Object)OpenOp.make(ZERO), (Object)Doc.Break.make(Doc.FillMode.INDEPENDENT, " ", ZERO, breakTag), (Object)CloseOp.make());
    }

    private static final ImmutableList<Op> forceBreakList(Optional<Output.BreakTag> breakTag) {
        return ImmutableList.of((Object)Doc.Break.make(Doc.FillMode.FORCED, "", Indent.Const.ZERO, breakTag));
    }

    public JavaInputAstVisitor(OpsBuilder builder, int indentMultiplier) {
        this.builder = builder;
        this.indentMultiplier = indentMultiplier;
        this.minusTwo = Indent.Const.make(-2, indentMultiplier);
        this.minusFour = Indent.Const.make(-4, indentMultiplier);
        this.plusTwo = Indent.Const.make(2, indentMultiplier);
        this.plusFour = Indent.Const.make(4, indentMultiplier);
        this.plusEight = Indent.Const.make(8, indentMultiplier);
    }

    private boolean inExpression() {
        return this.inExpression.peekLast();
    }

    @Override
    public void preVisit(ASTNode node) {
        this.inExpression.addLast(node instanceof Expression || this.inExpression.peekLast() != false);
    }

    @Override
    public void postVisit(ASTNode node) {
        this.inExpression.removeLast();
    }

    @Override
    public boolean visit(CompilationUnit node) {
        boolean first = true;
        if (node.getPackage() != null) {
            this.markForPartialFormat();
            this.visit(node.getPackage());
            this.builder.forcedBreak();
            first = false;
        }
        if (!node.imports().isEmpty()) {
            if (!first) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
            }
            for (ImportDeclaration importDeclaration : node.imports()) {
                this.markForPartialFormat();
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
                this.visit(importDeclaration);
                this.builder.forcedBreak();
            }
            first = false;
        }
        for (AbstractTypeDeclaration type : node.types()) {
            if (!first) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
            }
            this.dropEmptyDeclarations();
            this.markForPartialFormat();
            type.accept(this);
            this.builder.forcedBreak();
            first = false;
        }
        this.dropEmptyDeclarations();
        this.markForPartialFormat();
        return false;
    }

    private void dropEmptyDeclarations() {
        while (this.builder.peekToken().equals((Object)Optional.of((Object)";"))) {
            this.token(";");
        }
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        this.sync(node);
        this.builder.open(ZERO);
        this.visitAndBreakModifiers(node.modifiers(), Direction.VERTICAL, (Optional<Output.BreakTag>)Optional.absent());
        this.builder.open(ZERO);
        this.token("@");
        this.token("interface");
        this.builder.breakOp(" ");
        this.visit(node.getName());
        this.builder.close();
        this.builder.close();
        if (node.bodyDeclarations() == null) {
            this.builder.open(this.plusFour);
            this.token(";");
            this.builder.close();
        } else {
            this.addBodyDeclarations(node.bodyDeclarations(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        }
        this.builder.guessToken(";");
        return false;
    }

    @Override
    public boolean visit(AnnotationTypeMemberDeclaration node) {
        this.sync(node);
        this.declareOne(node, Direction.VERTICAL, node.modifiers(), node.getType(), VarArgsOrNot.NO, (List<Annotation>)ImmutableList.of(), node.getName(), "()", (List<Dimension>)ImmutableList.of(), "default", (Optional<Expression>)Optional.fromNullable((Object)node.getDefault()), (Optional<String>)Optional.of((Object)";"), ReceiverParameter.NO);
        return false;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        this.sync(node);
        this.addBodyDeclarations(node.bodyDeclarations(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
        return false;
    }

    @Override
    public boolean visit(ArrayAccess node) {
        Expression array;
        this.sync(node);
        this.builder.open(this.plusFour);
        ArrayDeque<Expression> stack = new ArrayDeque<Expression>();
        while (true) {
            stack.addLast(node.getIndex());
            array = node.getArray();
            if (!(array instanceof ArrayAccess)) break;
            node = (ArrayAccess)array;
        }
        array.accept(this);
        do {
            this.token("[");
            this.builder.breakToFill();
            ((Expression)stack.removeLast()).accept(this);
            this.token("]");
        } while (!stack.isEmpty());
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(ArrayCreation node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.token("new");
        this.builder.space();
        this.visitArrayType(node.getType(), DimensionsOrNot.NO);
        int dimensions = node.getType().getDimensions();
        this.builder.open(ZERO);
        for (int i = 0; i < dimensions; ++i) {
            this.builder.breakOp();
            this.token("[");
            if (i < node.dimensions().size()) {
                ((Expression)node.dimensions().get(i)).accept(this);
            }
            this.token("]");
        }
        this.builder.close();
        this.builder.close();
        if (node.getInitializer() != null) {
            this.builder.space();
            this.visit(node.getInitializer());
        }
        return false;
    }

    @Override
    public boolean visit(ArrayInitializer node) {
        this.sync(node);
        if (node.expressions().isEmpty()) {
            this.tokenBreakTrailingComment("{", this.plusTwo);
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.token("}", this.plusTwo);
        } else {
            boolean inMemberValuePair = node.getParent().getNodeType() == 80 || node.getParent().getNodeType() == 79;
            boolean shortItems = this.hasOnlyShortItems(node.expressions());
            boolean allowFilledElementsOnOwnLine = shortItems || !inMemberValuePair;
            this.builder.open(this.plusTwo);
            this.tokenBreakTrailingComment("{", this.plusTwo);
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            boolean hasTrailingComma = JavaInputAstVisitor.hasTrailingToken(this.builder.getInput(), node.expressions(), ",");
            this.builder.breakOp(hasTrailingComma ? Doc.FillMode.FORCED : Doc.FillMode.UNIFIED, "", ZERO);
            if (allowFilledElementsOnOwnLine) {
                this.builder.open(ZERO);
            }
            boolean first = true;
            Doc.FillMode fillMode = shortItems ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
            for (Expression expression : node.expressions()) {
                if (!first) {
                    this.token(",");
                    this.builder.breakOp(fillMode, " ", ZERO);
                }
                expression.accept(this);
                first = false;
            }
            this.builder.guessToken(",");
            if (allowFilledElementsOnOwnLine) {
                this.builder.close();
            }
            this.builder.breakOp(this.minusTwo);
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.builder.close();
            this.token("}", this.plusTwo);
        }
        return false;
    }

    private boolean hasOnlyShortItems(List<Expression> expressions) {
        for (Expression expression : expressions) {
            if (this.builder.actualSize(expression.getStartPosition(), expression.getLength()) < 10) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(ArrayType node) {
        this.sync(node);
        this.visitArrayType(node, DimensionsOrNot.YES);
        return false;
    }

    @Override
    public boolean visit(AssertStatement node) {
        this.sync(node);
        this.builder.open(ZERO);
        this.token("assert");
        this.builder.space();
        this.builder.open(node.getMessage() == null ? ZERO : this.plusFour);
        node.getExpression().accept(this);
        if (node.getMessage() != null) {
            this.builder.breakOp(" ");
            this.token(":");
            this.builder.space();
            node.getMessage().accept(this);
        }
        this.builder.close();
        this.builder.close();
        this.token(";");
        return false;
    }

    @Override
    public boolean visit(Assignment node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        node.getLeftHandSide().accept(this);
        this.builder.space();
        this.builder.op(node.getOperator().toString());
        this.builder.breakOp(" ");
        node.getRightHandSide().accept(this);
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(Block node) {
        this.visitBlock(node, CollapseEmptyOrNot.YES, AllowLeadingBlankLine.NO, AllowTrailingBlankLine.NO);
        return false;
    }

    @Override
    public boolean visit(BooleanLiteral node) {
        this.sync(node);
        this.token(node.toString());
        return false;
    }

    @Override
    public boolean visit(BreakStatement node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.token("break");
        if (node.getLabel() != null) {
            this.builder.breakOp(" ");
            this.visit(node.getLabel());
        }
        this.builder.close();
        this.token(";");
        return false;
    }

    @Override
    public boolean visit(CastExpression node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.token("(");
        node.getType().accept(this);
        this.token(")");
        this.builder.breakOp(" ");
        node.getExpression().accept(this);
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(CharacterLiteral node) {
        this.sync(node);
        this.token(node.getEscapedValue());
        return false;
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        this.sync(node);
        this.builder.open(ZERO);
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
            this.builder.breakOp();
            this.token(".");
        }
        this.token("new");
        this.builder.space();
        this.addTypeArguments(node.typeArguments(), this.plusFour);
        node.getType().accept(this);
        this.addArguments(node.arguments(), this.plusFour);
        this.builder.close();
        if (node.getAnonymousClassDeclaration() != null) {
            this.visit(node.getAnonymousClassDeclaration());
        }
        return false;
    }

    @Override
    public boolean visit(ConditionalExpression node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        node.getExpression().accept(this);
        this.builder.breakOp(" ");
        this.token("?");
        this.builder.space();
        node.getThenExpression().accept(this);
        this.builder.breakOp(" ");
        this.token(":");
        this.builder.space();
        node.getElseExpression().accept(this);
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(ConstructorInvocation node) {
        this.sync(node);
        this.addTypeArguments(node.typeArguments(), this.plusFour);
        this.token("this");
        this.addArguments(node.arguments(), this.plusFour);
        this.token(";");
        return false;
    }

    @Override
    public boolean visit(ContinueStatement node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.token("continue");
        if (node.getLabel() != null) {
            this.builder.breakOp(" ");
            this.visit(node.getLabel());
        }
        this.token(";");
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(CreationReference node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        node.getType().accept(this);
        this.builder.breakOp();
        this.builder.op("::");
        this.addTypeArguments(node.typeArguments(), this.plusFour);
        this.token("new");
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(Dimension node) {
        this.sync(node);
        if (!node.annotations().isEmpty()) {
            this.builder.open(ZERO);
            this.visitAnnotations(node.annotations(), BreakOrNot.NO, BreakOrNot.NO);
            this.builder.breakToFill(" ");
            this.builder.close();
        }
        this.token("[");
        this.token("]");
        return false;
    }

    @Override
    public boolean visit(DoStatement node) {
        this.sync(node);
        this.token("do");
        this.visitStatement(node.getBody(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.YES);
        if (node.getBody().getNodeType() == 8) {
            this.builder.space();
        } else {
            this.builder.breakOp(" ");
        }
        this.token("while");
        this.builder.space();
        this.token("(");
        node.getExpression().accept(this);
        this.token(")");
        this.token(";");
        return false;
    }

    @Override
    public boolean visit(EmptyStatement node) {
        this.sync(node);
        this.builder.guessToken(";");
        return false;
    }

    @Override
    public boolean visit(EnhancedForStatement node) {
        this.sync(node);
        this.builder.open(ZERO);
        this.token("for");
        this.builder.space();
        this.token("(");
        this.builder.open(ZERO);
        this.visitToDeclare(Direction.HORIZONTAL, node.getParameter(), (Optional<Expression>)Optional.of((Object)node.getExpression()), ":");
        this.builder.close();
        this.token(")");
        this.builder.close();
        this.visitStatement(node.getBody(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        return false;
    }

    @Override
    public boolean visit(EnumConstantDeclaration node) {
        this.sync(node);
        this.markForPartialFormat();
        List<Op> breaks = this.visitModifiers(node.modifiers(), Direction.VERTICAL, (Optional<Output.BreakTag>)Optional.absent());
        if (!breaks.isEmpty()) {
            this.builder.open(ZERO);
            this.builder.addAll(breaks);
            this.builder.close();
        }
        this.visit(node.getName());
        if (node.arguments().isEmpty()) {
            this.builder.guessToken("(");
            this.builder.guessToken(")");
        } else {
            this.addArguments(node.arguments(), this.plusFour);
        }
        if (node.getAnonymousClassDeclaration() != null) {
            this.visit(node.getAnonymousClassDeclaration());
        }
        return false;
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        boolean first;
        this.sync(node);
        this.builder.open(ZERO);
        this.visitAndBreakModifiers(node.modifiers(), Direction.VERTICAL, (Optional<Output.BreakTag>)Optional.absent());
        this.builder.open(this.plusFour);
        this.token("enum");
        this.builder.breakOp(" ");
        this.visit(node.getName());
        this.builder.close();
        this.builder.close();
        if (!node.superInterfaceTypes().isEmpty()) {
            this.builder.open(this.plusFour);
            this.builder.breakOp(" ");
            this.builder.open(this.plusFour);
            this.token("implements");
            this.builder.breakOp(" ");
            this.builder.open(ZERO);
            first = true;
            for (Type superInterfaceType : node.superInterfaceTypes()) {
                if (!first) {
                    this.token(",");
                    this.builder.breakToFill(" ");
                }
                superInterfaceType.accept(this);
                first = false;
            }
            this.builder.close();
            this.builder.close();
            this.builder.close();
        }
        this.builder.space();
        this.tokenBreakTrailingComment("{", this.plusTwo);
        if (node.enumConstants().isEmpty() && node.bodyDeclarations().isEmpty()) {
            this.builder.open(ZERO);
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.token("}");
            this.builder.close();
        } else {
            this.builder.open(this.plusTwo);
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.builder.forcedBreak();
            this.builder.open(ZERO);
            first = true;
            for (EnumConstantDeclaration enumConstant : node.enumConstants()) {
                if (!first) {
                    this.token(",");
                    this.builder.forcedBreak();
                    this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
                }
                this.visit(enumConstant);
                first = false;
            }
            if (((String)this.builder.peekToken().or((Object)"")).equals(",")) {
                this.token(",");
                this.builder.forcedBreak();
            }
            this.builder.close();
            this.builder.close();
            this.builder.open(ZERO);
            if (node.bodyDeclarations().isEmpty()) {
                this.builder.guessToken(";");
            } else {
                this.token(";");
                this.builder.forcedBreak();
                this.addBodyDeclarations(node.bodyDeclarations(), BracesOrNot.NO, FirstDeclarationsOrNot.NO);
            }
            this.builder.forcedBreak();
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.token("}", this.plusTwo);
            this.builder.close();
        }
        this.builder.guessToken(";");
        return false;
    }

    @Override
    public boolean visit(ExpressionMethodReference node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        node.getExpression().accept(this);
        this.builder.breakOp();
        this.builder.op("::");
        if (!node.typeArguments().isEmpty()) {
            this.addTypeArguments(node.typeArguments(), this.plusFour);
        }
        this.visit(node.getName());
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(ExpressionStatement node) {
        this.sync(node);
        node.getExpression().accept(this);
        this.token(";");
        return false;
    }

    @Override
    public boolean visit(FieldAccess node) {
        this.sync(node);
        this.visitDot(node);
        return false;
    }

    @Override
    public boolean visit(FieldDeclaration node) {
        this.sync(node);
        this.markForPartialFormat();
        this.addDeclaration(node, node.modifiers(), node.getType(), node.fragments(), JavaInputAstVisitor.fieldAnnotationDirection(node.modifiers()));
        return false;
    }

    @Override
    public boolean visit(ForStatement node) {
        this.sync(node);
        this.token("for");
        this.builder.space();
        this.token("(");
        this.builder.open(this.plusFour);
        this.builder.open(node.initializers().size() <= 1 ? ZERO : this.plusFour);
        boolean first = true;
        for (Expression initializer : node.initializers()) {
            if (!first) {
                this.token(",");
                this.builder.breakToFill(" ");
            }
            initializer.accept(this);
            first = false;
        }
        this.builder.close();
        this.token(";");
        this.builder.breakOp(" ");
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
        }
        this.token(";");
        this.builder.breakOp(" ");
        if (!node.updaters().isEmpty()) {
            this.builder.open(node.updaters().size() <= 1 ? ZERO : this.plusFour);
            boolean firstUpdater = true;
            for (Expression updater : node.updaters()) {
                if (!firstUpdater) {
                    this.token(",");
                    this.builder.breakToFill(" ");
                }
                updater.accept(this);
                firstUpdater = false;
            }
            this.builder.close();
        }
        this.builder.close();
        this.token(")");
        this.visitStatement(node.getBody(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        return false;
    }

    @Override
    public boolean visit(IfStatement node) {
        this.sync(node);
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        ArrayList<Statement> statements = new ArrayList<Statement>();
        while (true) {
            expressions.add(node.getExpression());
            statements.add(node.getThenStatement());
            if (node.getElseStatement() == null || node.getElseStatement().getNodeType() != 25) break;
            node = (IfStatement)node.getElseStatement();
        }
        this.builder.open(ZERO);
        boolean first = true;
        boolean followingBlock = false;
        int expressionsN = expressions.size();
        for (int i = 0; i < expressionsN; ++i) {
            if (!first) {
                if (followingBlock) {
                    this.builder.space();
                } else {
                    this.builder.forcedBreak();
                }
                this.token("else");
                this.builder.space();
            }
            this.token("if");
            this.builder.space();
            this.token("(");
            ((Expression)expressions.get(i)).accept(this);
            this.token(")");
            boolean onlyClause = expressionsN == 1 && node.getElseStatement() == null;
            boolean trailingClauses = i < expressionsN - 1 || node.getElseStatement() != null;
            this.visitStatement((Statement)statements.get(i), CollapseEmptyOrNot.valueOf(onlyClause), AllowLeadingBlankLine.YES, AllowTrailingBlankLine.valueOf(trailingClauses));
            followingBlock = ((Statement)statements.get(i)).getNodeType() == 8;
            first = false;
        }
        if (node.getElseStatement() != null) {
            if (followingBlock) {
                this.builder.space();
            } else {
                this.builder.forcedBreak();
            }
            this.token("else");
            this.visitStatement(node.getElseStatement(), CollapseEmptyOrNot.NO, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        }
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        this.sync(node);
        this.token("import");
        this.builder.space();
        if (node.isStatic()) {
            this.token("static");
            this.builder.space();
        }
        this.visitName(node.getName(), BreakOrNot.NO);
        if (node.isOnDemand()) {
            this.token(".");
            this.token("*");
        }
        this.token(";");
        return false;
    }

    @Override
    public boolean visit(InfixExpression node) {
        this.sync(node);
        ArrayList<Expression> operands = new ArrayList<Expression>();
        ArrayList<String> operators = new ArrayList<String>();
        JavaInputAstVisitor.walkInfix(PRECEDENCE.get(node.getOperator().toString()), node, operands, operators);
        Doc.FillMode fillMode = this.hasOnlyShortItems(operands) ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
        this.builder.open(this.plusFour);
        ((Expression)operands.get(0)).accept(this);
        int operatorsN = operators.size();
        for (int i = 0; i < operatorsN; ++i) {
            this.builder.breakOp(fillMode, " ", ZERO);
            this.builder.op((String)operators.get(i));
            this.builder.space();
            ((Expression)operands.get(i + 1)).accept(this);
        }
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(Initializer node) {
        this.sync(node);
        this.visitAndBreakModifiers(node.modifiers(), Direction.VERTICAL, (Optional<Output.BreakTag>)Optional.absent());
        node.getBody().accept(this);
        this.builder.guessToken(";");
        return false;
    }

    @Override
    public boolean visit(InstanceofExpression node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        node.getLeftOperand().accept(this);
        this.builder.breakOp(" ");
        this.builder.open(ZERO);
        this.token("instanceof");
        this.builder.breakOp(" ");
        node.getRightOperand().accept(this);
        this.builder.close();
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(IntersectionType node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        ArrayList<Type> types = new ArrayList<Type>();
        JavaInputAstVisitor.walkIntersectionTypes(types, node);
        boolean first = true;
        for (Type type : types) {
            if (!first) {
                this.builder.breakToFill(" ");
                this.token("&");
                this.builder.space();
            }
            type.accept(this);
            first = false;
        }
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(LabeledStatement node) {
        this.sync(node);
        this.builder.open(ZERO);
        this.visit(node.getLabel());
        this.token(":");
        this.builder.forcedBreak();
        this.builder.close();
        node.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(LambdaExpression node) {
        this.sync(node);
        boolean statementBody = node.getBody().getNodeType() == 8;
        this.builder.open(statementBody ? ZERO : this.plusFour);
        this.builder.open(this.plusFour);
        if (node.hasParentheses()) {
            this.token("(");
        }
        boolean first = true;
        for (ASTNode parameter : node.parameters()) {
            if (!first) {
                this.token(",");
                this.builder.breakOp(" ");
            }
            parameter.accept(this);
            first = false;
        }
        if (node.hasParentheses()) {
            this.token(")");
        }
        this.builder.close();
        this.builder.space();
        this.builder.op("->");
        if (statementBody) {
            this.builder.space();
        } else {
            this.builder.breakOp(" ");
        }
        node.getBody().accept(this);
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(MarkerAnnotation node) {
        this.sync(node);
        this.builder.open(ZERO);
        this.token("@");
        node.getTypeName().accept(this);
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(MemberValuePair node) {
        boolean isArrayInitializer = node.getValue().getNodeType() == 4;
        this.sync(node);
        this.builder.open(isArrayInitializer ? ZERO : this.plusFour);
        this.visit(node.getName());
        this.builder.space();
        this.token("=");
        if (isArrayInitializer) {
            this.builder.space();
        } else {
            this.builder.breakOp(" ");
        }
        node.getValue().accept(this);
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        this.sync(node);
        this.visitAndBreakModifiers(node.modifiers(), Direction.VERTICAL, (Optional<Output.BreakTag>)Optional.absent());
        this.builder.open(this.plusFour);
        Output.BreakTag breakBeforeName = this.genSym();
        Output.BreakTag breakBeforeType = this.genSym();
        this.builder.open(ZERO);
        boolean first = true;
        if (!node.typeParameters().isEmpty()) {
            this.token("<");
            this.typeParametersRest(node.typeParameters(), this.plusFour);
            first = false;
        }
        boolean openedNameAndTypeScope = false;
        if (!node.isConstructor() && node.getReturnType2() != null) {
            if (!first) {
                this.builder.breakOp(Doc.FillMode.INDEPENDENT, " ", ZERO, (Optional<Output.BreakTag>)Optional.of((Object)breakBeforeType));
            } else {
                first = false;
            }
            if (!openedNameAndTypeScope) {
                this.builder.open(Indent.If.make(breakBeforeType, this.plusFour, ZERO));
                openedNameAndTypeScope = true;
            }
            node.getReturnType2().accept(this);
        }
        if (!first) {
            this.builder.breakOp(Doc.FillMode.INDEPENDENT, " ", ZERO, (Optional<Output.BreakTag>)Optional.of((Object)breakBeforeName));
        } else {
            first = false;
        }
        if (!openedNameAndTypeScope) {
            this.builder.open(ZERO);
            openedNameAndTypeScope = true;
        }
        this.visit(node.getName());
        this.token("(");
        this.builder.close();
        this.builder.close();
        this.builder.open(Indent.If.make(breakBeforeName, this.plusFour, ZERO));
        this.builder.open(Indent.If.make(breakBeforeType, this.plusFour, ZERO));
        this.builder.open(ZERO);
        if (!node.parameters().isEmpty() || node.getReceiverType() != null) {
            this.builder.breakToFill("");
            this.visitFormals(node, (Optional<Type>)Optional.fromNullable((Object)node.getReceiverType()), node.getReceiverQualifier(), node.parameters());
        }
        this.token(")");
        this.extraDimensions(this.plusFour, node.extraDimensions());
        if (!node.thrownExceptionTypes().isEmpty()) {
            this.builder.breakToFill(" ");
            this.builder.open(this.plusFour);
            this.visitThrowsClause(node.thrownExceptionTypes());
            this.builder.close();
        }
        this.builder.close();
        this.builder.close();
        this.builder.close();
        this.builder.close();
        if (node.getBody() == null) {
            this.token(";");
        } else {
            this.builder.space();
            this.visitBlock(node.getBody(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        }
        this.builder.guessToken(";");
        return false;
    }

    @Override
    public boolean visit(MethodInvocation node) {
        this.sync(node);
        this.visitDot(node);
        return false;
    }

    @Override
    public boolean visit(Modifier node) {
        this.sync(node);
        this.token(node.toString());
        return false;
    }

    @Override
    public boolean visit(NameQualifiedType node) {
        this.sync(node);
        this.beforeAnnotatableType(node);
        this.builder.open(this.plusFour);
        node.getQualifier().accept(this);
        this.builder.breakOp();
        this.token(".");
        this.visit(node.getName());
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(NormalAnnotation node) {
        this.sync(node);
        this.builder.open(ZERO);
        this.token("@");
        node.getTypeName().accept(this);
        this.builder.open(this.plusTwo);
        this.token("(");
        this.builder.breakOp();
        boolean first = true;
        boolean hasArrayInitializer = false;
        for (MemberValuePair value : node.values()) {
            if (value.getValue().getNodeType() != 4) continue;
            hasArrayInitializer = true;
            break;
        }
        for (MemberValuePair value : node.values()) {
            if (!first) {
                this.token(",");
                if (hasArrayInitializer) {
                    this.builder.forcedBreak();
                } else {
                    this.builder.breakOp(" ");
                }
            }
            value.accept(this);
            first = false;
        }
        this.builder.breakOp(Doc.FillMode.UNIFIED, "", this.minusTwo, (Optional<Output.BreakTag>)Optional.absent());
        this.token(")");
        this.builder.close();
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(NullLiteral node) {
        this.sync(node);
        this.token(node.toString());
        return false;
    }

    @Override
    public boolean visit(NumberLiteral node) {
        this.sync(node);
        String value = node.getToken();
        if (value.startsWith("-")) {
            this.token("-");
            value = value.substring(1);
        }
        this.token(value);
        return false;
    }

    @Override
    public boolean visit(PackageDeclaration node) {
        this.sync(node);
        this.visitAndBreakModifiers(node.annotations(), Direction.VERTICAL, (Optional<Output.BreakTag>)Optional.absent());
        this.builder.open(this.plusFour);
        this.token("package");
        this.builder.space();
        this.visitName(node.getName(), BreakOrNot.NO);
        this.builder.close();
        this.token(";");
        return false;
    }

    @Override
    public boolean visit(ParameterizedType node) {
        this.sync(node);
        if (node.typeArguments().isEmpty()) {
            node.getType().accept(this);
            this.token("<");
            this.token(">");
        } else {
            this.builder.open(this.plusFour);
            node.getType().accept(this);
            this.token("<");
            this.builder.breakOp();
            this.builder.open(ZERO);
            boolean first = true;
            for (Type typeArgument : node.typeArguments()) {
                if (!first) {
                    this.token(",");
                    this.builder.breakToFill(" ");
                }
                typeArgument.accept(this);
                first = false;
            }
            this.builder.close();
            this.builder.close();
            this.token(">");
        }
        return false;
    }

    @Override
    public boolean visit(ParenthesizedExpression node) {
        this.sync(node);
        this.token("(");
        node.getExpression().accept(this);
        this.token(")");
        return false;
    }

    @Override
    public boolean visit(PostfixExpression node) {
        this.sync(node);
        node.getOperand().accept(this);
        this.builder.op(node.getOperator().toString());
        return false;
    }

    @Override
    public boolean visit(PrefixExpression node) {
        this.sync(node);
        String op = node.getOperator().toString();
        this.builder.op(op);
        Expression operand = node.getOperand();
        if ((op.equals("+") || op.equals("-")) && operand.getNodeType() == 38 && ((PrefixExpression)operand).getOperator().toString().startsWith(op)) {
            this.builder.space();
        }
        operand.accept(this);
        return false;
    }

    @Override
    public boolean visit(PrimitiveType node) {
        this.sync(node);
        this.beforeAnnotatableType(node);
        this.token(node.toString());
        return false;
    }

    @Override
    public boolean visit(QualifiedName node) {
        this.visitQualifiedName(node, BreakOrNot.YES);
        return false;
    }

    @Override
    public boolean visit(QualifiedType node) {
        Type qualifier;
        this.sync(node);
        this.builder.open(this.plusFour);
        ArrayDeque<SimpleName> stack = new ArrayDeque<SimpleName>();
        while (true) {
            stack.add(node.getName());
            qualifier = node.getQualifier();
            if (qualifier.getNodeType() != 75) break;
            node = (QualifiedType)qualifier;
        }
        qualifier.accept(this);
        do {
            this.builder.breakOp();
            this.token(".");
            this.visit((SimpleName)stack.removeLast());
        } while (!stack.isEmpty());
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(ReturnStatement node) {
        this.sync(node);
        this.token("return");
        if (node.getExpression() != null) {
            this.builder.space();
            node.getExpression().accept(this);
        }
        this.token(";");
        return false;
    }

    @Override
    public boolean visit(SimpleName node) {
        this.sync(node);
        this.token(node.getIdentifier());
        return false;
    }

    @Override
    public boolean visit(SimpleType node) {
        this.sync(node);
        this.beforeAnnotatableType(node);
        node.getName().accept(this);
        return false;
    }

    @Override
    public boolean visit(SingleMemberAnnotation node) {
        this.sync(node);
        Expression value = node.getValue();
        boolean isArrayInitializer = value.getNodeType() == 4;
        this.builder.open(isArrayInitializer ? ZERO : this.plusFour);
        this.token("@");
        node.getTypeName().accept(this);
        this.token("(");
        if (!isArrayInitializer) {
            this.builder.breakOp();
        }
        value.accept(this);
        this.builder.close();
        this.token(")");
        return false;
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        this.visitToDeclare(Direction.HORIZONTAL, node, (Optional<Expression>)Optional.fromNullable((Object)node.getInitializer()), "=");
        return false;
    }

    @Override
    public boolean visit(StringLiteral node) {
        this.sync(node);
        this.token(node.getEscapedValue());
        return false;
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        this.sync(node);
        if (node.getExpression() != null) {
            node.getExpression().accept(this);
            this.token(".");
        }
        this.addTypeArguments(node.typeArguments(), this.plusFour);
        this.token("super");
        this.addArguments(node.arguments(), this.plusFour);
        this.token(";");
        return false;
    }

    @Override
    public boolean visit(SuperFieldAccess node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        if (node.getQualifier() != null) {
            node.getQualifier().accept(this);
            this.builder.breakOp();
            this.token(".");
        }
        this.token("super");
        this.builder.breakOp();
        this.token(".");
        this.visit(node.getName());
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(SuperMethodInvocation node) {
        this.sync(node);
        this.visitDot(node);
        return false;
    }

    @Override
    public boolean visit(SuperMethodReference node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        if (node.getQualifier() != null) {
            this.builder.open(this.plusFour);
            node.getQualifier().accept(this);
            this.builder.breakOp();
            this.token(".");
            this.builder.close();
        }
        this.token("super");
        this.builder.breakOp();
        this.builder.op("::");
        if (!node.typeArguments().isEmpty()) {
            this.addTypeArguments(node.typeArguments(), this.plusFour);
        }
        this.visit(node.getName());
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(SwitchCase node) {
        this.sync(node);
        this.markForPartialFormat();
        if (node.isDefault()) {
            this.token("default", this.plusTwo);
            this.token(":");
        } else {
            this.token("case", this.plusTwo);
            this.builder.space();
            node.getExpression().accept(this);
            this.token(":");
        }
        return false;
    }

    @Override
    public boolean visit(SwitchStatement node) {
        this.sync(node);
        this.token("switch");
        this.builder.space();
        this.token("(");
        node.getExpression().accept(this);
        this.token(")");
        this.builder.space();
        this.tokenBreakTrailingComment("{", this.plusTwo);
        this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
        this.builder.open(this.plusFour);
        boolean first = true;
        boolean lastWasSwitchCase = false;
        for (ASTNode statement : node.statements()) {
            if (!first && !lastWasSwitchCase) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
            if (statement.getNodeType() == 49) {
                this.builder.open(this.minusTwo);
                this.builder.forcedBreak();
                this.visit((SwitchCase)statement);
                this.builder.close();
                lastWasSwitchCase = true;
            } else {
                this.builder.forcedBreak();
                statement.accept(this);
                lastWasSwitchCase = false;
            }
            first = false;
        }
        this.builder.close();
        this.builder.forcedBreak();
        this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
        this.token("}", this.plusFour);
        return false;
    }

    @Override
    public boolean visit(SynchronizedStatement node) {
        this.sync(node);
        this.token("synchronized");
        this.builder.space();
        this.token("(");
        this.builder.open(this.plusFour);
        this.builder.breakOp();
        node.getExpression().accept(this);
        this.builder.close();
        this.token(")");
        this.builder.space();
        node.getBody().accept(this);
        return false;
    }

    @Override
    public boolean visit(ThisExpression node) {
        this.sync(node);
        if (node.getQualifier() != null) {
            this.builder.open(this.plusFour);
            node.getQualifier().accept(this);
            this.builder.breakOp();
            this.token(".");
            this.builder.close();
        }
        this.token("this");
        return false;
    }

    @Override
    public boolean visit(ThrowStatement node) {
        this.sync(node);
        this.token("throw");
        this.builder.space();
        node.getExpression().accept(this);
        this.token(";");
        return false;
    }

    @Override
    public boolean visit(TryStatement node) {
        this.sync(node);
        this.builder.open(ZERO);
        this.token("try");
        this.builder.space();
        if (!node.resources().isEmpty()) {
            this.token("(");
            this.builder.open(node.resources().size() > 1 ? this.plusFour : ZERO);
            boolean first = true;
            for (VariableDeclarationExpression resource : node.resources()) {
                if (!first) {
                    this.token(";");
                    this.builder.forcedBreak();
                }
                this.visit(resource);
                first = false;
            }
            if (this.builder.peekToken().equals((Object)Optional.of((Object)";"))) {
                this.token(";");
                this.builder.space();
            }
            this.token(")");
            this.builder.close();
            this.builder.space();
        }
        boolean trailingClauses = !node.catchClauses().isEmpty() || node.getFinally() != null;
        this.visitBlock(node.getBody(), CollapseEmptyOrNot.valueOf(!trailingClauses), AllowLeadingBlankLine.YES, AllowTrailingBlankLine.valueOf(trailingClauses));
        for (int i = 0; i < node.catchClauses().size(); ++i) {
            CatchClause catchClause = (CatchClause)node.catchClauses().get(i);
            trailingClauses = i < node.catchClauses().size() - 1 || node.getFinally() != null;
            this.visitCatchClause(catchClause, AllowTrailingBlankLine.valueOf(trailingClauses));
        }
        if (node.getFinally() != null) {
            this.builder.space();
            this.token("finally");
            this.builder.space();
            this.visitBlock(node.getFinally(), CollapseEmptyOrNot.NO, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        }
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        this.sync(node);
        List<Op> breaks = this.visitModifiers(node.modifiers(), Direction.VERTICAL, (Optional<Output.BreakTag>)Optional.absent());
        boolean hasSuperclassType = node.getSuperclassType() != null;
        boolean hasSuperInterfaceTypes = !node.superInterfaceTypes().isEmpty();
        this.builder.addAll(breaks);
        this.token(node.isInterface() ? "interface" : "class");
        this.builder.space();
        this.visit(node.getName());
        if (!node.typeParameters().isEmpty()) {
            this.token("<");
        }
        this.builder.open(this.plusFour);
        if (!node.typeParameters().isEmpty()) {
            this.typeParametersRest(node.typeParameters(), hasSuperclassType || hasSuperInterfaceTypes ? this.plusFour : ZERO);
        }
        if (hasSuperclassType) {
            this.builder.breakToFill(" ");
            this.token("extends");
            this.builder.space();
            node.getSuperclassType().accept(this);
        }
        if (hasSuperInterfaceTypes) {
            this.builder.breakToFill(" ");
            this.builder.open(node.superInterfaceTypes().size() > 1 ? this.plusFour : ZERO);
            this.token(node.isInterface() ? "extends" : "implements");
            this.builder.space();
            boolean first = true;
            for (Type superInterfaceType : node.superInterfaceTypes()) {
                if (!first) {
                    this.token(",");
                    this.builder.breakToFill(" ");
                }
                superInterfaceType.accept(this);
                first = false;
            }
            this.builder.close();
        }
        this.builder.close();
        if (node.bodyDeclarations() == null) {
            this.token(";");
        } else {
            this.addBodyDeclarations(node.bodyDeclarations(), BracesOrNot.YES, FirstDeclarationsOrNot.YES);
            this.builder.guessToken(";");
        }
        return false;
    }

    @Override
    public boolean visit(TypeDeclarationStatement node) {
        this.sync(node);
        node.getDeclaration().accept(this);
        return false;
    }

    @Override
    public boolean visit(TypeLiteral node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        node.getType().accept(this);
        this.builder.breakOp();
        this.token(".");
        this.token("class");
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(TypeMethodReference node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        node.getType().accept(this);
        this.builder.breakOp();
        this.builder.op("::");
        if (!node.typeArguments().isEmpty()) {
            this.addTypeArguments(node.typeArguments(), this.plusFour);
        }
        this.visit(node.getName());
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(TypeParameter node) {
        this.sync(node);
        this.builder.open(ZERO);
        this.visitAndBreakModifiers(node.modifiers(), Direction.HORIZONTAL, (Optional<Output.BreakTag>)Optional.absent());
        this.visit(node.getName());
        if (!node.typeBounds().isEmpty()) {
            this.builder.space();
            this.token("extends");
            this.builder.open(this.plusFour);
            this.builder.breakOp(" ");
            this.builder.open(this.plusFour);
            boolean first = true;
            for (Type typeBound : node.typeBounds()) {
                if (!first) {
                    this.builder.breakToFill(" ");
                    this.token("&");
                    this.builder.space();
                }
                typeBound.accept(this);
                first = false;
            }
            this.builder.close();
            this.builder.close();
        }
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(UnionType node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        ArrayList<Type> types = new ArrayList<Type>();
        JavaInputAstVisitor.walkUnionTypes(types, node);
        boolean first = true;
        for (Type type : types) {
            if (!first) {
                this.builder.breakOp(" ");
                this.token("|");
                this.builder.space();
            }
            type.accept(this);
            first = false;
        }
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationExpression node) {
        this.sync(node);
        this.builder.open(this.plusFour);
        for (IExtendedModifier modifier : node.modifiers()) {
            ((ASTNode)((Object)modifier)).accept(this);
            this.builder.breakToFill(" ");
        }
        node.getType().accept(this);
        if (node.fragments().size() == 1) {
            this.builder.breakToFill(" ");
            this.visit((VariableDeclarationFragment)node.fragments().get(0));
        } else {
            this.builder.breakToFill(" ");
            this.builder.open(this.plusFour);
            boolean first = true;
            for (VariableDeclarationFragment fragment : node.fragments()) {
                if (!first) {
                    this.token(",");
                    this.builder.breakToFill(" ");
                }
                this.visit(fragment);
                first = false;
            }
            this.builder.close();
        }
        this.builder.close();
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        this.sync(node);
        this.visit(node.getName());
        this.extraDimensions(this.plusFour, node.extraDimensions());
        if (node.getInitializer() != null) {
            this.builder.space();
            this.token("=");
            this.builder.breakToFill(" ");
            this.builder.open(ZERO);
            node.getInitializer().accept(this);
            this.builder.close();
        }
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        this.sync(node);
        this.addDeclaration(node, node.modifiers(), node.getType(), node.fragments(), JavaInputAstVisitor.canLocalHaveHorizontalAnnotations(node.modifiers()));
        return false;
    }

    @Override
    public boolean visit(WhileStatement node) {
        this.sync(node);
        this.token("while");
        this.builder.space();
        this.token("(");
        node.getExpression().accept(this);
        this.token(")");
        this.visitStatement(node.getBody(), CollapseEmptyOrNot.YES, AllowLeadingBlankLine.YES, AllowTrailingBlankLine.NO);
        return false;
    }

    @Override
    public boolean visit(WildcardType node) {
        this.sync(node);
        this.beforeAnnotatableType(node);
        this.builder.open(ZERO);
        this.token("?");
        if (node.getBound() != null) {
            this.builder.open(this.plusFour);
            this.builder.space();
            this.token(node.isUpperBound() ? "extends" : "super");
            this.builder.breakOp(" ");
            node.getBound().accept(this);
            this.builder.close();
        }
        this.builder.close();
        return false;
    }

    private void beforeAnnotatableType(AnnotatableType node) {
        if (!node.annotations().isEmpty()) {
            this.builder.open(ZERO);
            for (Annotation annotation : node.annotations()) {
                annotation.accept(this);
                this.builder.breakOp(" ");
            }
            this.builder.close();
        }
    }

    void visitAnnotations(List<Annotation> annotations, BreakOrNot breakBefore, BreakOrNot breakAfter) {
        if (!annotations.isEmpty()) {
            if (breakBefore.isYes()) {
                this.builder.breakToFill(" ");
            }
            boolean first = true;
            for (Annotation annotation : annotations) {
                if (!first) {
                    this.builder.breakToFill(" ");
                }
                annotation.accept(this);
                first = false;
            }
            if (breakAfter.isYes()) {
                this.builder.breakToFill(" ");
            }
        }
    }

    private void visitBlock(Block node, CollapseEmptyOrNot collapseEmptyOrNot, AllowLeadingBlankLine allowLeadingBlankLine, AllowTrailingBlankLine allowTrailingBlankLine) {
        this.sync(node);
        if (collapseEmptyOrNot.isYes() && node.statements().isEmpty()) {
            this.tokenBreakTrailingComment("{", this.plusTwo);
            this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            this.token("}", this.plusTwo);
        } else {
            this.builder.open(ZERO);
            this.builder.open(this.plusTwo);
            this.tokenBreakTrailingComment("{", this.plusTwo);
            if (allowLeadingBlankLine == AllowLeadingBlankLine.NO) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            } else {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
            boolean first = true;
            for (Statement statement : node.statements()) {
                this.builder.forcedBreak();
                if (!first) {
                    this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
                }
                first = false;
                this.markForPartialFormat();
                statement.accept(this);
            }
            this.builder.close();
            this.builder.forcedBreak();
            this.builder.close();
            if (allowTrailingBlankLine == AllowTrailingBlankLine.NO) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            } else {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
            this.markForPartialFormat();
            this.token("}", this.plusTwo);
        }
    }

    private void visitStatement(Statement node, CollapseEmptyOrNot collapseEmptyOrNot, AllowLeadingBlankLine allowLeadingBlank, AllowTrailingBlankLine allowTrailingBlank) {
        this.sync(node);
        switch (node.getNodeType()) {
            case 8: {
                this.builder.space();
                this.visitBlock((Block)node, collapseEmptyOrNot, allowLeadingBlank, allowTrailingBlank);
                break;
            }
            default: {
                this.builder.open(this.plusTwo);
                this.builder.breakOp(" ");
                node.accept(this);
                this.builder.close();
            }
        }
    }

    private void visitArrayType(ArrayType node, DimensionsOrNot includeDimensions) {
        if (includeDimensions.isYes() && !node.dimensions().isEmpty()) {
            this.builder.open(this.plusFour);
        }
        node.getElementType().accept(this);
        if (includeDimensions.isYes()) {
            for (Dimension dimension : node.dimensions()) {
                this.builder.breakToFill(dimension.annotations().isEmpty() ? "" : " ");
                this.visit(dimension);
            }
        }
        if (includeDimensions.isYes() && !node.dimensions().isEmpty()) {
            this.builder.close();
        }
    }

    void visitAndBreakModifiers(List<IExtendedModifier> modifiers, Direction annotationDirection, Optional<Output.BreakTag> declarationAnnotationBreak) {
        this.builder.addAll(this.visitModifiers(modifiers, annotationDirection, declarationAnnotationBreak));
    }

    private List<Op> visitModifiers(List<IExtendedModifier> modifiers, Direction annotationsDirection, Optional<Output.BreakTag> declarationAnnotationBreak) {
        ImmutableList<Op> trailingBreak;
        IExtendedModifier modifier;
        int idx;
        if (modifiers.isEmpty()) {
            return EMPTY_LIST;
        }
        this.builder.open(ZERO);
        boolean first = true;
        boolean lastWasAnnotation = false;
        for (idx = 0; idx < modifiers.size() && !(modifier = modifiers.get(idx)).isModifier(); ++idx) {
            if (!first) {
                this.builder.addAll((List<Op>)(annotationsDirection.isVertical() ? JavaInputAstVisitor.forceBreakList(declarationAnnotationBreak) : JavaInputAstVisitor.breakList(declarationAnnotationBreak)));
            }
            ((ASTNode)((Object)modifier)).accept(this);
            first = false;
            lastWasAnnotation = true;
        }
        this.builder.close();
        ImmutableList<Op> immutableList = trailingBreak = annotationsDirection.isVertical() ? JavaInputAstVisitor.forceBreakList(declarationAnnotationBreak) : JavaInputAstVisitor.breakList(declarationAnnotationBreak);
        if (idx >= modifiers.size()) {
            return trailingBreak;
        }
        if (lastWasAnnotation) {
            this.builder.addAll((List<Op>)trailingBreak);
        }
        this.builder.open(ZERO);
        first = true;
        while (idx < modifiers.size()) {
            IExtendedModifier modifier2 = modifiers.get(idx);
            if (!first) {
                this.builder.addAll((List<Op>)JavaInputAstVisitor.breakFillList((Optional<Output.BreakTag>)Optional.absent()));
            }
            ((ASTNode)((Object)modifier2)).accept(this);
            first = false;
            lastWasAnnotation = modifier2.isAnnotation();
            ++idx;
        }
        this.builder.close();
        return JavaInputAstVisitor.breakFillList((Optional<Output.BreakTag>)Optional.absent());
    }

    private void visitCatchClause(CatchClause node, AllowTrailingBlankLine allowTrailingBlankLine) {
        this.sync(node);
        this.builder.space();
        this.token("catch");
        this.builder.space();
        this.token("(");
        this.builder.open(this.plusFour);
        SingleVariableDeclaration ex = node.getException();
        if (ex.getType().getNodeType() == 84) {
            this.builder.open(ZERO);
            this.visitUnionType(ex);
            this.builder.close();
        } else {
            this.builder.breakToFill();
            this.builder.open(ZERO);
            this.visit(ex);
            this.builder.close();
        }
        this.builder.close();
        this.token(")");
        this.builder.space();
        this.visitBlock(node.getBody(), CollapseEmptyOrNot.NO, AllowLeadingBlankLine.YES, allowTrailingBlankLine);
    }

    private void visitUnionType(SingleVariableDeclaration declaration) {
        UnionType type = (UnionType)declaration.getType();
        this.builder.open(ZERO);
        this.sync(declaration);
        this.visitAndBreakModifiers(declaration.modifiers(), Direction.HORIZONTAL, (Optional<Output.BreakTag>)Optional.absent());
        List union = type.types();
        boolean first = true;
        for (int i = 0; i < union.size() - 1; ++i) {
            if (!first) {
                this.builder.breakOp(" ");
                this.token("|");
                this.builder.space();
            } else {
                first = false;
            }
            ((Type)union.get(i)).accept(this);
        }
        this.builder.breakOp(" ");
        this.token("|");
        this.builder.space();
        Type last = (Type)union.get(union.size() - 1);
        this.declareOne(declaration, Direction.HORIZONTAL, Collections.emptyList(), last, VarArgsOrNot.valueOf(declaration.isVarargs()), declaration.varargsAnnotations(), declaration.getName(), "", declaration.extraDimensions(), "=", (Optional<Expression>)Optional.fromNullable((Object)declaration.getInitializer()), (Optional<String>)Optional.absent(), ReceiverParameter.NO);
        this.builder.close();
    }

    private static void walkInfix(int precedence, Expression expression, List<Expression> operands, List<String> operators) {
        if (expression.getNodeType() == 27) {
            InfixExpression infixExpression = (InfixExpression)expression;
            String myOperator = infixExpression.getOperator().toString();
            if (PRECEDENCE.get(myOperator) == precedence) {
                JavaInputAstVisitor.walkInfix(precedence, infixExpression.getLeftOperand(), operands, operators);
                operators.add(myOperator);
                JavaInputAstVisitor.walkInfix(precedence, infixExpression.getRightOperand(), operands, operators);
                if (infixExpression.hasExtendedOperands()) {
                    for (Expression extendedOperand : infixExpression.extendedOperands()) {
                        operators.add(myOperator);
                        JavaInputAstVisitor.walkInfix(precedence, extendedOperand, operands, operators);
                    }
                }
            } else {
                operands.add(expression);
            }
        } else {
            operands.add(expression);
        }
    }

    private static void walkIntersectionTypes(List<Type> types, IntersectionType node) {
        for (ASTNode type : node.types()) {
            if (type.getNodeType() == 87) {
                JavaInputAstVisitor.walkIntersectionTypes(types, (IntersectionType)type);
                continue;
            }
            types.add((Type)type);
        }
    }

    private void visitFormals(ASTNode node, Optional<Type> receiverType, SimpleName receiverQualifier, List<SingleVariableDeclaration> parameters) {
        if (receiverType.isPresent() || !parameters.isEmpty()) {
            this.builder.open(ZERO);
            boolean first = true;
            if (receiverType.isPresent()) {
                this.declareOne(node, Direction.HORIZONTAL, (List<IExtendedModifier>)ImmutableList.of(), (Type)receiverType.get(), VarArgsOrNot.NO, (List<Annotation>)ImmutableList.of(), receiverQualifier, "", (List<Dimension>)ImmutableList.of(), "", (Optional<Expression>)Optional.absent(), (Optional<String>)Optional.absent(), ReceiverParameter.YES);
                first = false;
            }
            for (SingleVariableDeclaration parameter : parameters) {
                if (!first) {
                    this.token(",");
                    this.builder.breakOp(" ");
                }
                this.visitToDeclare(Direction.HORIZONTAL, parameter, (Optional<Expression>)Optional.absent(), "=");
                first = false;
            }
            this.builder.close();
        }
    }

    private void visitThrowsClause(List<Type> thrownExceptionTypes) {
        this.token("throws");
        this.builder.breakToFill(" ");
        boolean first = true;
        for (Type thrownExceptionType : thrownExceptionTypes) {
            if (!first) {
                this.token(",");
                this.builder.breakToFill(" ");
            }
            thrownExceptionType.accept(this);
            first = false;
        }
    }

    private void visitName(Name node, BreakOrNot breaks) {
        this.sync(node);
        if (node.isSimpleName()) {
            this.visit((SimpleName)node);
        } else {
            this.visitQualifiedName((QualifiedName)node, breaks);
        }
    }

    private void visitToDeclare(Direction annotationsDirection, SingleVariableDeclaration node, Optional<Expression> initializer, String equals) {
        this.sync(node);
        this.declareOne(node, annotationsDirection, node.modifiers(), node.getType(), VarArgsOrNot.valueOf(node.isVarargs()), node.varargsAnnotations(), node.getName(), "", node.extraDimensions(), equals, initializer, (Optional<String>)Optional.absent(), ReceiverParameter.NO);
    }

    private void typeParametersRest(List<TypeParameter> typeParameters, Indent plusIndent) {
        this.builder.open(plusIndent);
        this.builder.breakOp();
        this.builder.open(ZERO);
        boolean first = true;
        for (TypeParameter typeParameter : typeParameters) {
            if (!first) {
                this.token(",");
                this.builder.breakOp(" ");
            }
            typeParameter.accept(this);
            first = false;
        }
        this.token(">");
        this.builder.close();
        this.builder.close();
    }

    private static void walkUnionTypes(List<Type> types, UnionType node) {
        for (ASTNode type : node.types()) {
            if (type.getNodeType() == 84) {
                JavaInputAstVisitor.walkUnionTypes(types, (UnionType)type);
                continue;
            }
            types.add((Type)type);
        }
    }

    void visitDot(Expression node0) {
        Expression node = node0;
        ArrayDeque<Expression> stack = new ArrayDeque<Expression>();
        block8: do {
            stack.addFirst(node);
            switch (node.getNodeType()) {
                case 22: {
                    node = ((FieldAccess)node).getExpression();
                    break;
                }
                case 32: {
                    node = ((MethodInvocation)node).getExpression();
                    break;
                }
                case 40: {
                    node = ((QualifiedName)node).getQualifier();
                    break;
                }
                case 48: {
                    stack.addFirst(AST.newAST(8).newSuperFieldAccess());
                    node = ((SuperMethodInvocation)node).getQualifier();
                    break;
                }
                case 52: {
                    node = ((ThisExpression)node).getQualifier();
                    break;
                }
                case 42: {
                    node = null;
                    break block8;
                }
                default: {
                    stack.removeFirst();
                    break block8;
                }
            }
        } while (node != null);
        ArrayList<Expression> items = new ArrayList<Expression>(stack);
        boolean needDot = false;
        if (node != null) {
            if (node.getNodeType() == 14 && ((ClassInstanceCreation)node).getAnonymousClassDeclaration() != null) {
                this.builder.open(ZERO);
                node.accept(this);
                this.token(".");
            } else {
                this.builder.open(this.plusFour);
                node.accept(this);
                this.builder.breakOp();
                needDot = true;
            }
        }
        int prefixIndex = TypeNameClassifier.typePrefixLength(this.simpleNames(stack));
        int invocationCount = 0;
        int firstInvocationIndex = -1;
        for (int i = 0; i < items.size(); ++i) {
            Expression expression = (Expression)items.get(i);
            if (expression.getNodeType() != 32 && expression.getNodeType() != 48) continue;
            if (i > 0 || node != null) {
                ++invocationCount;
            }
            if (firstInvocationIndex >= 0) continue;
            firstInvocationIndex = i;
        }
        if (invocationCount == 1) {
            prefixIndex = firstInvocationIndex;
        }
        if (prefixIndex > 0) {
            this.visitDotWithPrefix(items, needDot, prefixIndex);
        } else {
            this.visitRegularDot(items, needDot);
        }
        if (node != null) {
            this.builder.close();
        }
    }

    private void visitRegularDot(List<Expression> items, boolean needDot) {
        boolean trailingDereferences = items.size() > 1;
        boolean needDot0 = needDot;
        if (!needDot0) {
            this.builder.open(this.plusFour);
        }
        int minLength = this.indentMultiplier * 4;
        int length = needDot0 ? minLength : 0;
        for (Expression e : items) {
            if (needDot) {
                if (length > minLength) {
                    this.builder.breakOp(Doc.FillMode.UNIFIED, "", ZERO);
                }
                this.token(".");
                ++length;
            }
            Output.BreakTag tyargTag = this.genSym();
            this.dotExpressionUpToArgs(e, (Optional<Output.BreakTag>)Optional.of((Object)tyargTag));
            Indent.If tyargIndent = Indent.If.make(tyargTag, this.plusFour, ZERO);
            this.dotExpressionArgsAndParen(e, tyargIndent, trailingDereferences || needDot ? this.plusFour : ZERO);
            length += e.getLength();
            needDot = true;
        }
        if (!needDot0) {
            this.builder.close();
        }
    }

    private void visitDotWithPrefix(List<Expression> items, boolean needDot, int prefixIndex) {
        boolean trailingDereferences = prefixIndex >= 0 && prefixIndex < items.size() - 1;
        this.builder.open(this.plusFour);
        this.builder.open(trailingDereferences ? ZERO : ZERO);
        Output.BreakTag nameTag = this.genSym();
        for (int i = 0; i < items.size(); ++i) {
            Expression e = items.get(i);
            if (needDot) {
                Doc.FillMode fillMode = prefixIndex >= 0 && i <= prefixIndex ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
                this.builder.breakOp(fillMode, "", ZERO, (Optional<Output.BreakTag>)Optional.of((Object)nameTag));
                this.token(".");
            }
            Output.BreakTag tyargTag = this.genSym();
            this.dotExpressionUpToArgs(e, (Optional<Output.BreakTag>)Optional.of((Object)tyargTag));
            if (prefixIndex >= 0 && i == prefixIndex) {
                this.builder.close();
            }
            Indent.If tyargIndent = Indent.If.make(tyargTag, this.plusFour, ZERO);
            Indent.If argsIndent = Indent.If.make(nameTag, this.plusFour, trailingDereferences ? this.plusFour : ZERO);
            this.dotExpressionArgsAndParen(e, tyargIndent, argsIndent);
            needDot = true;
        }
        this.builder.close();
    }

    private List<String> simpleNames(ArrayDeque<Expression> stack) {
        ImmutableList.Builder simpleNames = ImmutableList.builder();
        block6: for (Expression expression : stack) {
            switch (expression.getNodeType()) {
                case 22: {
                    simpleNames.add((Object)((FieldAccess)expression).getName().getIdentifier());
                    continue block6;
                }
                case 40: {
                    simpleNames.add((Object)((QualifiedName)expression).getName().getIdentifier());
                    continue block6;
                }
                case 42: {
                    simpleNames.add((Object)((SimpleName)expression).getIdentifier());
                    continue block6;
                }
                case 32: {
                    simpleNames.add((Object)((MethodInvocation)expression).getName().getIdentifier());
                    break;
                }
            }
            break;
        }
        return simpleNames.build();
    }

    private void dotExpressionUpToArgs(Expression expression, Optional<Output.BreakTag> tyargTag) {
        switch (expression.getNodeType()) {
            case 22: {
                FieldAccess fieldAccess = (FieldAccess)expression;
                this.visit(fieldAccess.getName());
                break;
            }
            case 32: {
                MethodInvocation methodInvocation = (MethodInvocation)expression;
                if (!methodInvocation.typeArguments().isEmpty()) {
                    this.builder.open(this.plusFour);
                    this.addTypeArguments(methodInvocation.typeArguments(), ZERO);
                    this.builder.breakOp(Doc.FillMode.UNIFIED, "", ZERO, tyargTag);
                    this.builder.close();
                }
                this.visit(methodInvocation.getName());
                break;
            }
            case 48: {
                SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)expression;
                if (!superMethodInvocation.typeArguments().isEmpty()) {
                    this.builder.open(this.plusFour);
                    this.addTypeArguments(superMethodInvocation.typeArguments(), ZERO);
                    this.builder.breakOp(Doc.FillMode.UNIFIED, "", ZERO, tyargTag);
                    this.builder.close();
                }
                this.visit(superMethodInvocation.getName());
                break;
            }
            case 47: {
                this.token("super");
                break;
            }
            case 52: {
                this.token("this");
                break;
            }
            case 40: {
                this.visit(((QualifiedName)expression).getName());
                break;
            }
            case 42: {
                this.visit((SimpleName)expression);
                break;
            }
            default: {
                expression.accept(this);
            }
        }
    }

    private void dotExpressionArgsAndParen(Expression expression, Indent tyargIndent, Indent indent) {
        switch (expression.getNodeType()) {
            case 32: {
                this.builder.open(tyargIndent);
                MethodInvocation methodInvocation = (MethodInvocation)expression;
                this.addArguments(methodInvocation.arguments(), indent);
                this.builder.close();
                break;
            }
            case 48: {
                this.builder.open(tyargIndent);
                SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)expression;
                this.addArguments(superMethodInvocation.arguments(), indent);
                this.builder.close();
                break;
            }
        }
    }

    void addTypeArguments(List<Type> typeArguments, Indent plusIndent) {
        if (!typeArguments.isEmpty()) {
            this.token("<");
            this.builder.open(plusIndent);
            boolean first = true;
            for (Type typeArgument : typeArguments) {
                if (!first) {
                    this.token(",");
                    this.builder.breakToFill(" ");
                }
                typeArgument.accept(this);
                first = false;
            }
            this.builder.close();
            this.token(">");
        }
    }

    void addArguments(List<Expression> arguments, Indent plusIndent) {
        this.builder.open(plusIndent);
        this.token("(");
        if (!arguments.isEmpty()) {
            if (this.argumentsArePaired(arguments)) {
                this.builder.forcedBreak();
                this.builder.open(ZERO);
                boolean first = true;
                for (int i = 0; i < arguments.size() - 1; i += 2) {
                    Expression argument0 = arguments.get(i);
                    Expression argument1 = arguments.get(i + 1);
                    if (!first) {
                        this.token(",");
                        this.builder.forcedBreak();
                    }
                    this.builder.open(this.plusFour);
                    argument0.accept(this);
                    this.token(",");
                    this.builder.breakOp(" ");
                    argument1.accept(this);
                    this.builder.close();
                    first = false;
                }
                this.builder.close();
            } else {
                this.builder.breakOp();
                this.builder.open(ZERO);
                boolean first = true;
                Doc.FillMode fillMode = this.hasOnlyShortItems(arguments) ? Doc.FillMode.INDEPENDENT : Doc.FillMode.UNIFIED;
                for (Expression argument : arguments) {
                    if (!first) {
                        this.token(",");
                        this.builder.breakOp(fillMode, " ", ZERO);
                    }
                    argument.accept(this);
                    first = false;
                }
                this.builder.close();
            }
        }
        this.token(")");
        this.builder.close();
    }

    private boolean argumentsArePaired(List<Expression> arguments) {
        int i;
        int n = arguments.size();
        if (n % 2 != 0 || n < 4) {
            return false;
        }
        ArrayList<Expression> firsts = new ArrayList<Expression>();
        ArrayList<Expression> seconds = new ArrayList<Expression>();
        for (int i2 = 0; i2 < n; ++i2) {
            (i2 % 2 == 0 ? firsts : seconds).add(arguments.get(i2));
        }
        Integer firstColumn0 = this.actualColumn((Expression)firsts.get(0));
        if (firstColumn0 == null) {
            return false;
        }
        for (i = 1; i < n / 2; ++i) {
            Integer firstColumnI = this.actualColumn((Expression)firsts.get(i));
            if (firstColumn0.equals(firstColumnI)) continue;
            return false;
        }
        for (i = 0; i < n / 2; ++i) {
            Integer secondColumnI = this.actualColumn((Expression)seconds.get(i));
            if (secondColumnI == null) {
                return false;
            }
            if (firstColumn0 < secondColumnI) continue;
            return false;
        }
        return JavaInputAstVisitor.expressionsAreParallel(firsts, n / 2) && JavaInputAstVisitor.expressionsAreParallel(seconds, n / 4 + 1);
    }

    private Integer actualColumn(Expression expression) {
        ImmutableMap<Integer, Integer> positionToColumnMap = this.builder.getInput().getPositionToColumnMap();
        return (Integer)positionToColumnMap.get(this.builder.actualStartColumn(expression.getStartPosition()));
    }

    private static boolean expressionsAreParallel(List<Expression> expressions, int atLeastM) {
        HashMultimap map = HashMultimap.create();
        for (Expression expression : expressions) {
            map.put((Object)expression.getNodeType(), (Object)expression);
        }
        for (Integer nodeType : map.keys()) {
            if (map.get((Object)nodeType).size() < atLeastM) continue;
            return true;
        }
        return false;
    }

    private void visitQualifiedName(QualifiedName node0, BreakOrNot breaks) {
        Name qualifier;
        QualifiedName node = node0;
        this.sync(node);
        if (breaks.isYes()) {
            this.visitDot(node0);
            return;
        }
        ArrayDeque<SimpleName> stack = new ArrayDeque<SimpleName>();
        while (true) {
            stack.addFirst(node.getName());
            qualifier = node.getQualifier();
            if (qualifier == null || qualifier.getNodeType() != 40) break;
            node = (QualifiedName)qualifier;
        }
        if (qualifier != null) {
            this.visitName(qualifier, breaks);
            this.token(".");
        }
        boolean needDot = false;
        for (SimpleName name : stack) {
            if (needDot) {
                this.token(".");
            }
            this.visit(name);
            needDot = true;
        }
    }

    void declareOne(ASTNode node, Direction annotationsDirection, List<IExtendedModifier> modifiers, Type type, VarArgsOrNot isVarargs, List<Annotation> varargsAnnotations, SimpleName name, String op, List<Dimension> extraDimensions, String equals, Optional<Expression> initializer, Optional<String> trailing, ReceiverParameter receiverParameter) {
        boolean isField;
        Output.BreakTag typeBreak = this.genSym();
        Output.BreakTag verticalAnnotationBreak = this.genSym();
        EnumSet<DeclarationPosition> position = DeclarationPosition.getPositionInParent(node);
        boolean bl = isField = node.getNodeType() == 23;
        if (isField) {
            if (!position.contains((Object)DeclarationPosition.FIRST)) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.conditional(verticalAnnotationBreak));
            } else {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
            }
        }
        this.builder.open(ZERO);
        this.visitAndBreakModifiers(modifiers, annotationsDirection, (Optional<Output.BreakTag>)Optional.of((Object)verticalAnnotationBreak));
        this.builder.open(this.plusFour);
        this.builder.open(ZERO);
        this.builder.open(ZERO);
        type.accept(this);
        if (isVarargs.isYes()) {
            this.visitAnnotations(varargsAnnotations, BreakOrNot.YES, BreakOrNot.YES);
            this.builder.op("...");
        }
        this.builder.close();
        this.builder.breakOp(Doc.FillMode.INDEPENDENT, " ", ZERO, (Optional<Output.BreakTag>)Optional.of((Object)typeBreak));
        this.builder.open(Indent.If.make(typeBreak, this.plusFour, ZERO));
        if (receiverParameter.isYes()) {
            if (name != null) {
                this.visit(name);
                this.token(".");
            }
            this.token("this");
        } else {
            this.visit(name);
        }
        this.builder.op(op);
        this.extraDimensions(initializer.isPresent() ? this.plusFour : ZERO, extraDimensions);
        this.builder.close();
        this.builder.close();
        if (initializer.isPresent()) {
            this.builder.space();
            this.token(equals);
            if (((Expression)initializer.get()).getNodeType() == 4) {
                this.builder.open(this.minusFour);
                this.builder.space();
                ((Expression)initializer.get()).accept(this);
                this.builder.close();
            } else {
                this.builder.open(Indent.If.make(typeBreak, this.plusFour, ZERO));
                this.builder.breakToFill(" ");
                ((Expression)initializer.get()).accept(this);
                this.builder.close();
            }
        }
        this.builder.close();
        if (trailing.isPresent()) {
            this.builder.guessToken((String)trailing.get());
        }
        this.builder.close();
        if (isField) {
            if (!position.contains((Object)DeclarationPosition.LAST)) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.conditional(verticalAnnotationBreak));
            } else {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
            }
        }
    }

    private void declareMany(Direction annotationsDirection, List<IExtendedModifier> modifiers, Type type, List<VariableDeclarationFragment> fragments) {
        this.builder.open(ZERO);
        this.visitAndBreakModifiers(modifiers, annotationsDirection, (Optional<Output.BreakTag>)Optional.absent());
        this.builder.open(this.plusFour);
        type.accept(this);
        boolean first = true;
        for (VariableDeclarationFragment fragment : fragments) {
            if (!first) {
                this.token(",");
            }
            this.builder.breakOp(" ");
            this.builder.open(ZERO);
            this.visit(fragment.getName());
            Expression initializer = fragment.getInitializer();
            this.extraDimensions(initializer != null ? this.plusEight : this.plusFour, fragment.extraDimensions());
            if (initializer != null) {
                this.builder.space();
                this.token("=");
                if (initializer.getNodeType() == 4) {
                    this.builder.close();
                    this.builder.open(ZERO);
                    this.builder.space();
                    initializer.accept(this);
                } else {
                    this.builder.open(this.plusFour);
                    this.builder.breakOp(" ");
                    initializer.accept(this);
                    this.builder.close();
                }
            }
            this.builder.close();
            first = false;
        }
        this.builder.close();
        this.token(";");
        this.builder.close();
    }

    void addDeclaration(ASTNode node, List<IExtendedModifier> modifiers, Type type, List<VariableDeclarationFragment> fragments, Direction annotationsDirection) {
        if (fragments.size() == 1) {
            VariableDeclarationFragment fragment = fragments.get(0);
            this.declareOne(node, annotationsDirection, modifiers, type, VarArgsOrNot.NO, (List<Annotation>)ImmutableList.of(), fragment.getName(), "", fragment.extraDimensions(), "=", (Optional<Expression>)Optional.fromNullable((Object)fragment.getInitializer()), (Optional<String>)Optional.of((Object)";"), ReceiverParameter.NO);
        } else {
            this.declareMany(annotationsDirection, modifiers, type, fragments);
        }
    }

    void extraDimensions(Indent plusIndent, List<Dimension> extraDimensions) {
        this.builder.open(plusIndent);
        for (Dimension extraDimension : extraDimensions) {
            this.builder.breakToFill(extraDimension.annotations().isEmpty() ? "" : " ");
            this.visit(extraDimension);
        }
        this.builder.close();
    }

    void addBodyDeclarations(List<BodyDeclaration> bodyDeclarations, BracesOrNot braces, FirstDeclarationsOrNot first0) {
        if (bodyDeclarations.isEmpty()) {
            if (braces.isYes()) {
                this.builder.space();
                this.tokenBreakTrailingComment("{", this.plusTwo);
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.builder.open(ZERO);
                this.token("}", this.plusTwo);
                this.builder.close();
            }
        } else {
            if (braces.isYes()) {
                this.builder.space();
                this.tokenBreakTrailingComment("{", this.plusTwo);
                this.builder.open(ZERO);
            }
            this.builder.open(this.plusTwo);
            boolean first = first0.isYes();
            boolean lastOneGotBlankLineBefore = false;
            for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                boolean thisOneGetsBlankLineBefore;
                this.dropEmptyDeclarations();
                this.builder.forcedBreak();
                boolean bl = thisOneGetsBlankLineBefore = bodyDeclaration.getNodeType() != 23 || this.hasJavaDoc(bodyDeclaration);
                if (first) {
                    this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.PRESERVE);
                } else if (!first && (thisOneGetsBlankLineBefore || lastOneGotBlankLineBefore)) {
                    this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
                }
                this.markForPartialFormat();
                bodyDeclaration.accept(this);
                first = false;
                lastOneGotBlankLineBefore = thisOneGetsBlankLineBefore;
            }
            this.builder.close();
            this.builder.forcedBreak();
            this.markForPartialFormat();
            if (braces.isYes()) {
                this.dropEmptyDeclarations();
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.NO);
                this.token("}", this.plusTwo);
                this.builder.close();
            }
        }
    }

    private boolean hasJavaDoc(BodyDeclaration bodyDeclaration) {
        int position = bodyDeclaration.getStartPosition();
        Map.Entry<Integer, ? extends Input.Token> entry = this.builder.getInput().getPositionTokenMap().ceilingEntry(position);
        if (entry != null) {
            for (Input.Tok tok : entry.getValue().getToksBefore()) {
                if (!tok.getText().startsWith("/**")) continue;
                return true;
            }
        }
        return false;
    }

    private static Optional<? extends Input.Token> getNextToken(Input input, int position) {
        Map.Entry<Integer, ? extends Input.Token> ceilingEntry = input.getPositionTokenMap().ceilingEntry(position);
        return ceilingEntry == null ? Optional.absent() : Optional.of((Object)ceilingEntry.getValue());
    }

    private static boolean hasTrailingToken(Input input, List<ASTNode> nodes, String token) {
        if (nodes.isEmpty()) {
            return false;
        }
        ASTNode lastNode = nodes.get(nodes.size() - 1);
        Optional<? extends Input.Token> nextToken = JavaInputAstVisitor.getNextToken(input, lastNode.getStartPosition() + lastNode.getLength());
        return nextToken.isPresent() && ((Input.Token)nextToken.get()).getTok().getText().equals(token);
    }

    private static Direction canLocalHaveHorizontalAnnotations(List<IExtendedModifier> modifiers) {
        int normalAnnotations = 0;
        int markerAnnotations = 0;
        int singleMemberAnnotations = 0;
        for (IExtendedModifier modifier : modifiers) {
            switch (((ASTNode)((Object)modifier)).getNodeType()) {
                case 77: {
                    ++normalAnnotations;
                    break;
                }
                case 78: {
                    ++markerAnnotations;
                    break;
                }
                case 79: {
                    ++singleMemberAnnotations;
                    break;
                }
            }
        }
        return normalAnnotations == 0 && markerAnnotations <= 1 && singleMemberAnnotations == 0 ? Direction.HORIZONTAL : Direction.VERTICAL;
    }

    private static Direction fieldAnnotationDirection(List<IExtendedModifier> modifiers) {
        for (IExtendedModifier modifier : modifiers) {
            if (!modifier.isAnnotation() || ((ASTNode)((Object)modifier)).getNodeType() == 78) continue;
            return Direction.VERTICAL;
        }
        return Direction.HORIZONTAL;
    }

    final void token(String token) {
        this.builder.token(token, Doc.Token.RealOrImaginary.REAL, ZERO, (Optional<Indent>)Optional.absent());
    }

    final void token(String token, Indent plusIndentCommentsBefore) {
        this.builder.token(token, Doc.Token.RealOrImaginary.REAL, plusIndentCommentsBefore, (Optional<Indent>)Optional.absent());
    }

    final void tokenBreakTrailingComment(String token, Indent breakAndIndentTrailingComment) {
        this.builder.token(token, Doc.Token.RealOrImaginary.REAL, ZERO, (Optional<Indent>)Optional.of((Object)breakAndIndentTrailingComment));
    }

    private void markForPartialFormat() {
        if (!this.inExpression()) {
            this.builder.markForPartialFormat();
        }
    }

    final void sync(ASTNode node) {
        this.builder.sync(node.getStartPosition());
    }

    final Output.BreakTag genSym() {
        return new Output.BreakTag();
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("builder", (Object)this.builder).toString();
    }

    static {
        PRECEDENCE.put("*", 10);
        PRECEDENCE.put("/", 10);
        PRECEDENCE.put("%", 10);
        PRECEDENCE.put("+", 9);
        PRECEDENCE.put("-", 9);
        PRECEDENCE.put("<<", 8);
        PRECEDENCE.put(">>", 8);
        PRECEDENCE.put(">>>", 8);
        PRECEDENCE.put("<", 7);
        PRECEDENCE.put(">", 7);
        PRECEDENCE.put("<=", 7);
        PRECEDENCE.put(">=", 7);
        PRECEDENCE.put("==", 6);
        PRECEDENCE.put("!=", 6);
        PRECEDENCE.put("&", 5);
        PRECEDENCE.put("^", 4);
        PRECEDENCE.put("|", 3);
        PRECEDENCE.put("&&", 2);
        PRECEDENCE.put("||", 1);
    }

    static enum DeclarationPosition {
        FIRST,
        INTERIOR,
        LAST;


        static EnumSet<DeclarationPosition> getPositionInParent(ASTNode node) {
            EnumSet<DeclarationPosition> position = EnumSet.noneOf(DeclarationPosition.class);
            StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
            if (locationInParent instanceof ChildListPropertyDescriptor) {
                List propertyList = (List)node.getParent().getStructuralProperty(locationInParent);
                int idx = propertyList.indexOf(node);
                if (idx == 0) {
                    position.add(FIRST);
                }
                if (idx == propertyList.size() - 1) {
                    position.add(LAST);
                }
                if (position.isEmpty()) {
                    position.add(INTERIOR);
                }
            }
            return position;
        }
    }

    static enum FirstDeclarationsOrNot {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    static enum ReceiverParameter {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    static enum VarArgsOrNot {
        YES,
        NO;


        static VarArgsOrNot valueOf(boolean b) {
            return b ? YES : NO;
        }

        boolean isYes() {
            return this == YES;
        }
    }

    static enum DimensionsOrNot {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    static enum BracesOrNot {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    static enum AllowTrailingBlankLine {
        YES,
        NO;


        static AllowTrailingBlankLine valueOf(boolean b) {
            return b ? YES : NO;
        }
    }

    static enum AllowLeadingBlankLine {
        YES,
        NO;


        static AllowLeadingBlankLine valueOf(boolean b) {
            return b ? YES : NO;
        }
    }

    static enum CollapseEmptyOrNot {
        YES,
        NO;


        static CollapseEmptyOrNot valueOf(boolean b) {
            return b ? YES : NO;
        }

        boolean isYes() {
            return this == YES;
        }
    }

    static enum BreakOrNot {
        YES,
        NO;


        boolean isYes() {
            return this == YES;
        }
    }

    static enum Direction {
        VERTICAL,
        HORIZONTAL;


        boolean isVertical() {
            return this == VERTICAL;
        }
    }
}

