/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.MethodSignatureFormatter;

final class BindingDeclarationFormatter
extends Formatter<BindingDeclaration> {
    private final MethodSignatureFormatter methodSignatureFormatter;

    BindingDeclarationFormatter(MethodSignatureFormatter methodSignatureFormatter) {
        this.methodSignatureFormatter = methodSignatureFormatter;
    }

    @Override
    public String format(BindingDeclaration bindingDeclaration) {
        switch (bindingDeclaration.bindingElement().asType().getKind()) {
            case EXECUTABLE: {
                return this.methodSignatureFormatter.format(bindingDeclaration.bindingElementAsExecutable(), bindingDeclaration.contributingModuleType());
            }
            case DECLARED: {
                return ErrorMessages.stripCommonTypePrefixes(bindingDeclaration.bindingElement().asType().toString());
            }
        }
        String string = String.valueOf(bindingDeclaration.bindingElement());
        throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(string).length()).append("Formatting unsupported for element: ").append(string).toString());
    }
}

