/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingMethodValidator;
import dagger.internal.codegen.BindsMethodValidator;
import dagger.internal.codegen.FactoryGenerator;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.MultibindsMethodValidator;
import dagger.internal.codegen.ProducerFactoryGenerator;
import dagger.internal.codegen.ProducesMethodValidator;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvidesMethodValidator;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class ModuleProcessingStep<B extends Binding>
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final Class<? extends Annotation> moduleAnnotation;
    private final ModuleValidator moduleValidator;
    private final Class<? extends Annotation> factoryMethodAnnotation;
    private final ModuleMethodBindingFactory<B> moduleMethodBindingFactory;
    private final SourceFileGenerator<B> factoryGenerator;
    private final ImmutableSet<? extends BindingMethodValidator> methodValidators;
    private final Set<TypeElement> processedModuleElements = Sets.newLinkedHashSet();

    static ModuleProcessingStep<ProvisionBinding> moduleProcessingStep(Messager messager, ModuleValidator moduleValidator, final ProvisionBinding.Factory provisionBindingFactory, FactoryGenerator factoryGenerator, ProvidesMethodValidator providesMethodValidator, BindsMethodValidator bindsMethodValidator, MultibindsMethodValidator multibindsMethodValidator) {
        return new ModuleProcessingStep<ProvisionBinding>(messager, Module.class, moduleValidator, Provides.class, new ModuleMethodBindingFactory<ProvisionBinding>(){

            @Override
            public ProvisionBinding bindingForModuleMethod(ExecutableElement method, TypeElement module) {
                return provisionBindingFactory.forProvidesMethod(method, module);
            }
        }, factoryGenerator, (Iterable<? extends BindingMethodValidator>)ImmutableSet.of((Object)providesMethodValidator, (Object)bindsMethodValidator, (Object)multibindsMethodValidator));
    }

    static ModuleProcessingStep<ProductionBinding> producerModuleProcessingStep(Messager messager, ModuleValidator moduleValidator, final ProductionBinding.Factory productionBindingFactory, ProducerFactoryGenerator producerFactoryGenerator, ProducesMethodValidator producesMethodValidator, BindsMethodValidator bindsMethodValidator, MultibindsMethodValidator multibindsMethodValidator) {
        return new ModuleProcessingStep<ProductionBinding>(messager, ProducerModule.class, moduleValidator, Produces.class, new ModuleMethodBindingFactory<ProductionBinding>(){

            @Override
            public ProductionBinding bindingForModuleMethod(ExecutableElement method, TypeElement module) {
                return productionBindingFactory.forProducesMethod(method, module);
            }
        }, producerFactoryGenerator, (Iterable<? extends BindingMethodValidator>)ImmutableSet.of((Object)producesMethodValidator, (Object)bindsMethodValidator, (Object)multibindsMethodValidator));
    }

    ModuleProcessingStep(Messager messager, Class<? extends Annotation> moduleAnnotation, ModuleValidator moduleValidator, Class<? extends Annotation> factoryMethodAnnotation, ModuleMethodBindingFactory<B> moduleMethodBindingFactory, SourceFileGenerator<B> factoryGenerator, Iterable<? extends BindingMethodValidator> methodValidators) {
        this.messager = messager;
        this.moduleAnnotation = moduleAnnotation;
        this.moduleValidator = moduleValidator;
        this.factoryMethodAnnotation = factoryMethodAnnotation;
        this.moduleMethodBindingFactory = moduleMethodBindingFactory;
        this.factoryGenerator = factoryGenerator;
        this.methodValidators = ImmutableSet.copyOf(methodValidators);
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        ImmutableSet.Builder annotations = ImmutableSet.builder();
        annotations.add(this.moduleAnnotation);
        for (BindingMethodValidator validator : this.methodValidators) {
            annotations.add(validator.methodAnnotation());
        }
        return annotations.build();
    }

    @Override
    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet<ExecutableElement> validMethods = this.validMethods(elementsByAnnotation);
        for (TypeElement moduleElement : Sets.difference(ElementFilter.typesIn(elementsByAnnotation.get(this.moduleAnnotation)), this.processedModuleElements)) {
            List<ExecutableElement> moduleMethods;
            ValidationReport<TypeElement> report = this.moduleValidator.validate(moduleElement);
            report.printMessagesTo(this.messager);
            if (report.isClean() && this.moduleMethodsAreValid(validMethods, moduleMethods = ElementFilter.methodsIn(moduleElement.getEnclosedElements()))) {
                for (ExecutableElement method : Util.elementsWithAnnotation(moduleMethods, this.factoryMethodAnnotation)) {
                    this.generateFactory(this.moduleMethodBindingFactory.bindingForModuleMethod(method, moduleElement));
                }
            }
            this.processedModuleElements.add(moduleElement);
        }
        return ImmutableSet.of();
    }

    private ImmutableSet<ExecutableElement> validMethods(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet.Builder validMethods = ImmutableSet.builder();
        for (BindingMethodValidator validator : this.methodValidators) {
            validMethods.addAll(validator.validate(this.messager, ElementFilter.methodsIn(elementsByAnnotation.get(validator.methodAnnotation()))));
        }
        return validMethods.build();
    }

    private boolean moduleMethodsAreValid(ImmutableSet<ExecutableElement> validMethods, Iterable<ExecutableElement> moduleMethods) {
        for (ExecutableElement methodElement : moduleMethods) {
            if (validMethods.contains((Object)methodElement)) continue;
            for (BindingMethodValidator validator : this.methodValidators) {
                if (!MoreElements.isAnnotationPresent(methodElement, validator.methodAnnotation())) continue;
                return false;
            }
        }
        return true;
    }

    private void generateFactory(B binding) {
        try {
            this.factoryGenerator.generate(binding);
        }
        catch (SourceFileGenerationException e) {
            e.printMessageTo(this.messager);
        }
    }

    private static interface ModuleMethodBindingFactory<B extends Binding> {
        public B bindingForModuleMethod(ExecutableElement var1, TypeElement var2);
    }
}

