/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import dagger.Binds;
import dagger.Provides;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;

final class Util {
    static final Function<TypeElement, DeclaredType> AS_DECLARED_TYPE = new Function<TypeElement, DeclaredType>(){

        public DeclaredType apply(TypeElement typeElement) {
            return MoreTypes.asDeclared(typeElement.asType());
        }
    };
    static final ElementVisitor<TypeElement, Void> ENCLOSING_TYPE_ELEMENT = new SimpleElementVisitor6<TypeElement, Void>(){

        @Override
        protected TypeElement defaultAction(Element e, Void p) {
            return (TypeElement)this.visit(e.getEnclosingElement());
        }

        @Override
        public TypeElement visitType(TypeElement e, Void p) {
            return e;
        }
    };

    static boolean requiresAPassedInstance(Elements elements, TypeElement typeElement) {
        ImmutableSet<ExecutableElement> methods = MoreElements.getLocalAndInheritedMethods(typeElement, elements);
        boolean foundInstanceMethod = false;
        for (ExecutableElement method : methods) {
            if (method.getModifiers().contains((Object)Modifier.ABSTRACT) && !MoreElements.isAnnotationPresent(method, Binds.class)) {
                return true;
            }
            if (method.getModifiers().contains((Object)Modifier.STATIC) || !MoreElements.isAnnotationPresent(method, Provides.class) && !MoreElements.isAnnotationPresent(method, Produces.class)) continue;
            foundInstanceMethod = true;
        }
        if (foundInstanceMethod) {
            return !Util.componentCanMakeNewInstances(typeElement);
        }
        return false;
    }

    static boolean componentCanMakeNewInstances(TypeElement typeElement) {
        switch (typeElement.getKind()) {
            case CLASS: {
                break;
            }
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                return false;
            }
            default: {
                String string = String.valueOf((Object)typeElement.getKind());
                throw new AssertionError((Object)new StringBuilder(30 + String.valueOf(string).length()).append("TypeElement cannot have kind: ").append(string).toString());
            }
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return false;
        }
        if (Util.requiresEnclosingInstance(typeElement)) {
            return false;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.CONSTRUCTOR) || !((ExecutableElement)element).getParameters().isEmpty() || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            return true;
        }
        return false;
    }

    private static boolean requiresEnclosingInstance(TypeElement typeElement) {
        switch (typeElement.getNestingKind()) {
            case TOP_LEVEL: {
                return false;
            }
            case MEMBER: {
                return !typeElement.getModifiers().contains((Object)Modifier.STATIC);
            }
            case ANONYMOUS: 
            case LOCAL: {
                return true;
            }
        }
        String string = String.valueOf((Object)typeElement.getNestingKind());
        throw new AssertionError((Object)new StringBuilder(38 + String.valueOf(string).length()).append("TypeElement cannot have nesting kind: ").append(string).toString());
    }

    static ImmutableSet<ExecutableElement> getUnimplementedMethods(Elements elements, TypeElement type) {
        return FluentIterable.from(MoreElements.getLocalAndInheritedMethods(type, elements)).filter(MoreElements.hasModifiers(Modifier.ABSTRACT)).toSet();
    }

    static Predicate<AnnotationMirror> hasAnnotationType(final Class<? extends Annotation> annotation) {
        return new Predicate<AnnotationMirror>(){

            public boolean apply(AnnotationMirror input) {
                return MoreTypes.isTypeOf(annotation, input.getAnnotationType());
            }
        };
    }

    static boolean isAnyAnnotationPresent(Element element, Iterable<? extends Class<? extends Annotation>> annotationClasses) {
        for (Class<? extends Annotation> clazz : annotationClasses) {
            if (!MoreElements.isAnnotationPresent(element, clazz)) continue;
            return true;
        }
        return false;
    }

    static <E extends Element> FluentIterable<E> elementsWithAnnotation(Iterable<E> elements, final Class<? extends Annotation> annotation) {
        return FluentIterable.from(elements).filter((Predicate)new Predicate<Element>(){

            public boolean apply(Element element) {
                return MoreElements.isAnnotationPresent(element, annotation);
            }
        });
    }

    private Util() {
    }
}

