/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

class ClassEntry
implements Comparable<ClassEntry> {
    public final File file;
    public final File jarFile;
    public final File binDir;
    public final byte[] bytes;

    ClassEntry(File file, File jarFile, File binDir, byte[] bytes) {
        this.file = file;
        this.jarFile = jarFile;
        this.binDir = binDir;
        this.bytes = bytes;
    }

    public String path() {
        if (this.jarFile != null) {
            return this.jarFile.getPath() + ':' + this.file.getPath();
        }
        return this.file.getPath();
    }

    @Override
    public int compareTo(ClassEntry other) {
        int m2;
        String p1 = this.file.getPath();
        String p2 = other.file.getPath();
        int m1 = p1.length();
        if (m1 == (m2 = p2.length()) && p1.equals(p2)) {
            return 0;
        }
        int m = Math.min(m1, m2);
        for (int i = 0; i < m; ++i) {
            char c2;
            char c1 = p1.charAt(i);
            if (c1 == (c2 = p2.charAt(i))) continue;
            if (c1 == '.' && c2 == '$') {
                return -1;
            }
            if (c1 == '$' && c2 == '.') {
                return 1;
            }
            return c1 - c2;
        }
        return m == m1 ? -1 : 1;
    }

    public String toString() {
        return this.file.getPath();
    }

    public static List<ClassEntry> fromClassPath(LintClient client, List<File> classPath, boolean sort) {
        if (!classPath.isEmpty()) {
            ArrayList<ClassEntry> libraryEntries = new ArrayList<ClassEntry>(64);
            ClassEntry.addEntries(client, libraryEntries, classPath);
            if (sort) {
                Collections.sort(libraryEntries);
            }
            return libraryEntries;
        }
        return Collections.emptyList();
    }

    public static List<ClassEntry> fromClassFiles(LintClient client, List<File> classFiles, List<File> classFolders, boolean sort) {
        ArrayList<ClassEntry> entries = new ArrayList<ClassEntry>(classFiles.size());
        if (!classFolders.isEmpty()) {
            for (File file : classFiles) {
                String path = file.getPath();
                if (!file.isFile() || !path.endsWith(".class")) continue;
                try {
                    byte[] bytes = client.readBytes(file);
                    for (File dir : classFolders) {
                        if (!path.startsWith(dir.getPath())) continue;
                        entries.add(new ClassEntry(file, null, dir, bytes));
                    }
                }
                catch (IOException e) {
                    client.log(e, null, new Object[0]);
                }
            }
            if (sort && !entries.isEmpty()) {
                Collections.sort(entries);
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void addEntries(LintClient client, List<ClassEntry> entries, List<File> classPath) {
        for (File classPathEntry : classPath) {
            if (classPathEntry.getName().endsWith(".jar")) {
                File jarFile = classPathEntry;
                if (!jarFile.exists()) continue;
                ZipInputStream zis = null;
                FileInputStream fis = new FileInputStream(jarFile);
                try {
                    zis = new ZipInputStream(fis);
                    ZipEntry entry = zis.getNextEntry();
                    while (entry != null) {
                        block23: {
                            String name = entry.getName();
                            if (name.endsWith(".class")) {
                                try {
                                    byte[] bytes = ByteStreams.toByteArray((InputStream)zis);
                                    if (bytes == null) break block23;
                                    File file = new File(entry.getName());
                                    entries.add(new ClassEntry(file, jarFile, jarFile, bytes));
                                }
                                catch (Exception e) {
                                    client.log(e, null, new Object[0]);
                                    continue;
                                }
                            }
                        }
                        entry = zis.getNextEntry();
                    }
                }
                finally {
                    Closeables.close((Closeable)fis, (boolean)true);
                }
                try {
                    Closeables.close((Closeable)zis, (boolean)true);
                }
                catch (IOException e) {}
                continue;
                catch (IOException e) {
                    try {
                        client.log(e, "Could not read jar file contents from %1$s", jarFile);
                    }
                    catch (Throwable throwable) {
                        try {
                            Closeables.close(zis, (boolean)true);
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        Closeables.close((Closeable)zis, (boolean)true);
                    }
                    catch (IOException e3) {}
                    continue;
                }
            }
            if (classPathEntry.isDirectory()) {
                File binDir = classPathEntry;
                ArrayList<File> classFiles = new ArrayList<File>();
                ClassEntry.addClassFiles(binDir, classFiles);
                for (File file : classFiles) {
                    try {
                        byte[] bytes = client.readBytes(file);
                        entries.add(new ClassEntry(file, null, binDir, bytes));
                    }
                    catch (IOException e) {
                        client.log(e, null, new Object[0]);
                    }
                }
                continue;
            }
            client.log(null, "Ignoring class path entry %1$s", classPathEntry);
        }
    }

    private static void addClassFiles(File dir, List<File> classFiles) {
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isFile() && file.getName().endsWith(".class")) {
                    classFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                ClassEntry.addClassFiles(file, classFiles);
            }
        }
    }

    public static Map<String, String> createSuperClassMap(LintClient client, List<ClassEntry> libraryEntries, List<ClassEntry> classEntries) {
        int size = libraryEntries.size() + classEntries.size();
        HashMap map = Maps.newHashMapWithExpectedSize((int)size);
        SuperclassVisitor visitor = new SuperclassVisitor(map);
        ClassEntry.addSuperClasses(client, visitor, libraryEntries);
        ClassEntry.addSuperClasses(client, visitor, classEntries);
        return map;
    }

    public static Map<String, String> createSuperClassMap(LintClient client, List<ClassEntry> entries) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)entries.size());
        SuperclassVisitor visitor = new SuperclassVisitor(map);
        ClassEntry.addSuperClasses(client, visitor, entries);
        return map;
    }

    private static void addSuperClasses(LintClient client, SuperclassVisitor visitor, List<ClassEntry> entries) {
        for (ClassEntry entry : entries) {
            try {
                ClassReader reader = new ClassReader(entry.bytes);
                int flags = 7;
                reader.accept((ClassVisitor)visitor, flags);
            }
            catch (Throwable t) {
                client.log(null, "Error processing %1$s: broken class file?", entry.path());
            }
        }
    }

    private static class SuperclassVisitor
    extends ClassVisitor {
        private final Map<String, String> mMap;

        public SuperclassVisitor(Map<String, String> map) {
            super(327680);
            this.mMap = map;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (superName != null && !"java/lang/Object".equals(superName)) {
                this.mMap.put(name, superName);
            }
        }
    }
}

