/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractArgumentParameterChecker;
import com.google.errorprone.bugpatterns.ArgumentParameterSimilarityMetrics;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@BugPattern(name="ArgumentParameterSwap", summary="An argument is more similar to a different parameter; the arguments may have been swapped.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class ArgumentParameterSwap
extends AbstractArgumentParameterChecker {
    private static final ImmutableSet<Tree.Kind> VALID_KINDS = ImmutableSet.of((Object)((Object)Tree.Kind.MEMBER_SELECT), (Object)((Object)Tree.Kind.IDENTIFIER), (Object)((Object)Tree.Kind.METHOD_INVOCATION));
    private static final Function<VisitorState, ImmutableSet<AbstractArgumentParameterChecker.PotentialReplacement>> REPLACEMENTS_DRAWN_FROM_ARGS = state -> {
        List<? extends ExpressionTree> args;
        Tree parentNode = state.getPath().getParentPath().getLeaf();
        switch (parentNode.getKind()) {
            case METHOD_INVOCATION: {
                args = ((MethodInvocationTree)parentNode).getArguments();
                break;
            }
            case NEW_CLASS: {
                args = ((NewClassTree)parentNode).getArguments();
                break;
            }
            default: {
                return ImmutableSet.of();
            }
        }
        return (ImmutableSet)args.stream().filter(expr -> VALID_KINDS.contains((Object)expr.getKind())).map(ArgumentParameterSwap::potentialReplacement).filter(s -> s != null).collect(ImmutableSet.toImmutableSet());
    };

    public ArgumentParameterSwap() {
        this((ImmutableSet<String>)ImmutableSet.of((Object)"index", (Object)"item", (Object)"key", (Object)"value"), 0.667);
    }

    public ArgumentParameterSwap(ImmutableSet<String> ignoreParams, double swapHandicap) {
        super(REPLACEMENTS_DRAWN_FROM_ARGS, new AbstractArgumentParameterChecker.ParameterPredicate(ignoreParams, 4), swapHandicap, ArgumentParameterSimilarityMetrics::computeNormalizedTermIntersection, VALID_KINDS);
    }

    @Nullable
    private static AbstractArgumentParameterChecker.PotentialReplacement potentialReplacement(ExpressionTree expr) {
        String extractedArgumentName = ArgumentParameterSwap.extractArgumentName(expr);
        return extractedArgumentName == null ? null : AbstractArgumentParameterChecker.PotentialReplacement.create(extractedArgumentName, expr.toString(), ASTHelpers.getSymbol((Tree)expr));
    }
}

