/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.lookup;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.turbine.binder.lookup.CanonicalSymbolResolver;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.Scope;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.tree.Tree;

public class WildImportIndex
implements Scope {
    private final ImmutableList<Supplier<Scope>> packages;

    public WildImportIndex(ImmutableList<Supplier<Scope>> packages) {
        this.packages = packages;
    }

    public static WildImportIndex create(final CanonicalSymbolResolver resolve, final TopLevelIndex cpi, ImmutableList<Tree.ImportDecl> imports) {
        ImmutableList.Builder packageScopes = ImmutableList.builder();
        for (final Tree.ImportDecl i : imports) {
            if (!i.wild()) continue;
            packageScopes.add((Object)Suppliers.memoize((Supplier)new Supplier<Scope>(){

                public Scope get() {
                    Scope packageIndex = cpi.lookupPackage(i.type());
                    if (packageIndex != null) {
                        return packageIndex;
                    }
                    LookupResult result = cpi.lookup(new LookupKey((Iterable<String>)i.type()));
                    if (result == null) {
                        return null;
                    }
                    final ClassSymbol sym = resolve.resolve(result);
                    if (sym == null) {
                        return null;
                    }
                    return new Scope(){

                        @Override
                        public LookupResult lookup(LookupKey lookupKey) {
                            ClassSymbol member = resolve.resolveOne(sym, lookupKey.first());
                            return member != null ? new LookupResult(member, lookupKey) : null;
                        }
                    };
                }
            }));
        }
        return new WildImportIndex((ImmutableList<Supplier<Scope>>)packageScopes.build());
    }

    @Override
    public LookupResult lookup(LookupKey lookup) {
        for (Supplier packageScope : this.packages) {
            LookupResult result;
            Scope scope = (Scope)packageScope.get();
            if (scope == null || (result = scope.lookup(lookup)) == null) continue;
            return result;
        }
        return null;
    }
}

