/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

public class Util {
    public boolean verbose = false;
    public PrintWriter log;
    public DiagnosticListener<? super JavaFileObject> dl;
    private ResourceBundle m;

    Util(PrintWriter log, DiagnosticListener<? super JavaFileObject> dl) {
        this.log = log;
        this.dl = dl;
    }

    public void log(String s) {
        this.log.println(s);
    }

    private void initMessages() throws Exit {
        try {
            this.m = ResourceBundle.getBundle("com.sun.tools.javah.resources.l10n");
        }
        catch (MissingResourceException mre) {
            this.fatal("Error loading resources.  Please file a bug report.", mre);
        }
    }

    private String getText(String key, Object ... args) throws Exit {
        if (this.m == null) {
            this.initMessages();
        }
        try {
            return MessageFormat.format(this.m.getString(key), args);
        }
        catch (MissingResourceException e) {
            this.fatal("Key " + key + " not found in resources.", e);
            return null;
        }
    }

    public void usage() throws Exit {
        this.log.println(this.getText("usage", new Object[0]));
    }

    public void version() throws Exit {
        this.log.println(this.getText("javah.version", System.getProperty("java.version"), null));
    }

    public void bug(String key) throws Exit {
        this.bug(key, null);
    }

    public void bug(String key, Exception e) throws Exit {
        this.dl.report(this.createDiagnostic(Diagnostic.Kind.ERROR, key, new Object[0]));
        this.dl.report(this.createDiagnostic(Diagnostic.Kind.NOTE, "bug.report", new Object[0]));
        throw new Exit(11, (Throwable)e);
    }

    public void error(String key, Object ... args) throws Exit {
        this.dl.report(this.createDiagnostic(Diagnostic.Kind.ERROR, key, args));
        throw new Exit(15);
    }

    private void fatal(String msg, Exception e) throws Exit {
        this.dl.report(this.createDiagnostic(Diagnostic.Kind.ERROR, "", msg));
        throw new Exit(10, (Throwable)e);
    }

    private Diagnostic<JavaFileObject> createDiagnostic(final Diagnostic.Kind kind, final String code, final Object ... args) {
        return new Diagnostic<JavaFileObject>(){

            @Override
            public String getCode() {
                return code;
            }

            @Override
            public long getColumnNumber() {
                return -1L;
            }

            @Override
            public long getEndPosition() {
                return -1L;
            }

            @Override
            public Diagnostic.Kind getKind() {
                return kind;
            }

            @Override
            public long getLineNumber() {
                return -1L;
            }

            @Override
            public String getMessage(Locale locale) {
                if (code.length() == 0) {
                    return (String)args[0];
                }
                return Util.this.getText(code, args);
            }

            @Override
            public long getPosition() {
                return -1L;
            }

            @Override
            public JavaFileObject getSource() {
                return null;
            }

            @Override
            public long getStartPosition() {
                return -1L;
            }
        };
    }

    public static class Exit
    extends Error {
        private static final long serialVersionUID = 430820978114067221L;
        public final int exitValue;
        public final Throwable cause;

        Exit(int exitValue) {
            this(exitValue, null);
        }

        Exit(int exitValue, Throwable cause) {
            super(cause);
            this.exitValue = exitValue;
            this.cause = cause;
        }

        Exit(Exit e) {
            this(e.exitValue, e.cause);
        }
    }
}

