/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Util {
    public static String toFileSystemPath(String pkgId) {
        String pn;
        if (pkgId == null || pkgId.length() == 0) {
            return null;
        }
        if (pkgId.charAt(0) == ':') {
            pn = pkgId.substring(1).replace('.', File.separatorChar);
        } else {
            int cp = pkgId.indexOf(58);
            String mn = pkgId.substring(0, cp);
            pn = mn + File.separatorChar + pkgId.substring(cp + 1).replace('.', File.separatorChar);
        }
        return pn;
    }

    public static String justPackageName(String pkgName) {
        int c = pkgName.indexOf(":");
        if (c == -1) {
            throw new IllegalArgumentException("Expected ':' in package name (" + pkgName + ")");
        }
        return pkgName.substring(c + 1);
    }

    public static String extractStringOption(String opName, String s) {
        return Util.extractStringOption(opName, s, null);
    }

    public static String extractStringOption(String opName, String s, String deflt) {
        int p = s.indexOf(opName + "=");
        if (p == -1) {
            return deflt;
        }
        int pe = s.indexOf(44, p += opName.length() + 1);
        if (pe == -1) {
            pe = s.length();
        }
        return s.substring(p, pe);
    }

    public static boolean extractBooleanOption(String opName, String s, boolean deflt) {
        String str = Util.extractStringOption(opName, s);
        return "true".equals(str) ? true : ("false".equals(str) ? false : deflt);
    }

    public static int extractIntOption(String opName, String s) {
        return Util.extractIntOption(opName, s, 0);
    }

    public static int extractIntOption(String opName, String s, int deflt) {
        int p = s.indexOf(opName + "=");
        if (p == -1) {
            return deflt;
        }
        int pe = s.indexOf(44, p += opName.length() + 1);
        if (pe == -1) {
            pe = s.length();
        }
        int v = 0;
        try {
            v = Integer.parseInt(s.substring(p, pe));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    public static String pkgNameOfClassName(String fqClassName) {
        int i = fqClassName.lastIndexOf(46);
        String pkg = i == -1 ? "" : fqClassName.substring(0, i);
        return ":" + pkg;
    }

    public static String cleanSubOptions(Set<String> allowedSubOptions, String s) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String o = st.nextToken();
            int p = o.indexOf(61);
            if (p <= 0) continue;
            String key = o.substring(0, p);
            String val = o.substring(p + 1);
            if (!allowedSubOptions.contains(key)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(key + "=" + val);
        }
        return sb.toString();
    }

    public static Set<String> set(String ... ss) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(ss));
        return set;
    }

    public static String normalizeDriveLetter(String file) {
        if (file.length() > 2 && file.charAt(1) == ':') {
            return Character.toUpperCase(file.charAt(0)) + file.substring(1);
        }
        if (file.length() > 3 && file.charAt(0) == '*' && file.charAt(2) == ':') {
            return file.substring(0, 1) + Character.toUpperCase(file.charAt(1)) + file.substring(2);
        }
        return file;
    }

    public static String findServerSettings(String[] args) {
        for (String s : args) {
            if (!s.startsWith("--server:")) continue;
            return s;
        }
        return null;
    }

    public static <E> Set<E> union(Set<? extends E> s1, Set<? extends E> s2) {
        HashSet<Object> union = new HashSet<Object>();
        union.addAll(s1);
        union.addAll(s2);
        return union;
    }

    public static <E> Set<E> subtract(Set<? extends E> orig, Set<? extends E> toSubtract) {
        HashSet<E> difference = new HashSet<E>(orig);
        difference.removeAll(toSubtract);
        return difference;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static File pathToFile(Path path) {
        return path == null ? null : path.toFile();
    }

    public static <E> Set<E> intersection(Collection<? extends E> c1, Collection<? extends E> c2) {
        HashSet<E> intersection = new HashSet<E>(c1);
        intersection.retainAll(c2);
        return intersection;
    }

    public static <I, T> Map<I, T> indexBy(Collection<? extends T> c, Function<? super T, ? extends I> indexFunction) {
        return c.stream().collect(Collectors.toMap(indexFunction, o -> o));
    }
}

