/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.client.CacheInvalidationMessage;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;

public class CacheSingleInvalidationMessage
extends CacheInvalidationMessage {
    private Data key;
    private String sourceUuid;

    public CacheSingleInvalidationMessage() {
    }

    public CacheSingleInvalidationMessage(String name, Data key, String sourceUuid) {
        super(name);
        this.key = key;
        this.sourceUuid = sourceUuid;
    }

    @Override
    public Data getKey() {
        return this.key;
    }

    @Override
    public String getSourceUuid() {
        return this.sourceUuid;
    }

    @Override
    public int getClassId() {
        return 13;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        super.writePortable(writer);
        writer.writeUTF("uuid", this.sourceUuid);
        ObjectDataOutput out = writer.getRawDataOutput();
        boolean hasKey = this.key != null;
        out.writeBoolean(hasKey);
        if (hasKey) {
            out.writeData(this.key);
        }
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        super.readPortable(reader);
        this.sourceUuid = reader.readUTF("uuid");
        ObjectDataInput in = reader.getRawDataInput();
        if (in.readBoolean()) {
            this.key = in.readData();
        }
    }

    public String toString() {
        return "CacheSingleInvalidationMessage{name='" + this.name + '\'' + ", key=" + this.key + ", sourceUuid='" + this.sourceUuid + '\'' + '}';
    }
}

