/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.queue.client;

import com.hazelcast.collection.impl.queue.client.QueueRequest;
import com.hazelcast.collection.impl.queue.operations.PollOperation;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.spi.Operation;
import java.security.Permission;
import java.util.concurrent.TimeUnit;

public class PollRequest
extends QueueRequest {
    public PollRequest() {
    }

    public PollRequest(String name) {
        super(name);
    }

    public PollRequest(String name, long timeoutMillis) {
        super(name, timeoutMillis);
    }

    @Override
    protected Operation prepareOperation() {
        return new PollOperation(this.name, this.timeoutMillis);
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(this.name, "remove");
    }

    @Override
    public String getMethodName() {
        if (this.timeoutMillis == -1L) {
            return "take";
        }
        return "poll";
    }

    @Override
    public Object[] getParameters() {
        if (this.timeoutMillis > 0L) {
            return new Object[]{this.timeoutMillis, TimeUnit.MILLISECONDS};
        }
        return null;
    }
}

