/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.bufferpool;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.bufferpool.BufferPool;
import com.hazelcast.internal.serialization.impl.bufferpool.BufferPoolFactory;
import com.hazelcast.util.ConcurrentReferenceHashMap;
import java.util.concurrent.ConcurrentMap;

public final class BufferPoolThreadLocal {
    private static final float LOAD_FACTOR = 0.91f;
    private final ConcurrentMap<Thread, BufferPool> pools;
    private final SerializationService serializationService;
    private final BufferPoolFactory bufferPoolFactory;

    public BufferPoolThreadLocal(SerializationService serializationService, BufferPoolFactory bufferPoolFactory) {
        this.serializationService = serializationService;
        this.bufferPoolFactory = bufferPoolFactory;
        int initialCapacity = Runtime.getRuntime().availableProcessors();
        this.pools = new ConcurrentReferenceHashMap<Thread, BufferPool>(initialCapacity, 0.91f, 1);
    }

    public BufferPool get() {
        Thread t = Thread.currentThread();
        BufferPool pool = (BufferPool)this.pools.get(t);
        if (pool == null) {
            pool = this.bufferPoolFactory.create(this.serializationService);
            this.pools.put(t, pool);
        }
        return pool;
    }

    public void clear() {
        this.pools.clear();
    }
}

