/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.nonblocking;

import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.ascii.TextReadHandler;
import com.hazelcast.nio.tcp.NewClientReadHandler;
import com.hazelcast.nio.tcp.OldClientReadHandler;
import com.hazelcast.nio.tcp.ReadHandler;
import com.hazelcast.nio.tcp.SocketReader;
import com.hazelcast.nio.tcp.SocketWriter;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.nonblocking.AbstractHandler;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThread;
import com.hazelcast.util.Clock;
import com.hazelcast.util.StringUtil;
import com.hazelcast.util.counters.Counter;
import com.hazelcast.util.counters.SwCounter;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;

public final class NonBlockingSocketReader
extends AbstractHandler
implements SocketReader {
    @Probe(name="in.eventCount")
    private final SwCounter eventCount = SwCounter.newSwCounter();
    @Probe(name="in.bytesRead")
    private final SwCounter bytesRead = SwCounter.newSwCounter();
    @Probe(name="in.normalFramesRead")
    private final SwCounter normalFramesRead = SwCounter.newSwCounter();
    @Probe(name="in.priorityFramesRead")
    private final SwCounter priorityFramesRead = SwCounter.newSwCounter();
    private final MetricsRegistry metricRegistry;
    private ReadHandler readHandler;
    private ByteBuffer inputBuffer;
    private volatile long lastReadTime;

    public NonBlockingSocketReader(TcpIpConnection connection, NonBlockingIOThread ioThread, MetricsRegistry metricsRegistry) {
        super(connection, ioThread, 1);
        this.ioThread = ioThread;
        this.metricRegistry = metricsRegistry;
        this.metricRegistry.scanAndRegister(this, "tcp.connection[" + connection.getMetricsId() + "]");
    }

    @Probe(name="in.idleTimeMs", level=ProbeLevel.DEBUG)
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastReadTime, 0L);
    }

    @Probe(name="in.interestedOps", level=ProbeLevel.DEBUG)
    private long interestOps() {
        SelectionKey selectionKey = this.selectionKey;
        return selectionKey == null ? -1L : (long)selectionKey.interestOps();
    }

    @Probe(name="in.readyOps", level=ProbeLevel.DEBUG)
    private long readyOps() {
        SelectionKey selectionKey = this.selectionKey;
        return selectionKey == null ? -1L : (long)selectionKey.readyOps();
    }

    @Override
    public Counter getNormalFramesReadCounter() {
        return this.normalFramesRead;
    }

    @Override
    public Counter getPriorityFramesReadCounter() {
        return this.priorityFramesRead;
    }

    @Override
    public long getLastReadTimeMillis() {
        return this.lastReadTime;
    }

    @Override
    public long getEventCount() {
        return this.eventCount.get();
    }

    @Override
    public void init() {
        this.ioThread.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                try {
                    NonBlockingSocketReader.this.getSelectionKey();
                }
                catch (Throwable t) {
                    NonBlockingSocketReader.this.onFailure(t);
                }
            }
        });
    }

    @Override
    public void requestMigration(NonBlockingIOThread newOwner) {
        this.ioThread.addTaskAndWakeup(new StartMigrationTask(newOwner));
    }

    @Override
    public void handle() throws Exception {
        int readBytes;
        this.eventCount.inc();
        this.lastReadTime = Clock.currentTimeMillis();
        if (!this.connection.isAlive()) {
            this.logger.finest("We are being asked to read, but connection is not live so we won't");
            return;
        }
        if (this.readHandler == null) {
            this.initReadHandler();
            if (this.readHandler == null) {
                return;
            }
        }
        if ((readBytes = this.socketChannel.read(this.inputBuffer)) <= 0) {
            if (readBytes == -1) {
                throw new EOFException("Remote socket closed!");
            }
            return;
        }
        this.bytesRead.inc(readBytes);
        this.inputBuffer.flip();
        this.readHandler.onRead(this.inputBuffer);
        if (this.inputBuffer.hasRemaining()) {
            this.inputBuffer.compact();
        } else {
            this.inputBuffer.clear();
        }
    }

    private void initReadHandler() throws IOException {
        if (this.readHandler != null) {
            return;
        }
        ByteBuffer protocolBuffer = ByteBuffer.allocate(3);
        int readBytes = this.socketChannel.read(protocolBuffer);
        if (readBytes == -1) {
            throw new EOFException("Could not read protocol type!");
        }
        if (readBytes == 0 && this.connectionManager.isSSLEnabled()) {
            return;
        }
        if (!protocolBuffer.hasRemaining()) {
            String protocol = StringUtil.bytesToString(protocolBuffer.array());
            SocketWriter socketWriter = this.connection.getSocketWriter();
            if ("HZC".equals(protocol)) {
                this.configureBuffers(this.ioService.getSocketReceiveBufferSize() * 1024);
                this.connection.setType(ConnectionType.MEMBER);
                socketWriter.setProtocol("HZC");
                this.readHandler = this.ioService.createReadHandler(this.connection);
            } else if ("CB1".equals(protocol)) {
                this.configureBuffers(this.ioService.getSocketClientReceiveBufferSize() * 1024);
                socketWriter.setProtocol("CB1");
                this.readHandler = new OldClientReadHandler(this.connection, this.ioService);
            } else if ("CB2".equals(protocol)) {
                this.configureBuffers(this.ioService.getSocketClientReceiveBufferSize() * 1024);
                socketWriter.setProtocol("CB2");
                this.readHandler = new NewClientReadHandler(this.connection, this.ioService);
            } else {
                this.configureBuffers(this.ioService.getSocketReceiveBufferSize() * 1024);
                socketWriter.setProtocol("TXT");
                this.inputBuffer.put(protocolBuffer.array());
                this.readHandler = new TextReadHandler(this.connection);
                this.connection.getConnectionManager().incrementTextConnections();
            }
        }
        if (this.readHandler == null) {
            throw new IOException("Could not initialize ReadHandler!");
        }
    }

    private void configureBuffers(int size) {
        this.inputBuffer = ByteBuffer.allocate(size);
        try {
            this.connection.setReceiveBufferSize(size);
        }
        catch (SocketException e) {
            this.logger.finest("Failed to adjust TCP receive buffer of " + this.connection + " to " + size + " B.", e);
        }
    }

    @Override
    public void destroy() {
        this.metricRegistry.deregister(this);
        this.ioThread.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                try {
                    NonBlockingSocketReader.this.socketChannel.closeInbound();
                }
                catch (IOException e) {
                    NonBlockingSocketReader.this.logger.finest("Error while closing inbound", e);
                }
            }
        });
    }

    public String toString() {
        return this.connection + ".socketReader";
    }

    private class StartMigrationTask
    implements Runnable {
        private final NonBlockingIOThread newOwner;

        public StartMigrationTask(NonBlockingIOThread newOwner) {
            this.newOwner = newOwner;
        }

        @Override
        public void run() {
            if (NonBlockingSocketReader.this.ioThread == this.newOwner) {
                return;
            }
            try {
                NonBlockingSocketReader.this.startMigration(this.newOwner);
            }
            catch (Throwable t) {
                NonBlockingSocketReader.this.onFailure(t);
            }
        }
    }
}

