// Copyright 2016 The Bazel Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef LINUX_SANDBOX_OPTIONS_H__
#define LINUX_SANDBOX_OPTIONS_H__

#include <stdbool.h>
#include <stddef.h>

#include <string>
#include <vector>

// Options parsing result.
struct Options {
  // Working directory (-W)
  std::string working_dir;
  // How long to wait before killing the child (-T)
  int timeout_secs;
  // How long to wait before sending SIGKILL in case of timeout (-t)
  int kill_delay_secs;
  // Where to redirect stdout (-l)
  std::string stdout_path;
  // Where to redirect stderr (-L)
  std::string stderr_path;
  // Files or directories to make writable for the sandboxed process (-w)
  std::vector<std::string> writable_files;
  // Directories where to mount an empty tmpfs (-e)
  std::vector<std::string> tmpfs_dirs;
  // Source of files or directories to explicitly bind mount in the sandbox (-M)
  std::vector<std::string> bind_mount_sources;
  // Target of files or directories to explicitly bind mount in the sandbox (-m)
  std::vector<std::string> bind_mount_targets;
  // Set the hostname inside the sandbox to 'localhost' (-H)
  bool fake_hostname;
  // Create a new network namespace (-N)
  bool create_netns;
  // Pretend to be root inside the namespace (-R)
  bool fake_root;
  // Set the username inside the sandbox to 'nobody' (-U)
  bool fake_username;
  // Print debugging messages (-D)
  bool debug;
  // Command to run (--)
  std::vector<char *> args;
};

extern struct Options opt;

void ParseOptions(int argc, char *argv[]);

#endif
