/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.Resolve;
import com.google.turbine.binder.bound.BoundClass;
import com.google.turbine.binder.bound.HeaderBoundClass;
import com.google.turbine.binder.bound.PackageSourceBoundClass;
import com.google.turbine.binder.bound.SourceHeaderBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.tree.Tree;
import java.util.ArrayDeque;

public class HierarchyBinder {
    private final ClassSymbol origin;
    private final PackageSourceBoundClass base;
    private final Env<ClassSymbol, ? extends HeaderBoundClass> env;

    public static SourceHeaderBoundClass bind(ClassSymbol origin, PackageSourceBoundClass base, Env<ClassSymbol, ? extends HeaderBoundClass> env) {
        return new HierarchyBinder(origin, base, env).bind();
    }

    private HierarchyBinder(ClassSymbol origin, PackageSourceBoundClass base, Env<ClassSymbol, ? extends HeaderBoundClass> env) {
        this.origin = origin;
        this.base = base;
        this.env = env;
    }

    private SourceHeaderBoundClass bind() {
        ClassSymbol superclass;
        Tree.TyDecl decl = this.base.decl();
        int access = this.base.access();
        switch (decl.tykind()) {
            case CLASS: {
                access |= 0x20;
                break;
            }
            case INTERFACE: {
                access |= 0x600;
                break;
            }
            case ENUM: {
                access |= 0x4020;
                break;
            }
            case ANNOTATION: {
                access |= 0x2600;
                break;
            }
            default: {
                throw new AssertionError((Object)decl.tykind());
            }
        }
        if ((access & 8) == 0 && this.implicitStatic(this.base)) {
            access |= 8;
        }
        if (decl.tykind() == TurbineTyKind.INTERFACE) {
            access |= 0x400;
        }
        if (decl.xtnds().isPresent()) {
            superclass = this.resolveClass((Tree.ClassTy)decl.xtnds().get());
        } else {
            switch (decl.tykind()) {
                case ENUM: {
                    superclass = ClassSymbol.ENUM;
                    access |= 0x10;
                    break;
                }
                case CLASS: 
                case INTERFACE: 
                case ANNOTATION: {
                    superclass = !this.origin.equals(ClassSymbol.OBJECT) ? ClassSymbol.OBJECT : null;
                    break;
                }
                default: {
                    throw new AssertionError((Object)decl.tykind());
                }
            }
        }
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (!decl.impls().isEmpty()) {
            for (Tree.ClassTy i : decl.impls()) {
                ClassSymbol result = this.resolveClass(i);
                if (result == null) {
                    throw new AssertionError(i);
                }
                interfaces.add((Object)result);
            }
        } else if (decl.tykind() == TurbineTyKind.ANNOTATION) {
            interfaces.add((Object)ClassSymbol.ANNOTATION);
        }
        ImmutableMap.Builder typeParameters = ImmutableMap.builder();
        for (Tree.TyParam p : decl.typarams()) {
            typeParameters.put((Object)p.name(), (Object)new TyVarSymbol(this.origin, p.name()));
        }
        return new SourceHeaderBoundClass(this.base, superclass, (ImmutableList<ClassSymbol>)interfaces.build(), access, (ImmutableMap<String, TyVarSymbol>)typeParameters.build());
    }

    private boolean implicitStatic(BoundClass c) {
        if (c.owner() == null) {
            return false;
        }
        switch (c.kind()) {
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION: {
                return true;
            }
            case CLASS: {
                switch (this.env.get(c.owner()).kind()) {
                    case INTERFACE: 
                    case ANNOTATION: {
                        return true;
                    }
                }
                return false;
            }
        }
        throw new AssertionError((Object)c.kind());
    }

    private ClassSymbol resolveClass(Tree.ClassTy ty) {
        ArrayDeque<String> flat = new ArrayDeque<String>();
        Tree.ClassTy curr = ty;
        while (curr != null) {
            flat.addFirst(curr.name());
            curr = (Tree.ClassTy)curr.base().orNull();
        }
        LookupResult result = this.lookup(new LookupKey(flat));
        if (result == null) {
            throw TurbineError.format(this.base.source(), ty.position(), TurbineError.ErrorKind.SYMBOL_NOT_FOUND, ty);
        }
        ClassSymbol sym = (ClassSymbol)result.sym();
        for (String bit : result.remaining()) {
            if ((sym = Resolve.resolve(this.env, this.origin, sym, bit)) != null) continue;
            throw this.error(ty.position(), TurbineError.ErrorKind.SYMBOL_NOT_FOUND, bit);
        }
        return sym;
    }

    private LookupResult lookup(LookupKey lookup) {
        ClassSymbol curr = this.base.owner();
        while (curr != null) {
            ClassSymbol result = Resolve.resolve(this.env, this.origin, curr, lookup.first());
            if (result != null) {
                return new LookupResult(result, lookup);
            }
            curr = this.env.get(curr).owner();
        }
        return this.base.scope().lookup(lookup);
    }

    private TurbineError error(int position, TurbineError.ErrorKind kind, Object ... args) {
        return TurbineError.format(this.base.source(), position, kind, args);
    }
}

