/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.turbine.model.Const;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ClassFile {
    private final int access;
    private final String name;
    private final String signature;
    private final String superClass;
    private final List<String> interfaces;
    private final List<MethodInfo> methods;
    private final List<FieldInfo> fields;
    private final List<AnnotationInfo> annotations;
    private final List<InnerClass> innerClasses;
    private final ImmutableList<TypeAnnotationInfo> typeAnnotations;

    public ClassFile(int access, String name, String signature, String superClass, List<String> interfaces, List<MethodInfo> methods, List<FieldInfo> fields, List<AnnotationInfo> annotations, List<InnerClass> innerClasses, ImmutableList<TypeAnnotationInfo> typeAnnotations) {
        this.access = access;
        this.name = name;
        this.signature = signature;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.methods = methods;
        this.fields = fields;
        this.annotations = annotations;
        this.innerClasses = innerClasses;
        this.typeAnnotations = typeAnnotations;
    }

    public int access() {
        return this.access;
    }

    public String name() {
        return this.name;
    }

    public String signature() {
        return this.signature;
    }

    public String superName() {
        return this.superClass;
    }

    public List<String> interfaces() {
        return this.interfaces;
    }

    public List<MethodInfo> methods() {
        return this.methods;
    }

    public List<FieldInfo> fields() {
        return this.fields;
    }

    public List<AnnotationInfo> annotations() {
        return this.annotations;
    }

    public List<InnerClass> innerClasses() {
        return this.innerClasses;
    }

    public ImmutableList<TypeAnnotationInfo> typeAnnotations() {
        return this.typeAnnotations;
    }

    public static class TypeAnnotationInfo {
        private final TargetType targetType;
        private final Target target;
        private final TypePath path;
        private final AnnotationInfo anno;
        public static final Target EMPTY_TARGET = new Target(){

            @Override
            public Target.Kind kind() {
                return Target.Kind.EMPTY;
            }
        };

        public TypeAnnotationInfo(TargetType targetType, Target target, TypePath path, AnnotationInfo anno) {
            this.targetType = targetType;
            this.target = target;
            this.path = path;
            this.anno = anno;
        }

        public AnnotationInfo anno() {
            return this.anno;
        }

        public TargetType targetType() {
            return this.targetType;
        }

        public Target target() {
            return this.target;
        }

        public TypePath path() {
            return this.path;
        }

        public static class TypePath {
            private final TypePath parent;
            private final Kind kind;
            private final int index;

            public static TypePath root() {
                return new TypePath(null, null);
            }

            public TypePath array() {
                return new TypePath(Kind.ARRAY, this);
            }

            public TypePath nested() {
                return new TypePath(Kind.NESTED, this);
            }

            public TypePath wild() {
                return new TypePath(Kind.WILDCARD_BOUND, this);
            }

            public TypePath typeArgument(int idx) {
                return new TypePath(idx, Kind.TYPE_ARGUMENT, this);
            }

            private TypePath(Kind kind, TypePath parent) {
                this(0, kind, parent);
            }

            private TypePath(int index, Kind kind, TypePath parent) {
                this.index = index;
                this.kind = kind;
                this.parent = parent;
            }

            public int typeArgumentIndex() {
                return this.index;
            }

            public byte tag() {
                return (byte)this.kind.tag;
            }

            public ImmutableList<TypePath> flatten() {
                ArrayDeque<TypePath> flat = new ArrayDeque<TypePath>();
                TypePath curr = this;
                while (curr.kind != null) {
                    flat.addFirst(curr);
                    curr = curr.parent;
                }
                return ImmutableList.copyOf(flat);
            }

            static enum Kind {
                ARRAY(0),
                NESTED(1),
                WILDCARD_BOUND(2),
                TYPE_ARGUMENT(3);

                final int tag;

                private Kind(int tag) {
                    this.tag = tag;
                }
            }
        }

        public static class ThrowsTarget
        extends Target {
            private final int index;

            public ThrowsTarget(int index) {
                this.index = index;
            }

            @Override
            public Target.Kind kind() {
                return Target.Kind.THROWS;
            }

            public int index() {
                return this.index;
            }
        }

        public static class FormalParameterTarget
        extends Target {
            private final int index;

            public FormalParameterTarget(int index) {
                this.index = index;
            }

            @Override
            public Target.Kind kind() {
                return Target.Kind.FORMAL_PARAMETER;
            }

            public int index() {
                return this.index;
            }
        }

        public static class TypeParameterBoundTarget
        extends Target {
            private final int typeParameterIndex;
            private final int boundIndex;

            public TypeParameterBoundTarget(int typeParameterIndex, int boundIndex) {
                this.typeParameterIndex = typeParameterIndex;
                this.boundIndex = boundIndex;
            }

            @Override
            public Target.Kind kind() {
                return Target.Kind.TYPE_PARAMETER_BOUND;
            }

            public int typeParameterIndex() {
                return this.typeParameterIndex;
            }

            public int boundIndex() {
                return this.boundIndex;
            }
        }

        public static class SuperTypeTarget
        extends Target {
            private final int index;

            public SuperTypeTarget(int index) {
                this.index = index;
            }

            @Override
            public Target.Kind kind() {
                return Target.Kind.SUPERTYPE;
            }

            public int index() {
                return this.index;
            }
        }

        public static class TypeParameterTarget
        extends Target {
            private final int index;

            public TypeParameterTarget(int index) {
                this.index = index;
            }

            public int index() {
                return this.index;
            }

            @Override
            public Target.Kind kind() {
                return Target.Kind.TYPE_PARAMETER;
            }
        }

        public static abstract class Target {
            public abstract Kind kind();

            public static enum Kind {
                TYPE_PARAMETER,
                SUPERTYPE,
                TYPE_PARAMETER_BOUND,
                EMPTY,
                FORMAL_PARAMETER,
                THROWS;

            }
        }

        public static enum TargetType {
            CLASS_TYPE_PARAMETER(0),
            METHOD_TYPE_PARAMETER(1),
            SUPERTYPE(16),
            CLASS_TYPE_PARAMETER_BOUND(17),
            METHOD_TYPE_PARAMETER_BOUND(18),
            FIELD(19),
            METHOD_RETURN(20),
            METHOD_RECEIVER_PARAMETER(21),
            METHOD_FORMAL_PARAMETER(22),
            METHOD_THROWS(23);

            private final int tag;

            private TargetType(int tag) {
                this.tag = tag;
            }

            public int tag() {
                return this.tag;
            }
        }
    }

    public static class AnnotationInfo {
        private final String typeName;
        private final boolean runtimeVisible;
        private final Map<String, ElementValue> elementValuePairs;

        public AnnotationInfo(String typeName, boolean runtimeVisible, Map<String, ElementValue> elementValuePairs) {
            this.typeName = typeName;
            this.runtimeVisible = runtimeVisible;
            this.elementValuePairs = elementValuePairs;
        }

        public String typeName() {
            return this.typeName;
        }

        public boolean isRuntimeVisible() {
            return this.runtimeVisible;
        }

        public Map<String, ElementValue> elementValuePairs() {
            return this.elementValuePairs;
        }

        public static interface ElementValue {
            public Kind kind();

            public static class AnnotationValue
            implements ElementValue {
                private final AnnotationInfo annotation;

                public AnnotationValue(AnnotationInfo annotation) {
                    this.annotation = annotation;
                }

                @Override
                public Kind kind() {
                    return Kind.ANNOTATION;
                }

                public AnnotationInfo annotation() {
                    return this.annotation;
                }
            }

            public static class ConstClassValue
            implements ElementValue {
                private final String className;

                public ConstClassValue(String className) {
                    this.className = className;
                }

                @Override
                public Kind kind() {
                    return Kind.CLASS;
                }

                public String className() {
                    return this.className;
                }
            }

            public static class ArrayValue
            implements ElementValue {
                private final List<ElementValue> elements;

                public ArrayValue(List<ElementValue> elements) {
                    this.elements = elements;
                }

                @Override
                public Kind kind() {
                    return Kind.ARRAY;
                }

                public List<ElementValue> elements() {
                    return this.elements;
                }
            }

            public static class ConstValue
            implements ElementValue {
                private final Const.Value value;

                public ConstValue(Const.Value value) {
                    this.value = value;
                }

                @Override
                public Kind kind() {
                    return Kind.CONST;
                }

                public Const.Value value() {
                    return this.value;
                }
            }

            public static class EnumConstValue
            implements ElementValue {
                private final String typeName;
                private final String constName;

                public EnumConstValue(String typeName, String constName) {
                    this.typeName = typeName;
                    this.constName = constName;
                }

                @Override
                public Kind kind() {
                    return Kind.ENUM;
                }

                public String typeName() {
                    return this.typeName;
                }

                public String constName() {
                    return this.constName;
                }
            }

            public static enum Kind {
                ENUM,
                CONST,
                ARRAY,
                CLASS,
                ANNOTATION;

            }
        }
    }

    public static class MethodInfo {
        private final int access;
        private final String name;
        private final String descriptor;
        @Nullable
        private final String signature;
        private final List<String> exceptions;
        @Nullable
        private final AnnotationInfo.ElementValue defaultValue;
        private final List<AnnotationInfo> annotations;
        private final ImmutableList<ImmutableList<AnnotationInfo>> parameterAnnotations;
        private final ImmutableList<TypeAnnotationInfo> typeAnnotations;
        private final ImmutableList<ParameterInfo> parameters;

        public MethodInfo(int access, String name, String descriptor, @Nullable String signature, List<String> exceptions, @Nullable AnnotationInfo.ElementValue defaultValue, List<AnnotationInfo> annotations, ImmutableList<ImmutableList<AnnotationInfo>> parameterAnnotations, ImmutableList<TypeAnnotationInfo> typeAnnotations, ImmutableList<ParameterInfo> parameters) {
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
            this.defaultValue = defaultValue;
            this.annotations = annotations;
            this.parameterAnnotations = parameterAnnotations;
            this.typeAnnotations = typeAnnotations;
            this.parameters = parameters;
        }

        public int access() {
            return this.access;
        }

        public String name() {
            return this.name;
        }

        public String descriptor() {
            return this.descriptor;
        }

        @Nullable
        public String signature() {
            return this.signature;
        }

        public List<String> exceptions() {
            return this.exceptions;
        }

        @Nullable
        public AnnotationInfo.ElementValue defaultValue() {
            return this.defaultValue;
        }

        public List<AnnotationInfo> annotations() {
            return this.annotations;
        }

        public ImmutableList<ImmutableList<AnnotationInfo>> parameterAnnotations() {
            return this.parameterAnnotations;
        }

        public ImmutableList<TypeAnnotationInfo> typeAnnotations() {
            return this.typeAnnotations;
        }

        public ImmutableList<ParameterInfo> parameters() {
            return this.parameters;
        }

        public static class ParameterInfo {
            private final String name;
            private final int access;

            public ParameterInfo(String name, int access) {
                this.name = name;
                this.access = access;
            }

            public String name() {
                return this.name;
            }

            public int access() {
                return this.access;
            }
        }
    }

    public static class InnerClass {
        private final String innerClass;
        private final String outerClass;
        private final String innerName;
        private final int access;

        public InnerClass(String innerClass, String outerClass, String innerName, int access) {
            this.innerClass = innerClass;
            this.outerClass = outerClass;
            this.innerName = innerName;
            this.access = access;
        }

        public String innerClass() {
            return this.innerClass;
        }

        public String outerClass() {
            return this.outerClass;
        }

        public String innerName() {
            return this.innerName;
        }

        public int access() {
            return this.access;
        }
    }

    public static class FieldInfo {
        private final int access;
        private final String name;
        private final String descriptor;
        @Nullable
        private final String signature;
        @Nullable
        private final Const.Value value;
        private final List<AnnotationInfo> annotations;
        private final ImmutableList<TypeAnnotationInfo> typeAnnotations;

        public FieldInfo(int access, String name, String descriptor, @Nullable String signature, Const.Value value, List<AnnotationInfo> annotations, ImmutableList<TypeAnnotationInfo> typeAnnotations) {
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.value = value;
            this.annotations = annotations;
            this.typeAnnotations = typeAnnotations;
        }

        public int access() {
            return this.access;
        }

        public String name() {
            return this.name;
        }

        public String descriptor() {
            return this.descriptor;
        }

        @Nullable
        public String signature() {
            return this.signature;
        }

        @Nullable
        public Const.Value value() {
            return this.value;
        }

        public List<AnnotationInfo> annotations() {
            return this.annotations;
        }

        public ImmutableList<TypeAnnotationInfo> typeAnnotations() {
            return this.typeAnnotations;
        }
    }
}

