/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.replicatedmap.impl.client.AbstractReplicatedMapClientRequest;
import com.hazelcast.replicatedmap.impl.operation.PutOperation;
import com.hazelcast.replicatedmap.impl.operation.VersionResponsePair;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.TimeUnit;

public class ClientReplicatedMapPutTtlRequest
extends AbstractReplicatedMapClientRequest {
    private Data key;
    private Data value;
    private long ttlMillis;

    public ClientReplicatedMapPutTtlRequest() {
    }

    public ClientReplicatedMapPutTtlRequest(String name, Data key, Data value, long ttlMillis) {
        super(name);
        this.key = key;
        this.value = value;
        this.ttlMillis = ttlMillis;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeLong("ttlMillis", this.ttlMillis);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
        out.writeData(this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.ttlMillis = reader.readLong("ttlMillis");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
        this.value = in.readData();
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public Permission getRequiredPermission() {
        return new ReplicatedMapPermission(this.getMapName(), "put");
    }

    @Override
    public String getMethodName() {
        return "put";
    }

    @Override
    public Object[] getParameters() {
        if (this.ttlMillis == 0L) {
            return new Object[]{this.key, this.value};
        }
        return new Object[]{this.key, this.value, this.ttlMillis, TimeUnit.MILLISECONDS};
    }

    @Override
    protected Operation prepareOperation() {
        return new PutOperation(this.getMapName(), this.key, this.value, this.ttlMillis);
    }

    @Override
    protected int getPartition() {
        InternalPartitionService partitionService = this.clientEngine.getPartitionService();
        return partitionService.getPartitionId(this.key);
    }

    @Override
    protected Object filter(Object response) {
        if (response instanceof VersionResponsePair) {
            VersionResponsePair pair = (VersionResponsePair)response;
            return pair.getResponse();
        }
        return response;
    }
}

