/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.fixes.Fix;
import com.sun.source.tree.Tree;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class Description {
    public static final Description NO_MATCH = new Description(null, "<no match>", "<no match>", "<no match>", (ImmutableList<Fix>)ImmutableList.of(), BugPattern.SeverityLevel.SUGGESTION);
    private static final String UNDEFINED_CHECK_NAME = "Undefined";
    public final Tree node;
    public final String checkName;
    private final String rawMessage;
    @Nullable
    private final String link;
    public final ImmutableList<Fix> fixes;
    public final BugPattern.SeverityLevel severity;

    public String getMessage() {
        return String.format("[%s] %s", this.checkName, this.getMessageWithoutCheckName());
    }

    @Nullable
    public String getLink() {
        return this.link;
    }

    public String getRawMessage() {
        return this.rawMessage;
    }

    public String getMessageWithoutCheckName() {
        return this.link != null ? String.format("%s\n%s", this.rawMessage, this.link) : String.format("%s", this.rawMessage);
    }

    public Description(Tree node, String message, Fix suggestedFix, BugPattern.SeverityLevel severity) {
        this(node, UNDEFINED_CHECK_NAME, message, message, (ImmutableList<Fix>)ImmutableList.of((Object)suggestedFix), severity);
        if (suggestedFix == null) {
            throw new IllegalArgumentException("suggestedFix must not be null.");
        }
    }

    private Description(Tree node, String checkName, String rawMessage, String link, ImmutableList<Fix> fixes, BugPattern.SeverityLevel severity) {
        this.node = node;
        this.checkName = checkName;
        this.rawMessage = rawMessage;
        this.link = link;
        this.fixes = fixes;
        this.severity = severity;
    }

    @CheckReturnValue
    public Description applySeverityOverride(BugPattern.SeverityLevel severity) {
        return new Description(this.node, this.checkName, this.rawMessage, this.link, this.fixes, severity);
    }

    @CheckReturnValue
    public Description filterFixes(Predicate<? super Fix> predicate) {
        return new Description(this.node, this.checkName, this.rawMessage, this.link, (ImmutableList<Fix>)ImmutableList.copyOf((Iterable)Iterables.filter(this.fixes, predicate)), this.severity);
    }

    private static String linkTextForDiagnostic(String linkUrl) {
        return Strings.isNullOrEmpty((String)linkUrl) ? null : "  (see " + linkUrl + ")";
    }

    public static Builder builder(Tree node, String name, @Nullable String link, BugPattern.SeverityLevel severity, String message) {
        return new Builder(node, name, link, severity, message);
    }

    public static class Builder {
        private final Tree node;
        private final String name;
        private final String linkUrl;
        private final BugPattern.SeverityLevel severity;
        private final ImmutableList.Builder<Fix> fixListBuilder = ImmutableList.builder();
        private String rawMessage;

        private Builder(Tree node, String name, @Nullable String linkUrl, BugPattern.SeverityLevel severity, String rawMessage) {
            this.node = (Tree)Preconditions.checkNotNull((Object)node);
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.linkUrl = linkUrl;
            this.severity = (BugPattern.SeverityLevel)Preconditions.checkNotNull((Object)severity);
            this.rawMessage = (String)Preconditions.checkNotNull((Object)rawMessage);
        }

        public Builder addFix(Fix fix) {
            Preconditions.checkArgument((fix != null ? 1 : 0) != 0, (Object)"fix must not be null");
            if (!fix.isEmpty()) {
                this.fixListBuilder.add((Object)fix);
            }
            return this;
        }

        public Builder addAllFixes(List<? extends Fix> fixes) {
            Preconditions.checkArgument((fixes != null ? 1 : 0) != 0, (Object)"fixes must not be null");
            for (Fix fix : fixes) {
                this.addFix(fix);
            }
            return this;
        }

        public Builder setMessage(String message) {
            if (message == null) {
                throw new IllegalArgumentException("message must not be null");
            }
            this.rawMessage = message;
            return this;
        }

        public Description build() {
            return new Description(this.node, this.name, this.rawMessage, Description.linkTextForDiagnostic(this.linkUrl), this.fixListBuilder.build(), this.severity);
        }
    }
}

