/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="ShortCircuitBoolean", category=BugPattern.Category.JDK, summary="Prefer the short-circuiting boolean operators && and || to & and |.", severity=BugPattern.SeverityLevel.WARNING)
public class ShortCircuitBoolean
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        switch (tree.getKind()) {
            case AND: 
            case OR: {
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree), (Type)state.getSymtab().booleanType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((int)state.getEndPosition((Tree)tree.getLeftOperand()), (int)((JCTree)((Object)tree.getRightOperand())).getStartPosition(), (String)(tree.getKind() == Tree.Kind.AND ? " && " : " || ")));
    }
}

